<?php
/**
 *  This file is part of ubiquitous.

 *  ubiquitous is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  ubiquitous is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses></http:>.
 * 
 *  2007 - 2020, open3A GmbH - Support@open3A.de
 */

class mCronGUI extends anyC implements iGUIHTMLMP2 {

	public function getHTML($id, $page){
		$this->addOrderV3("CronName");
		$this->loadMultiPageMode($id, $page, 0);

		$gui = new HTMLGUIX($this);
		$gui->version("mCron");

		$gui->name("Cron");
		
		$gui->attributes(array("CronName"));
		
		$B = $gui->addSideButton("Crontab\naktualisieren", "./ubiquitous/Cron/save.png");
		$B->popup("", "Crontab erstellen", "mCron", "-1", "updateCrontab", "1", "", "{width:600}");
		
		if(Applications::activeApplication() == "Zeus"){
			$B = $gui->addSideButton("Backup-Job\neintragen", "./ubiquitous/Cron/save.png");
			$B->popup("", "Backup-Job eintragen", "mCron", "-1", "createBackupJob", "", "", "{width:600}");
		}
		
		#$B = $gui->addSideButton("Crontab\nleeren", "empty");
		#$B->popup("", "Crontab leeren", "mCron", "-1", "clearCrontab", "1");
		
		$apps = Applications::getList();
		$apps["plugins"] = "plugins";

		foreach($apps AS $app){
			$AP = new AppPlugins($app);
			$AP->getAllPlugins();
		}
		
		$i = 0;
		$T = new HTMLTable(2, "Plugins mit Cronjobs");
		$T->setColWidth(1, 20);
		$T->useForSelection(false);
		while($C = Registry::callNext("Cronjob")){
			$h = $C[0];
			
			
			$B = new Button("Details anzeigen", "./images/i2/details.png", "icon");
			
			$T->addRow(array($B, $h));
			$T->addRowEvent("click", OnEvent::popup("Details Cronjob", "mCron", "-1", "detailsPopup", array("'$C[0]'"), "", "{width:800}"));
			$i++;
		}

		if($i == 0)
			$T->addRow(array("", "Keine Cronjobs notwendig."));
		
		$TD = "<p class=\"highlight\" style=\"padding:5px;\">Bitte beachten Sie: Dieses Plugin zeigt nur die möglichen Cronjobs an, es kann sie <strong>nicht</strong> anlegen!</p>";
		
		if(Applications::activeApplication() != "Zeus")
			return $TD.$T;
		
		return $gui->getBrowserHTML($id);
	}
	
	public function detailsPopup($name){
		$apps = Applications::getList();
		$apps["plugins"] = "plugins";

		foreach($apps AS $app){
			$AP = new AppPlugins($app);
			$AP->getAllPlugins();
		}
		
		echo "<p class=\"prettyTitle\">Cronjobs $name</p>
				<p style=\"margin-bottom:15px;\">Bitte erstellen Sie folgende Cronjobs:</p>";
		
		while($C = Registry::callNext("Cronjob")){
			if($C[0] != $name)
				continue;
			
			$h  = "";
			for($i = 1; $i < count($C); $i++)
				$h .= "<p style=\"font-weight:bold;\">".$C[$i][3]."</p><pre style=\"margin-left:5px;margin-top:5px;margin-bottom:20px;font-size:11px;\">".$C[$i][1]." ".$C[$i][2]." ".rtrim(Util::getRootPath(), "/").$C[$i][0]."</pre>";
			
			echo $h;
		}
		
	}
	
	public function createBackupJob(){
		$F = new Factory("Cron");
		$update = false;
		
		$F->sA("CronGUID", "backupJob1");
		if(!$F->exists()){
			$F->sA("CronName", "Backup MySQL");
			$F->sA("CronMinute", "00");
			$F->sA("CronHour", "2");
			$F->sA("CronDayOfMonth", "*");
			$F->sA("CronMonth", "*");
			$F->sA("CronDayOfWeek", "*");
			$F->sA("CronCommand", "/home/nemiah/backupMySQL.sh");

			$F->store();
			$update = true;
			echo "<p>Backup-Job MySQL angelegt</p>";
		} else
			echo "<p>Backup-Job MySQL existiert bereits</p>";
		
		
		$F = new Factory("Cron");
		
		$F->sA("CronGUID", "backupJob2");
		if(!$F->exists()){
			$F->sA("CronName", "Backup Data");
			$F->sA("CronMinute", "00");
			$F->sA("CronHour", "4");
			$F->sA("CronDayOfMonth", "*");
			$F->sA("CronMonth", "*");
			$F->sA("CronDayOfWeek", "*");
			$F->sA("CronCommand", "/home/nemiah/backupData.sh");

			$F->store();
			$update = true;
			echo "<p>Backup-Job Data angelegt</p>";
		} else
			echo "<p>Backup-Job Data existiert bereits</p>";
		
		if($update)
			$this->updateCrontab(1);
	}

	public function updateCrontab($echo){
		$this->clearCrontab($echo);
		$this->createCrontab($echo);
	}
	
	public function createCrontab($echo = true){
		$AC = anyC::get("Cron");
		
		$content = "";
		while($C = $AC->getNextEntry()){
			$content .= $C->A("CronMinute")." ".$C->A("CronHour")." ".$C->A("CronDayOfMonth")." ".$C->A("CronMonth")." ".$C->A("CronDayOfWeek")." ".$C->A("CronCommand")."\n";
		}
		
		$file = Util::getTempFilename("cron", "tmp");
		file_put_contents($file, trim($content)."\n");
		
		if($echo){
			echo "<pre style=\"font-size:10px;padding:5px;\">";
			echo $content;
			echo "</pre>";
		}
		
		$CH = Util::getCloudHost();
		
		$SC = new SystemCommand();
		if($CH == null)
			$SC->setCommand("crontab $file 2>&1");
		else
			$SC->setCommand("sudo -u ".$CH->sysUser." sh -c \"crontab $file\" 2>&1");
		$SC->execute();
		
		if($echo)
			echo $SC->getOutput();
		
	}
	
	public function clearCrontab($echo = true){
		$CH = Util::getCloudHost();
		
		$SC = new SystemCommand();
		if($CH == null)
			$SC->setCommand("crontab -r 2>&1");
		else
			$SC->setCommand("sudo -u ".$CH->sysUser." sh -c \"crontab -r\" 2>&1");
		$SC->execute();
		$output = $SC->getOutput();
		
		if($echo){
			if(trim($output) == "")
				echo "<p>Crontab geleert</p>";
			else 
				echo "<p>Es ist ein Fehler aufgetreten: $output</p>";
		}
	}
}
?>