<?php
/**
 *  This file is part of ubiquitous.

 *  ubiquitous is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  ubiquitous is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses></http:>.
 * 
 *  2007 - 2020, open3A GmbH - Support@open3A.de
 */
class Cron extends PersistentObject {
	public static function dropCronGroup($GroupID){
		$AC = anyC::get("Cron", "CronGroupID", $GroupID);
		while($C = $AC->getNextEntry()){
			$C->deleteMe();
		}
	}
	
	public static function createCron($name, $GroupID, $minute, $hour, $command, $dayOfMonth = "*", $month = "*", $dayOfWeek = "*"){
		$F = new Factory("Cron");
		
		$F->sA("CronName", $name);
		$F->sA("CronGroupID", $GroupID);
		$F->sA("CronMinute", $minute);
		$F->sA("CronHour", $hour);
		$F->sA("CronDayOfMonth", $dayOfMonth);
		$F->sA("CronMonth", $month);
		$F->sA("CronDayOfWeek", $dayOfWeek);
		$F->sA("CronCommand", $command);
		
		$F->store();
	}
}
?>