<?php
/**
 *  This file is part of ubiquitous.

 *  ubiquitous is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  ubiquitous is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses></http:>.
 * 
 *  2007 - 2020, open3A GmbH - Support@open3A.de
 */

class mWartungGUI extends UnpersistentClass implements iGUIHTMLMP2 {
	public function getHTML($id, $page){

		$FB = new FileBrowser();
		$FB->addDir(Util::getRootPath()."specifics/");
		$FB->addDir(dirname(__FILE__));
		
		$T = new HTMLTable(2, "Wartung");
		$T->addColStyle(1, "width:20px;");
		$T->useForSelection(false);
		
		foreach($FB->getAsLabeledArray("iWartung", ".class.php", true) AS $k => $v){
			$B = new Button("", "./images/i2/edit.png", "icon");
			$B->loadFrame("contentLeft", "Wartung", $v);
			$action = $B->getAction();
			$T->addRow(array($B, $k));
			$T->addRowEvent("click", $action);
		}
		
		$TW = new HTMLTable(1);
		
		
		$B = new Button("Warnung", "warning", "icon");
		$B->style("float:left;margin-right:10px;");
				
		$TW->addRow(array($B."<p style=\"color:red;font-weight:bold;\">ACHTUNG: Mit diesem Plugin können viele Daten auf einmal gelöscht werden. Seien Sie daher SEHR VORSICHTIG!</p>"));
		$TW->setColClass(1, "");
		
		return $TW.$T;
	}
	
	function getCollectionOf(){ //Needed for Admin rights
		return "Wartung";
	}
}
?>