<?php
/**
 *  This file is part of ubiquitous.

 *  ubiquitous is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  ubiquitous is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses></http:>.
 * 
 *  2007 - 2020, open3A GmbH - Support@open3A.de
 */

class Wartung_mVertrag implements iWartung {
	public function getLabel(){
		if(!Session::isPluginLoaded("mVertrag"))
			return null;
		
		return "Verträge";
	}

	public function getHTML() {
		$T = new HTMLTable(2, "Verrträge Aktionen");
		$T->setColWidth(1, 156);
		$T->setColClass(1, "");
		
		$B = new Button("MwSt-Satz\nanpassen", "lieferschein");
		#$B->doBefore("if(confirm('Möchten Sie wirklich ALLE Artikel aus der Datenbank löschen?')) %AFTER");
		$B->popup("", "MwSt-Satz anpassen", "Wartung", "-1", "runAction", array("'Wartung_mVertrag::changeMwStPopup'"));
		
		$T->addRow(array($B, "Passen Sie hier die Mehrwertsteuer der manuell erfassten Vertragspositionen an."));
		
		return $T;
	}
	
	public function changeMwStPopup(){
		$F = new HTMLForm("updatePrices", array("action", "oldPercentMwSt", "percentMwSt"));
		$F->getTable()->setColWidth(1, 120);
		
		$AC = anyC::get("VertragPosten");
		$AC->addAssocV3("VertragPostenArtikelID", "=", "0");
		$AC->addGroupV3("VertragPostenMwSt");
		$mwsts = array(-1 => "Alle");
		while($P = $AC->n())
			$mwsts[$P->A("VertragPostenMwSt")] = Util::CLNumberParserZ($P->A("VertragPostenMwSt"))."%";
		
		#$F->setType("KategorieID", "select", null, $keys);
		$F->setType("action", "hidden");
		$F->setType("oldPercentMwSt", "select", null, $mwsts);
		
		#$F->setLabel("KategorieID", "Kategorie");
		$F->setLabel("percentMwSt", "MwSt-Satz neu");
		$F->setLabel("oldPercentMwSt", "MwSt-Satz bisher");
		
		$F->setValue("action", "Wartung_mVertrag::changeMwStNow");
		
		$F->setDescriptionField("percentMwSt", "Angabe in %, z.B: 19,00");
		
		$F->useRecentlyChanged();
		$F->setSaveRMEPCR("Anpassen", "", "Wartung", "-1", "runAction", "\$j('#editDetailsContentWartung').html(transport.responseText);");
		
		echo "<p>Diese Funktion ändert den in den Vertragspositionen direkt eingetragenen Mehrwertsteuer-Satz. Die Artikel müssen extra angepasst werden!</p>".$F;
	}
	
	public function changeMwStNow($oldPercentMwSt, $percentMwSt){
		$percentMwSt = Util::CLNumberParserZ(str_replace("%", "", $percentMwSt), "store");

		if(trim($percentMwSt) == "")
			Red::alertD ("Bitte geben Sie einen Prozentsatz ein");
		
		$AC = anyC::get("VertragPosten");
		$AC->addAssocV3("VertragPostenArtikelID", "=", "0");
		if($oldPercentMwSt != "-1")
			$AC->addAssocV3("VertragPostenMwSt", "=", $oldPercentMwSt);
		
		$i = 0;
		while($A = $AC->getNextEntry()){
			
			$A->changeA("VertragPostenMwSt", $percentMwSt);
			
			$i++;
			$A->saveMe();
		}
		
		return "<p>$i Vertragspositionen angepasst</p>";
		
	}
}
?>