<?php
/**
 *  This file is part of ubiquitous.

 *  ubiquitous is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  ubiquitous is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses></http:>.
 * 
 *  2007 - 2020, open3A GmbH - Support@open3A.de
 */

class Wartung_mStammdaten implements iWartung {
	public function getLabel(){
		if(!Session::isPluginLoaded("mStammdaten"))
			return null;
		
		return "Stammdaten";
	}

	public function getHTML() {
		$T = new HTMLTable(2, "Stammdaten Aktionen");
		$T->setColWidth(1, 156);
		$T->setColClass(1, "");
		
		$B = new Button("Stammdaten\nzurücksetzen", "back");
		$B->doBefore("if(confirm('Möchten Sie wirklich die Stammdaten zurücksetzen?')) %AFTER");
		$B->popup("", "Stammdaten zurücksetzen", "Wartung", "-1", "runAction", array("'Wartung_mStammdaten::reset'"));
		
		$T->addRow(array($B, "Mit diesem Knopf setzen Sie die Stammdaten auf den Ursprungszustand zurück."));
		
		return $T;
	}
	
	public function reset(){
		$DB = new DBStorage();
		
		$C = $DB->getConnection();
		
		$C->query("DROP TABLE Stammdaten");
		$S = new mStammdaten();
		
		ob_start();
		$S->checkMyTables();
		$create = ob_get_contents();
		ob_end_clean();

		return "<p>Tabelle Stammdaten gelöscht</p><pre style=\"font-size:10px;max-height:400px;overflow:auto;padding:5px;\">".$create."</pre>";
	}
}
?>