<?php
/**
 *  This file is part of ubiquitous.

 *  ubiquitous is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  ubiquitous is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses></http:>.
 * 
 *  2007 - 2020, open3A GmbH - Support@open3A.de
 */

class Wartung_mMailtest implements iWartung {
	public function getLabel(){
		#if(!Session::isPluginLoaded("mStammdaten"))
		#	return null;
		
		return "Mailtest";
	}

	public function getHTML() {
		$T = new HTMLTable(2, "Mailtest Aktionen");
		$T->setColWidth(1, 156);
		$T->setColClass(1, "");
		
		$B = new Button("SMTP-\nVersand", "mail");
		#$B->doBefore("if(confirm('Möchten Sie wirklich die Stammdaten zurücksetzen?')) %AFTER");
		$B->popup("", "SMTP-Versand", "Wartung", "-1", "runAction", array("'Wartung_mMailtest::smtpTestPopup'"));
		
		$T->addRow(array($B, "Mit diesem Knopf können Sie den SMTP-Versand von E-Mails testen."));
		
		
		$B = new Button("Versand mit\nAnhang", "mail");
		#$B->doBefore("if(confirm('Möchten Sie wirklich die Stammdaten zurücksetzen?')) %AFTER");
		$B->popup("", "SMTP-Versand", "Wartung", "-1", "runAction", array("'Wartung_mMailtest::attachmentTestPopup'"));
		
		$T->addRow(array($B, "Mit diesem Knopf können Sie den Versand von E-Mails mit Anhang testen."));
		
		return $T;
	}
	
	public function attachmentTestPopup(){
		$F = new HTMLForm("mailSAttach", array("action", "absender", "empfaenger"));
		$F->getTable()->setColWidth(1, 120);
		
		$F->setValue("action", "Wartung_mMailtest::attachmentTest");
		$F->setType("action", "hidden");
		
		$F->setLabel("empfaenger", "Empfänger");
		
		$F->useRecentlyChanged();
		$F->setSaveRMEPCR("Testmail senden", "", "Wartung", "-1", "runAction", "\$j('#MailtestMessage').html(transport.responseText);");
		
		return $F."<pre id=\"MailtestMessage\" style=\"padding:5px;font-size:10px;white-space: pre-wrap;max-height:300px;overflow:auto;\"></pre>";
	}
	
	public function attachmentTest($mailfrom, $mailto){
		if($mailfrom == "")
			Red::errorD("Bitte geben Sie einen Absender ein!");

		if($mailto == "")
			Red::errorD("Bitte geben Sie einen Empfänger ein!");
		try {
			$mail = new htmlMimeMail5(substr($mailfrom, stripos($mailfrom, "@") + 1));
		} catch(Exception $e){
			die("<p style=\"padding:5px;color:red;\">Fehler beim Übergeben der E-Mail. ".$e->getMessage()."</p>");
		}
		$mail->setFrom("phynx Mailtest <".$mailfrom.">");
		if(!ini_get('safe_mode')) $mail->setReturnPath($mailfrom);
		$mail->setSubject("phynx Mailtest");

		$mail->addAttachment(
	    	new fileAttachment(
				dirname(__FILE__)."/R13004-25.10.2013-Max_PHPUnitTest.pdf",
	    		'application/pdf',
	    		new Base64Encoding())
	    );
		
		$mail->setText(wordwrap("Diese Nachricht wurde vom phynx Mailtester erzeugt. Ihre E-Mail-Einstellungen sind korrekt.", 80));
		
		$mail->setHTML(Util::makeHTMLMail("<p>Diese Nachricht wurde vom phynx Mailtester erzeugt. Ihre E-Mail-Einstellungen sind korrekt.</p>"));
		$mail->setHTMLCharset("UTF-8");
			
		$adressen = array();
		$adressen[] = $mailto;
		if($mail->send($adressen))
			echo "<p style=\"padding:5px;color:green;\">E-Mail erfolgreich übergeben.</p>";
		else
			echo "<p style=\"padding:5px;color:red;\">Fehler beim Übergeben der E-Mail. Bitte überprüfen Sie Ihre Server-Einstellungen.<br />Fehler: ".nl2br(print_r($mail->errors, true))."</p>";
		
		echo $mail->getRFC822($adressen);

	}
	
	public function smtpTestPopup(){
		$F = new HTMLForm("mailSmtp", array("action", "server", "port", "benutzer", "passwort", "absender", "empfaenger"));
		$F->getTable()->setColWidth(1, 120);
		
		$F->setValue("port", "25");
		$F->setValue("action", "Wartung_mMailtest::smtpTest");
		$F->setType("action", "hidden");
		
		$F->setLabel("empfaenger", "Empfänger");
		
		$F->insertSpaceAbove("absender");
		
		$F->useRecentlyChanged();
		$F->setSaveRMEPCR("Testmail senden", "", "Wartung", "-1", "runAction", "\$j('#MailtestMessage').html(transport.responseText);");
		
		return $F."<pre id=\"MailtestMessage\" style=\"padding:5px;font-size:10px;white-space: pre-wrap;\"></pre>";
		/*$DB = new DBStorage();
		
		$C = $DB->getConnection();
		
		$C->query("DROP TABLE Stammdaten");
		$S = new mStammdaten();
		
		ob_start();
		$S->checkMyTables();
		$create = ob_get_contents();
		ob_end_clean();

		return "<p>Tabelle Stammdaten gelöscht</p><pre style=\"font-size:10px;max-height:400px;overflow:auto;padding:5px;\">".$create."</pre>";*/
	}
	
	public function smtpTest($server, $port, $benutzername, $passwort, $absender, $empfaenger){

		$mimeMail2 = new PHPMailer(false);#, substr($absender, stripos($mailfrom, "@") + 1));
		$mimeMail2->IsSMTP();

		$mimeMail2->Host = $server;
		$mimeMail2->Port = $port;

		$mimeMail2->SMTPAuth = $benutzername != "";
		$mimeMail2->Username = $benutzername;
		$mimeMail2->Password = $passwort;
				
		$mimeMail2->CharSet = "UTF-8";
		$mimeMail2->Subject = "phynx Mailtest";
		
		$mimeMail2->From = $absender;
		$mimeMail2->Sender = $absender;
		$mimeMail2->FromName = "phynx Mailtest";
		
		$mimeMail2->Body = wordwrap("Diese Nachricht wurde vom phynx Mailtester erzeugt. Ihre E-Mail-Einstellungen sind korrekt.", 80);
		$mimeMail2->AddAddress($empfaenger);
		
		if($mimeMail2->Send())
			echo "<span style=\"color:green;\">E-Mail erfolgreich übergeben.</span>";
		else
			echo "<span style=\"color:red;\">Fehler beim Übergeben der E-Mail. Bitte überprüfen Sie Ihre Server-Einstellungen.<br />Fehler: ".nl2br(print_r($mimeMail2->ErrorInfo, true))."</span>";
	}
}
?>