<?php
/**
 *  This file is part of ubiquitous.

 *  ubiquitous is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  ubiquitous is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses></http:>.
 * 
 *  2007 - 2020, open3A GmbH - Support@open3A.de
 */

class Wartung_mLieferant implements iWartung {
	public function getLabel(){
		if(!Session::isPluginLoaded("mLieferant"))
			return null;
		
		return "Lieferanten";
	}

	public function getHTML() {
		$T = new HTMLTable(2, "Lieferanten Aktionen");
		$T->setColWidth(1, 156);
		$T->setColClass(1, "");
		
		$B = new Button("MwSt-Satz\nanpassen", "lieferschein");
		#$B->doBefore("if(confirm('Möchten Sie wirklich ALLE Artikel aus der Datenbank löschen?')) %AFTER");
		$B->popup("", "MwSt-Satz anpassen", "Wartung", "-1", "runAction", array("'Wartung_mLieferant::changeMwStPopup'"));
		
		$T->addRow(array($B, "Passen Sie hier die bei den Lieferanten eingetragene Mehrwertsteuer an."));
		
		return $T;
	}
	
	public function changeMwStPopup(){
		$F = new HTMLForm("updatePrices", array("action", "oldPercentMwSt", "percentMwSt"));
		$F->getTable()->setColWidth(1, 120);
		
		#$kat = new Kategorien();
		#$kat->addAssocV3("type","=","2");
		#$keys = $kat->getArrayWithKeysAndValues("Alle");
		
		#$mwst = new Kategorien();
		#$mwst->addAssocV3("type","=","mwst");
		#$mwsts = $mwst->getArrayWithKeysAndValues("Alle");
		$AC = anyC::get("Lieferant");
		$AC->addGroupV3("LieferantMwStSatz");
		$mwsts = array(-1 => "Alle");
		while($P = $AC->n())
			$mwsts[$P->A("LieferantMwStSatz")] = Util::CLNumberParserZ($P->A("LieferantMwStSatz"))."%";
		
		#$F->setType("KategorieID", "select", null, $keys);
		$F->setType("action", "hidden");
		$F->setType("oldPercentMwSt", "select", null, $mwsts);
		
		#$F->setLabel("KategorieID", "Kategorie");
		$F->setLabel("percentMwSt", "MwSt-Satz neu");
		$F->setLabel("oldPercentMwSt", "MwSt-Satz bisher");
		
		$F->setValue("action", "Wartung_mLieferant::changeMwStNow");
		
		$F->setDescriptionField("percentMwSt", "Angabe in %, z.B: 19,00");
		
		$F->useRecentlyChanged();
		$F->setSaveRMEPCR("Anpassen", "", "Wartung", "-1", "runAction", "\$j('#editDetailsContentWartung').html(transport.responseText);");
		
		echo "<p>Diese Funktion ändert den in den Lieferanten eingetragenen Mehrwertsteuer-Satz. Der MwSt-Satz wird bei Bestellungen und im Belegeingang berücksichtigt.</p>".$F;
	}
	
	public function changeMwStNow($oldPercentMwSt, $percentMwSt){
		$percentMwSt = Util::CLNumberParserZ(str_replace("%", "", $percentMwSt), "store");

		if($percentMwSt == null)
			Red::alertD ("Bitte geben Sie einen Prozentsatz ein");
		
		$AC = anyC::get("Lieferant");
		if($oldPercentMwSt != "-1")
			$AC->addAssocV3("LieferantMwStSatz", "=", $oldPercentMwSt);
		
		$i = 0;
		while($A = $AC->getNextEntry()){
			
			$A->changeA("LieferantMwStSatz", $percentMwSt);
			
			$i++;
			$A->saveMe();
		}
		
		return "<p>$i Lieferanten angepasst</p>";
		
	}
}
?>