<?php
/**
 *  This file is part of ubiquitous.

 *  ubiquitous is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  ubiquitous is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses></http:>.
 * 
 *  2007 - 2020, open3A GmbH - Support@open3A.de
 */

class Wartung_mLager implements iWartung {
	public function getLabel(){
		#if(!Session::isPluginLoaded("mLager"))
			return null;
		
		return "Lager";
	}

	public function getHTML() {
		$T = new HTMLTable(2, "Lager Aktionen");
		$T->setColWidth(1, 156);
		$T->setColClass(1, "");
		
		$B = new Button("Lagerbestände\nfixen", "trash");
		#$B->doBefore("if(confirm('Möchten Sie wirklich ALLE Adressen aus der Datenbank löschen?')) %AFTER");
		$B->popup("", "Lagerbestände fixen", "Wartung", "-1", "runAction", array("'Wartung_mLager::fixLB'"));
		
		$T->addRow(array($B, "Fixt die Objektzuordnungen."));
		
		return $T;
	}
	
	public function fixLB(){
		
		$Objekte = array();
		$AC = anyC::get("ObjektL");
		$AC->addAssocV3("objektNummer", "!=", "");
		while($O = $AC->getNextEntry())
			$Objekte["OBJ".($O->A("objektNummer") + 20000)] = $O;
		
		$link = array();
		$link["OBJ21261"] = "76";
		$link["OBJ21263"] = "37";
		$link["OBJ21356"] = "38";
		$link["OBJ21383"] = "40";
		$link["OBJ21467"] = "27";
		
		$AC = anyC::get("Lagerbestandsaenderung");
		$AC->addAssocV3("LagerbestandsaenderungDatum", ">", 1380581327);
		$AC->addAssocV3("LagerbestandsaenderungKommentar", "=", "Materialentnahme für Objekt");
		$AC->addJoinV3("Lagerbestand", "LagerbestandsaenderungLagerbestandID", "=", "LagerbestandID");
		$AC->addJoinV3("Lager", "t2.LagerbestandLagerID", "=", "LagerID");
		$AC->addOrderV3("LagerbestandsaenderungReferenz");
		$UO = null;
		$T = new HTMLTable(4);
		$T->maxHeight(400);
		while($L = $AC->getNextEntry()){
			$Objekt = "UNBEKANNT!";
			if(isset($Objekte[$L->A("LagerbestandsaenderungReferenz")])){
				$Objekt = $Objekte[$L->A("LagerbestandsaenderungReferenz")]->A("objektName");
				$UO = $Objekte[$L->A("LagerbestandsaenderungReferenz")];
			}
			
			if(isset($link[$L->A("LagerbestandsaenderungReferenz")])){
				$Obj = new ObjektL($link[$L->A("LagerbestandsaenderungReferenz")]);
				$Objekt = $Obj->A("objektName");
				$UO = $Obj;
			}
			
			$T->addRow(array($L->A("LagerName"), $L->A("LagerbestandsaenderungReferenz"), $Objekt, $UO != null ? "OBJ".($UO->getID() + 20000) : ""));
			
			#$Lag = new Lagerbestandsaenderung($L->A("LagerbestandsaenderungID"));
			#$Lag->changeA("LagerbestandsaenderungReferenz", "OBJ".($UO->getID() + 20000));
			#$Lag->saveMe();
		}
		
		return $T;
		/*$DB = new DBStorage();
		
		$C = $DB->getConnection();
		
		$C->query("DELETE FROM Adresse WHERE AuftragID = -1");
		$i1 = $C->affected_rows;
		
		$C->query("DELETE FROM Kappendix");
		$i2 = $C->affected_rows;
		
		return "<p>$i1 Adressen gelöscht</p><p>$i2 Kundendaten gelöscht</p>";*/
		
	}
}
?>