<?php
/**
 *  This file is part of ubiquitous.

 *  ubiquitous is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  ubiquitous is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses></http:>.
 * 
 *  2007 - 2020, open3A GmbH - Support@open3A.de
 */

class Wartung_mKassenbuch implements iWartung {
	public function getLabel(){
		if(!Session::isPluginLoaded("mKassenbuch"))
			return null;
		
		return "Kassenbuch";
	}

	public function getHTML() {
		$T = new HTMLTable(2, "Kassenbuch Aktionen");
		$T->setColWidth(1, 156);
		$T->setColClass(1, "");
		
		$B = new Button("Kassenbuch\nzurücksetzen", "trash");
		$B->doBefore("if(confirm('Möchten Sie wirklich das KOMPLETTE Kassenbuch LEEREN?')) %AFTER");
		$B->popup("", "Kassenbuch zurücksetzen", "Wartung", "-1", "runAction", array("'Wartung_mKassenbuch::deleteAll'"));
		
		$T->addRow(array($B, "Mit diesem Knopf setzen Sie das komplette Kassenbuch zurück auf Null!"));
		
		return $T;
	}
	
	
	public function deleteAll(){
		$fastMode = true;
		
		try {
			$DB = new DBStorage();

			$C = $DB->getConnection();
		} catch (ClassNotFoundException $ex) {
			$fastMode = false;
		}
		
		if(!$fastMode){
			$AC = anyC::get("Kassenbuch");
			$AC->setFieldsV3(array("KassenbuchDatum"));
			while($A = $AC->n())
				$A->deleteMe();
		} else {
			$DB = new DBStorage();

			$C = $DB->getConnection();

			$C->query("DELETE FROM Kassenbuch");
			$i = $C->affected_rows;
		}
		
		return "<p>$i Einträge gelöscht</p>";
	}
}
?>