<?php
/**
 *  This file is part of ubiquitous.

 *  ubiquitous is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  ubiquitous is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses></http:>.
 * 
 *  2007 - 2020, open3A GmbH - Support@open3A.de
 */

class Wartung_mImport implements iWartung {
	public function getLabel(){
		if(!Session::isPluginLoaded("mImport"))
			return null;
		
		return "Import";
	}

	public function getHTML() {
		$T = new HTMLTable(2, "Import Aktionen");
		$T->setColWidth(1, 156);
		$T->setColClass(1, "");
		
		$B = new Button("Importierte\nAdressen löschen", "trash");
		#$B->doBefore("if(confirm('Möchten Sie wirklich ALLE Adressen aus der Datenbank löschen?')) %AFTER");
		$B->popup("", "Importierte Adressen löschen", "Wartung", "-1", "runAction", array("'Wartung_mImport::showImports'"));
		
		$T->addRow(array($B, "Löscht die Adressen mit Kundennummer, Ansprechpartner und Tags, die durch einen Import angelegt wurden."));
		
		
		$B = new Button("Importierte\nArtikel löschen", "trash");
		$B->popup("", "Import löschen", "Wartung", "-1", "runAction", array("'Wartung_mImport::deleteImportPopup'"));
		
		$T->addRow(array($B, "Mit diesem Knopf löschen Sie alle Artikel aus einem bestimmten Import."));
		
		return $T;
	}
	
	public function deleteImportPopup(){
		$F = new HTMLForm("updatePrices", array("action", "import"));
		$F->getTable()->setColWidth(1, 120);
		
		#$kat = new Kategorien();
		#$kat->addAssocV3("type","=","2");
		#$keys = $kat->getArrayWithKeysAndValues();
		
		$opt = array();
		$AC = anyC::get("Artikel");
		$AC->addGroupV3("ArtikelImported");
		$AC->addAssocV3("ArtikelImported", "!=", "");
		while($A = $AC->n()){
			$opt[$A->A("ArtikelImported")] = $A->A("ArtikelImported");
		}
		
		$F->setType("import", "select", null, $opt);
		$F->setType("action", "hidden");
		
		$F->setLabel("import", "Import");
		
		$F->setValue("action", "Wartung_mImport::deleteImportNow");
		
		$F->useRecentlyChanged();
		$F->setSaveRMEPCR("Löschen", "", "Wartung", "-1", "runAction", "\$j('#editDetailsContentWartung').html(transport.responseText);");
		
		echo $F;
	}
	
	public function deleteImportNow($import){
		if($import == "")
			Red::errorD ("Bitte wählen Sie einen Import");
		
		$AC = anyC::get("Artikel");
		$AC->addAssocV3 ("ArtikelImported", "=", $import);
		
		$i = 0;
		while($A = $AC->getNextEntry()){
			$A->deleteMe();
			$i++;
		}
		
		return "<p>$i Artikel gelöscht</p>";
		
	}
	
	public function showImports(){
		$AC = anyC::get("Adresse");
		$AC->addGroupV3("SUBSTRING_INDEX(AdresseImported, ':', 1)");
		$AC->addAssocV3("AuftragID", "=", "-1");
		$keys = array("" => "Bitte auswählen…");
		while($A = $AC->n()){
			$ex = explode(":", $A->A("AdresseImported"));
			$keys[$ex[0]] = $ex[0];
		} 
		
		
		$F = new HTMLForm("deleteByImport", array("action", "import"));
		$F->getTable()->setColWidth(1, 120);
		
		$F->setType("import", "select", null, $keys);
		$F->setType("action", "hidden");
		
		$F->setLabel("import", "Import");
		
		$F->setValue("action", "Wartung_mImport::deleteImports");
		$F->setValue("import", "");
		
		$F->useRecentlyChanged();
		$F->setSaveRMEPCR("Löschen", "", "Wartung", "-1", "runAction", "\$j('#editDetailsContentWartung').html(transport.responseText);");
		
		return $F;
	}
	
	public function deleteImports($filename){
		$DB = new DBStorage();
		$C = $DB->getConnection();
		
		$IDs = array();
		$Q = $C->query("SELECT AdresseID FROM Adresse WHERE AdresseImported LIKE '$filename:%' AND AuftragID = '-1'");
		while($R = $Q->fetch_object())
			$IDs[] = $R->AdresseID;
			
		
		$C->query("DELETE FROM Adresse WHERE AdresseImported LIKE '$filename:%' AND AuftragID = '-1'");
		$C->query("DELETE FROM Kappendix WHERE AdresseID IN(". implode(",", $IDs).")");
		$C->query("DELETE FROM Tag WHERE TagOwnerClass = 'Adresse' AND TagOwnerClassID IN(". implode(",", $IDs).")");
		$C->query("DELETE FROM Ansprechpartner WHERE AnsprechpartnerOwnerClass = 'Adresse' AND AnsprechpartnerOwnerClassID IN(". implode(",", $IDs).")");
		
		return "<p>".count($IDs)." Adressen und Kundendaten gelöscht</p>";
	}
	
}
?>