<?php
/**
 *  This file is part of ubiquitous.

 *  ubiquitous is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  ubiquitous is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses></http:>.
 * 
 *  2007 - 2020, open3A GmbH - Support@open3A.de
 */

class Wartung_mBanking implements iWartung {
	public function getLabel(){
		if(!Session::isPluginLoaded("mBanking"))
			return null;
		
		return "Banking";
	}

	public function getHTML() {
		$T = new HTMLTable(2, "Banking Aktionen");
		$T->setColWidth(1, 156);
		$T->setColClass(1, "");
		
		$B = new Button("Doppelte Ein-\nträge löschen", "lieferschein");
		#$B->doBefore("if(confirm('Möchten Sie wirklich ALLE Artikel aus der Datenbank löschen?')) %AFTER");
		$B->popup("", "Doppelte Einträge löschen", "Wartung", "-1", "runAction", array("'Wartung_mBanking::deleteDoublePopup'"));
		
		$T->addRow(array($B, "Es werden manchmal doppelte Einträge erzeugt, sie können hier gelöscht werden."));
		
		return $T;
	}
	
	private $queryDouble = "SELECT 
			GROUP_CONCAT(BankingID) AS ids,
			CONCAT(`BankingRemoteName`, `BankingPurpose`, `BankingValueValue`,`BankingValutadate`, `BankingBankingKontoID`) AS suche, 
			CONCAT(`BankingRemoteName`, '<br>', `BankingPurpose`, '<br>', `BankingValueValue`, '<br>',`BankingValutadate`) AS text, 
			COUNT(CONCAT(`BankingRemoteName`, `BankingPurpose`, `BankingValueValue`,`BankingValutadate`)) AS anzahl
		FROM
			Banking
		GROUP BY 
			suche
		HAVING 
			COUNT(suche) > 1";
	
	public function deleteDoublePopup(){
		$DB = new DBStorage();
		$C = $DB->getConnection();
		
		$Q = $C->query($this->queryDouble);
		
		$T = new HTMLTable(2);
		$T->maxHeight(400);
		while($R = $Q->fetch_array()){
			$T->addRow([
				$R["text"]."<br><small style=\"color:grey;\">".$R["ids"]."</small>",
				$R["anzahl"]
			]);
		}
		
		$B = new Button("Einträge\nlöschen", "lieferschein");
		$B->style("margin:10px;float:right;");
		$B->rmePCR("Wartung", "-1", "runAction", "Wartung_mBanking::deleteDoubleNow", "function(transport){ \$j('#editDetailsContentWartung').html(transport.responseText); }");
		
		echo $T.$B;
	}
	
	public function deleteDoubleNow(){
		$DB = new DBStorage();
		$C = $DB->getConnection();
		
		$T = new HTMLTable(2);
		$T->maxHeight(400);
		$Q = $C->query($this->queryDouble);
		while($R = $Q->fetch_array()){
			$T->addRow([
				$R["text"]."<br><small style=\"color:grey;\">".$R["ids"]."</small>",
				$R["anzahl"]
			]);
			
			$AC = anyC::get("Banking");
			$AC->addAssocV3("BankingID", "IN", "(".$R["ids"].")");
			$canDelete = [];
			while($B = $AC->n()){
				$T->addRow([
					$B->A("BankingRemoteName"),
					""
				]);
				if(
					$B->A("BankingBuchungssatzID") + 
					$B->A("BankingGRLBMID") + 
					$B->A("BankingEingangsbelegID") + 
					$B->A("BankingBestellungID") + 
					$B->A("BankingZahlungsaufforderungID") + 
					$B->A("BankingKassenbuchID") == 0){
					
					$T->addRowClass ("confirm");
					$canDelete[] = $B->getID();
				} else
					$T->addRowClass ("highlight");
			}
			
			if(count($canDelete) == $AC->numLoaded()){
				unset($canDelete[0]);
				
				$C->query("DELETE FROM Banking WHERE BankingID IN(".implode(", ", $canDelete).")");
			}
			
			if(count($canDelete) == $AC->numLoaded() - 1){
				$C->query("DELETE FROM Banking WHERE BankingID IN(".implode(", ", $canDelete).")");
			}
		}
		
		echo $T;
	}
	
	/*public function (){
		$F = new HTMLForm("updatePrices", array("action", "oldPercentMwSt", "percentMwSt"));
		$F->getTable()->setColWidth(1, 120);
		
		$AC = anyC::get("VertragPosten");
		$AC->addAssocV3("VertragPostenArtikelID", "=", "0");
		$AC->addGroupV3("VertragPostenMwSt");
		$mwsts = array(-1 => "Alle");
		while($P = $AC->n())
			$mwsts[$P->A("VertragPostenMwSt")] = Util::CLNumberParserZ($P->A("VertragPostenMwSt"))."%";
		
		#$F->setType("KategorieID", "select", null, $keys);
		$F->setType("action", "hidden");
		$F->setType("oldPercentMwSt", "select", null, $mwsts);
		
		#$F->setLabel("KategorieID", "Kategorie");
		$F->setLabel("percentMwSt", "MwSt-Satz neu");
		$F->setLabel("oldPercentMwSt", "MwSt-Satz bisher");
		
		$F->setValue("action", "Wartung_mVertrag::changeMwStNow");
		
		$F->setDescriptionField("percentMwSt", "Angabe in %, z.B: 19,00");
		
		$F->useRecentlyChanged();
		$F->setSaveRMEPCR("Anpassen", "", "Wartung", "-1", "runAction", "\$j('#editDetailsContentWartung').html(transport.responseText);");
		
		echo "<p>Diese Funktion ändert den in den Vertragspositionen direkt eingetragenen Mehrwertsteuer-Satz. Die Artikel müssen extra angepasst werden!</p>".$F;
	}
	
	public function changeMwStNow($oldPercentMwSt, $percentMwSt){
		$percentMwSt = Util::CLNumberParserZ(str_replace("%", "", $percentMwSt), "store");

		if(trim($percentMwSt) == "")
			Red::alertD ("Bitte geben Sie einen Prozentsatz ein");
		
		$AC = anyC::get("VertragPosten");
		$AC->addAssocV3("VertragPostenArtikelID", "=", "0");
		if($oldPercentMwSt != "-1")
			$AC->addAssocV3("VertragPostenMwSt", "=", $oldPercentMwSt);
		
		$i = 0;
		while($A = $AC->getNextEntry()){
			
			$A->changeA("VertragPostenMwSt", $percentMwSt);
			
			$i++;
			$A->saveMe();
		}
		
		return "<p>$i Vertragspositionen angepasst</p>";
		
	}*/
}
?>