<?php
/**
 *  This file is part of ubiquitous.

 *  ubiquitous is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  ubiquitous is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses></http:>.
 * 
 *  2007 - 2020, open3A GmbH - Support@open3A.de
 */

class Wartung_mAuftrag implements iWartung {
	public function getLabel(){
		if(!Session::isPluginLoaded("Auftraege"))
			return null;
		
		return "Aufträge";
	}

	public function getHTML() {
		$T = new HTMLTable(2, "Aufträge Aktionen");
		$T->setColWidth(1, 156);
		$T->setColClass(1, "");
		
		$B = new Button("Alle Aufträge\nlöschen", "trash");
		$B->doBefore("if(confirm('Möchten Sie wirklich ALLE Aufträge aus der Datenbank löschen?')) %AFTER");
		$B->popup("", "Alle Aufträge löschen", "Wartung", "-1", "runAction", array("'Wartung_mAuftrag::deleteAll'"));
		
		$T->addRow(array($B, "Mit diesem Knopf löschen Sie alle Aufträge in der Datenbank."));
		
		
		$B = new Button("Rechnungen\nlöschen", "trash");
		#$B->doBefore("if(confirm('Möchten Sie wirklich ALLE Aufträge aus der Datenbank löschen?')) %AFTER");
		$B->popup("", "Rechnungen löschen", "Wartung", "-1", "runAction", array("'Wartung_mAuftrag::deleteBelegePopup'"));
		
		$T->addRow(array($B, "Mit diesem Knopf löschen Sie Rechnungen sowie die zugehörigen Aufräge."));
		
		
		$B = new Button("Belege vor\nDatum löschen", "trash");
		#$B->doBefore("if(confirm('Möchten Sie wirklich ALLE Aufträge aus der Datenbank löschen?')) %AFTER");
		$B->popup("", "Belege vor Datum löschen", "Wartung", "-1", "runAction", array("'Wartung_mAuftrag::deleteBelegeDatumPopup'"));
		
		$T->addRow(array($B, "Löscht alle Aufträge vor einem wählbaren Datum."));
		
		
		$B = new Button("Belege ab Datum\nneu berechnen", "trash");
		#$B->doBefore("if(confirm('Möchten Sie wirklich ALLE Aufträge aus der Datenbank löschen?')) %AFTER");
		$B->popup("", "Belege nach Datum neu berechnen", "Wartung", "-1", "runAction", array("'Wartung_mAuftrag::recalcBelegeDatumPopup'"));
		
		$T->addRow(array($B, "Berechnet alle Belege ab einem wählbaren Datum neu."));
		
		
		$B = new Button("Belege von\nTag löschen", "trash");
		#$B->doBefore("if(confirm('Möchten Sie wirklich ALLE Aufträge aus der Datenbank löschen?')) %AFTER");
		$B->popup("", "Belege vn Tag löschen", "Wartung", "-1", "runAction", array("'Wartung_mAuftrag::deleteBelegeDatumDayPopup'"));
		
		$T->addRow(array($B, "Löscht alle Belege von einem bestimmten Tag."));
		
		$B = new Button("Als bezahlt\nmarkieren", "trash");
		#$B->doBefore("if(confirm('Möchten Sie wirklich ALLE Aufträge aus der Datenbank löschen?')) %AFTER");
		$B->popup("", "Als bezahlt markieren", "Wartung", "-1", "runAction", array("'Wartung_mAuftrag::setBelegePayedPopup'"));
		
		$T->addRow(array($B, "Setzt alle unbezahlten Rechnungen und Gutschriften bis zu einem bestimmten Tag als bezahlt."));
		
		return $T;
	}
	
	public function setBelegePayedPopup(){
		$F = new HTMLForm("setPayed", array("datum"));
		$F->getTable()->setColWidth(1, 120);
		$F->setType("datum", "date");
				
		$BG = new Button("Als bezahlt\nmarkieren", "trash");
		$BG->doBefore("if(confirm('Die ausgewählten Rechnungen und Gutschriften als bezahlt markieren?')) %AFTER");
		$BG->style("float:right;margin:10px;");
		$BG->popup("", "Rechnungen markieren", "Wartung", "-1", "runAction", array("'Wartung_mAuftrag::setBelegePayedNow'", "joinFormFieldsToString('setPayed')"));
		
		return "<p>Wählen Sie den Tag, bis zu dem die Rechnungen als bezahlt markiert werden sollen. Es wird das Belegdatum als Zahldatum verwendet.</p>".$F.$BG;
	}
	
	public function setBelegePayedNow($data){
		parse_str($data, $data);
		$datum = Util::CLDateParser($data["datum"], "store");
		
		$i = 0;
		$AC = anyC::get("GRLBM");
		$AC->addAssocV3("datum", "<=", $datum);
		$AC->addAssocV3("isPayed", "=", "0");
		$AC->addAssocV3("isR", "=", "1", "AND", "2");
		$AC->addAssocV3("isG", "=", "1", "OR", "2");
		while($R = $AC->n()){
			$R->setPayed("true", "0,00", $R->A("datum"), "false", "", true, false);
			$i++;
		}
		
		return "<p style=\"color:green;\">$i Rechnung".($i == 1 ? "" : "en")." und/oder Gutschrift".($i == 1 ? "" : "en")." als bezahlt markiert.</p>";
	}
	
	
	public function deleteBelegeDatumDayPopup(){
		$F = new HTMLForm("deleteBelege", array("datum", "art"));
		$F->getTable()->setColWidth(1, 120);
		$F->setType("datum", "date");
		
		$F->setType("art", "select", "0", array("0" => "Alle", "R" => "Rechnungen", "L" => "Lieferscheine"));
		
		$BG = new Button("Belege\nlöschen", "trash");
		$BG->doBefore("if(confirm('Die ausgewählten Belege löschen?')) %AFTER");
		$BG->style("float:right;margin:10px;");
		$BG->popup("", "Belege löschen", "Wartung", "-1", "runAction", array("'Wartung_mAuftrag::deleteBelegeDatumDayNow'", "joinFormFieldsToString('deleteBelege')"));
		
		return "<p>Wählen Sie den Tag, von dem die Belege gelöscht werden sollen.</p><p>Wenn die zugehörigen Aufträge keine weiteren Belege mehr enthalten, werden sie ebenfalls gelöscht.</p>".$F.$BG;
	}
	
	public function deleteBelegeDatumDayNow($data){
		parse_str($data, $data);
		$datum = Util::CLDateParser($data["datum"], "store");
		
		$AC = anyC::get("GRLBM");
		$AC->addAssocV3("datum", "=", $datum);
		if($data["art"] != "0")
			$AC->addAssocV3 ("is".$data["art"], "=", "1");
		
		$i = 0;
		while($B = $AC->n()){
			$B->deleteMe ();
			
			$ACS = anyC::get("GRLBM", "AuftragID", $B->A("AuftragID"));
			$ACS->lCV3();
			
			if($ACS->numLoaded() == 0){
				$A = new Auftrag($B->A("AuftragID"));
				$A->deleteMe();
			}
			
			$i++;
		}
		
		return "<p style=\"color:green;\">$i Beleg".($i == 1 ? "" : "e")." gelöscht.</p>";
	}
	
	
	public function recalcBelegeDatumPopup(){
		$F = new HTMLForm("recalcBelege", array("datum"));
		$F->getTable()->setColWidth(1, 120);
		$F->setType("datum", "date");
		
		$BG = new Button("Belege\nneu berechnen", "refresh");
		$BG->doBefore("if(confirm('Die ausgewählten Belege neu berechnen?')) %AFTER");
		$BG->style("float:right;margin:10px;");
		$BG->popup("", "Belege löschen", "Wartung", "-1", "runAction", array("'Wartung_mAuftrag::recalcBelegeDatumNow'", "joinFormFieldsToString('recalcBelege')"));
		
		return "<p>Wählen Sie das Datum, <strong>ab</strong> dem die Belege neu berechnet werden sollen.</p>".$F.$BG;
	}
	
	public function recalcBelegeDatumNow($data){
		parse_str($data, $data);
		$datum = Util::CLDateParser($data["datum"], "store");
		
		$AC = anyC::get("GRLBM");
		$AC->addAssocV3("datum", ">=", $datum);
		$i = 0;
		Posten::$recalcBeleg = false;
		Posten::$ignoreLock = true;
		while($B = $AC->n()){
			$ACP = anyC::get("Posten", "GRLBMID", $B->getID());
			while($P = $ACP->n()){
				#$P = new Posten();
				$P->resetParsers();
				$P->saveMe(true, false, false);
			}
			#$B = new GRLBM();
			$B->getSumOfPosten(false, true);
			
			$i++;
		}
		
		return "<p style=\"color:green;\">$i Beleg".($i == 1 ? "" : "e")." neu berechnet.</p>";
	}
	
	public function deleteBelegeDatumPopup(){
		$F = new HTMLForm("deleteBelege", array("datum"));
		$F->getTable()->setColWidth(1, 120);
		$F->setType("datum", "date");
		
		$BG = new Button("Belege\nlöschen", "trash");
		$BG->doBefore("if(confirm('Die ausgewählten Belege löschen?')) %AFTER");
		$BG->style("float:right;margin:10px;");
		$BG->popup("", "Belege löschen", "Wartung", "-1", "runAction", array("'Wartung_mAuftrag::deleteBelegeDatumNow'", "joinFormFieldsToString('deleteBelege')"));
		
		return "<p>Wählen Sie das Datum, <strong>vor</strong> dem die Belege gelöscht werden sollen.</p><p>Wenn die zugehörigen Aufträge keine weiteren Belege mehr enthalten, werden sie ebenfalls gelöscht.</p>".$F.$BG;
	}
	
	public function deleteBelegeDatumNow($data){
		parse_str($data, $data);
		$datum = Util::CLDateParser($data["datum"], "store");
		
		$AC = anyC::get("GRLBM");
		$AC->addAssocV3("datum", "<", $datum);
		
		Posten::$ignoreLock = true;
		$i = 0;
		while($B = $AC->n()){
			$B->deleteMe ();
			
			$ACS = anyC::get("GRLBM", "AuftragID", $B->A("AuftragID"));
			$ACS->lCV3();
			
			if($ACS->numLoaded() == 0){
				$A = new Auftrag($B->A("AuftragID"));
				$A->deleteMe();
			}
			
			$i++;
		}
		
		return "<p style=\"color:green;\">$i Beleg".($i == 1 ? "" : "e")." gelöscht.</p>";
	}
	
	public function deleteBelegePopup(){
		$T = new HTMLTable(3);
		$T->setColWidth(3, 20);
		#$T->setColWidth(1, 20);
		$T->maxHeight(400);
		$T->setTableStyle("padding-left:0px; ");
		
		$T->addColStyle(1,"text-align:left;width:180px;");
		$T->addColStyle(2,"text-align:right;");
		$T->useForSelection(false);
		
		$AC = anyC::get("GRLBM", "isR", "1");
		$AC->addJoinV3("Auftrag", "AuftragID","=","AuftragID");
		$AC->addJoinV3("Kappendix", "t2.kundennummer", "=", "kundennummer");
		$AC->addJoinV3("Adresse", "t2.AdresseID", "=","AdresseID");
		$AC->addOrderV3("datum", "DESC");
		$AC->addOrderV3("nummer", "DESC");
		$AC->setLimitV3(150);
			
		$list = BPS::getProperty("CustomizerAuftragBelegkopieGUI", "list", ",");
		
		while($B = $AC->getNextEntry()){
		
			$HI = new HTMLInput("copyBelegID".$B->getID(), "checkbox", 0);
			$HI->id("copyBelegID".$B->getID());
			if(strpos($list, ",".$B->getID().",") !== false)
				$HI->setValue (1);
			
			$HI->onchange("if(this.checked) ".OnEvent::rme($this, "addToList", array($B->getID()))." else ".OnEvent::rme($this, "removeFromList", array($B->getID()))." ".OnEvent::reloadSidePanel(str_replace("GUI", "", get_class($this))));
			
			$name = $B->A("firma");
			if($name == "") $name = $B->A("vorname")." ".$B->A("nachname");
			
			$BS = new Button("Beleg anzeigen", "./images/i2/pdf.gif", "icon");
			$BS->windowRme("Auftrag", $B->A("AuftragID"), "getGRLBMPDF", array("'false'","''",$B->getID()), '_Brief;templateType:PDF');
			$T->addRow(array(
				"<small style=\"color:grey;\">".$name." (".$B->A("kundennummer").")</small><br />".$B->A("prefix").$B->A("nummer"),
				Util::CLDateParser($B->A("datum"))."<br><small style=\"color:grey;\">".Util::CLFormatCurrency($B->A("bruttobetrag") * 1)."</small>",
				$HI));
		
			#$T->addCellStyle (2, "text-align:left;");
			
			$action = "\$j('#copyBelegID".$B->getID()."').prop('checked', !\$j('#copyBelegID".$B->getID()."').prop('checked')).trigger('change')";
			
			$T->addCellEvent(1, "click", $action);
			$T->addCellEvent(2, "click", $action);
		}
		
		$BG = new Button("Rechnungen\nlöschen", "trash");
		$BG->doBefore("if(confirm('Die ausgewählten Belege löschen?')) %AFTER");
		$BG->style("float:right;margin:10px;");
		$BG->popup("", "Belege löschen", "Wartung", "-1", "runAction", array("'Wartung_mAuftrag::deleteBelegeNow'", "joinFormFieldsToString('deleteBelege')"));
		
		return "<p>Wenn die zugehörigen Aufträge keine weiteren Belege mehr enthalten, werden sie ebenfalls gelöscht.</p><form id=\"deleteBelege\">".$T."</form>".$BG."<div style=\"clear:both;\"></div>";
	}
	
	public function deleteBelegeNow($data){
		parse_str($data, $data);
		
		$T = new HTMLTable(2);
		$T->addColStyle(1,"text-align:left;width:180px;");
		$T->addColStyle(2,"text-align:right;");
		
		$i = 0;
		foreach($data AS $GRLBMID => $action){
			if($action != "1")
				continue;
			
			
			$B = new GRLBM(str_replace("copyBelegID", "", $GRLBMID), false);
			
			$T->addRow(array(
				$B->A("prefix").$B->A("nummer"),
				Util::CLDateParser($B->A("datum"))."<br><small style=\"color:grey;\">".Util::CLFormatCurrency($B->A("bruttobetrag") * 1)."</small>",
				));
			
			$B->deleteMe();
			
			
			$AC = anyC::get("GRLBM", "AuftragID", $B->A("AuftragID"));
			$AC->addAssocV3("isM", "=", "0");
			$AC->lCV3();
			
			if($AC->numLoaded() == 0){
				#$G = $AC->n();
				$A = new Auftrag($B->A("AuftragID"));
				$A->deleteMe();
			}
			$i++;
		}
		
		return "<p style=\"color:green;\">$i Beleg".($i == 1 ? "" : "e")." gelöscht.</p>".$this->deleteBelegePopup();
	}
	
	public function deleteAll(){
		$DB = new DBStorage();
		
		$C = $DB->getConnection();
		
		$C->query("DELETE FROM GRLBM");
		$i1 = $C->affected_rows;
		
		$C->query("DELETE FROM Posten");
		$i2 = $C->affected_rows;
		
		$C->query("DELETE FROM Auftrag");
		$i3 = $C->affected_rows;
		
		$C->query("DELETE FROM Adresse WHERE AuftragID != -1");
		$i4 = $C->affected_rows;
		
		return "<p>$i1 Posten gelöscht</p><p>$i2 Belege gelöscht</p><p>$i3 Aufträge gelöscht</p><p>$i4 Adressen gelöscht</p>";
	}
}
?>