<?php
/**
 *  This file is part of ubiquitous.

 *  ubiquitous is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  ubiquitous is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses></http:>.
 * 
 *  2007 - 2020, open3A GmbH - Support@open3A.de
 */

class Wartung_mArtikel implements iWartung {
	public function getLabel(){
		if(!Session::isPluginLoaded("mArtikel"))
			return null;
		
		return "Artikel";
	}

	public function getHTML() {
		$T = new HTMLTable(2, "Artikel Aktionen");
		$T->setColWidth(1, 156);
		$T->setColClass(1, "");
		
		$B = new Button("Artikelpreise\nanpassen", "lieferschein");
		#$B->doBefore("if(confirm('Möchten Sie wirklich ALLE Artikel aus der Datenbank löschen?')) %AFTER");
		$B->popup("", "Artikelpreise anpassen", "Wartung", "-1", "runAction", array("'Wartung_mArtikel::changePricesPopup'"));
		
		$T->addRow(array($B, "Passen Sie hier die Artikelpreise an."));
		
		if(Session::isPluginLoaded("mLieferant")){
			$B = new Button("Lieferantenpreise\nanpassen", "lieferschein");
			#$B->doBefore("if(confirm('Möchten Sie wirklich ALLE Artikel aus der Datenbank löschen?')) %AFTER");
			$B->popup("", "Lieferantenpreise anpassen", "Wartung", "-1", "runAction", array("'Wartung_mArtikel::changeDPricesPopup'"));

			$T->addRow(array($B, "Passen Sie hier die Lieferantenpreise an."));
		}
		
		$B = new Button("MwSt-Satz\nanpassen", "lieferschein");
		#$B->doBefore("if(confirm('Möchten Sie wirklich ALLE Artikel aus der Datenbank löschen?')) %AFTER");
		$B->popup("", "MwSt-Satz anpassen", "Wartung", "-1", "runAction", array("'Wartung_mArtikel::changeMwStPopup'"));
		
		$T->addRow(array($B, "Passen Sie hier die Mehrwertsteuer an."));
		
		if(Session::isPluginLoaded("mBBDienststelle")){
			$B = new Button("Steuerkennz.\nanpassen", "lieferschein");
			#$B->doBefore("if(confirm('Möchten Sie wirklich ALLE Artikel aus der Datenbank löschen?')) %AFTER");
			$B->popup("", "Steuerkennz. anpassen", "Wartung", "-1", "runAction", array("'Wartung_mArtikel::changeSteuerkennzPopup'"));

			$T->addRow(array($B, "Passen Sie hier die Steuerkennzeichen an."));
		}
		
		if(Session::isPluginLoaded("mBrutto")){
			$B = new Button("In Brutto-\nArtikel ändern", "lieferschein");
			#$B->doBefore("if(confirm('Möchten Sie wirklich ALLE Artikel aus der Datenbank löschen?')) %AFTER");
			$B->popup("", "In Brutto-Artikel ändern", "Wartung", "-1", "runAction", array("'Wartung_mArtikel::changeToBrutto'"));

			$T->addRow(array($B, "Ändern Sie Artikel-Preise in Brutto-Preise."));
		}
		
		$T->addRow(array("&nbsp;"));
		$T->addRowClass("backgroundColor0");
		
		$B = new Button("Alle Artikel\nlöschen", "trash");
		$B->doBefore("if(confirm('Möchten Sie wirklich ALLE Artikel aus der Datenbank löschen?')) %AFTER");
		$B->popup("", "Alle Artikel löschen", "Wartung", "-1", "runAction", array("'Wartung_mArtikel::deleteAll'"));
		
		$T->addRow(array($B, "Mit diesem Knopf löschen Sie alle Artikel in der Datenbank."));
		
		$B = new Button("Artikel in Kate-\ngorie löschen", "trash");
		$B->popup("", "Artikel löschen", "Wartung", "-1", "runAction", array("'Wartung_mArtikel::deleteCategoryPopup'"));
		
		$T->addRow(array($B, "Mit diesem Knopf löschen Sie alle Artikel in einer bestimmten Kategorie."));
		
		return $T;
	}
	
	
	public function deleteCategoryPopup(){
		$F = new HTMLForm("updatePrices", array("action", "KategorieID"));
		$F->getTable()->setColWidth(1, 120);
		
		$kat = new Kategorien();
		$kat->addAssocV3("type","=","2");
		$keys = $kat->getArrayWithKeysAndValues();
		
		$F->setType("KategorieID", "select", null, $keys);
		$F->setType("action", "hidden");
		
		$F->setLabel("KategorieID", "Kategorie");
		
		$F->setValue("action", "Wartung_mArtikel::deleteCategoryNow");
		
		$F->useRecentlyChanged();
		$F->setSaveRMEPCR("Löschen", "", "Wartung", "-1", "runAction", "\$j('#editDetailsContentWartung').html(transport.responseText);");
		
		echo $F;
	}
	
	public function deleteCategoryNow($KategorieID){
		if($KategorieID == "0")
			Red::errorD ("Bitte wählen Sie eine Kategorie");
		
		$AC = anyC::get("Artikel");
		if($KategorieID != "0")
			$AC->addAssocV3 ("KategorieID", "=", $KategorieID);
		
		$i = 0;
		while($A = $AC->getNextEntry()){
			$A->deleteMe();
			$i++;
		}
		
		return "<p>$i Artikel gelöscht</p>";
		
	}
	
	public function changeToBrutto(){
		$F = new HTMLForm("updatePrices", array("action", "KategorieID"));
		$F->getTable()->setColWidth(1, 120);
		
		$kat = new Kategorien();
		$kat->addAssocV3("type","=","2");
		$keys = $kat->getArrayWithKeysAndValues("Alle");
		
		$F->setType("KategorieID", "select", null, $keys);
		$F->setType("action", "hidden");
		
		$F->setLabel("KategorieID", "Kategorie");
		
		$F->setValue("action", "Wartung_mArtikel::changeToBruttoNow");
		
		$F->useRecentlyChanged();
		$F->setSaveRMEPCR("Anpassen", "", "Wartung", "-1", "runAction", "\$j('#editDetailsContentWartung').html(transport.responseText);");
		
		echo "<p>Diese Funktion ändert die Artikel in der ausgewählten Kategorie in Brutto-Artikel. Um den Preis zu erhöhen, verwenden Sie die Funktion 'Artikelpreise anpassen'.</p>".$F;
	}
	
	public function changeToBruttoNow($KategorieID){
		
		$AC = anyC::get("Artikel");
		if($KategorieID != "0")
			$AC->addAssocV3("KategorieID", "=", $KategorieID);
		
		$i = 0;
		while($A = $AC->getNextEntry()){
			$A->resetParsers();
			
			$A->changeA("isBrutto", "1");
			
			$i++;
			$A->saveMe();
		}
		
		return "<p>$i Artikel angepasst</p>";
		
	}
	
	public function changeDPricesPopup(){
		$fields = array("action", "KategorieID");
		$fields[] = "LieferantID";
		$fields[] = "percentLP";
		#$fields[] = "percentNettoEK";
		
		$F = new HTMLForm("updatePrices", $fields);
		$F->getTable()->setColWidth(1, 120);
		
		$kat = new Kategorien();
		$kat->addAssocV3("type","=","2");
		$keys = $kat->getArrayWithKeysAndValues("Alle");
		
		$F->setType("KategorieID", "select", null, $keys);
		$F->setType("action", "hidden");
		
		$F->setLabel("KategorieID", "Kategorie");
		$F->setLabel("percentLP", "Listenpreis");
		
		$F->setValue("action", "Wartung_mArtikel::changeDPricesNow");
		
		$AC = anyC::get("Lieferant");
		$Ls = array();
		while($L = $AC->n())
			$Ls[$L->getID()] = $L->A("LieferantFirma");

		$F->setType("LieferantID", "select", 0, $Ls);
		$F->setLabel("LieferantID", "Lieferant");
		
		
		$F->setDescriptionField("percentLP", "Änderung in Prozent: 0,8 verringert den Preis um 20%; 1,5 erhöht den Preis um 50%");
		#$F->setDescriptionField("percentNettoEK", "Änderung in Prozent: 0,8 verringert den Preis um 20%; 1,5 erhöht den Preis um 50%");
		
		$F->useRecentlyChanged();
		$F->setSaveRMEPCR("Anpassen", "", "Wartung", "-1", "runAction", "\$j('#editDetailsContentWartung').html(transport.responseText);");
		
		echo "<p>Diese Funktion ändert nur die Lieferantenpreise.</p>".$F;
	}
	
	public function changePricesPopup(){
		$F = new HTMLForm("updatePrices", array("action", "KategorieID", "percentNettoVK", "percentNettoEK"));
		$F->getTable()->setColWidth(1, 120);
		
		$kat = new Kategorien();
		$kat->addAssocV3("type","=","2");
		$keys = $kat->getArrayWithKeysAndValues("Alle");
		
		$F->setType("KategorieID", "select", null, $keys);
		$F->setType("action", "hidden");
		
		$F->setLabel("KategorieID", "Kategorie");
		$F->setLabel("percentNettoVK", "Netto-VK");
		$F->setLabel("percentNettoEK", "Netto-EK");
		
		$F->setValue("action", "Wartung_mArtikel::changePricesNow");
		
		$F->setDescriptionField("percentNettoVK", "Änderung in Prozent: 0,8 verringert den Preis um 20%; 1,5 erhöht den Preis um 50%");
		$F->setDescriptionField("percentNettoEK", "Änderung in Prozent: 0,8 verringert den Preis um 20%; 1,5 erhöht den Preis um 50%");
		
		$F->useRecentlyChanged();
		$F->setSaveRMEPCR("Anpassen", "", "Wartung", "-1", "runAction", "\$j('#editDetailsContentWartung').html(transport.responseText);");
		
		echo "<p>Diese Funktion ändert nur die direkt im Artikel eingetragenen Preise.</p>".$F;
	}
	
	public function changeSteuerkennzPopup(){
		$F = new HTMLForm("updatePrices", array("action", "oldStKz", "newStKz"));
		$F->getTable()->setColWidth(1, 120);
		
		$ac = anyC::get("Artikel");
		$ac->addGroupV3("steuerkennzeichen");
		$stkz = ["" => "Bitte auswählen…"];
		while($A = $ac->n())
			$stkz[$A->A("steuerkennzeichen")] = CustomizerAutoBistumBamberg::$steuerkennzeichen[$A->A("steuerkennzeichen")];
		
		$F->setType("action", "hidden");
		$F->setType("oldStKz", "select", null, $stkz);
		$F->setType("newStKz", "select", null, CustomizerAutoBistumBamberg::$steuerkennzeichen);
		
		$F->setLabel("newStKz", "Steuerkennz. neu");
		$F->setLabel("oldStKz", "Steuerkennz. bisher");
		
		$F->setValue("action", "Wartung_mArtikel::changeSteuerkennzNow");
		
		$F->useRecentlyChanged();
		$F->setSaveRMEPCR("Anpassen", "", "Wartung", "-1", "runAction", "\$j('#editDetailsContentWartung').html(transport.responseText);");
		
		echo "<p>Diese Funktion ändert das im Artikel eingetragene Steuerkennzeichen.</p>".$F;
	}
	
	public function changeSteuerkennzNow($oldStKz, $newStKz){
		
		if($oldStKz == "" OR $newStKz == "")
			Red::alertD ("Bitte wählen Sie zwei Steuerkennzeichen");
		
		$AC = anyC::get("Artikel", "steuerkennzeichen", $oldStKz);
		
		$i = 0;
		while($A = $AC->getNextEntry()){
			$A->resetParsers();
			
			$A->changeA("steuerkennzeichen", $newStKz);
			
			if($A->A("isBrutto") == "1")
				$A->changeA("preis", $A->A("bruttopreis"));
			
			$i++;
			$A->saveMe();
		}
		
		return "<p>$i Artikel angepasst</p>";
		
	}
	
	public function changeMwStPopup(){
		$F = new HTMLForm("updatePrices", array("action", "KategorieID", "oldPercentMwSt", "percentMwSt"));
		$F->getTable()->setColWidth(1, 120);
		
		$kat = new Kategorien();
		$kat->addAssocV3("type","=","2");
		$keys = $kat->getArrayWithKeysAndValues("Alle");
		
		$mwst = new Kategorien();
		$mwst->addAssocV3("type","=","mwst");
		$mwsts = $mwst->getArrayWithKeysAndValues("Alle");
		
		$F->setType("KategorieID", "select", null, $keys);
		$F->setType("action", "hidden");
		$F->setType("oldPercentMwSt", "select", null, $mwsts);
		
		$F->setLabel("KategorieID", "Kategorie");
		$F->setLabel("percentMwSt", "MwSt-Satz neu");
		$F->setLabel("oldPercentMwSt", "MwSt-Satz bisher");
		
		$F->setValue("action", "Wartung_mArtikel::changeMwStNow");
		
		$F->setDescriptionField("percentMwSt", "Angabe in %, z.B: 19,00");
		
		$F->useRecentlyChanged();
		$F->setSaveRMEPCR("Anpassen", "", "Wartung", "-1", "runAction", "\$j('#editDetailsContentWartung').html(transport.responseText);");
		
		echo "<p>Diese Funktion ändert nur den direkt im Artikel eingetragenen Mehrwertsteuer-Satz.</p>".$F;
	}
	
	public function changeDPricesNow($KategorieID, $LieferantID, $percentLP){
		$percentLP = Util::CLNumberParserZ($percentLP, "store");
		
		if($percentLP == null)
			Red::alertD ("Bitte geben Sie einen Prozentsatz ein");
		
		$AC = anyC::get("LieferantPreis", "LieferantPreisLieferantID", $LieferantID);
		$AC->addAssocV3("LieferantPreisVarianteArtikelID", "=", "0");
		$AC->addJoinV3("Artikel", "LieferantPreisArtikelID", "=", "ArtikelID");
		#$AC = anyC::get("Artikel");
		if($KategorieID != "0")
			$AC->addAssocV3("KategorieID", "=", $KategorieID);
		$AC->setFieldsV3(array("t1.*"));
		$i = 0;
		while($A = $AC->getNextEntry()){
			$A->resetParsers();
			
			$A->changeA("LieferantPreisListenPreis", $A->A("LieferantPreisListenPreis") * $percentLP);
			
			$i++;
			$A->saveMe();
		}
		
		return "<p>$i Artikel angepasst</p>";
		
	}
	
	public function changePricesNow($KategorieID, $percentNettoVK, $percentNettoEK){
		$percentNettoVK = Util::CLNumberParserZ($percentNettoVK, "store");
		$percentNettoEK = Util::CLNumberParserZ($percentNettoEK, "store");
		
		if($percentNettoEK == null AND $percentNettoVK == null)
			Red::alertD ("Bitte geben Sie mindestens einen Prozentsatz ein");
		
		$AC = anyC::get("Artikel");
		if($KategorieID != "0")
			$AC->addAssocV3 ("KategorieID", "=", $KategorieID);
		
		$i = 0;
		while($A = $AC->getNextEntry()){
			$A->resetParsers();
			
			if($A->A("isBrutto") == "0" AND $percentNettoVK != null)
				$A->changeA("preis", $A->A("preis") * $percentNettoVK);
			
			if($A->A("isBrutto") == "1" AND $percentNettoVK != null)
				$A->changeA("preis", $A->A("bruttopreis") * $percentNettoVK);
			
			
			if($percentNettoEK != null)
				$A->changeA("EK1", $A->A("EK1") * $percentNettoEK);
			
			$i++;
			$A->saveMe();
		}
		
		return "<p>$i Artikel angepasst</p>";
		
	}
	
	public function changeMwStNow($KategorieID, $oldPercentMwSt, $percentMwSt){
		$percentMwStOrig = str_replace("%", "", $percentMwSt);
		$percentMwSt = Util::CLNumberParserZ($percentMwStOrig, "store");
		
		if(trim($percentMwSt) == "")
			Red::alertD ("Bitte geben Sie einen Prozentsatz ein");
		
		$AC = anyC::get("Kategorie", "name", Util::formatNumber("de_DE",Util::CLNumberParser($percentMwStOrig, "store"))."%");
		$AC->addAssocV3("type", "=", "mwst");
		$K = $AC->n();
		if(!$K){
			$F = new Factory("Kategorie");
			$F->sA("name", Util::formatNumber("de_DE",Util::CLNumberParser($percentMwStOrig, "store"))."%");
			$F->sA("type", "mwst");
			$F->store();
		}
		
		$AC = anyC::get("Artikel");
		if($KategorieID != "0")
			$AC->addAssocV3 ("KategorieID", "=", $KategorieID);
		if($oldPercentMwSt != "0"){
			$KO = new Kategorie($oldPercentMwSt);
			$AC->addAssocV3("mwst", "=", Util::parseFloat("de_DE", str_replace("%", "", $KO->A("name"))));
		}
		
		$i = 0;
		while($A = $AC->getNextEntry()){
			$A->resetParsers();
			
			$A->changeA("mwst", $percentMwSt);
			
			if($A->A("isBrutto") == "1")
				$A->changeA("preis", $A->A("bruttopreis"));
			
			$i++;
			$A->saveMe();
		}
		
		return "<p>$i Artikel angepasst</p>";
		
	}
	
	public function deleteAll(){
		$DB = new DBStorage();
		
		$C = $DB->getConnection();
		$C->query("DELETE FROM Artikel");
		$i = $C->affected_rows;
		
		$C->query("DELETE FROM LieferantPreis");
		
		return "<p>$i Artikel gelöscht</p>";
	}
}
?>