<?php
/**
 *  This file is part of ubiquitous.

 *  ubiquitous is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  ubiquitous is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses></http:>.
 * 
 *  2007 - 2020, open3A GmbH - Support@open3A.de
 */

class Wartung_mAdresse implements iWartung {
	public function getLabel(){
		if(!Session::isPluginLoaded("Adressen"))
			return null;
		
		return "Adressen";
	}

	public function getHTML() {
		$T = new HTMLTable(2, "Adressen Aktionen");
		$T->setColWidth(1, 156);
		$T->setColClass(1, "");
		
		$B = new Button("Alle Adressen\nlöschen", "trash");
		$B->doBefore("if(confirm('Möchten Sie wirklich ALLE Adressen aus der Datenbank löschen?')) %AFTER");
		$B->popup("", "Alle Adressen löschen", "Wartung", "-1", "runAction", array("'Wartung_mAdresse::deleteAll'"));
		
		$T->addRow(array($B, "Mit diesem Knopf löschen Sie alle Adressen in der Datenbank. Dies setzt auch die Kundennummern zurück!"));
		
		$B = new Button("Leere Adressen\nlöschen", "trash");
		$B->doBefore("if(confirm('Möchten Sie wirklich alle leeren Adressen aus der Datenbank löschen?')) %AFTER");
		$B->popup("", "Alle leeren Adressen löschen", "Wartung", "-1", "runAction", array("'Wartung_mAdresse::deleteEmpty'"));
		
		$T->addRow(array($B, "Mit diesem Knopf löschen Sie die Adressen in der Datenbank, die keine Einträge bei Firma, Vor- und Nachname sowie in der Adresse haben. Dies löscht auch die Kundennummern!"));
		
		
		$B = new Button("Verwaiste Kunden-\ndaten anzeigen", "empty");
		#$B->doBefore("if(confirm('Möchten Sie wirklich ALLE Adressen aus der Datenbank löschen?')) %AFTER");
		$B->popup("", "Verwaiste Kundendaten anzeigen", "Wartung", "-1", "runAction", array("'Wartung_mAdresse::showOrphans'"));
		
		$T->addRow(array($B, "Zeigt alle Kundendaten an, die keine Verbindung zu einer Adresse oder einem Auftrag mehr haben."));
		
		$B = new Button("Kundennummern\nlöschen", "trash");
		#$B->doBefore("if(confirm('Möchten Sie wirklich ALLE Adressen aus der Datenbank löschen?')) %AFTER");
		$B->popup("", "Kundennummern löschen", "Wartung", "-1", "runAction", array("'Wartung_mAdresse::showKdList'"));
		
		$T->addRow(array($B, "Verarbeitet eine Liste von Kundennummern und löscht diese zusammen mit der Adresse aus der Datenbank."));
		
		#$B = new Button("Duplikate\nfinden", "seiten");
		#$B->doBefore("if(confirm('Möchten Sie wirklich ALLE Adressen aus der Datenbank löschen?')) %AFTER");
		#$B->popup("", "Duplikate finden", "Wartung", "-1", "runAction", array("'Wartung_mAdresse::showDuplicates'"));
		#$B->loading();
		
		#$T->addRow(array($B, "Findet Duplikate in der Adressen-Datenbank"));
		
		return $T;
	}
	
	public function showDuplicates(){
		set_time_limit (0);
		
		$DB = new DBStorage();
		
		$C = $DB->getConnection();
		$Q = $C->query("SELECT * FROM Adresse WHERE type = 'default' AND AuftragID = -1");
		#$AC1 = anyC::get("Adresse", "AuftragID", "-1");
		#$AC1->addAssocV3("type", "=", "default");
		
		$AC2 = anyC::get("Adresse", "AuftragID", "-1");
		$AC2->addAssocV3("type", "=", "AB1");
		
		$i = 0;
		$T = new HTMLTable(2);
		$T->maxHeight(400);
		while($A1 = $Q->fetch_object()){
			while($A2 = $AC2->n()){
				if(strtolower($A1->vorname) != strtolower($A2->A("vorname"))
					OR strtolower($A1->nachname) != strtolower($A2->A("nachname")))
					continue;
				
				if($A1->email != "" AND $A2->A("email") != "" AND $A1->email != $A2->A("email")) 
					continue;
				
				$T->addRow(array("$A1->vorname $A1->nachname", $A2->getShortAddress()));
				
				$A2->deleteMe();
				$C->query("UPDATE Tag SET TagOwnerClassID = '$A1->AdresseID' WHERE TagOwnerClass = 'Adresse' AND TagOwnerClassID = '".$A2->getID()."'");
				
				$i++;
			}
			$AC2->resetPointer();
		}
		
		$T->addRow(array("Gesamt: $i"));
		$T->addRowColspan(1, 2);
		
		return $T;
	}
	
	public function showKdList(){
		
		$I = new HTMLInput("kdnr", "textarea");
		$I->style("width:380px;margin-left:10px;height:300px;");
		
		$B = new Button("Kundennummern\nlöschen", "trash");
		$B->style("float:right;margin:10px;");
		$B->popup("", "", "Wartung", "-1", "runAction", array("'Wartung_mAdresse::deleteKdList'", "\$j('[name=kdnr]').val()"));
		
		return "<p style=\"color:grey;\">Bitte geben Sie pro Zeile eine Kundennummer ein:</p>$I$B<div style=\"clear:both;\"></div>";
	}
	
	public function deleteKdList($list){

		$T = new HTMLTable(1);
		$T->maxHeight(400);
		$ex = explode("\n", $list);
		foreach($ex AS $KN){
			$A = anyC::getFirst("Auftrag", "kundennummer", $KN);
			if($A != null){
				$T->addRow(array("$KN wird in Auftrag verwendet"));
				$T->addRowClass("error");
				continue;
			}
			
			$K = Kappendix::getKappendixToKundennummer($KN);
			if($K == null){
				$T->addRow(array("$KN unbekannt"));
				$T->addRowClass("error");
				continue;
			}
			
			$Adresse = new Adresse($K->A("AdresseID"));
			$Adresse->deleteMe();
			
			$K->deleteMe();
			
			$T->addRow(array("$KN gelöscht"));
		}
		
		return $T;
	}
	
	public function showOrphans(){
		$AC = anyC::get("Kappendix");
		$AC->addJoinV3("Adresse", "AdresseID", "=", "AdresseID");
		$AC->addAssocV3("vorname", "IS", "NULL");
		$AC->addOrderV3("kundennummer", "DESC");
		
		$T = new HTMLTable(2);
		$T->maxHeight(400);
		$T->setColWidth(2, 20);
		while($K = $AC->getNextEntry()){
			$ACA = anyC::get("Auftrag", "kundennummer", $K->A("kundennummer"));
			$KA = $ACA->getNextEntry();
			
			$B = new Button("Kundendaten löschen", "trash_stroke", "iconic");
			$B->popup("", "Verwaiste Kundendaten anzeigen", "Wartung", "-1", "runAction", array("'Wartung_mAdresse::deleteOrphan'", $K->getID()));
			
			if($KA == null)
				$T->addRow(array($K->A("kundennummer"), $B));
		}
		
		return $T;
	}
	
	public function deleteOrphan($KID){
		$K = new Kappendix($KID);
		$K->deleteMe();
		
		return $this->showOrphans();
	}
	
	public function deleteEmpty(){
		$fastMode = true;
		
		try {
			$DB = new DBStorage();

			$C = $DB->getConnection();
		} catch (ClassNotFoundException $ex) {
			$fastMode = false;
		}
		
		$AC = anyC::get("Adresse", "AuftragID", "-1");
		$AC->addAssocV3("firma", "=", "");
		$AC->addAssocV3("vorname", "=", "");
		$AC->addAssocV3("nachname", "=", "");
		
		$AC->addAssocV3("strasse", "=", "");
		$AC->addAssocV3("nr", "=", "");
		$AC->addAssocV3("ort", "=", "");
		$AC->addAssocV3("plz", "=", "");
		#$AC->lCV3();
		$i = 0;
		while($A = $AC->n()){
			$A->deleteMe();
			
			if($fastMode)
				$C->query("DELETE FROM Kappendix WHERE AdresseID = '".$A->getID()."'");
			else {
				$ACS = anyC::get("Kappendix");
				$ACS->addAssocV3("AdresseID", "=", $A->getID());
				$K = $ACS->n();
				if($K)
					$K->deleteMe();
			}
			
			$i++;
		}
		return "<p>$i Adressen und Kundendaten gelöscht</p>";
	}
	
	public function deleteAll(){
		$fastMode = true;
		
		try {
			$DB = new DBStorage();

			$C = $DB->getConnection();
		} catch (ClassNotFoundException $ex) {
			$fastMode = false;
		}
		
		if(!$fastMode){
			$AC = anyC::get("Adresse");
			$AC->setFieldsV3(array("firma"));
			while($A = $AC->n())
				$A->deleteMe();
			
			
			$AC = anyC::get("Kappendix");
			$AC->setFieldsV3(array("kundennummer"));
			while($K = $AC->n())
				$K->deleteMe();
			
		} else {
			$DB = new DBStorage();

			$C = $DB->getConnection();

			$C->query("DELETE FROM Adresse WHERE AuftragID = -1");
			$i1 = $C->affected_rows;

			$C->query("DELETE FROM Kappendix");
			$i2 = $C->affected_rows;

			$C->query("DELETE FROM Akquise");
			$C->query("DELETE FROM AkquiseLead");
		}
		
		return "<p>$i1 Adressen gelöscht</p><p>$i2 Kundendaten gelöscht</p>";
	}
}
?>