<?php
/**
 *  This file is part of ubiquitous.

 *  ubiquitous is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  ubiquitous is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses></http:>.
 * 
 *  2007 - 2020, open3A GmbH - Support@open3A.de
 */

class Wartung_Database implements iWartung {
	public function getLabel(){
		#if(!Session::isPluginLoaded("Adressen"))
		#	return null;
		
		return "Datenbank";
	}

	public function getHTML() {
		$T = new HTMLTable(2, "Datenbank Aktionen");
		$T->setColWidth(1, 156);
		$T->setColClass(1, "");
		
		$B = new Button("Tabellennamen\nanpassen", "./ubiquitous/Wartung/databaseEngine.png");
		#$B->doBefore("if(confirm('Möchten Sie wirklich ALLE Adressen aus der Datenbank löschen?')) %AFTER");
		$B->popup("", "Tabellennamen anpassen", "Wartung", "-1", "runAction", array("'Wartung_Database::fixNames'"));
		
		$T->addRow(array($B, "Mit diesem Knopf werden die Tabellennamen angepasst. Dies ist beim Umzug von Windows auf Linux notwendig."));
		
		$B = new Button("Engine\nanzeigen", "./ubiquitous/Wartung/databaseEngine.png");
		$B->popup("", "Engine anzeigen", "Wartung", "-1", "runAction", array("'Wartung_Database::showEngine'"));
		
		$T->addRow(array($B, "Mit diesem Knopf wird die Engine bei allen Tabellen angezeigt!"));
		
		
		$B = new Button("Engine\nMyISAM", "./ubiquitous/Wartung/databaseEngine.png");
		$B->doBefore("if(confirm('Möchten Sie die engine ALLER Tabellen auf MyISAM setzen?')) %AFTER");
		$B->popup("", "Engine MyISAM", "Wartung", "-1", "runAction", array("'Wartung_Database::setEngineMyISAM'"));
		
		$T->addRow(array($B, "Mit diesem Knopf wird die Engine bei allen Tabellen auf MyISAM gesetzt!"));
		
		$B = new Button("Engine\nInnoDB", "./ubiquitous/Wartung/databaseEngine.png");
		$B->doBefore("if(confirm('Möchten Sie die engine ALLER Tabellen auf InnoDB setzen?')) %AFTER");
		$B->popup("", "Engine InnoDB", "Wartung", "-1", "runAction", array("'Wartung_Database::setEngineInnoDB'"));
		
		$T->addRow(array($B, "Mit diesem Knopf wird die Engine bei allen Tabellen auf InnoDB gesetzt!"));
		
		
		return $T;
	}
	
	public function showEngine(){
		$DB = new DBStorage();
		
		$C = $DB->getConnection();
		
		$Q = $C->query("SHOW TABLES");
		
		echo "<pre style=\"padding:5px;max-height:400px;font-size:10px;\">Tabellen in Ihrer Datenbank:\n\n";
		while($T = $Q->fetch_row()){
			echo str_pad($T[0].":", 30, " ", STR_PAD_RIGHT);


			$R = $C->query("SHOW TABLE STATUS WHERE Name = '$T[0]'");
			$S = $R->fetch_array();
			if($S["Comment"] == "VIEW"){
				echo "VIEW\n";
				continue;
			}
			echo $S["Engine"];
			
			echo "\n";
		}
		
		echo "</pre>";
	}
	
	public function setEngineMyISAM(){
		$DB = new DBStorage();
		
		$C = $DB->getConnection();
		
		$this->setEngine($C, "MyISAM");
		#ALTER TABLE `adresse` ENGINE = MyISAM;
		return "<p></p>";
	}
	
	public function setEngineInnoDB(){
		$DB = new DBStorage();
		
		$C = $DB->getConnection();
		
		$this->setEngine($C, "InnoDB");
		#ALTER TABLE `adresse` ENGINE = MyISAM;
		return "<p></p>";
	}
	
	private function setEngine($C, $engine){
		$Q = $C->query("SHOW TABLES");
		
		echo "<pre style=\"padding:5px;max-height:400px;font-size:10px;\">Tabellen in Ihrer Datenbank:\n\n";
		while($T = $Q->fetch_row()){
			echo str_pad($T[0].":", 30, " ", STR_PAD_RIGHT);


			$R = $C->query("SHOW TABLE STATUS WHERE Name = '$T[0]'");
			$S = $R->fetch_array();
			if($S["Comment"] == "VIEW"){
				echo "VIEW\n";
				continue;
			}
			
			if($S["Engine"] != "$engine"){
				$C->query("ALTER TABLE `$T[0]` ENGINE = $engine;");
			
				echo $S["Engine"]." -&gt; $engine\n";
			} else
				echo $S["Engine"]."\n";
			
		}
		echo "</pre>";
	}
	
	public function fixNames(){
		$DB = new DBStorage();
		
		$C = $DB->getConnection();
		
		$this->doIt($C);
		
		return "";
	}
	
	public function doIt($C){
		$tabellen = explode("\n", "ACL
AKunde
API
ATeilnehmer
ATeilnehmerRechnung
Abo
Abrechnung
AbrechnungPosition
Abteilung
Abwesenheit
AbwesenheitArchiv
Achievement
AchievementStatus
ActiveDirectory
AdminLog
AdressBuch
Adresse
AdresseNiederlassung
Akquise
AkquiseLead
AltePosten
Ansprechpartner
Anwesenheit
App
AppProvider
AppRight
AppService
Arbeitgeber
ArbeitgeberUrlaub
ArbeitgeberUrlaubGruppe
Archiv
Armory
Artikel
ArtikelRG
Aufgabe
Auftrag
Ausgabe
Auswertung
AutoLogin
BACL
BRKabel
BRKunde
BRMAuftrag
BRMAuftragMessung
BRMBaugruppe
BRMBaugruppeTeil
BRMKabel
BRMKunde
BRMMessung
BRMMotor
BRMSteuerung
BRMTeil
BRMTeilMessung
BRMTeilSollwert
BRStecker
BackupLog
BackupLogCheck
BackupProfile
Banking
BankingKonto
BankingTransfer
Belegvorlage
Benutzer
Benutzer2Product
Berater
Bestellung
Bild
Bon
Buchung
Buchungsregel
BuchungsregelBedingung
BuchungsregelBuchung
Buchungssatz
CMachine
CServer
CSetup
CallLog
Carrier
ChangeLog
Check
Cloud
CloudKunde
Cloudserver
Cloudversion
Comet
Content
Cron
DArtikel
DBMail
DBMail2Object
DBMailAdresse
DBMailAutomatics
DBMailBox
DBMailVorlage
DataLog
Datei
Daten
Demo
DemoT
Deployment
Tables_in_open3ADev 	 
Device
Dokument
Domain
Download
Drucker
ELDA
ELDAException
EPub
EPubDL
Eingangsbeleg
Einkaufszettel
Einsatzort
EinsatzortKundenpreis
Etikette
Event
Exp
FITCRM
Feiertag
Fhem
FhemEvent
FhemLocation
FhemPreset
FhemServer
Folge
Frage
FrageAntwort
FrageModul
FrageModulAntwort
GPSData
GRLBM
GSKalkulation
GSMaterialverbrauch
GSQM
GSQMAntwort
GSQMAuswahl
GSQMPruefer
GSRaumgruppe
GSTaetigkeit
GSVersion
Gaeb
Galaxy
Gefrierschrank
GenderDB
Gericht
Google
Gruppe
Gutenberg
Handbuch
Handler
ImportDatenbank
ImportExcel
Incoming
IncomingPrettify
JD
JDownload
Jabber
JabberRoster
JabberUser
JabberVcard
KBKonto
KKKabel
KKKabelGruppe
KKKabelTyp
KKStecker
Kappendix
Kasse
Kassenbuch
Kategorie
Konto
Kundenpreis
Kundenzugang
LAAnzeige
LABouquet
LABouquetLAAnzeige
LADisplay
LADisplayBouquet
LADisplayError
LADisplayLog
LANews
LLAccount
LLLifeLine
Lager
Lagerbestand
Lagerbestandsaenderung
Laufzettel
Leadgeber
Lieferant
LieferantPreis
LogitechMediaServer
Lohngruppe
LohngruppeLohn
LohngruppeLohnZuschlag
MMEG
MMRede
MMToDo
MMWebinar
Mail
MailCheck
MailKonto
MailPHP
Tables_in_open3ADev 	 
MailPHPTarget
Merlin
Merlin_alt
Micropayment
Mobile
MobileCall
MobileSMS
Module
MultiLanguage
MwSt
NMMNTraffic
Navigation
NewSeries
Newsletter
NewsletterAdresse
NewsletterTemp
Notiz
Nuntius
OGRLBM
OPOS
OSM
OSMDistance
Objekt
ObjektL
ObjektPosition
OpenSSL
OpenSSLCA
OpenWeatherMap
PDF
PDFElement
PDFJS
PDFix
PDFixLSZZ
PDFixUser
PITerminal
PZuO
Patch
PayPal
PayPalUserKonto
PayPalUserKontoMovement
Paymill
Pdfschreiben
Personal
PlManager
Planet
Plugin
PluginDeployment
PluginTemplate
Posten
PostenKalkulation
PostenKalkulationVorgabe
Postleitzahl
Preisgruppe
Projekt
Provision
RC
RSSFilter
RSSParser
Rabattgruppe
Rechner
Refactoring
Regionaldirektor
RegionaldirektorPLZ
Reminder
Repeatable
Request
RequestTime
Resource2Projekt
SEPA
SFTP
SLOC
SPEvent
STeilnehmer
STeilnehmerHotel
STeilnehmerTicket
Schiff
SchiffLager
SchiffTransport
SchiffTyp
Schreiben
Script
Seite
Seminar
Serial
Serie
Seriennummer
Service
ServiceLog
ServiceOnRechner
Share
Shop
Sitemap
Snom
SnomPhoneBook
SnomUser
Software
SoftwareVersion
SozialpraktikumOrt
SozialpraktikumSchueler
Sprache
Tables_in_open3ADev 	 
Staffelpreis
Stammdaten
Starsystem
Stelle
StelleZeitung
Stellenausschreibung
StellenausschreibungHP
Stueckliste
Sync
SyncGet
SyncTable
SyncUser
SysUser
TAApp
TADienststelle
TAMitarbeiter
TGData
TGNav
TM_Adresse_1
TM_Adresse_2
TM_Adresse_3
TM_Content_1
TM_Domain_1
TM_GRLBM_1
TM_Kappendix_1
TM_Navigation_1
TM_Posten_1
TM_Seite_1
TM_Template_1
TM_Vertrag_1
Tag
Team
Teilnehmer
Telefonanlage
TempPosten
Template
Test
TestResult
TestSet
TestSetResult
TestStep
Textbaustein
Tinkerforge
TinkerforgeBricklet
TinkerforgeData
Todo
TodoInvitation
Tracker
UPnP
UPnPRadioStation
User
UserOld
UserFakeTable
Userdata
VAlias
VBlacklist
VDomain
VFetchmail
VSieve
VTransport
VUser
Variante
VarianteArtikel
VermiKunde
Vermietet
Versand
Vertrag
VertragPosten
VertragPostenKunde
Vorlage
WSBewerbung
WSJob
WVertrag
Warenkorb
Websocket
Wecker
Wetter
Workflow
WorkflowStep
ZEArbeitsZeit
ZEArbeitsZeitGroup
ZEData
ZEDataInfo
ZESchicht
ZESchichtzuordnung
ZEStatus
ZESumme
ZETerminal
ZETerminalFail
ZPush
Zahlungsart
Zeitarbeitsfirma
Zeiterfassung
availableCustomizer
availablePlugins
fheOverview
generatedPlugin
geoDB
hUmsatz
o3AKunde
openEAN
Tables_in_open3ADev 	 
pCal
pPArbeitskraft
pPArbeitskraftBerufstyp
pPArbeitskraftBlacklist
pPAuto
pPBerufstyp
pPBerufstypKundenrabatt
pPBerufstypVerrechnung
pPFirma
pPFirmaAdmin
pPFirmaKundeBenutzer
pPJob
pPJobAnmeldung
pPJobBeleg
pPJobStorno
pPVeranstaltung
pPVeranstaltungBerufstyp
pPVeranstaltungStation
pPVerfuegbarkeit
pPWorker
phim
phynxAltLogin
prettifyDB
trinityDB
xCal");

	$Q = $C->query("SHOW TABLES");

	#echo "<pre>";

	echo "<pre style=\"padding:5px;max-height:400px;font-size:10px;overflow:auto;\">Tabellen in Ihrer Datenbank:\n\n";
	while($T = $Q->fetch_row()){
		echo str_pad($T[0].":", 30, " ", STR_PAD_RIGHT);

		$found = false;
		foreach($tabellen AS $Tab){
			if($Tab === $T[0]){
				echo "<span style=\"color:green;\">OK</span>";
				$found = true;
			}
		}

		if(!$found){
			foreach($tabellen AS $Tab){
				if(strtolower($Tab) === $T[0]){
					echo "<span style=\"\">-&gt; ".$Tab." umbenannt!</span>";
					$C->query("RENAME TABLE `$T[0]` TO `$Tab` ;");
					$found = true;
				}
			}
		}

		echo "\n";
	}
	echo "</pre>";
	}
}
?>