<?php
/**
 *  This file is part of ubiquitous.

 *  ubiquitous is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  ubiquitous is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses></http:>.
 * 
 *  2007 - 2020, open3A GmbH - Support@open3A.de
 */

class Wartung_DSGVO implements iWartung {
	public function getLabel(){
		if(!Session::isPluginLoaded("Adressen"))
			return null;
		
		if(!Session::isPluginLoaded("Auftraege"))
			return null;
		
		return "DSGVO";
	}

	public function getHTML() {
		$T = new HTMLTable(2, "DSGVO Aktionen");
		$T->setColWidth(1, 156);
		$T->setColClass(1, "");
		
		#$B = new Button("Alte Adressen u.\nAufträge löschen", "trash");
		#$B->doBefore("if(confirm('Möchten Sie wirklich die betroffenen Aufträge und Adressen aus der Datenbank löschen?')) %AFTER");
		#$B->popup("", "Aufträge und Adressen löschen", "Wartung", "-1", "runAction", array("'Wartung_DSGVO::deleteOlderThan10Yrs'"));
		
		$D = $this->date();
		
		#$T->addRow(array($B, "<strong style=\"color:red;\">BETA</strong> Löscht die Aufträge und zugehörige Adressen (falls diese später nicht mehr verwendet wurden) aus der Datenbank, die vor dem ".Util::CLDateParser($D->time())." erstellt wurden. Die Kundennummer bleibt im System, um Verwechslungen zu vermeiden."));
		
		$B = new Button("Alte/unbenutzte\nAdressen löschen", "trash");
		#$B->doBefore("if(confirm('Möchten Sie wirklich die betroffenen Adressen aus der Datenbank löschen?')) %AFTER");
		$B->popup("", "Adressen löschen", "Wartung", "-1", "runAction", array("'Wartung_DSGVO::showAdressesUnusedOrOlderThan10Yrs'"));
		
		$T->addRow(array($B, "<strong style=\"color:red;\">BETA</strong> Löscht alle Adressen aus der Datenbank, die nicht oder vor dem ".Util::CLDateParser($D->time())." in einem Auftrag verwendet wurden. Die Kundennummer bleibt im System, um Verwechslungen zu vermeiden."));
		
		$B = new Button("Alte Aufträge\nanonymisieren", "./ubiquitous/Wartung/anonymize.png");
		$B->doBefore("if(confirm('Möchten Sie wirklich die betroffenen Aufträge anonymisieren?')) %AFTER");
		$B->popup("", "Aufträge anonymisieren", "Wartung", "-1", "runAction", array("'Wartung_DSGVO::anonymizeAuftraegeOlderThan10Yrs'"));
		
		$T->addRow(array($B, "<strong style=\"color:red;\">BETA</strong> Anonymisiert alle Aufträge ohne Beleg oder deren letzter Beleg vor dem ".Util::CLDateParser($D->time())." erstellt wurde."));
		
		
		return $T;
	}
	
	function anonymizeAuftraegeOlderThan10Yrs(){
		$D = $this->date();
		
		$DB = new DBStorage();
		$C = $DB->getConnection();
		
		$Q = $C->query("
		SELECT
			t1.AdresseID
		FROM
			Auftrag t1
		LEFT JOIN
			GRLBM t2
			ON(t2.AuftragID = t1.AuftragID)
		LEFT JOIN
			Adresse t3
			ON(t1.AdresseID = t3.AdresseID)
		WHERE
			firma != 'Anonymisiert'
		GROUP BY
			t1.AuftragID
		HAVING
			MAX(t2.datum) IS NULL 
			OR MAX(t2.datum) < ".$D->time()."");
		print_r($C->error);
		$Anon = array();
		while($R = $Q->fetch_object())
			$Anon[] = $R->AdresseID;
		
		if($C->affected_rows === 0)
			return "<p class=\"confirm\">Keine betroffenen Aufträge!</p>";
		
		$C->query("
		UPDATE 
			Adresse 
		SET 
			firma = 'Anonymisiert',
			anrede = '3',
			vorname = '',
			nachname = '',
			strasse = '',
			nr = '',
			tel = '',
			mobil = '',
			email = '',
			homepage = '',
			position = '',
			zusatz1 = '',
			titelPrefix = '',
			titelSuffix = ''
		WHERE
			AdresseID IN(". implode(",", $Anon).")");
		
		return "<p>$C->affected_rows Aufträge anonymisiert</p>";
	}
	
	private function date(){
		$D = new Datum();
		$D->setToJan1st(date("Y"));
		for($i = 0; $i < 10; $i++)
			$D->subYear();
		
		return $D;
	}
	
	function showAdressesUnusedOrOlderThan10Yrs(){
		$D = $this->date();
		
		$DB = new DBStorage();
		$C = $DB->getConnection();
		
		$Q = $C->query("SELECT
			MAX(t4.datum) AS maxdatum,
			t2.kundennummer,
			t1.AdresseID,
			firma,
			vorname,
			nachname
		FROM 
			Adresse t1 
		LEFT JOIN 
			Kappendix t2 
			ON(t1.AdresseID = t2.AdresseID) 
		LEFT JOIN 
			Auftrag t3 
			ON(t2.kundennummer = t3.kundennummer)
		LEFT JOIN
			GRLBM t4
			ON(t3.AuftragID = t4.AuftragID)
		WHERE 
			t1.AuftragID = -1 
			AND t1.type = 'default'
		GROUP BY
			t1.AdresseID
		HAVING
			MAX(t4.datum) IS NULL 
			OR MAX(t4.datum) < ".$D->time()."");
		print_r($C->error);
		
		$T = new HTMLTable(3);
		$T->maxHeight(400);
		$T->addHeaderRow(array(
			"KdNr.",
			"Name/Firma",
			"Zul. Benutzt"
		));
		while($R = $Q->fetch_object()){
			$N = $R->firma != "" ? $R->firma : trim($R->vorname." ".$R->nachname);

			$T->addRow(array(
				$R->kundennummer !== null ? $R->kundennummer : "Keine",
				$N,
				$R->maxdatum !== null ? Util::CLDateParser($R->maxdatum) : "nie"
			));
			#echo $R->kundennummer."/".$R->AdresseID.": ";
			#var_dump($R->maxdatum);
			#echo Util::CLDateParser($R->maxdatum);
			#echo "<br>";
		}
		
		if($C->affected_rows === 0)
			return "<p class=\"confirm\">Keine betroffenen Adressen!</p>";
		
		echo "<p>Betroffene Adressen:</p>";
		echo $T;
		
		$B = new Button("Adressen jetzt\nlöschen", "trash");
		$B->doBefore("if(confirm('Möchten Sie wirklich die betroffenen Adressen aus der Datenbank löschen?')) %AFTER");
		$B->popup("", "Adressen löschen", "Wartung", "-1", "runAction", array("'Wartung_DSGVO::deleteAdressesUnusedOrOlderThan10Yrs'"));
		$B->style("margin:10px;float:right;");
		
		echo $B;
	}
	
	function deleteAdressesUnusedOrOlderThan10Yrs(){
		$D = $this->date();
		
		$DB = new DBStorage();
		$C = $DB->getConnection();
		
		$Del = array();
		$Q = $C->query("SELECT
			t1.AdresseID
		FROM 
			Adresse t1 
		LEFT JOIN 
			Kappendix t2 
			ON(t1.AdresseID = t2.AdresseID) 
		LEFT JOIN 
			Auftrag t3 
			ON(t2.kundennummer = t3.kundennummer)
		LEFT JOIN
			GRLBM t4
			ON(t3.AuftragID = t4.AuftragID)
		WHERE 
			t1.AuftragID = -1 
			AND t1.type = 'default'
		GROUP BY
			t1.AdresseID
		HAVING
			MAX(t4.datum) IS NULL 
			OR MAX(t4.datum) < ".$D->time()."");
		
		while($R = $Q->fetch_object())
			$Del[] = $R->AdresseID;
		
		
		$Q = $C->query("
		DELETE
		FROM 
			Adresse 
		WHERE 
			AdresseID IN(".implode(",", $Del).")");
		print_r($C->error);
		
		$num = $C->affected_rows;
		$C->query("DELETE FROM Ansprechpartner WHERE AnsprechpartnerOwnerClass = 'Adresse' AND AnsprechpartnerOwnerClassID IN(".implode(",", $Del).")");
		
		
		
		return "<p>$num Adressen gelöscht</p>";
	}

	/*function deleteOlderThan10Yrs(){
		$D = $this->date();
		
		$DB = new DBStorage();
		$C = $DB->getConnection();
		
		$C->query("DELETE FROM GRLBM WHERE isM = '1' AND datum < ".$D->time()."");
		
		$AuftragIDs = array();
		$kundennummern = array();
		$AC = anyC::get("GRLBM");
		$AC->addJoinV3("Auftrag", "AuftragID", "=", "AuftragID");
		$AC->addAssocV3("datum", "<", $D->time());
		while($G = $AC->n()){
			if($G->A("kundennummer") > 0)
				$kundennummern[$G->A("kundennummer")] = $G->A("kundennummer");
			
			$AuftragIDs[$G->A("AuftragID")] = $G->A("AuftragID");
			
			$C->query("DELETE FROM Posten WHERE GRLBMID = '".$G->getID()."'");
			$C->query("DELETE FROM GRLBM WHERE GRLBMID = '".$G->getID()."'");
			
		}
		
		$Q = $C->query("SELECT AuftragID FROM GRLBM WHERE AuftragID IN(".implode(",", $AuftragIDs).")");
		while($R = $Q->fetch_object())
			unset($AuftragIDs[$Q->A("AuftragID")]);
		
		$C->query("DELETE FROM Auftrag WHERE AuftragID IN(".implode(",", $AuftragIDs).")");
		$C->query("DELETE FROM Adresse WHERE AuftragID IN(".implode(",", $AuftragIDs).")");
		
		$Q = $C->query("SELECT kundennummer FROM Auftrag WHERE kundennummer IN(".implode(",", $kundennummern).")");
		while($R = $Q->fetch_object())
			unset($kundennummern[$Q->A("kundennummer")]);
		
		$AdressIDs = array();
		$Q = $C->query("SELECT * FROM Kappendix WHERE kundennummer IN(".implode(",", $kundennummern).")");
		while($R = $Q->fetch_object())
			$AdressIDs[$R->AdresseID] = $R->AdresseID;
		
		$C->query("UPDATE Kappendix SET KappendixIBAN = '', KappendixKontonummer = '', KappendixKontoinhaber = '' WHERE kundennummer IN(".implode(",", $kundennummern).")");
		$C->query("DELETE FROM Adresse WHERE AdresseID IN(".implode(",", $AdressIDs).")");
		
		$C->query("DELETE FROM Ansprechpartner WHERE AnsprechpartnerOwnerClass = 'Adresse' AND AnsprechpartnerOwnerClassID IN(".implode(",", $AdressIDs).")");
	}*/
}
?>