<?php
/*
 *  This file is part of phynx.

 *  phynx is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  phynx is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 *  2007 - 2020, open3A GmbH - Support@open3A.de
 */

class CustomizerGUI extends Customizer implements iGUIHTML2 {
	public function getHTML($id){
		$bps = $this->getMyBPSData();
		$active = mUserdata::getGlobalSettingValue("activeCustomizer");
		
		$c = $bps["load"];
		$c = new $c();
		
		$Patches = new anyC();
		$Patches->setCollectionOf("Patch");
		
		
		$U = new XMLC();
		$U->setXML($c->tableUpdatesXML());
		$U->lCV3();
		
		$t3 = new HTMLTable(1, "Tabellenupdates");
		
		while($u = $U->getNextEntry()){
			$t3->addRow("<b>".$u->A("PatchDescription").":</b><br /><small>".nl2br($u->A("PatchValue"))."</small>");

			$Patches->addAssocV3("PatchNummer", "=", $u->A("PatchNummer"), "OR", $u->A("PatchNummer"));
			$Patches->addAssocV3("PatchDate", "=", $u->A("PatchDate"), "AND", $u->A("PatchNummer"));
		}

		$Patches->lCV3();

		$runUpdates = new Button("Tabellenupdates\nausführen", "update");
		$runUpdates->style("float:right;");
		$runUpdates->rmePCR("Customizer", "", "runUpdates", "", "contentManager.reloadFrame('contentLeft'); contentManager.reloadFrame('contentRight');");

		
		if($Patches->numLoaded() == $U->numLoaded() OR $c->tableUpdatesXML() == null)
			$runUpdates = "";

		
		$t2 = new HTMLTable(1,"Einstellungen für ".$c->getLabel());
		if($active != $bps["load"]) $t2->addRow("$runUpdates<input
			type=\"button\" 
			class=\"bigButton backgroundColor3\" 
			value=\"Customizer\naktivieren\" 
			style=\"background-image:url(./images/navi/okCatch.png);\" 
			onclick=\"contentManager.rmePCR('Customizer', '', 'activateCustomizer', '$bps[load]','contentManager.reloadFrame(\'contentRight\'); contentManager.reloadFrame(\'contentLeft\');');\" />");
		
		else  $t2->addRow("$runUpdates<input
			type=\"button\" 
			class=\"bigButton backgroundColor3\" 
			value=\"Customizer\ndeaktivieren\" 
			style=\"background-image:url(./images/navi/stop.png);\" 
			onclick=\"contentManager.rmePCR('Customizer', '', 'deactivateCustomizer', '','contentManager.reloadFrame(\'contentRight\'); contentManager.reloadFrame(\'contentLeft\');');\" />");
		
		if($c->customizerDescription() != "")
			$t2->addRow(nl2br($c->customizerDescription()));
			
		if(count($c->getAffectedClasses()) > 0)
			$t2->addRow("Von diesem Customizer betroffene Klassen:<br />".implode("<br />",$c->getAffectedClasses()));
		
		return $t2->getHTML().($U->numLoaded() > 0 ? $t3 : "");
	}
	
	public function runUpdates(){
		$bps = $this->getMyBPSData();
		parent::updates($bps["load"]);
	}

	public function activateCustomizer($class){
		$UD = new mUserdata();
		$UD->setUserdata("activeCustomizer", $class, "", -1);

		$this->runUpdates();
	}

	public function deactivateCustomizer(){
		$UD = new mUserdata();
		$UD->delUserdata("activeCustomizer", -1);
	}
	
	/*
	public static function registerCustomizer(){
		$fbdir = CustomizerGUI::getLocalCustomizerDir();
		if($fbdir == null) return;
		
		$FB = new FileBrowser();
		$FB->addDir($fbdir);
		$FB->addOnlyExtension(".class.php");
		
		foreach($FB->getAsArray() AS $k => $v){
			registerClassPath(str_replace(".class.php","",$v), str_replace("..", ".", $fbdir).$v);
			#print_r($_SESSION["classPaths"]);
		}
	}*/
}
?>