<?php
/**
 *  This file is part of openWaWi.

 *  openWaWi is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  openWaWi is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 *  2007 - 2020, open3A GmbH - Support@open3A.de
 */

class mRabattgruppeGUI extends anyC implements iGUIHTMLMP2 {

	public function getHTML($id, $page){
		$LID = BPS::getProperty("mRabattgruppeGUI", "LieferantID", -1);
		$this->addAssocV3("RabattgruppeLieferantID", "=", $LID);
		$this->addOrderV3("RabattgruppeNummer");
		$this->loadMultiPageMode($id, $page, 0);

		$gui = new HTMLGUIX($this);

		$gui->name("Rabattgruppe");
		
		$gui->attributes(array("RabattgruppeNummer", "RabattgruppeName"));
		
		$B = $gui->addSideButton("Zurück zu\nLieferanten", "back");
		$B->loadPlugin("contentRight", "mLieferant", "", $LID);
				
		return $gui->getBrowserHTML($id);
	}

	public function getACData($attributeName, $query, $third){
		$this->addAssocV3("RabattgruppeLieferantID", "=", $third);
		$this->setSearchStringV3($query);
		$this->setSearchFieldsV3(array("RabattgruppeName", "RabattgruppeNummer"));
		
		
		$this->setFieldsV3(array("RabattgruppeName AS label", "RabattgruppeNummer AS value", "CONCAT('Rabattgruppe ', RabattgruppeNummer) AS description"));
		
		$this->setLimitV3("10");
		
		echo $this->asJSON();
	}
}
?>