<?php
/**
 *  This file is part of openWaWi.

 *  openWaWi is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  openWaWi is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 *  2007 - 2020, open3A GmbH - Support@open3A.de
 */
class LieferantPreisGUI extends LieferantPreis implements iGUIHTML2 {
	public function __construct($ID) {
		parent::__construct($ID);
		
		$this->setParser("LieferantPreisListenPreis", "Util::CLNumberParserZ");
	}
	
	function getHTML($id){
		$gui = new HTMLGUIX($this);
		$gui->name("LieferantPreis");
	
		return $gui->getEditHTML();
	}
	
	public function unsetHaupt(){
		$AC = anyC::get("LieferantPreis", "LieferantPreisHaupt", "1");
		$AC->addAssocV3("LieferantPreisID", "!=", $this->getID());
		$AC->addAssocV3("LieferantPreisArtikelID", "=", $this->A("LieferantPreisArtikelID"));
		$AC->addAssocV3("LieferantPreisVarianteArtikelID", "=", $this->A("LieferantPreisVarianteArtikelID"));
		while($LP = $AC->n()){
			$LP->changeA("LieferantPreisHaupt", "0");
			$LP->saveMe();
		}
	}
}
?>