<?php
/**
 *  This file is part of openWaWi.

 *  openWaWi is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  openWaWi is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 *  2007 - 2020, open3A GmbH - Support@open3A.de
 */
class LieferantGUI extends Lieferant implements iGUIHTML2 {
	function __construct($ID) {
		parent::__construct($ID);
		$this->setParser("LieferantSkontoProzent", "Util::CLNumberParserZ");
		$this->setParser("LieferantMwStSatz", "Util::CLNumberParserZ");
		
	}
	function getHTML($id){
		T::load(__DIR__, "mLieferant");
		
		$this->makeNewIfNew();
		
		if(Applications::activeApplication() == "lightCRM")
			return $this->getCRMGUI($id);
		
		
		$gui = new HTMLGUIX();
		$gui->object($this);
		$gui->name("Lieferant");

		$attr = array(
			"LieferantFirma",
			"LieferantKategorieID",
			"LieferantStrasse",
			"LieferantHausnummer",
			"LieferantPLZ",
			"LieferantOrt",
			"LieferantLand",
			"LieferantSpracheID",
			"LieferantTel",
			"LieferantFax",
			"LieferantEMail",
			"LieferantBemerkung",
			"LieferantKundennummer",
			"LieferantHomepage",
			"LieferantBenutzername",
			"LieferantPasswort",
			"LieferantZahlungVia",
			"LieferantUseBankingKontoID",
			#"LieferantBankBLZ",
			#"LieferantBankKonto",
			"LieferantBankIBAN",
			"LieferantBankBIC",
			"LieferantSkontoTage",
			"LieferantSkontoProzent",
			"LieferantKonto",
			"LieferantMwStSatz",
			"LieferantSteuernummer"
		);
		
		$gui->attributes($attr);
		
		
		$S = mStammdaten::getActiveStammdaten();
		$UStIdNr1 = $S->A("ustidnr");
		
		$B = new Button("USt-IdNr überprüfen","./images/i2/okCatch.png", "icon");
		$B->rmePCR("Kappendix", "-1", "checkUStIdNr", array("'$UStIdNr1'", "\$j('[name=LieferantSteuernummer]').val()"), " ");
		$gui->addFieldButton("LieferantSteuernummer", $B);
		#$gui->activateFeature("addCustomButton", $this, "UStIdNr", $B);
		
		$gui->type("LieferantLand", "select", array_merge(array("" => "keine Angabe"), ISO3166::getCountries()));
		
		$gui->label("LieferantSkontoTage", "Tage");
		$gui->label("LieferantSkontoProzent", "Prozent");
		$gui->label("LieferantBankIBAN", "IBAN");
		$gui->label("LieferantBankBIC", "BIC");
		$gui->label("LieferantZahlungVia", "Zahlung via");
		$gui->label("LieferantEMail", "E-Mail");
		$gui->label("LieferantTel", "Telefon");
		$gui->label("LieferantFax", "Fax");
		$gui->label("LieferantUseBankingKontoID", "Von Konto");
		$gui->label("LieferantMwStSatz", "MwSt-Satz");
		$gui->label("LieferantKategorieID", "Kategorie");
		$gui->descriptionField("LieferantBemerkung", "Wird in der Liste rechts angezeigt");
		
		if(Session::isPluginLoaded("Auftraege")){
			$payments = array_merge(array("" => T::_("bitte auswählen...")), GRLBM::getPaymentVia());
			$gui->type("LieferantZahlungVia", "select", $payments);
			$gui->space("LieferantZahlungVia", "Zahlung");
		} else
			$gui->type ("LieferantZahlungVia", "hidden");
		
		
		$kat = new Kategorien();
		$kat->addAssocV3("type","=","lieferant");
		$kat->addOrderV3("name");
		
		$gui->type("LieferantKategorieID", "select", $kat->getArrayWithKeysAndValues(T::_("Bitte auswählen...")));
		
		if(Session::isPluginLoaded("mBanking")){
			$AC = anyC::get("BankingKonto", "BankingKontoType", "1");
			$gui->type("LieferantUseBankingKontoID", "select", $AC, "BankingKontoName", "Keines");
			$gui->toggleFields("LieferantZahlungVia", array("transfer"), array("LieferantUseBankingKontoID"));
		} else
			$gui->type ("LieferantUseBankingKontoID", "hidden");
		
		
		if(Session::isPluginLoaded("mSprache")) {
			$gui->label("LieferantSpracheID","Sprache");
			$gui->descriptionField("LieferantSpracheID", "und Währung");
			$gui->type("LieferantSpracheID", "select", new mSprache(), "SpracheName");
		} else 
			$gui->type("LieferantSpracheID","hidden");
		
		$gui->space("LieferantSkontoTage", "Skonto");
		$gui->space("LieferantTel", "Kontakt");
		$gui->space("LieferantStrasse");
		$gui->space("LieferantBemerkung");
		$gui->space("LieferantKonto", "Buchhaltung");
		$gui->space("LieferantBankBLZ", "Bank");
		if(Session::isPluginLoaded("mKonto"))
			$gui->autoComplete("LieferantKonto", "mKonto", "function(selection){ \$j('[name=LieferantKonto]').val(selection.value); return false; }");
		
		$B = $gui->addSideButton("Rabattgruppen\nbearbeiten", "./openWaWi/Lieferanten/Rabattgruppe.png");
		$B->loadPlugin("contentRight", "mRabattgruppe", "mRabattgruppeGUI;LieferantID:".$this->getID());
		#$B->loadFrame("contentRight", "mRabattgruppe", -1, 0, );
		
		if(Session::isPluginLoaded("mAnsprechpartner"))
			$gui->addSideButton(Ansprechpartner::getButton("Lieferant", $id));

		
		if(Session::isPluginLoaded("mFile"))
			$gui->addSideButton(mFileGUI::getManagerButton("Lieferant", $this->getID()));
		
		if($this->getID() == -1 AND Session::isPluginLoaded("Adressen")){
			$B = $gui->addSideButton("Aus Adresse\nkopieren", "address");
			$B->customSelect("contentRight", "-1", "Adressen", "Lieferant.copyFromAddress");
		}
		
		if(Session::isPluginLoaded("mDokument"))
			$gui->addSideButton(Dokument::getButton("Lieferant", $this->getID()));
		
		if(Session::isPluginLoaded("mEingangsbeleg"))
			$gui->addSideButton(Eingangsbeleg::getButtonLieferant($this->getID()));
			
		return $gui->getEditHTML();
	}
	
	private function getCRMGUI($id){
		$this->loadMeOrEmpty();
		
		$bps = $this->getMyBPSData();
		$gui = new CRMHTMLGUI();
		$gui->object($this);
		$gui->name("Lieferant");
		
		$attr = array(
			"LieferantFirma",
			"LieferantKategorieID",
			#"LieferantSpracheID",
			"LieferantTel",
			"LieferantFax",
			"LieferantEMail",
			"LieferantKundennummer",
			"LieferantHomepage",
			"LieferantBenutzername",
			"LieferantPasswort"
		);
		
		if(isset($bps["edit"]))
			$attr[] = "LieferantBemerkung";
		else
			$attr[] = "bemerkung";
		
		$gui->attributes($attr);
		
		$gui->label("LieferantFirma", "Firma");
		$gui->label("LieferantEMail", "E-Mail");
		$gui->label("LieferantTel", "Telefon");
		$gui->label("LieferantFax", "Fax");
		$gui->label("LieferantKundennummer", "Kundennummer");
		$gui->label("LieferantHomepage", "Homepage");
		$gui->label("LieferantBenutzername", "Benutzername");
		$gui->label("LieferantPasswort", "Passwort");
		$gui->label("LieferantBemerkung", "Bemerkung");
		$gui->label("LieferantKategorieID", "Kategorie");
		
		$gui->type("LieferantBemerkung", "textarea");
		
		$kat = new Kategorien();
		$kat->addAssocV3("type","=","lieferant");
		$kat->addOrderV3("name");
		
		$gui->type("LieferantKategorieID", "select", $kat->getArrayWithKeysAndValues("Bitte auswählen…"));
		
		$gui->space("LieferantKundennummer", "Kundendaten");
		$gui->space("LieferantTel", " ");
		$gui->space("LieferantBemerkung");
		#$gui->space("LieferantTel", "Kontakt");
		#$gui->space("LieferantStrasse");
		$Tab = new HTMLTable(2);
		$Tab->setColWidth(1, 120);
		$Tab->setColClass(1, "");
		$Tab->setColClass(2, "");
		$Tab->addRow(array("Bemerkung"));
		$Tab->addRowClass("backgroundColor2");
		$Tab->addRowColspan(1, 2);
		$Tab->addRow(array(nl2br($this->A("LieferantBemerkung"))));
		
		$gui->space("bemerkung", " ", false, $Tab);
		#$gui->space("LieferantKonto", "Buchhaltung");
		#$gui->space("LieferantBankBLZ", "Bank");
		#
		if(!isset($bps["edit"])){
			$gui->parser("LieferantFirma", "LieferantGUI::parserFirma");
			$gui->parser("LieferantHomepage", "WAdresseGUI::parserHomepage");
			$gui->parser("LieferantEMail", "LieferantGUI::parserEMail");
		}
		
		if(Session::isPluginLoaded("mSprache")) {
			$gui->insertAttribute("after", "LieferantFirma", "LieferantSpracheID");
			$gui->label("LieferantSpracheID","Sprache (Land)");
			
			$AC = new mSprache();
			$sprachen = array_merge(array(0 => "keine Auswahl"), $AC->toArray("SpracheLandSprache"));
			$gui->type("LieferantSpracheID", "select", $sprachen);
		}
		
		$GUIF = new GUITabFactory("WAdresse");
		
		
		if(Session::isPluginLoaded("mAnsprechpartner"))
			$GUIF->addCustomTab(OnEvent::popup("Ansprechpartner", "mAnsprechpartner", "-1", "getPopup", array("'Lieferant'", $this->getID())), "Ansprechp.", "./ubiquitous/Ansprechpartner/Ansprechpartner.png");

		

		if(Session::isPluginLoaded("mMail")){
			$Mails = new mDBMailCRMGUI();
			$Mails->setOwner("Lieferant", $this->ID);
			$GUIF->addTab($Mails, "Mails", "./lightCRM/Mail/Mail.png");
		}
		
		if(Session::isPluginLoaded("mDokument")){
			$Dokumente = new mDokumentGUI();
			$Dokumente->setOwner("Lieferant", $this->ID);
			$GUIF->addTab($Dokumente, "Dokumente", "./images/navi/angebot.png");
		}
			
		if(Session::isPluginLoaded("mFile")){
			$Files = new FileManagerGUI();
			$Files->setOwner("Lieferant", $this->ID);
			$GUIF->addTab($Files, "Dateien", "computer");
		}
		
		if(Session::isPluginLoaded("mHistorie")){
			$Historie = new mHistorieGUI();
			$Historie->setOwner("Lieferant", $this->ID);
			$GUIF->addTab($Historie, "Historie", "./lightCRM/Historie/Historie.png");
		}
			
		$gui->customize($this->customizer);
		
		return $gui->getEditHTML().(($id != -1 AND !isset($bps["edit"])) ? $GUIF->buildTabBar() : "");
	}
	
	public static function parserEMail($w, $l, $E){
		$B = new Button($E->A("LieferantEMail"), "./images/i2/email.png", "icon");
		$B->style("float:right;margin-left:4px;");
		$B->onclick("document.location.href='mailto:".$E->A("LieferantEMail")."';");
		
		if(Session::isPluginLoaded("mMail")){
			$B = Mail::writeMailButton($E);
			$B->style("float:right;margin-left:4px;");
		}
		
		if(trim($w) == "")
			$B = "";

		
		return $B.$w;
	}
	
	public static function parserFirma($w, $E){
		return $E->getAsAdresse()->getFormattedAddress();
	}
	
	public function copyFromAddress($AdresseID){
		$Adresse = new Adresse($AdresseID);
		$Kappendix = Kappendix::getKappendixToAdresse($AdresseID);
		
		$js = "\$j('[name=LieferantFirma]').val('".addslashes($Adresse->A("firma"))."');";
		$js .= "\$j('[name=LieferantStrasse]').val('".addslashes($Adresse->A("strasse"))."');";
		$js .= "\$j('[name=LieferantHausnummer]').val('".addslashes($Adresse->A("nr"))."');";
		$js .= "\$j('[name=LieferantPLZ]').val('".addslashes($Adresse->A("plz"))."');";
		$js .= "\$j('[name=LieferantOrt]').val('".addslashes($Adresse->A("ort"))."');";
		$js .= "\$j('[name=LieferantLand]').val('".addslashes(ISO3166::getCodeToCountry($Adresse->A("land")))."');";
		
		$js .= "\$j('[name=LieferantTel]').val('".addslashes($Adresse->A("tel"))."');";
		$js .= "\$j('[name=LieferantFax]').val('".addslashes($Adresse->A("fax"))."');";
		$js .= "\$j('[name=LieferantEMail]').val('".addslashes($Adresse->A("email"))."');";
		
		$js .= "\$j('[name=LieferantBankBLZ]').val('".addslashes($Kappendix->A("KappendixBLZ"))."');";
		$js .= "\$j('[name=LieferantBankKonto]').val('".addslashes($Kappendix->A("KappendixKontonummer"))."');";
		$js .= "\$j('[name=LieferantBankIBAN]').val('".addslashes($Kappendix->A("KappendixIBAN"))."');";
		$js .= "\$j('[name=LieferantBankBIC]').val('".addslashes($Kappendix->A("KappendixSWIFTBIC"))."');";
		
		#$js .= "\$j('[name=LieferantBemerkung]').val('".addslashes($Adresse->A("bemerkung"))."');";
		
		
		
		echo OnEvent::script($js);
	}
	
	public static function popupSelection(GRLBM $GRLBM, $ArtikelID){
		if(!Lieferant::check($GRLBM->getMyPrefix()) OR !Lieferant::has($ArtikelID))
			return "";
		
		$Artikel = new Artikel($ArtikelID);
		
		$AC = Lieferant::getLieferanten($ArtikelID);
		
		#$Artikel = new Artikel($ArtikelID);
		
		$T = new HTMLTable(2, T::_("Lieferanten"));
		$T->maxHeight(400);
		$T->weight("light");
		$T->useForSelection(false);
		$T->setColWidth(1, 20);
		
		$hasHaupt = false;
		while($L = $AC->getNextEntry())
			if($L->A("LieferantPreisHaupt"))
				$hasHaupt = true;
	
		$AC->resetPointer();
		
		$i = 0;
		while($L = $AC->getNextEntry()){
			#$BS = new Button("Lieferant auswählen", "./images/i2/cart.png", "icon");
			$BS = new HTMLInput("lieferantSelection", "radio1", $L->A("LieferantID"));
			if(!$hasHaupt)
				$BS->isSelected($i == 0);
			else
				$BS->isSelected($L->A("LieferantPreisHaupt"));
			
			$T->addRow(array($BS."", "<span style=\"float:right;\">EK: ".Aspect::joinPoint("price", __CLASS__, __METHOD__, array($Artikel->getArtikelEK1($L->A("LieferantID"))), Util::CLFormatNumber($Artikel->getArtikelEK1($L->A("LieferantID")), true))."</span>".$L->A("LieferantFirma")));
			$T->addRowEvent("click", "\$j(this).find('[name=lieferantSelection]').prop('checked', true);");
			#$T->addRowEvent("click", OnEvent::rme($L, "addToBeleg", array("'$ArtikelID'", "'$GRLBMID'"), "function(){ contentManager.loadFrame('subframe', 'GRLBM', $GRLBMID); ".OnEvent::closePopup("mLieferant")." }"));
			$i++;
			if($L->A("LieferantPreisHaupt"))
				$T->addRowClass ("confirm");
		}
		
		return $T;
	}
}
?>