<?php
/*
 *  This file is part of open3A.

 *  open3A is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  open3A is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  2007 - 2020, open3A GmbH - Support@open3A.de 
 */
class LastschriftListe {
	public function getInterestingData($onlyIDs = null, $ignorePayed = false){
		$AS = new ArrayCollection();
		
		$zIDs = [];
		foreach($onlyIDs AS $k => $v){
			if(strpos($v, "_") === false)
				continue;
			
			$ex = explode("_", $v);
			$zIDs[] = $ex[1];
			#unset($onlyIDs[$k]);
			$onlyIDs[$k] = 0;
		}
		#print_r($zIDs);
		$AC = anyC::get("GRLBM");
		if(!$ignorePayed)
			$AC->addAssocV3("isPayed", "=", "0", "AND","1");
		$AC->addAssocV3("isR", "=", "1", "AND","1");
		$AC->addJoinV3("Auftrag", "AuftragID","=","AuftragID");
		$AC->addJoinV3("Kappendix", "t2.kundennummer", "=", "kundennummer");
		$AC->addJoinV3("Adresse", "t2.AdresseID", "=","AdresseID");
		$AC->addAssocV3("KappendixEinzugsermaechtigung", "=", "1","AND","1");
		$AC->addAssocV3("GRLBMSEPAData", "NOT LIKE", "%\"MandateDate\":\"0\"%");
		$AC->addAssocV3("GRLBMRuecklastschrift", "=", "0");
		
		if($onlyIDs != null)
			$AC->addAssocV3("GRLBMID", "IN", "(".implode(", ", $onlyIDs).")", "AND", "2");
		
		
		if(Session::isPluginLoaded("mZahlungsart"))
			$AC->addAssocV3("GRLBMpayedVia", "=", "debit", "AND", "3");
		
		while($G = $AC->n())
			$AS->add ($G);
		
		
		if(Session::isPluginLoaded("mZahlungsaufforderung")){
			$AC = anyC::get("Zahlungsaufforderung");
			if(!$ignorePayed)
				$AC->addAssocV3("ZahlungsaufforderungBezahltAm", "=", "0", "AND","1");
			#$AC->addAssocV3("isR", "=", "1", "AND","1");
			$AC->addJoinV3("GRLBM", "ZahlungsaufforderungGRLBMID", "=", "GRLBMID");
			$AC->addJoinV3("Auftrag", "t2.AuftragID","=","AuftragID");
			$AC->addJoinV3("Kappendix", "t3.kundennummer", "=", "kundennummer");
			$AC->addJoinV3("Adresse", "t3.AdresseID", "=","AdresseID");
			$AC->addAssocV3("KappendixEinzugsermaechtigung", "=", "1","AND","1");
			$AC->addAssocV3("GRLBMSEPAData", "NOT LIKE", "%\"MandateDate\":\"0\"%");
			$AC->addAssocV3("GRLBMRuecklastschrift", "=", "0");
			$AC->setFieldsV3(["*", "ZahlungsaufforderungSEPATransmitted AS GRLBMSEPATransmitted", "ZahlungsaufforderungNummer AS nummer"]);
			if($zIDs != null)
				$AC->addAssocV3("ZahlungsaufforderungID", "IN", "(".implode(", ", $zIDs).")", "AND", "2");

			if(Session::isPluginLoaded("mZahlungsart"))
				$AC->addAssocV3("GRLBMpayedVia", "=", "debit", "AND", "3");

			while($G = $AC->n())
				$AS->add ($G);
		}
		
		return $AS;
	}
	
	public function getDebitor($k, $orderMode, $days, $minDays, $type){
		$dt = new DateTime();
		$wd = 0;
		while($wd < $minDays){
			$dt->add(new DateInterval("P1D"));

			if($dt->format("w") != 6 AND $dt->format("w") != 0)
				$wd++;
		}
		
		
		$inhaber = $k->A("KappendixKontoinhaber");
		if($k->A("KappendixSameKontoinhaber") == "1" OR $k->A("KappendixKontoinhaber") == "")
			if($k->A("firma") == "") 
				$inhaber = $k->A("vorname")." ".$k->A("nachname");
			else 
				$inhaber = $k->A("firma");

		$rqCD = $dt;
		if($orderMode == "default"){
			$dt2 = new DateTime();
			$dt2->setTimestamp($k->A("datum"));

			$dt2->add(new DateInterval("P".$days."D"));

			while($dt2->format("w") == 6 OR $dt2->format("w") == 0)
				$dt2->add(new DateInterval("P1D"));

			$rqCD = $dt2;

			if($dt2->getTimestamp() < $dt->getTimestamp())
				$rqCD = $dt;
		}

		if($orderMode == "min3" OR $orderMode == "min4"){
			$days = str_replace("min", "", $orderMode);

			$dt2 = new DateTime();
			$dt2->setTimestamp($k->A("datum"));

			$dt2->add(new DateInterval("P".$days."D"));

			while($dt2->format("w") == 6 OR $dt2->format("w") == 0)
				$dt2->add(new DateInterval("P1D"));

			$rqCD = $dt2;

			if($dt2->getTimestamp() < $dt->getTimestamp())
				$rqCD = $dt;
		}


		#echo $rqCD->format("d-m-Y")."\n";

		$data = new stdClass();
		if($k->A("GRLBMSEPAData") != "" AND $k->A("GRLBMSEPAData") != "[]")
			$data = json_decode($k->A("GRLBMSEPAData"));


		$brutto = $k->A("bruttobetrag");
		if($k->A("GRLBMSkonto") != ""){
			$skontoData = json_decode($k->A("GRLBMSkonto"));
			if(isset($skontoData->prozent) AND $skontoData->prozent > 0)
				$brutto = $brutto * ((100 - $skontoData->prozent) / 100);
		}
		
		$brutto += $k->A("gebuehren");
				
		$D = new SEPADebitor(array(
			'transferID' => $k->A("prefix").$k->A("nummer"),
			'mandateID' => isset($data->MandateID) ? $data->MandateID : substr($k->A("kundennummer").str_replace(" ", "", $k->A("KappendixIBAN")), 0, 34),
			'mandateDateOfSignature' => date("Y-m-d", isset($data->MandateDate) ? $data->MandateDate : $k->A("KappendixIBANMandatDatum")),
			'name' => $inhaber,
			'iban' => isset($data->IBAN) ? $data->IBAN : $k->A("KappendixIBAN"),
			'bic' => isset($data->BIC) ? $data->BIC : $k->A("KappendixSWIFTBIC"),
			'amount' => Util::kRound($brutto),
			'currency' => 'EUR',
			'info' => $k->A("prefix").$k->A("nummer")." vom ".Util::CLDateParser($k->A("datum")),
			'requestedCollectionDate' => $rqCD,
			'sequenceType' => $k->A("GRLBMSEPAMode") == "" ? "OOFF" : $k->A("GRLBMSEPAMode"),
			'type' => (isset($data->Typ) AND $data->Typ != "") ? $data->Typ : $type,
			'endToEndId' => $k->A("ZahlungsaufforderungID") !== null ? "Zahlungsaufforderung:".$k->A("ZahlungsaufforderungID") : "GRLBM:".$k->A("GRLBMID")
		));
		
		return $D;
	}
	
	public function getCreditor(Stammdaten $s){
		$name = $s->A("firmaLang");
		if($name == "")
			$name = $s->A("firmaKurz");
		if($name == "")
			$name = $s->A("vorname")." ".$s->A("nachname");
		
		return new SEPACreditor(array(
			'name' => $name,
			'iban' => $s->A("IBAN"),
			'bic' => $s->A("SWIFTBIC"),
			'identifier' => $s->A("glaeubigerID")
		));
	}
}
?>
