<?php
/*
 *  This file is part of open3A.

 *  open3A is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  open3A is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  2007 - 2020, open3A GmbH - Support@open3A.de
 */

if(isset($argv[1]))
	$_GET["cloud"] = $argv[1];

if(isset($argv[2]))
	$_SERVER["HTTP_HOST"] = $argv[2];

session_name("ExtConnMahnungen");

require_once realpath(dirname(__FILE__)."/../../system/connect.php");

register_shutdown_function('cronShutdownHandler');
function cronShutdownHandler() {
	$last_error = error_get_last();
	if ($last_error['type'] !== E_ERROR) 
		return;
	
	print_r(SysMessages::i()->getMessages());
}
$absolutePathToPhynx = realpath(dirname(__FILE__)."/../../")."/";
$e = new ExtConn($absolutePathToPhynx);

$e->loadPlugin("open3A", "Auftraege");
$e->loadPlugin("open3A", "Mahnung");
$e->loadPlugin("open3A", "Stammdaten");
$e->loadPlugin("open3A", "Kunden");
$e->loadPlugin("open3A", "Adressen");
$e->loadPlugin("open3A", "Textbausteine");
$e->loadPlugin("open3A", "Brief");

$e->addClassPath($absolutePathToPhynx."specifics");
$e->addClassPath(FileStorage::getFilesDir());


$e->useDefaultMySQLData();

$e->useUser();

$G = anyC::get("GRLBM");
$G->setLimitV3("1");
$G->addAssocV3("isR","=","1");
$G = $G->getNextEntry();

if(!$G){
	$e->cleanUp();
	die();
}

$M = new mMahnung();

$validOverDue = $M->findOverDue($G->A("zahlungsziel") !== null, true);
$newIDs = array();
foreach($validOverDue AS $BID => $B)
	$newIDs[] = $BID;

$createdIDs = $M->create($newIDs);
#print_r($createdIDs);

foreach($createdIDs AS $MID){
	try {
		$Mahnung = new GRLBM($MID);
		$GRLBM = new GRLBM($Mahnung->A("AuftragID"));
		
		$A = new Auftrag($GRLBM->A("AuftragID"));
		$A->sendViaEmail($MID, "", "", "", false);
	} catch (Exception $ex){
		echo $GRLBM->A("nummer")."/".$Mahnung->A("nummer").": ".$ex->getMessage();
	}
}

$e->cleanUp();
?>