<?php
/*
 *  This file is part of open3A.

 *  open3A is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  open3A is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 *  2007 - 2020, open3A GmbH - Support@open3A.de
 */

class MahnungGUI extends UnpersistentClass implements iGUIHTML2, icontextMenu {
	function __construct() {
		parent::__construct();
		$this->customize();
	}
	
	public $CustomizerTeilzahlungen = false;
	
	function getHTML($id, $ZahlungsaufforderungID = 0){
		$gui = new HTMLGUI();
		$gui->VersionCheck("Mahnung");
		
		
		$_SESSION["BPS"]->setActualClass("MahnungGUI");
		$bps = $_SESSION["BPS"]->getAllProperties();
		
		$G = new GRLBM($id/*$bps["GRLBMID"]*/);
		$G->loadMe();

		$Ts = new anyC();
		$Ts->setCollectionOf("Textbaustein");
		$Ts->addAssocV3("KategorieID",">","30");
		$Ts->addAssocV3("KategorieID","<","34");
		$Ts->lCV3();
		
		if($Ts->numLoaded() == 0)
			return "
			<div class=\"backgroundColor1 Tab\"><p>Textbausteine</p></div>
			<table>
				<colgroup>
					<col class=\"backgroundColor3\" />
				</colgroup>
				<tr>
					<td><input onclick=\"rme('Mahnung','','createTBs','','contentManager.reloadFrameLeft();');\" type=\"button\" value=\"Textbausteine\nanlegen\" class=\"bigButton backgroundColor2\" style=\"float:right;background-image:url(./images/navi/document.png);\" />
					Es wurden keine Textbausteine für Mahnungen gefunden.<br /><br />Bitte klicken Sie auf den Button, um Textbausteine anzulegen.</td>
				</tr>
			</table>";
		
		
			
		$Gs = anyC::get("GRLBM");
		$Gs->addAssocV3("AuftragID","=",$id/*$bps["GRLBMID"]*/);
		$Gs->addAssocV3("isM","=","1");
		$Gs->addAssocV3("GRLBMZahlungsaufforderungID", "=", $ZahlungsaufforderungID);
		$Gs->addOrderV3("nummer");
		$Gs->lCV3();
		
		$Ms = array();
		
		while($t = $Gs->getNextEntry())
			$Ms[$t->A("nummer")] = $t;
		

		$html = "
		<div class=\"backgroundColor1 Tab\" style=\"margin-top:10px;\"><p>".T::_("Mahnungen")."</p></div>
		<table>
			<colgroup>
				<col class=\"\" />
			</colgroup>";
		
		if(!isset($Ms["1"])) {
			$B = new Button("1. Mahnung\n erstellen", "mahnung");
			$B->onclick("rme('Mahnung', '', 'createMahnung', Array('$id','1', '$ZahlungsaufforderungID'), 'if(checkResponse(transport)) contentManager.reloadFrame(\'contentLeft\'); contentManager.reloadFrame(\'contentRight\');');");
			$B->id("createMahnung1Button");
			
			$html .= "
			<tr>
				<td>$B</td>
			</tr>";
		}
		if(isset($Ms["1"])) $html .= $this->getMahnungHTML(1, $G, $Ms);
		
		if(isset($Ms["1"]) AND !isset($Ms["2"])) {
			$B = new Button("2. Mahnung\n erstellen", "mahnung");
			$B->onclick("rme('Mahnung', '', 'createMahnung', Array('$id','2', '$ZahlungsaufforderungID'), 'if(checkResponse(transport)) contentManager.reloadFrame(\'contentLeft\'); contentManager.reloadFrame(\'contentRight\');');");
			$B->id("createMahnung2Button");
			
			$html .= "
			<tr>
				<td>$B</td>
			</tr>";
		}
		
		if(isset($Ms["2"])) $html .= $this->getMahnungHTML(2, $G, $Ms);
		
		if(isset($Ms["2"]) AND !isset($Ms["3"])) {
			$B = new Button("3. Mahnung\n erstellen", "mahnung");
			$B->onclick("rme('Mahnung', '', 'createMahnung', Array('$id','3', '$ZahlungsaufforderungID'), 'if(checkResponse(transport)) contentManager.reloadFrame(\'contentLeft\'); contentManager.reloadFrame(\'contentRight\');');");
			$B->id("createMahnung3Button");
			
			$html .= "
			<tr>
				<td>$B</td>
			</tr>";
		}
		if(isset($Ms["3"])) $html .= $this->getMahnungHTML(3, $G, $Ms);
		
		$html .= "
		</table>";
		
		return $html;
	}
	
	function getMahnungHTML($nr, $G, $Ms){
		$Ts = new Textbausteine();
		list($keys, $values) = $Ts->getTBs("mahnung$nr", "");
		
		$B = new Button("Mahnung\nanzeigen","pdf");
		$B->windowRme("Auftrag",$G->getA()->AuftragID,"getGRLBMPDF",array("'false'", "''", $Ms[$nr]->getID()), "Brief;templateType:PDF");
		
		$BMail = new Button("per E-Mail\nverschicken","mail");
		$BMail->onclick("Auftrag.windowMail(".$G->getA()->AuftragID.", '".$Ms[$nr]->getID()."','E-Mail', ".$Ms[$nr]->A("GRLBMAnsprechpartnerID").");");
		if($Ms[$nr]->A("isEMailed"))
			$BMail->addClass("confirm");
		
		$BMailS = new Button("Einstellungen","wrench", "iconic");
		$BMailS->className("buttonSettings iconicG");
		$BMailS->onclick("phynxContextMenu.start(this, 'GRLBM','viaMail:".$G->getID()."','E-Mail:','right','up');");
		
		$B3 = "";
		$B2 = $BMail.$BMailS;
		if(Session::isPluginLoaded("PL")){
			$B2 = PLGUI::getButton2($G->getA()->AuftragID, $Ms[$nr]->getID());
			
			#$B->type("LPBig");
			$B->style("float:left;margin-right:10px;");
			
			$BMail->type("LPBig");
			if($Ms[$nr]->A("isEMailed"))
				$BMail->addClass("confirm");
			
			$B3 = $BMail.$BMailS;
		}
		
		$ESM = "";
		if($Ms[$nr]->A("isEMailed"))
			$ESM = "<br><small style=\"color:grey;\">per E-Mail verschickt am ".Util::CLDateTimeParser($Ms[$nr]->A("isEMailedTime"))."</small>";
		
		
		#$B2->style("float:right;");
		
		/*new Button("Kopie","pdf");
		$B2->windowRme("Auftrag",$G->getA()->AuftragID,"getGRLBMPDF",array("'true'", "''", $Ms[$nr]->getID()), "Brief;templateType:PDF");
		
		$B2->settings("GRLBM", "1");*/
		
		#$B3 = new Button("Kopie-Einstellungen anzeigen","./images/i2/settings.png");
		#$B3->onclick("phynxContextMenu.start(this, 'GRLBM','1','Kopie:','right','down');");
		#$B3->style("float:right;");
		#$B3->type("icon");
		$IE = new Button("Mahnung bearbeiten", "./images/i2/edit.png", "icon");
		$IE->style("float:right;");
		$IE->onclick("\$j('#Mahnung$nr').slideToggle()");
		
		$ID = new Button("Mahnung löschen", "trash_stroke", "iconic");
		$ID->style("float:right;margin-right:10px;");
		$ID->rmePCR("GRLBM", $Ms[$nr]->getID(), "deleteMe", "", OnEvent::reload("Left").OnEvent::reload("Right"));
		$ID->doBefore("if(confirm('Mahnung wirklich löschen?')) %AFTER");
		
		$I1 = new HTMLInput("zahlbarBis$nr", "date", Util::CLDateParserE($Ms[$nr]->A("lieferDatum")));
		$I1->id("zahlbarBis$nr");
		
		$I2 = new HTMLInput("datumDerMahnung$nr", "date", Util::CLDateParserE($Ms[$nr]->A("datum")));
		$I2->id("datumDerMahnung$nr");
		
		return "
			<tr>
				<td>
					<div id=\"Mahnung{$nr}Header\" onclick=\"\" class=\"backgroundColor4\" style=\"padding:5px;\">
						$IE$ID<b>$nr. ".T::_("Mahnung")."</b>
						<div style=\"clear:both;\"></div>
					</div>
					<div id=\"Mahnung$nr\" style=\"display:none;\">
						<table>
							<colgroup>
								<col style=\"width:120px;\" class=\"backgroundColor2\" />
								<col class=\"backgroundColor3\" />
							</colgroup>
							<tr>
								<td><label>".T::_("Textbaustein").":</label></td>
								<td><select id=\"TB$nr\">".Util::makeOptions($keys, $values)."</select></td>
							</tr>
							<tr>
								<td><label>".T::_("Zahlbar bis").":</label></td>
								<td>$I1</td>
							</tr>
							<tr>
								<td><label>".T::_("Datum").":<br /><small>".T::_("der Mahnung")."</small></label></td>
								<td>$I2</td>
							</tr>
							<tr>
								<td><label>".T::_("Betrag").":</label></td>
								<td><input id=\"betragDerMahnung$nr\" type=\"text\" value=\"".Util::CLNumberParserZ($Ms[$nr]->A("bruttobetrag"))."\" /></td>
							</tr>
							<tr>
								<td><label>".T::_("Gebühren").":</label></td>
								<td><input id=\"mahngebuehren$nr\" type=\"text\" value=\"".Util::CLNumberParserZ($Ms[$nr]->A("gebuehren"))."\" /></td>
							</tr>
							<tr>
								<td colspan=\"2\">
									<input
										onclick=\"rme('Mahnung','','updateMahnung', Array('{$Ms["$nr"]->getID()}', $('zahlbarBis$nr').value, $('TB$nr').value, $('datumDerMahnung$nr').value, $('betragDerMahnung$nr').value, $('mahngebuehren$nr').value),'if(checkResponse(transport)) $(\'payUntil$nr\').update($(\'zahlbarBis$nr\').value);')\"
										type=\"button\"
										value=\"".T::_("Mahnung aktualisieren")."\" />
								</td>
							</tr>
						</table>
						<p><small style=\"color:grey;\">".T::_("Wenn Sie ein oder mehrere Felder nicht ausfüllen, werden Standardwerte verwendet.")."</small></p>
					</div>
					<table style=\"margin-bottom:20px;\">
						<tr>
							<td>".T::_("Zahlbar bis").": <span id=\"payUntil$nr\">".Util::CLDateParser($Ms[$nr]->A("lieferDatum"))."</span></td>
						</tr>
						<tr>
							<td>
								<div style=\"float:right;\">$B2</div>
								$B$B3$ESM
							</td>
						</tr>
					</table>
				</td>
			</tr>";
	}
	
	public function parseTB($nr, $TBID = null, $vars = null){
		if($TBID == null) {
			$TBs = new anyC();
			$TBs->setCollectionOf("Textbaustein");
			$TBs->addAssocV3("KategorieID","=",$nr + 30);
			$TBs->addAssocV3("isKatDefault","=","1");
			
			$T = $TBs->getNextEntry();
		} else {
			$T = new Textbaustein($TBID);
			$T->loadMe();
		}
		
		if($T == null) return "";
		
		$text = $T->getA()->text;
		
		if($vars != null)
			foreach($vars AS $k => $v){
				/*if(strpos($text, "{".$k."}") !== false AND $k == "Anrede"){
					$v = str_replace("1:","Sehr geehrte Frau", $v);
					$v = str_replace("2:","Sehr geehrter Herr", $v);
					$v = str_replace("3:","Sehr geehrte Damen und Herren", $v);
					$v = str_replace("0:","Sehr geehrte Damen und Herren", $v);
				}*/
				$text = str_replace("{".$k."}",$v, $text);
			
				$complexStart = strpos($text, "{".$k);
				if($complexStart === false) continue;
				
				$complexEnde = strpos($text,"}",$complexStart);
				
				$complexTotal = substr($text, $complexStart+1, $complexEnde-$complexStart-1);
				$complexVars = array();
				$s = explode(";",$complexTotal);
				$complex = $s[1];
				$s = explode("|",$complex);
				foreach($s AS $key => $value){
					$a = explode(":",$s[$key]);
					$complexVars[$a[0]] = $a[1];
				}
				
				$vs = explode(":",$v);
				
				$text = str_replace("{".$complexTotal."}",$complexVars[$vs[0]].$vs[1], $text);
			}
		
		return $text;
	}
	
	public function updateMahnung($GRLBMID, $zahlbarBis, $TB, $datumDerMahnung, $betragDerMahnung = "", $mahngebuehren = "0", $output = true){
		$mahngebuehren = Util::CLNumberParser($mahngebuehren, "store");
		
		$G = new GRLBM($GRLBMID);
		$G->loadMe();
		$A = $G->getA();
		
		$oldG = new GRLBM($A->AuftragID, false);
		#$oldG->loadMe();
		
		$Auftrag = new Auftrag($oldG->A("AuftragID"));
		#$Auftrag->loadMe();
		
		$Adresse = new Adresse($Auftrag->A("AdresseID"));
		#$Adresse->loadMe();

		$Kappendix = new mKappendix();
		$Kappendix->addAssocV3("kundennummer","=",$Auftrag->A("kundennummer"));
		$Kappendix = $Kappendix->getNextEntry();

		$tage = 14;

		$AspectTage = Aspect::joinPoint("tageZumZahlen", $this, __METHOD__, $A);
		if($AspectTage != null)
			$tage = $AspectTage;

		if($Kappendix != null AND $Kappendix->A("KappendixZahlungsziel") != null)
			$tage = $Kappendix->A("KappendixZahlungsziel");
		
		$zahlbarBisDefault = Util::CLDateParser(time() + $tage * 3600 * 24);


		$RechnungsBetrag = $RechnungsBetragOrig = $betragDerMahnung == "" ? $oldG->getSumOfPosten() : Util::CLNumberParser($betragDerMahnung, "store");
		if($oldG->A("GRLBMTeilzahlungenSumme"))
			$RechnungsBetrag -= $oldG->A("GRLBMTeilzahlungenSumme");
		
		$MahnGebuehren = Aspect::joinPoint("mahnGebühren", $this, __METHOD__, array($A, $RechnungsBetrag), $mahngebuehren);

		$MahnGebuehrenGesamt = $MahnGebuehren;
		$AC = anyC::get("GRLBM", "AuftragID", $G->A("AuftragID"));
		$AC->addAssocV3("isM", "=", "1");
		$AC->addAssocV3("nummer", "<", $G->A("nummer"));
		while($M = $AC->n())
			$MahnGebuehrenGesamt += $M->A("gebuehren");
		
		$vars = array(
			"Benutzername" => $_SESSION["S"]->getCurrentUser()->A("name"),
			"Benutzerposition" => $_SESSION["S"]->getCurrentUser()->A("UserPosition"),
			"BisDatum" => $zahlbarBis != "" ? $zahlbarBis : $zahlbarBisDefault,
			"Anrede" => Util::formatAnrede("de_DE", $Adresse),#($Adresse->A("nachname") != "" ? $Adresse->A("anrede") : "3").":".(($Adresse->A("nachname") != "" AND $Adresse->A("anrede") != "0") ? " " : "")."".($Adresse->A("anrede") != "0" ? $Adresse->A("nachname") : ""),
			"RechnungsBetrag" => utf8_encode(Util::conv_euro(Util::CLFormatCurrency($RechnungsBetrag, true))),
			"RechnungsDatum" => Util::CLDateParser($oldG->A("datum")),
			"RechnungsNummer" => $oldG->A("nummer"),
			"MahnDatum" => $datumDerMahnung != "" ? $G->A("datum") : $datumDerMahnung,
			"MahnGebührenGesamt" => utf8_encode(Util::conv_euro(Util::CLFormatCurrency($MahnGebuehrenGesamt, true))),
			"MahnGebühren" => utf8_encode(Util::conv_euro(Util::CLFormatCurrency($MahnGebuehren, true))),
			"GesamtBetrag" => utf8_encode(Util::conv_euro(Util::CLFormatCurrency($RechnungsBetrag + $MahnGebuehrenGesamt, true))));
	
		if($oldG->A("GRLBMTeilzahlungenSumme") !== null) {
			$vars["Teilzahl.Summe"] = utf8_encode(Util::conv_euro(Util::CLFormatCurrency($oldG->A("GRLBMTeilzahlungenSumme") * 1, true)));
			$vars["Teilzahl.Restbetrag"] = utf8_encode(Util::conv_euro(Util::CLFormatCurrency($RechnungsBetrag - $oldG->A("GRLBMTeilzahlungenSumme"), true)));
			$TZ = explode("\n", trim($oldG->A("GRLBMTeilzahlungen")));
			foreach($TZ AS $k => $l){
				if(trim($l) == "")
					continue;
				
				$ex = explode(";", $l);
				$vars["Teilzahl.Datum"] .= ($k == 0 ? "" : ($k == count($TZ) - 1 ? " und " : ", ")).Util::CLDateParser($ex[1]);
			}
			
		}
		
		if($A->nummer == "2" OR $A->nummer == "3") {
			$ersteMahnung = new anyC();
			$ersteMahnung->setCollectionOf("GRLBM");
			$ersteMahnung->addAssocV3("AuftragID","=",$A->AuftragID);
			$ersteMahnung->addAssocV3("nummer","=","1");
			$ersteMahnung = $ersteMahnung->getNextEntry();
			if($ersteMahnung != null) $vars["1.MahnungDatum"] = Util::formatDate("de_DE",$ersteMahnung->getA()->datum);
		}
		
		if($A->nummer == "3") {
			$zweiteMahnung = new anyC();
			$zweiteMahnung->setCollectionOf("GRLBM");
			$zweiteMahnung->addAssocV3("AuftragID","=",$A->AuftragID);
			$zweiteMahnung->addAssocV3("nummer","=","2");
			$zweiteMahnung = $zweiteMahnung->getNextEntry();
			if($zweiteMahnung != null) $vars["2.MahnungDatum"] = Util::formatDate("de_DE",$zweiteMahnung->getA()->datum);
		}
		
		$A->textbausteinOben = $this->parseTB($A->nummer, $TB, $vars);
		if($datumDerMahnung != "") $A->datum = $datumDerMahnung;
		$A->gebuehren = $MahnGebuehren;
		$A->bruttobetrag = $RechnungsBetragOrig;

		$A->lieferDatum = $zahlbarBis != "" ? $zahlbarBis : $zahlbarBisDefault;
		
		$G2 = new GRLBM($GRLBMID);
		$G2->setA($A);
		$G2->saveMe();
		
		if($output) echo Red::messageSaved();
	}
	
	public function createMahnung($GRLBMID, $nr, $ZahlungsaufforderungID = 0){
		$oldGRLBM = new GRLBM($GRLBMID);
		$G = new GRLBM(-1);
		$A = $G->newAttributes();
		$A->AuftragID = $GRLBMID;
		$A->nummer = $nr;
		$A->isM = 1;
		$A->prefix = mStammdaten::getActiveStammdaten()->getPrefix("M");
		$A->lieferAdresseID = $oldGRLBM->A("lieferAdresseID");
		
		$GRLBM = new GRLBM($GRLBMID);
		$Auftrag = new Auftrag($GRLBM->A("AuftragID"));
		
		$Kappendix = new mKappendix();
		$Kappendix->addAssocV3("kundennummer","=",$Auftrag->A("kundennummer"));
		$Kappendix = $Kappendix->getNextEntry();

		$tage = 14;

		$AspectTage = Aspect::joinPoint("tageZumZahlen", $this, __METHOD__, $A);
		if($AspectTage != null)
			$tage = $AspectTage;

		if($Kappendix != null AND $Kappendix->A("KappendixZahlungsziel") != null AND $Kappendix->A("KappendixZahlungsziel") > 0)
			$tage = $Kappendix->A("KappendixZahlungsziel");
		#var_dump($tage);
		$zahlbarBis = Util::CLDateParser(time() + $tage * 3600 * 24);

		#$zahlbarBis = Util::CLDateParser(time() + 14 * 3600 * 24);
		#if($Kappendix != null AND $Kappendix->A("KappendixZahlungsziel") != null)
		#	$zahlbarBis = Util::CLDateParser(time() + $Kappendix->A("KappendixZahlungsziel") * 3600 * 24);

		
		$A->textbausteinOben = "";
		$A->textbausteinUnten = "";
		$A->zahlungsbedingungen = "";
		$A->GRLBMAnsprechpartnerID = $oldGRLBM->A("GRLBMAnsprechpartnerID");
		$A->GRLBMZahlungsaufforderungID = $ZahlungsaufforderungID;
		$G->setA($A);
		$id = $G->newMe();
		
		$geb = explode(";", mUserdata::getGlobalSettingValue("mahnungGebühren", "0;0;0;0;0;0"));
		
		$RechnungsBetrag = $oldGRLBM->getSumOfPosten();
		if($oldGRLBM->A("GRLBMTeilzahlungenSumme"))
			$RechnungsBetrag -= $oldGRLBM->A("GRLBMTeilzahlungenSumme");
		
		$mahngebuehren = 0;
		if($nr == 1)
			$mahngebuehren = Util::kRound($RechnungsBetrag * ($geb[3] / 100)) + $geb[0];

		if($nr == 2)
			$mahngebuehren = Util::kRound($RechnungsBetrag * ($geb[4] / 100)) + $geb[1];

		if($nr == 3)
			$mahngebuehren = Util::kRound($RechnungsBetrag * ($geb[5] / 100)) + $geb[2];
		
		
		$this->updateMahnung($id, $zahlbarBis, null, date("d.m.Y"), "", $mahngebuehren, false);
		
		return $id;
	}
	
	public function createTBs(){
		$T = new Textbaustein();
		$A = $T->newAttributes();
		$A->isKatDefault = 1;
		
		$A->label = "erste Mahnung";
		$A->KategorieID = 31;
		$A->text = "Betreff: Unsere Rechnung {RechnungsNummer} vom {RechnungsDatum}

{Anrede},

Ihren Auftrag haben wir schnell und pünktlich ausgeführt.
Leider warten wir bis heute vergeblich auf den Zahlungseingang.

Bitte überweisen Sie den Rechnungsbetrag von {RechnungsBetrag} bis zum {BisDatum} auf unser Konto.

Vielen Dank!


Mit freundlichen Grüßen,


{Benutzername}";
		
		$T2 = new Textbaustein();
		$T2->setA($A);
		$T2->newMe();
		
		$A->label = "zweite Mahnung";
		$A->KategorieID = 32;
		$A->text = "Betreff: Unsere Rechnung {RechnungsNummer} vom {RechnungsDatum} und die Mahnung vom {1.MahnungDatum}

{Anrede},

am {1.MahnungDatum} haben wir Sie an den Zahlungsrückstand von {RechnungsBetrag} erinnert.
Bis heute haben wir weder eine Zahlung noch eine Reaktion von Ihnen erhalten.

Bitte überweisen Sie den Rechnungsbetrag bis zum {BisDatum} auf unser Konto:

Bankverbindung: Dresdner Bank Hamburg
Kontonummer: 1234 5678
Bankleitzahl: 200 800 00.

Sollten wir bis zum {BisDatum} keinen Zahlungseingang feststellen, werden wir zusätzlich Mahngebühren und Verzugszinsen berechnen.

Wir hoffen, dass dies nicht nötig sein wird!


Mit freundlichen Grüßen,


{Benutzername}";
		
		$T2 = new Textbaustein();
		$T2->setA($A);
		$T2->newMe();
		
		$A->label = "dritte Mahnung";
		$A->KategorieID = 33;
		$A->text = "Betreff: Unsere Rechnung {RechnungsNummer} vom {RechnungsDatum} sowie die Mahnungen vom {1.MahnungDatum} und {2.MahnungDatum}

{Anrede},

auf unsere Mahnungen haben Sie leider nicht reagiert.
Es besteht immer noch ein Zahlungsrückstand von {RechnungsBetrag}.

Bevor wir das gerichtliche Mahnverfahren einleiten, geben wir Ihnen hiermit eine letzte Chance, den Rechnungsbetrag zu zahlen.

Bitte nutzen Sie diese letzte Frist bis zum {BisDatum}. Danke!


{Benutzername}";
		
		$T2 = new Textbaustein();
		$T2->setA($A);
		$T2->newMe();
		
	}

	public static function doSomethingElse(){
		$_SESSION["S"]->registerOnLoginFunction("MahnungGUI","registerTBKategorien");
	}

	static function registerTBKategorien(){
		T::load(__DIR__, "Mahnung");
		
		$M = new MahnungGUI();
		
		$k = new Textbausteine();
		$k->addTBKategorie(T::_("Textbaustein erste Mahnung"),"31");
		$k->addTBKategorie(T::_("Textbaustein zweite Mahnung"),"32");
		$k->addTBKategorie(T::_("Textbaustein dritte Mahnung"),"33");
		
		$k->addTBKategorie(T::_("E-Mail erste Mahnung"),"131");
		$k->addTBKategorie(T::_("E-Mail zweite Mahnung"),"132");
		$k->addTBKategorie(T::_("E-Mail dritte Mahnung"),"133");

		$M1 = array("Anrede","BisDatum", "Benutzername", "Benutzerposition", "RechnungsNummer", "RechnungsDatum", "RechnungsBetrag", "MahnGebühren", "MahnGebührenGesamt", "MahnDatum", "GesamtBetrag");
		$M2 = array("Anrede","BisDatum", "Benutzername", "Benutzerposition", "RechnungsNummer", "RechnungsDatum", "1.MahnungDatum", "RechnungsBetrag", "MahnGebühren", "MahnGebührenGesamt", "MahnDatum", "GesamtBetrag");
		$M3 = array("Anrede","BisDatum", "Benutzername", "Benutzerposition", "RechnungsNummer", "RechnungsDatum", "1.MahnungDatum", "2.MahnungDatum", "RechnungsBetrag", "MahnGebühren", "MahnGebührenGesamt", "MahnDatum", "GesamtBetrag");
		
		if($M->CustomizerTeilzahlungen){
			$M1[] = "Teilzahl.Summe";
			$M1[] = "Teilzahl.Restbetrag";
			$M1[] = "Teilzahl.Datum";
			
			$M2[] = "Teilzahl.Summe";
			$M2[] = "Teilzahl.Restbetrag";
			$M2[] = "Teilzahl.Datum";
			
			$M3[] = "Teilzahl.Summe";
			$M3[] = "Teilzahl.Restbetrag";
			$M3[] = "Teilzahl.Datum";
		}
		
		$k->addTBVariables("31", $M1);
		$k->addTBVariables("32", $M2);
		$k->addTBVariables("33", $M3);
		
		
		$M1 = array("Anrede","Firmenname","Benutzername", "Belegnummer","Belegdatum", "Rechnungsnummer", "Rechnungsdatum", "Gesamtsumme", "+1Woche","+2Wochen","+3Wochen","+1Monat", "+#Tage");
		$M2 = array("Anrede","Firmenname","Benutzername", "Belegnummer","Belegdatum", "1.Mahnungsdatum", "Rechnungsnummer", "Rechnungsdatum", "Gesamtsumme", "+1Woche","+2Wochen","+3Wochen","+1Monat", "+#Tage");
		$M3 = array("Anrede","Firmenname","Benutzername", "Belegnummer","Belegdatum", "1.Mahnungsdatum", "2.Mahnungsdatum", "Rechnungsnummer", "Rechnungsdatum", "Gesamtsumme", "+1Woche","+2Wochen","+3Wochen","+1Monat", "+#Tage");
		
		$k->addTBVariables("131", $M1);
		$k->addTBVariables("132", $M2);
		$k->addTBVariables("133", $M3);
		
		
	}

	public function getContextMenuHTML($identifier) {
		$F = new HTMLForm("mahnGeb", array("ersteMahnung", "zweiteMahnung", "dritteMahnung"), null, array("ersteMahnungPercent", "zweiteMahnungPercent", "dritteMahnungPercent"));
		$F->cols(1);
		
		$geb = explode(";", mUserdata::getGlobalSettingValue("mahnungGebühren", "0;0;0;0;0;0"));		
		
		$F->setLabel("ersteMahnung", "Gebühren 1. Mahnung");
		$F->setLabel("zweiteMahnung", "Gebühren 2. Mahnung");
		$F->setLabel("dritteMahnung", "Gebühren 3. Mahnung");
		
		$F->setValue("ersteMahnung", Util::CLNumberParserZ($geb[0]));
		$F->setValue("zweiteMahnung", Util::CLNumberParserZ($geb[1]));
		$F->setValue("dritteMahnung", Util::CLNumberParserZ($geb[2]));
		
		$F->setInputStyle("ersteMahnung", "text-align:right;");
		$F->setInputStyle("zweiteMahnung", "text-align:right;");
		$F->setInputStyle("dritteMahnung", "text-align:right;");
		
		$F->setType("ersteMahnung", "parser", null, array("MahnungGUI::parserErsteMahnung", $geb));
		$F->setType("zweiteMahnung", "parser", null, array("MahnungGUI::parserZweiteMahnung", $geb));
		$F->setType("dritteMahnung", "parser", null, array("MahnungGUI::parserDritteMahnung", $geb));
		
		$F->setSaveRMEPCR("Speichern", "", "Mahnung", "-1", "saveGebuehren", OnEvent::closeContext());
		
		echo $F;
	}
	
	public static function parserErsteMahnung($w, $l, $E){
		$I = new HTMLInput("ersteMahnung", "text", Util::CLNumberParserZ($E[0]));
		$I->style("width:70px;text-align:right;");
		
		$I2 = new HTMLInput("ersteMahnungPercent", "text", Util::CLNumberParserZ($E[3]));
		$I2->style("width:70px;text-align:right;");
		
		$c = Util::getLangCurrencyFormat(Session::getLanguage());
		
		return $I."<span style=\"color:grey;\">$c[0]</span> + $I2 <span style=\"color:grey;\">%</span>";
	}
	
	public static function parserZweiteMahnung($w, $l, $E){
		$I = new HTMLInput("zweiteMahnung", "text", Util::CLNumberParserZ($E[1]));
		$I->style("width:70px;text-align:right;");
		
		$I2 = new HTMLInput("zweiteMahnungPercent", "text", Util::CLNumberParserZ($E[4]));
		$I2->style("width:70px;text-align:right;");
		
		$c = Util::getLangCurrencyFormat(Session::getLanguage());
		
		return $I."<span style=\"color:grey;\">$c[0]</span> + $I2 <span style=\"color:grey;\">%</span>";
	}
	
	public static function parserDritteMahnung($w, $l, $E){
		$I = new HTMLInput("dritteMahnung", "text", Util::CLNumberParserZ($E[2]));
		$I->style("width:70px;text-align:right;");
		
		$I2 = new HTMLInput("dritteMahnungPercent", "text", Util::CLNumberParserZ($E[5]));
		$I2->style("width:70px;text-align:right;");
		
		$c = Util::getLangCurrencyFormat(Session::getLanguage());
		
		return $I."<span style=\"color:grey;\">$c[0]</span> + $I2 <span style=\"color:grey;\">%</span>";
	}

	function saveGebuehren(){
		$A = func_get_args();
		foreach($A AS $k => $v)
			$A[$k] = Util::CLNumberParserZ($v, "store");
		
		mUserdata::setUserdataS("mahnungGebühren", implode(";", $A), "", -1);
		Red::messageSaved();
	}
}
?>