<?php
/**
 *  This file is part of open3A.

 *  open3A is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  open3A is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 *  2007 - 2020, open3A GmbH - Support@open3A.de
 */
class ImportDatanormGUI extends ImportDatanorm implements iGUIHTML2 {
	function getHTML($id){
		$F = new HTMLForm("datanormUpload", array("mwst", "lieferant", "prefix", "datei"), "Datanorm-Import");

		$F->setType("datei", "file");
		$F->addJSEvent("datei", "onChange", OnEvent::popup("Datanorm-Import", "DatanormImport", "-1", "redeemer", array("$('datanormUpload').mwst.value", "$('datanormUpload').lieferant.value", "$('datanormUpload').prefix.value"), "", "{width:800, blackout: true, hPosition: 'center', hasX: false}"));
		#"contentManager.loadFrame('contentLeft', 'DatanormImport', -1, 0, 'DatanormImportGUI;mwst:'+$('datanormUpload').mwst.value+';lieferant:'+$('datanormUpload').lieferant.value+';prefix:'+$('datanormUpload').prefix.value);"
		$F->getTable()->setColWidth(1, 120);
		#$F->setSaveUpload("ImportDatanorm", "Datanorm-Datei importieren","function () { contentManager.loadFrame('contentLeft', 'DatanormImport'); }");

		$AC = anyC::get("Lieferant");
		$L = array("0" => "bitte auswählen");
		while($E = $AC->getNextEntry())
			$L[$E->getID()] = $E->A("LieferantFirma");

		$F->setType("lieferant", "select", null, $L);

		$F->setLabel("prefix", "Präfix");
		$F->setDescriptionField("prefix", "Artikelnummern-Präfix für diesen Lieferanten, z.B. 'BUZ_'");
		
		$kat = new Kategorien();
		$kat->addAssocV3("type","=","mwst");
		$values = $kat->getArrayWithValues();

		$mwst = array("-1" => "bitte auswählen");
		#$mwst["-1"] = new HTMLInput("bitte auswählen", "option", "-1");
		foreach($values AS $k => $v){
			$uv = "".Util::parseFloat("de_DE",str_replace("%","",$v));
			$mwst[$uv] = Util::CLNumberParserZ(Util::parseFloat("de_DE",str_replace("%","",$v)),"load")."%";#new HTMLInput(Util::CLNumberParserZ(Util::parseFloat("de_DE",str_replace("%","",$v)),"load")."%", "option", $uv);

		}
		#print_r($mwst);
		#echo Util::parseFloat("de_DE",str_replace("%","",Kategorien::getDefault("mwst", "19,00%")));
		$F->setLabel("mwst", "MwSt");
		$F->setType("mwst", "select", "".Util::parseFloat("de_DE",str_replace("%","",Kategorien::getDefault("mwst", "-1,00%"))), $mwst);
		#$F->setValue("mwst", "-1");
		
		$B = new Button("Lieferanten bearbeiten", "./openWaWi/Lieferanten/Lieferant18.png", "icon");
		$B->style("float:right;");
		$B->loadFrame("contentRight", "mLieferant", "-1", "0", "mLieferantGUI;-");
		
		$F->addFieldButton("lieferant", $B);
		
		return $F;
	}

	public static function getImportGUI(){
		if(!Session::isPluginLoaded("mLieferant"))
			return "";
		
		$T = new ImportDatanormGUI();
		return $T->getHTML(-1);
	}
}
?>