<?php
/*
 *  This file is part of open3A.

 *  open3A is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  open3A is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 *  2007 - 2020, open3A GmbH - Support@open3A.de
 */
class mImportGUI extends Collection implements iGUIHTML2 {
	function __construct() {
		$this->collectionOf = "Import";
	}
	
	function checkIfMyTableExists(){
		$this->collectionOf = "ImportSetting";
		return parent::checkIfMyTableExists();
	}
	
	public function getHTML($id){
		T::load(__DIR__, "mImport");
		$gui = new HTMLGUI();
		$gui->VersionCheck("mImport");
		$gui->setName("Temporäre Dateien");

		if(isset($_SESSION["TempFiles"]) AND is_object($_SESSION["TempFiles"]))
			$gui->setAttributes($_SESSION["TempFiles"]->getCollector());
		
		$gui->setShowAttributes(array("originalFilename"));
		$gui->setCollectionOf("Import", "Temp. Datei");
		$gui->setIsDisplayMode(true);
		$gui->setDeleteInDisplayMode(true);
		$gui->setEditInDisplayMode(true, "contentLeft");
		
		$gui->setJSEvent("onDelete","function() {contentManager.reloadFrameRight();}");
		
		$F = new HTMLForm("CSVUpload", array("csvdatei"), "CSV-Import");

		$F->setType("csvdatei", "file");
		$F->setLabel("csvdatei", "Datei");
		$F->addJSEvent("csvdatei", "onChange", "contentManager.reloadFrame('contentRight');");
		$F->getTable()->setColWidth(1, 120);

		#$t = new HTMLTable(1,"XML-Import");
		#$t->addRow("<textarea name=\"XMLString\" id=\"XMLImportTA\"></textarea>");
		#$t->addRow("<input type=\"button\" onclick=\"if($('XMLImportTA').value != '') rmeP('ImportXML','','tempXML',joinFormFieldsToString('XMLImportForm'),'contentManager.loadFrame(\'contentLeft\',\'ImportXML\');'); else alert('Bitte geben Sie XML-Text in das Feld ein.');\" value=\"Vorschau laden\" />");

		if(Applications::activeApplication() != "open3A" AND Applications::activeApplication() != "lightCRM" AND Applications::activeApplication() != "openWaWi")
			$F = "";
		
		$ADD = "";
		while(($HTML = Registry::callNext("Import")) !== null)
			$ADD .= $HTML."<div style=\"height:30px;\"></div>";
		
		#<form id=\"XMLImportForm\">".$t->getHTML()."</form>
		try {
			return HTMLGUIX::tipJS("mImport").$ADD."".$F."</div>".((isset($_SESSION["TempFiles"]) AND count($_SESSION["TempFiles"]->getCollector()) > 0) ? $gui->getBrowserHTML($id) : "");
		} catch (Exception $e){ }
	}
}
?>
