<?php
/*
 *  This file is part of open3A.

 *  open3A is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  open3A is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 *  2007 - 2020, open3A GmbH - Support@open3A.de
 */
class importArtikelGUI extends aImportDefault implements iImportable, iFileBrowser  {
	public function getLabel(){
		if(!Session::isPluginLoaded("mArtikel")) return null;
		return "Artikel";
	}
	
	public function getFieldsList(){
		$f = array(
			"Artikelname" => "name",
			"Artikelnummer" => "artikelnummer",
			"Einheit" => "gebinde",
			"Nettopreis" => "preis");
		
		if(Session::isPluginLoaded("mBrutto"))
			$f["Bruttopreis"] = "bruttopreis";
		
		$f["MwSt"] = "mwst";
		$f["Einkaufspreis 1"] = "EK1";
		$f["Einkaufspreis 2"] = "EK2";
		$f["Beschreibung"] = "beschreibung";
		$f["Bemerkung"] = "bemerkung";
		$f["Kategorie"] = "KategorieID";
		$f["ArtikelNr. Hersteller"] = "artikelnummerHersteller";
		$f["EAN"] = "EAN";
		
		if(Session::isPluginLoaded("mLieferant")){
			$f["Lieferant"] = "lieferant";
			$f["Lagerbestand"] = "lagerbestand";
			$f["Rabattgruppe"] = "rabattgruppe";
			$f["Listenpreis"] = "listenpreis";
		}
		
		if(Session::isPluginLoaded("mArtikelRG")){
			$f["Rabattgruppe 1"] = "RG1";
			$f["Rabattgruppe 2"] = "RG2";
			$f["Rabattgruppe 3"] = "RG3";
			$f["Rabattgruppe 4"] = "RG4";
			$f["Rabattgruppe 5"] = "RG5";
		}
		
		$f = Aspect::joinPoint("fields", $this, __METHOD__, array($f), $f);
		
		if(is_array(current($f))){
			$new = array();
			foreach($f AS $subfields)
				foreach ($subfields AS $l => $v){
					if(isset($new[$l]))
						continue;
					
					$new[$l] = $v;
				}
				
				$f = $new;
		}
		
		return $f;
	}

	protected function isEmpty($lineData){
		$empty = true;
		
		foreach($lineData AS $v)
			if(trim($v) != "")
				$empty = false;
		
		return $empty;
	}
	
	public function getImportID($lineData){
		if($this->A("artikelnummer") == "-")
			return -1;
		
		if($lineData[$this->A("artikelnummer")] == "")
			return -1;
		
		$AC = anyC::get("Artikel", "artikelnummer", $lineData[$this->A("artikelnummer")]);
		$AC->setLimitV3(2);
		if($AC->numLoaded() > 1)
			return -1;
		
		$A = $AC->n();
		if($A == null)
			return -1;
		
		return $A->getID();
	}
	
	public function getFieldsSeparators(){
		$separators = array(
			"lieferant" => "Lieferant",
			"RG1" => "Rabattgruppen");
		
		return $separators;
	}
	
	public function getFieldsDescriptions(){
		$fields = array(
			"artikelnummer" => "<small style=\"color:red;\">Wenn eine Artikelnummer gefunden wird, wird der Eintrag aktualisiert.</small>"
		);
		
		return $fields;
	}
	
	public function getFieldsValues(){
		$fields = array();
		
		$AC = anyC::get("Kategorie", "type", "2");
		$Ks = array();
		while($K = $AC->getNextEntry())
			$Ks["use_".$K->getID()] = $K->A("name");
		
		$fields["KategorieID_append"] = $Ks;
		
		if(Session::isPluginLoaded("mLieferant")){
			$Ls = array(0 => "Kein Lieferant");

			$AC = anyC::get("Lieferant");
			while($L = $AC->n())
				$Ls[$L->getID()] = $L->A("LieferantFirma");
					
			$fields["lieferant"] = $Ls;
		}

		return $fields;
	}
	
	public function getPlugin(){
		return "Artikel";
	}

	private $KIDs = array();
	protected function parser($fieldName, $value) {
		$value = Aspect::joinPoint("parser", $this, __METHOD__, array($fieldName, $value), $value);
		
		if($fieldName == "preis" OR $fieldName == "bruttopreis" OR $fieldName == "EK1" OR $fieldName == "EK2" OR $fieldName == "listenpreis"){

			$f = Util::getLangNumbersFormat(Session::getLanguage());
			$num = preg_replace("/[^0-9,\.]/","",$value);
			if($f[0] != $this->A("sepDecimal"))
				$num = str_replace($this->A("sepDecimal"), $f[0], $num);
			
			return $num;
		}
		
		if($fieldName == "KategorieID" AND $this->A("KategorieID") != "-" AND substr($this->A("KategorieID"), 0, 4) == "use_")
			return str_replace ("use_", "", $this->A("KategorieID"));

		if($fieldName == "KategorieID" AND $this->A("KategorieID") != "-" AND substr($this->A("KategorieID"), 0, 4) != "use_" AND trim($value) != ""){
			if(isset($this->KIDs[$value]))
				return $this->KIDs[$value];
			
			$AC = anyC::get("Kategorie", "type", "2");
			$AC->addAssocV3("name", "=", $value);
			$K = $AC->n();
			if($K == null){
				$F = new Factory("Kategorie");
				$F->sA("type", "2");
				$F->sA("name", $value);
				$id = $F->store();
				
				$this->KIDs[$value] = $id;
				
				return $id;
			} else {
				$this->KIDs[$value] = $K->getID();
				return $K->getID();
			}
		}
		
		return $value;
	}
	
	protected function beforeNew(PersistentObject $O) {
		$O->changeA("isBrutto", "0");
		
		if(Session::isPluginLoaded("mBrutto") AND $this->A("bruttopreis") != "-" AND trim($O->A("bruttopreis") != "")){
			$O->changeA("isBrutto", "1");
			$O->changeA("preis", $O->A("bruttopreis"));
		}
	}
	
	protected function onNew($newID, $lineData) {
		if(Session::isPluginLoaded("mLieferant") AND $this->A("lieferant") != "-"){
			$F = new Factory("LieferantPreis");

			$F->sA("LieferantPreisArtikelID", $newID);
			$F->sA("LieferantPreisLieferantID", $this->A("lieferant"));
			
			if($this->A("lagerbestand") != "-")
				$F->sA("LieferantPreisLagerbestand", Util::CLNumberParserZ($lineData[$this->A("lagerbestand")], "store"));
			if($this->A("rabattgruppe") != "-")
				$F->sA("LieferantPreisRabattgruppe", $lineData[$this->A("rabattgruppe")]);
			if($this->A("listenpreis") != "-")
				$F->sA("LieferantPreisListenPreis", Util::CLNumberParserZ($lineData[$this->A("listenpreis")], "store"));
			
			$F->store(true, false);
		}
		
		if(Session::isPluginLoaded("mArtikelRG")){
			$F = new Factory("ArtikelRG");
			$F->sA("ArtikelRGArtikelID", $newID);
			
			$i = 0;
			for($j = 1; $j <= 5; $j++)
				if($this->A("RG$j") != "-"){
					$F->sA("ArtikelRG$j", $lineData[$this->A("RG$j")]);
					$i++;
				}
			
			if($i)
				$F->store(true, false);
		}
	}
	
	protected function onUpdate($ID, $lineData){
		if(Session::isPluginLoaded("mLieferant") AND $this->A("lieferant") != "-"){
			$AC = anyC::get("LieferantPreis", "LieferantPreisLieferantID", $this->A("lieferant"));
			$AC->addAssocV3("LieferantPreisArtikelID", "=", $ID);
			
			$LP = $AC->n();
			if($LP != null){
				if($this->A("lagerbestand") != "-")
					$LP->changeA("LieferantPreisLagerbestand", Util::CLNumberParserZ($lineData[$this->A("lagerbestand")], "store"));
				if($this->A("rabattgruppe") != "-")
					$LP->changeA("LieferantPreisRabattgruppe", $lineData[$this->A("rabattgruppe")]);
				if($this->A("listenpreis") != "-")
					$LP->changeA("LieferantPreisListenPreis", Util::CLNumberParserZ($lineData[$this->A("listenpreis")], "store"));
				
				$LP->saveMe();
			}
		}
		
		if(Session::isPluginLoaded("mArtikelRG")){
			$RG = anyC::getFirst("ArtikelRG", "ArtikelRGArtikelID", $ID);
			
			if($RG == null){
				$F = new Factory("ArtikelRG");
				$F->sA("ArtikelRGArtikelID", $ID);
				$RGID = $F->store();
				
				$RG = new ArtikelRG($RGID);
			}
			
			$i = 0;
			for($j = 1; $j <= 5; $j++)
				if($this->A("RG$j") != "-"){
					$RG->changeA("ArtikelRG$j", $lineData[$this->A("RG$j")]);
					$i++;
				}
			
			if($i)
				$RG->saveMe();
		}
	}
}
?>