<?php
/**
 *  This file is part of open3A.

 *  open3A is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  open3A is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  2007 - 2020, open3A GmbH - Support@open3A.de
 */
abstract class ImportLargeFileCSV extends UnpersistentClass implements iGUIHTML2 {
	public function getHTML($id){
		if(!isset($_SESSION["TempFiles"]))
			return;

		$C = $_SESSION["TempFiles"]->getCollector();
		$v = $C[0];

		$bpsName = "lastLine".Util::makeFilename(basename($v->A("filename")));
		
		if(count($C) > 1){
			unset($_SESSION["TempFiles"]);
			BPS::unsetProperty("MyImportAlgo", $bpsName);
			Red::errorD("Dieser Import unterstützt nur eine Datei pro Upload");
		}

		#print_r(BPS::getAllProperties("DatanormImportAlgo"));


		$T = new HTMLTable(6, "CSV-Import");
		$T->setColWidth(1, 20);
		$T->setTableStyle("font-size:10px;");

		$lastLine = BPS::getProperty("MyImportAlgo", $bpsName, 0);
		$row = 0;
		$broke = false;

		$handle = fopen($v->A("filename"),"r");
		
		while(($data = fgetcsv($handle, 1000, ";")) !== false) {
			$row++;
			#$nextData = fgetcsv($handle, 1000, ";");

			if($lastLine > $row) continue;

			$tabCon = $this->handleLine($data);
			
			$T->addRow(array_merge(array($row), $tabCon));
			if($tabCon[5] === false)
				$T->addRowStyle("color:grey;");

			#$data = $nextData;
			if($row - $lastLine == 19/* AND $data !== false*/) {
				if(fgetcsv($handle, 1000, ";") !== false)
					$broke = true;
				break;
			}
		}

		fclose($handle);

		BPS::setProperty("MyImportAlgo", $bpsName, ++$row);

		$reload = "";
		if(!$broke){
			unset($_SESSION["TempFiles"]);
			BPS::unsetProperty("MyImportAlgo", $bpsName);

			$B = new Button("Import abgeschlossen", "bestaetigung");
			$B->type("icon");
			$B->style("float:left;margin-right:10px;");

			$T->addRow(array($B."Der Import wurde erfolgreich abgeschlossen."));
			$T->addRowColspan(1, 6);
		} else {
			$B = new Button("Import wird fortgesetzt", "navigation");
			$B->type("icon");
			$B->style("float:left;margin-right:10px;");
			$B->onclick("contentManager.loadFrame('contentLeft', '".str_replace("GUI", "", get_class($this))."');");
			$T->addRow(array($B."Bitte haben Sie Geduld, während der Import fortgesetzt wird."));
			$T->addRowColspan(1, 6);

			$reload = "<script type=\"text/javascript\">contentManager.loadFrame('contentLeft', '".str_replace("GUI", "", get_class($this))."');</script>";
		}

		return $T.$reload;
	}

	public static function getImportGUI(){}
	
	public abstract function handleLine($data);
}
?>
