/*
 *
 *  This file is part of open3A.

 *  open3A is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  open3A is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 *  2007 - 2020, open3A GmbH - Support@open3A.de
 */
 
 var ImportMessages = {
 	M001: function(anz) {return anz+" Datensätze importiert";}
 }

var Import = {

	openSchnellImportAdresse: function(label){
		Popup.load(label, "importAdresse", "", "getFastImportWindow", Array(''));
		//contentManager.rmePCR('importAdresse', '', 'getFastImportWindow', Array(''), 'if(checkResponse(transport)) { Popup.display(\''+label+'\',transport);}', '');
	},

	preview: function(id,  onSuccess){
		Popup.load('Vorschau', 'Import', id, 'getPreview', [$('sep').value,$('sepText').value,$('startLine').value,$('endLine').value,$('codepage').value,$('firstLine').checked ? 'true' : 'false'], '', 'edit', "{width: 600}");
		contentManager.rmePCR('Import', id, 'loadFields', $('importToPlugin').value, function(transport){ $j('#importFields').html(transport.responseText); if(typeof onSuccess == "function") onSuccess(); });
	},
			
	applySettings: function(id, data){
		$j.each(data, function(i, obj) {
			if(i == "TempFileID")
				return;
			
			if($j("[name="+i+"]").prop("type") == "checkbox")
				$j("[name="+i+"]").prop("checked", obj == "1");
			else
				$j("[name="+i+"]").val(obj);
		});
		
		Import.preview(id, function(){
			$j.each(data, function(i, obj) {
				if(i == "TempFileID")
					return;
			
				if($j("[name="+i+"]").prop("type") == "checkbox")
					$j("[name="+i+"]").prop("checked", obj == "1");
				else
					$j("[name="+i+"]").val(obj);
			});
		});
	},
			
	schnellImportAdresse: function(text){
		var split = text.split("\n");

		for(var i = 0; i < 7; i++){

			if(i == 0 && $j('input[name=firma]').length) {
				$j('input[name=firma]').val("");

				if(typeof split[i] == "undefined") continue;
				$j('input[name=firma]').val(split[i]);
			}

			if(i == 1){
				if(!$j('input[name=nachname]').length || ! $j('input[name=vorname]').length) continue;
				
				$j('input[name=vorname]').val("");
				$j('input[name=nachname]').val("");
				if(typeof split[i] == "undefined") continue;

				var split1 = split[1].split(" ");
				var foundAnrede = false;
				
				$j("select[name=anrede] option").filter(function() {
					if($j(this).text() == split1[0]){
						foundAnrede = true;
						return true;
					}
					
					return false;
				}).prop('selected', true);

				var start = 0;
				if(foundAnrede) start++;


				//$('nachname').value = "";
				//$('vorname').value = "";

				if(split1.length > start + 1){
					if(split1.length > start) $j('input[name=vorname]').val(split1[start]);
					$j('input[name=nachname]').val("");
					for(var l = start + 1; l < split1.length; l++)
						if($j('input[name=nachname]').length)
							$j('input[name=nachname]').val($j('input[name=nachname]').val()+($j('input[name=nachname]').val() != "" ? " " : "")+split1[l]);
					
				} else {
					$j('input[name=vorname]').val("");

					if(split1.length > start)
						if(foundAnrede) $j('input[name=nachname]').val(split1[1]);
						else $j('input[name=nachname]').val(split[1]);
					else
						$j('input[name=nachname]').val("");
				}
			}

			if(i == 2){
				if(!$j('input[name=strasse]').length || !$j('input[name=nr]').length) continue;

				$j('input[name=strasse]').val("");
				$j('input[name=nr]').val("");
				if(typeof split[i] == "undefined") continue;

				if(split[2] == "") continue;

				var split2 = split[2].split(" ");
				if(split2.length == 0) continue;

				$j('input[name=strasse]').val(split2[0]);
				for(var j = 1; j < split2.length - 1; j++){
					$j('input[name=strasse]').val($j('input[name=strasse]').val()+($j('input[name=strasse]').val() != "" ? " " : "")+split2[j]);
				}
				
				if(split2.length > 1) $j('input[name=nr]').val(split2[split2.length - 1]);
			}

			if(i == 3){
				if(!$j('input[name=plz]').length || !$j('input[name=ort]').length) continue;

				$j('input[name=plz]').val("");
				$j('input[name=ort]').val("");
				if(typeof split[i] == "undefined") continue;

				if(split[3] == "") continue;

				var split3 = split[3].split(" ");
				if(split3.length > 1){
					if(split3.length > 0) $j('input[name=plz]').val(split3[0]);

					$j('input[name=ort]').val("");
					for(var j = 1; j < split3.length; j++)
						$j('input[name=ort]').val($j('input[name=ort]').val()+($j('input[name=ort]').val() != "" ? " " : "")+split3[j]);
				} else
					if($j('input[name=ort]').length) $j('input[name=ort]').val(split[3]);
			}

			if(i == 4){
				if(!$j("select[name=land]").length)
					continue;
				
				//$j("select[name=land] option:first").prop('selected', true);
				
				if(typeof split[i] == "undefined")
					continue;

				
				$j("select[name=land] option").filter(function() {
					if($j(this).text() == split[4]){
						return true;
					}
					
					return false;
				}).prop('selected', true);
			}

			if(i == 5){
				if(!$j("input[name=tel]").length)
					continue;

				$j("input[name=tel]").val("");
				if(typeof split[i] == "undefined")
					continue;

				$j("input[name=tel]").val(split[5]);
			}

			if(i == 6){
				if(!$j("input[name=email]").length)
					continue;

				$j("input[name=email]").val("");
				if(typeof split[i] == "undefined")
					continue;

				$j("input[name=email]").val(split[6]);
			}
		}

	}
}