<?php
/*
 *  This file is part of open3A.

 *  open3A is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  open3A is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 *  2007 - 2020, open3A GmbH - Support@open3A.de
 */
class exportPrueferGUI extends exportDefault implements iExport {
	protected $usedDate = "datum";
	protected $belege = array("R", "G");
	
	protected $headersBelege = array(
		"Belegtyp",
		"Belegnummer",
		"Belegdatum",
		"Lieferdatum",
		"Leistungsdatum",
		"Belegsumme netto",
		"Beleg USt Betrag",
		"Belegsumme brutto",
		"Rabatt Prozent",
		"Rabatt Betrag",
		"Zahlstatus",
		"Zahldatum",
		"Zahlbetrag",
		"Währung",
		"Kundennummer",
		"Kundenname",
		"Straße",
		"Ort",
		"Land",
		"USt-Id-Nr",
		"Steuerfrei"
	);
	
	protected $typesBelege = array(
		"AlphaNumeric",#Belegtyp",
		"AlphaNumeric",#"Belegnummer",
		"Date",#"Belegdatum",
		"Date",#"Lieferdatum",
		"Date",#"Leistungsdatum",
		"Numeric",#"Belegsumme netto",
		"Numeric",#"Beleg USt Betrag",
		"Numeric",#"Belegsumme brutto",
		"Numeric",#"Rabatt Prozent",
		"Numeric",#"Rabatt Betrag",
		"AlphaNumeric",#"Zahlstatus",
		"Date",#"Zahldatum",
		"Numeric",#"Zahlbetrag",
		"AlphaNumeric",#"Währung",
		"AlphaNumeric",#"Kundennummer",
		"AlphaNumeric",#"Kundenname",
		"AlphaNumeric",#"Straße",
		"AlphaNumeric",#"Ort",
		"AlphaNumeric",#"Land",
		"AlphaNumeric",#"USt-Id-Nr",
		"AlphaNumeric",#"Steuerfrei"
	);
	
	protected $headersPositionen = array(
		"Belegtyp",
		"Belegnummer",
		"Bezeichnung",
		"Artikelnummer",
		"Einheit",
		"Menge",
		"Rabatt Prozent",
		"Belegrabatt",
		"Preis netto",
		"Ust Betrag",
		"Ust Satz Prozent"
	);
	
	protected $typesPositionen = array(
		"AlphaNumeric",#"Belegtyp",
		"AlphaNumeric",#"Belegnummer",
		"AlphaNumeric",#"Bezeichnung",
		"AlphaNumeric",#"Artikelnummer",
		"AlphaNumeric",#"Einheit",
		"Numeric",#"Menge",
		"Numeric",#"Rabatt Prozent",
		"Numeric",#"Belegrabatt",
		"Numeric",#"Preis netto",
		"Numeric",#"Ust Betrag",
		"Numeric",#"Ust Satz Prozent"
	);
	protected $headersKassenbuch = array(
		"Belegtyp",
		"Belegnummer",
		"Belegdatum",
		"Beschreibung",
		"Einzahlung",
		"Entnahme",
		"Beleg USt Betrag",
		"Währung",
		"Änderungen"
	);
	
	protected $typesKassenbuch = array(
		"AlphaNumeric",#Belegtyp",
		"AlphaNumeric",#"Belegnummer",
		"Date",#"Belegdatum",
		"AlphaNumeric",#"Beschreibung",
		"Numeric",#"Einzahlung",
		"Numeric",#"Entnahme",
		"Numeric",#"Beleg USt Betrag",
		"AlphaNumeric",#"Währung",
		"AlphaNumeric",#"Änderungen"
	);
	
	public function isDisabled() {
		$pSpecData = mUserdata::getPluginSpecificData("Auftraege");
		if(isset($pSpecData["pluginSpecificCantCreateR"]))
			return true;
		
		return false;
	}
	
	public function getLabel(){
		return "Betriebsprüfung (GoBD)";
	}
	
	public function getApps(){
		return array("open3A", "openFiBu");
	}

	public static $alreadyExported = array();
	public static $className;
	
	
	public function getHTML($id, $page = 0){
		T::load(__DIR__, "Exps");
		
		self::$className = get_class($this);

		$ST = new HTMLSideTable("right");

		$B = $ST->addButton("Belege", "export");
		$B->windowRme(str_replace("GUI", "", get_class($this)), "-1", "getExportDataBelege", array("joinFormFields('exportForm')"));
		
		$B = $ST->addButton("Positionen", "export");
		$B->windowRme(str_replace("GUI", "", get_class($this)), "-1", "getExportDataPositionen", array("joinFormFields('exportForm')"));
		
		if(Session::isPluginLoaded("mKassenbuch")){
			$B = $ST->addButton("Kassenbuch", "export");
			$B->windowRme(str_replace("GUI", "", get_class($this)), "-1", "getExportDataKassenbuch", array("joinFormFields('exportForm')"));
		}
		
		$B = $ST->addButton("index.xml", "export");
		$B->windowRme(str_replace("GUI", "", get_class($this)), "-1", "getExportIndexXml", array("joinFormFields('exportForm')"));

		$B = $ST->addButton("Alles als\n.zip-Datei", "export");
		$B->windowRme(str_replace("GUI", "", get_class($this)), "-1", "getExportZip", array("joinFormFields('exportForm')"));

		
		
		#$B = $ST->addButton("Auswahl\ninvertieren", "bestaetigung");
		#$B->onclick("for(i = 0;i < $('exportForm').elements.length;i++) { $('exportForm').elements[i].checked = !$('exportForm').elements[i].checked; }");

		$TT = new HTMLTable(2, T::_("Bitte geben Sie einen Zeitraum ein:"));
		$TT->setColWidth(1, 120);
		
		$IS = new HTMLInput("ZeitraumStart", "date");#, "01.01.2015");
		$IS->hasFocusEvent(true);

		$IE = new HTMLInput("ZeitraumEnde", "date");#, "31.12.2015");
		$IE->hasFocusEvent(true);

		$TT->addLV(T::_("Von").":", $IS);
		$TT->addLV(T::_("Bis").":", $IE);

		return $ST."<form id=\"exportForm\">".$TT."</form>";
	}

	public function getExportZip($data){
		parse_str($data, $parsedData);
		$dates = date("Ymd", Util::CLDateParser($parsedData["ZeitraumStart"], "store"))."-".date("Ymd", Util::CLDateParser($parsedData["ZeitraumEnde"], "store"));
		$filename = Util::getTempFilename("GoBD_Export_".$dates, "zip");
		
		$zip = new ZipArchive();
		$res = $zip->open($filename, ZipArchive::CREATE);
		if(!$res)
			throw new Exception("Zippen fehlgeschlagen!");

		$zip->addFromString('index.xml', $this->getExportIndexXml($data, true, $dates));
		$zip->addFromString("Belege_".$dates.".csv", $this->getExportDataBelege($data, true));
		$zip->addFromString("Positionen_".$dates.".csv", $this->getExportDataPositionen($data, true));
		if(Session::isPluginLoaded("mKassenbuch"))
			$zip->addFromString("Kassenbuch_".$dates.".csv", $this->getExportDataKassenbuch($data, true));
		
		$zip->close();
		
		header("Content-Type: application/zip");
		header("Content-Disposition: attachment; filename=\"GoBD_Export_".$dates.".zip\"");
		readfile($filename);
		unlink($filename);
	}
	
	public function getExportIndexXml($data, $return = false, $dates = null){
		parse_str($data, $parsedData);
		
		
		$S = Stammdaten::getActiveStammdaten();
		
		$start = '<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE DataSet SYSTEM "gdpdu-01-08-2002.dtd">
<DataSet>
	<Version>1.0</Version>
	<DataSupplier>
		<Name>'.$S->A("firmaLang").'</Name>
		<Location>'.$S->A("ort").'/'. ISO3166::getCountryToCode($S->A("land")).'</Location>
		<Comment>Datentraegerüberlassung nach GoBD vom '.date("d.m.Y").'</Comment>
	</DataSupplier>
	<Media>
		<Name>Datenträger 1 von 1</Name>
	</Media>
</DataSet>';
		
		$xml = new SimpleXMLElement($start);
		
		
		$table = $xml->Media->addChild("Table");
		$table->addChild("URL", "Belege_".($dates ? $dates : Util::CLDateParser(time())).".csv");
		$table->addChild("Name", "Belege");
		$table->addChild("Description", "Die im Zeitraum erstellten Belege");
		$table->addChild("DecimalSymbol", ",");
		$table->addChild("DigitGroupingSymbol", ".");
		$table->addChild("Range")->addChild("From", "2");
		
		#$table->addChild("UTF8");
		#$validity = $table->addChild("Validity");
		#$range = $validity->addChild("Range");
		#$range->addChild("From", date("Ymd", Util::CLDateParser($parsedData["ZeitraumStart"], "store")));
		#$range->addChild("To", date("Ymd", Util::CLDateParser($parsedData["ZeitraumEnde"], "store")));
		#$validity->addChild("Format", "YYYYMMDD");
		
		$fields = $table->addChild("VariableLength");
		$fields->addChild("ColumnDelimiter", "	");
		foreach($this->headersBelege AS $k => $label)
			$this->newCol($fields, $label, $this->typesBelege[$k]);
				
		
		$table = $xml->Media->addChild("Table");
		$table->addChild("URL", "Positionen_".($dates ? $dates : Util::CLDateParser(time())).".csv");
		$table->addChild("Name", "Positionen");
		$table->addChild("Description", "Die im Zeitraum erstellten Positionen");
		$table->addChild("DecimalSymbol", ",");
		$table->addChild("DigitGroupingSymbol", ".");
		$table->addChild("Range")->addChild("From", "2");
		
		#$table->addChild("UTF8");
		#$validity = $table->addChild("Validity");
		#$range = $validity->addChild("Range");
		#$range->addChild("From", date("Ymd", Util::CLDateParser($parsedData["ZeitraumStart"], "store")));
		#$range->addChild("To", date("Ymd", Util::CLDateParser($parsedData["ZeitraumEnde"], "store")));
		#$validity->addChild("Format", "YYYYMMDD");
		
		$fields = $table->addChild("VariableLength");
		$fields->addChild("ColumnDelimiter", "	");
		foreach($this->headersPositionen AS $k => $label)
			$this->newCol($fields, $label, $this->typesPositionen[$k]);
		
		$fk = $fields->addChild("ForeignKey");
		$fk->addChild("Name", "Belegnummer");
		$fk->addChild("References", "Belege");
		
		$table = $xml->Media->addChild("Table");
		$table->addChild("URL", "Kassenbuch_".($dates ? $dates : Util::CLDateParser(time())).".csv");
		$table->addChild("Name", "Belege");
		$table->addChild("Description", "Die im Zeitraum erfassten Kassenumsätze");
		$table->addChild("DecimalSymbol", ",");
		$table->addChild("DigitGroupingSymbol", ".");
		$table->addChild("Range")->addChild("From", "2");
		
		$fields = $table->addChild("VariableLength");
		$fields->addChild("ColumnDelimiter", "	");
		foreach($this->headersKassenbuch AS $k => $label)
			$this->newCol($fields, $label, $this->typesKassenbuch[$k]);
		
		/*
		
		$dom = new DOMDocument;
		$dom->preserveWhiteSpace = FALSE;
		$dom->loadXML($xml->asXML());
		$dom->formatOutput = TRUE;
		echo $dom->saveXml();
		*/
		#die();
		
		$systemId = 'data://text/plain;base64,'.base64_encode(file_get_contents(__DIR__."/gdpdu-01-08-2002.dtd"));

		$old = new DOMDocument;
		$old->loadXML($xml->asXML());

		$creator = new DOMImplementation;
		$doctype = $creator->createDocumentType('DataSet', null, $systemId);
		$new = $creator->createDocument(null, null, $doctype);
		$new->encoding = "utf-8";

		$oldNode = $old->getElementsByTagName('DataSet')->item(0);
		$newNode = $new->importNode($oldNode, true);
		$new->appendChild($newNode);
		
		if (!$new->validate())
			throw new Exception("XML-Erzeugung fehlgeschlagen!");
		
		$dom = new DOMDocument;
		$dom->preserveWhiteSpace = false;
		$dom->loadXML($new->saveXML());
		$dom->formatOutput = true;
		
		if($return)
			return $dom->saveXML();
		
		header ("Content-Type:text/xml");
		header("Content-Disposition: attachment; filename=\"index.xml\"");
		echo $dom->saveXml();
	}

	private function newCol($xml, $label, $type){
		
		$vc = $xml->addChild("VariableColumn");
		$vc->addChild("Name", $label);
		$t = $vc->addChild($type);
		if($type == "Date")
			$t->addChild("Format", "DD.MM.YYYY");
		
	}
	
	public function factory(){
		return null;
	}
	
	public function getExportDataBelege($data, $return = false){
		parse_str($data, $parsedData);
		unset($parsedData["targetPage"]);

		if($parsedData["ZeitraumStart"] == "")
			unset($parsedData["ZeitraumStart"]);
		else
			$parsedData["ZeitraumStart"] = Util::CLDateParser($parsedData["ZeitraumStart"], "store");

		if($parsedData["ZeitraumEnde"] == "")
			unset($parsedData["ZeitraumEnde"]);
		else
			$parsedData["ZeitraumEnde"] = Util::CLDateParser($parsedData["ZeitraumEnde"], "store");

		$AC = $this->getExportCollection($parsedData);

		if(isset($parsedData["ZeitraumEnde"]) AND !isset($parsedData["ZeitraumStart"]))
			die(Util::getBasicHTMLError("Bitte geben Sie ein Startdatum ein.", "Export-Fehler"));

		if($AC == null) 
			die(Util::getBasicHTMLError("Bitte wählen Sie Elemente zum Exportieren aus.", "Export-Fehler"));

		$Ex = new CSVExport(count($this->headersBelege));
		$Ex->enclosedBy("");
		$Ex->separator("\t");
		$Ex->addHeaderRow($this->headersBelege);

		#$Kappendixes = array();
		
		while($C = $AC->n(true)){
			$Kundennummer = $C->A("kundennummer");
			if($Kundennummer == "-2") 
				$Kundennummer = "";
			
			$sums = $C->getSumOfPosten(true, false);

			if($C->A("isPayed") == "0")
				$C->changeA("GRLBMpayedDate", "0");
		
			#foreach($sums[5] AS $mwst => $sum) {
			$type = "Rechnung";
			if($C->A("isG"))
				$type = "Gutschrift";

			$data = array(
				$type,
				$C->A("prefix").$C->A("nummer"),
				Util::CLDateParser($C->A("datum")),
				Util::CLDateParser($C->A("lieferDatum")),
				" ",
				Util::CLNumberParserZ($C->A("nettobetrag") * ($C->A("isG") ? -1 : 1)),
				Util::CLNumberParserZ($C->A("steuern") * ($C->A("isG") ? -1 : 1)),
				Util::CLNumberParserZ($C->A("bruttobetrag") * ($C->A("isG") ? -1 : 1)),
				Util::CLNumberParserZ($C->A("rabatt")),
				$C->A("rabatt") > 0 ? Util::CLNumberParserZ(($C->A("nettobetrag") / (100 - $C->A("rabatt"))) * 100 - $C->A("nettobetrag")) : Util::CLNumberParserZ(0),
				$C->A("isPayed") ? "bezahlt" : "unbezahlt",
				Util::CLDateParserE($C->A("GRLBMpayedDate")),
				Util::CLNumberParserZ($C->A("isPayed") ? $C->A("bruttobetrag") * ((100 - $C->A("payedWithSkonto")) / 100) : 0),
				"EUR",
				$Kundennummer,
				$C->A("firma") != "" ? $C->A("firma") : $C->A("vorname")." ".$C->A("nachname"),
				$C->A("strasse")." ".$C->A("nr"),
				$C->A("plz")." ".$C->A("ort"),
				$C->A("land"),
				$C->A("UStIdNr"),
				(count($sums[5]) == 1 AND isset($sums[5]["0.00"])) ? "ja" : "nein"
			);

			$Ex->addRow($data);
			#}
		}
		
		if($return)
			return $Ex->getExport ();
		
		
		$Ex->getExport("Belege_".Util::CLDateParser(time()).".csv");
	}
	public function getExportDataKassenbuch($data, $return = false){
		parse_str($data, $parsedData);
		unset($parsedData["targetPage"]);

		if($parsedData["ZeitraumStart"] == "")
			unset($parsedData["ZeitraumStart"]);
		else
			$parsedData["ZeitraumStart"] = Util::CLDateParser($parsedData["ZeitraumStart"], "store");

		if($parsedData["ZeitraumEnde"] == "")
			unset($parsedData["ZeitraumEnde"]);
		else
			$parsedData["ZeitraumEnde"] = Util::CLDateParser($parsedData["ZeitraumEnde"], "store");

		if(isset($parsedData["ZeitraumEnde"]) AND !isset($parsedData["ZeitraumStart"]))
			die(Util::getBasicHTMLError("Bitte geben Sie ein Startdatum ein.", "Export-Fehler"));

		
		
		#$AC = $this->getExportCollection($parsedData);
		$AC = anyC::get("Kassenbuch");
		$AC->addAssocV3("KassenbuchDatum", ">=", $parsedData["ZeitraumStart"]);
		$AC->addAssocV3("KassenbuchDatum", "<=", $parsedData["ZeitraumEnde"]);
		
		if($AC == null) 
			die(Util::getBasicHTMLError("Bitte wählen Sie Elemente zum Exportieren aus.", "Export-Fehler"));

		$Ex = new CSVExport(count($this->headersKassenbuch));
		$Ex->enclosedBy("");
		$Ex->separator("\t");
		$Ex->addHeaderRow($this->headersKassenbuch);

		while($C = $AC->n(true)){
			
			/*
			"Belegnummer",
			"Belegdatum",
			"Beschreibung",
			"Einzahlung",
			"Entnahme",
			"Beleg USt Betrag",
			"Währung"
			*/
			
			$ex = explode("\n", trim($C->A("KassenbuchChanges")));
		
			$data = array(
				Kassenbuch::$typen[$C->A("KassenbuchTyp")],
				$C->A("KassenbuchBelegnummer"),
				Util::CLDateParser($C->A("KassenbuchDatum")),
				$C->A("KassenbuchBuchungstext"),
				Util::CLNumberParserZ($C->A("KassenbuchEinnahme")),
				Util::CLNumberParserZ($C->A("KassenbuchAusgabe")),
				Util::CLNumberParserZ($C->A("KassenbuchSteuern")),
				"EUR",
				(count($ex) > 1 ? "ja" : "nein")
			);

			$Ex->addRow($data);
			#}
		}
		
		if($return)
			return $Ex->getExport ();
		
		
		$Ex->getExport("Kassenbuch_".Util::CLDateParser(time()).".csv");
	}
	
	public function getExportDataPositionen($data, $return = false){
		parse_str($data, $parsedData);
		unset($parsedData["targetPage"]);

		if($parsedData["ZeitraumStart"] == "")
			unset($parsedData["ZeitraumStart"]);
		else
			$parsedData["ZeitraumStart"] = Util::CLDateParser($parsedData["ZeitraumStart"], "store");

		if($parsedData["ZeitraumEnde"] == "")
			unset($parsedData["ZeitraumEnde"]);
		else
			$parsedData["ZeitraumEnde"] = Util::CLDateParser($parsedData["ZeitraumEnde"], "store");

		$AC = $this->getExportCollectionPositionen($parsedData);

		if(isset($parsedData["ZeitraumEnde"]) AND !isset($parsedData["ZeitraumStart"]))
			 die(Util::getBasicHTMLError("Bitte geben Sie ein Startdatum ein.", "Export-Fehler"));

		if($AC == null) die(Util::getBasicHTMLError("Bitte wählen Sie Elemente zum Exportieren aus.", "Export-Fehler"));

		$Ex = new CSVExport(count($this->headersPositionen));
		$Ex->enclosedBy("");
		$Ex->separator("\t");
		$Ex->addHeaderRow($this->headersPositionen);

		#$Kappendixes = array();
		
		while($C = $AC->n(true)){
			$Kundennummer = $C->A("kundennummer");
			if($Kundennummer == "-2") $Kundennummer = "";
			
			#$sums = $C->getSumOfPosten(true, false);

			if($C->A("isPayed") == "0")
				$C->changeA("GRLBMpayedDate", "0");
		
			
			$type = "Rechnung";
			if($C->A("isG"))
				$type = "Gutschrift";
			
			$data = array(
				$type,
				$C->A("prefix").$C->A("nummer"),
				$C->A("name"),
				$C->A("artikelnummer"),
				$C->A("gebinde"),
				Util::CLNumberParserZ($C->A("menge")),
				Util::CLNumberParserZ($C->A("rabattPosition")),
				Util::CLNumberParserZ($C->A("rabattBeleg")),
				Util::CLNumberParserZ($C->A("preis")),
				Util::CLNumberParserZ($C->A("preis") * ($C->A("mwst") / 100)),
				Util::CLNumberParserZ($C->A("mwst"))
			);

			$Ex->addRow($data);
		}
		
		if($return)
			return $Ex->getExport();
		
		$Ex->getExport("Positionen_".Util::CLDateParser(time()).".csv");
	}

	public function getExportCollection($data = null){
		$AC = anyC::get("GRLBM");
		$AC->addJoinV3("Auftrag", "AuftragID", "=", "AuftragID");
		$AC->addJoinV3("Adresse", "t2.AdresseID", "=", "AdresseID");
		$c = 0;
		if($this->usedDate == "GRLBMpayedDate")
			$AC->addAssocV3("isPayed", "=", "1");
		
		if(!isset($data["ZeitraumStart"])){
			foreach($data AS $k => $v){
				if($v == "0") continue;

				$k = str_replace("exportBeleg", "", $k);
				$AC->addAssocV3("GRLBMID", "=", $k, $c == 0 ? "AND" : "OR", "2");

				$c++;
			}
		} else {
			
			foreach($this->belege AS $k => $b){
				if($b == "R" OR $b == "G")
					$AC->addAssocV3("is$b", "=", "1", $k == 0 ? "AND" : "OR", "1");
				else
					$AC->addAssocV3("isWhat", "=", $b, $k == 0 ? "AND" : "OR", "1");
			}

			$AC->addAssocV3($this->usedDate, ">=", $data["ZeitraumStart"], "AND", "2");

			if(isset($data["ZeitraumEnde"]))
				$AC->addAssocV3($this->usedDate, "<=", $data["ZeitraumEnde"], "AND", "2");

			$c++;
		}

		if($c == 0) return null;
		return $AC;
	}
	
	public function getExportCollectionPositionen($data = null){
		$AC = anyC::get("GRLBM");
		$AC->addJoinV3("Posten", "GRLBMID", "=", "GRLBMID");
		$AC->addJoinV3("Auftrag", "AuftragID", "=", "AuftragID");
		$AC->addJoinV3("Adresse", "t3.AdresseID", "=", "AdresseID");
		$AC->setFieldsV3(array(
			"prefix",
			"nummer",
			"name",
			"gebinde",
			"bruttopreis",
			"artikelnummer",
			"menge",
			"t2.rabatt AS rabattPosition",
			"t1.rabatt AS rabattBeleg",
			"preis",
			"mwst"
		));
		$c = 0;
		if($this->usedDate == "GRLBMpayedDate")
			$AC->addAssocV3("isPayed", "=", "1");
		
		if(!isset($data["ZeitraumStart"])){
			foreach($data AS $k => $v){
				if($v == "0") continue;

				$k = str_replace("exportBeleg", "", $k);
				$AC->addAssocV3("GRLBMID", "=", $k, $c == 0 ? "AND" : "OR", "2");

				$c++;
			}
		} else {
			
			foreach($this->belege AS $k => $b){
				if($b == "R" OR $b == "G")
					$AC->addAssocV3("is$b", "=", "1", $k == 0 ? "AND" : "OR", "1");
				else
					$AC->addAssocV3("isWhat", "=", $b, $k == 0 ? "AND" : "OR", "1");
			}

			$AC->addAssocV3($this->usedDate, ">", $data["ZeitraumStart"], "AND", "2");

			if(isset($data["ZeitraumEnde"]))
				$AC->addAssocV3($this->usedDate, "<=", $data["ZeitraumEnde"], "AND", "2");

			$c++;
		}

		if($c == 0) return null;
		return $AC;
	}

	protected function entryParser(PersistentObject $entry){
		
	}

}
?>