<?php
/*
 *  This file is part of open3A.

 *  open3A is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  open3A is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 *  2007 - 2020, open3A GmbH - Support@open3A.de
 */
class exportEingangsbelegeGUI extends exportDefault implements iExport {
	protected $usedDate = "EingangsbelegDatum";
	#protected $belege = array("R", "G");
	protected $numberDisplayed = 20;
	protected static $UserID = 0;
	
	protected $headers = array(
			"Firma",
			"Belegnummer",
			"Belegdatum",
			"Mehrwertsteuersatz",
			"Bruttobetrag",
			"Zahlungsdatum",
			"Bemerkung"
		);
	
	public function getLabel(){
		if(!Session::isPluginLoaded("mEingangsbeleg"))
			return null;
		
		return "Eingangsbelege nach Belegdatum";
	}
	
	public function getApps(){
		return array("open3A", "openFiBu");
	}

	public static $alreadyExported = array();
	public static $className;
	
	/*protected function getExportPreviewCollection(){
		$AC = anyC::get("GRLBM");
		foreach($this->belege AS $k => $b){
			if($b == "R" OR $b == "G")
				$AC->addAssocV3("is$b", "=", "1", $k == 0 ? "AND" : "OR");
			else
				$AC->addAssocV3("isWhat", "=", $b, $k == 0 ? "AND" : "OR");
		}
		
		if($this->usedDate == "datum")
			$AC->addOrderV3("datum", "DESC");
		else {
			$AC->addAssocV3("isPayed", "=", "1", "AND", "2");
			$AC->addOrderV3("GRLBMpayedDate", "DESC");
		}

		return $AC;
	}*/
	
	protected function formFields(){
		return array("ZeitraumStart", "ZeitraumEnde");
	}
	
	protected function getForm() {
		$TT = new HTMLForm("exportBelegeForm", $this->formFields(), "Einstellungen");
		$TT->hasFormTag(false);
		$TT->getTable()->setColWidth(1, 120);
		
		$TT->setType("ZeitraumStart", "date");
		$TT->setType("ZeitraumEnde", "date");
		
		$TT->setLabel("ZeitraumStart", "Von");
		$TT->setLabel("ZeitraumEnde", "Bis");
		
		return $TT;
	}
	
	public function getHTML($id, $page = 0){
		T::load(__DIR__, "Exps");
		self::$className = get_class($this);
		
		$ST = new HTMLSideTable("right");

		$B = $ST->addButton("jetzt\nexportieren", "export");
		$B->windowRme(str_replace("GUI", "", get_class($this)), "-1", "getExportData", array("joinFormFields('exportBelegeForm')"));

		$this->callbackSidetable($ST);
		
		$TT = $this->getForm();

		return $ST."<form id=\"exportBelegeForm\">".$TT;#."<div style=\"margin-top:30px;\">".$gui->getBrowserHTML($id)."</div></form>";
	}

	protected function callbackSidetable(HTMLSideTable $ST){
		
	}
	
	public static function nummerParser($w, $E){
		return $E->A("prefix").$w;
	}

	public static function wertParser($w, $E){
		if(!isset(self::$alreadyExported[$E->getID()]))
			self::$alreadyExported[$E->getID()] = self::$UserID == -1 ? mUserdata::getGlobalSettingValue(self::$className.$E->getID(), "") : mUserdata::getUDValueS(self::$className.$E->getID(), "");
		
		$wert = self::$alreadyExported[$E->getID()];
		
		return $wert != "" ? Util::CLDateParser($wert) : "";
	}

	public static function dateParser($w, $E){
		return $w != "" ? Util::CLDateParser($w) : "";
	}

	public static function IDParser($w, $E){
		if(!isset(self::$alreadyExported[$E->getID()]))
			self::$alreadyExported[$E->getID()] = self::$UserID == -1 ? mUserdata::getGlobalSettingValue(self::$className.$E->getID(), "") : mUserdata::getUDValueS(self::$className.$E->getID(), "");
		
		$wert = self::$alreadyExported[$E->getID()];
		
		$I = new HTMLInput("exportBeleg$w", "checkbox", $wert != "" ? "0" : "1");
		$I->setClass("usable");
		return $I;
	}

	public function factory(){
		return new CSVExport(count($this->headers));
	}
	
	public function getExportData($data, $start = null, $count = null, $CK1 = null){
		set_time_limit(360);
		parse_str($data, $parsedData);
		#print_r($parsedData);
		#die();
		unset($parsedData["targetPage"]);

		if($parsedData["ZeitraumStart"] == "")
			unset($parsedData["ZeitraumStart"]);
		else
			$parsedData["ZeitraumStart"] = Util::CLDateParser($parsedData["ZeitraumStart"], "store");

		if($parsedData["ZeitraumEnde"] == "")
			unset($parsedData["ZeitraumEnde"]);
		else
			$parsedData["ZeitraumEnde"] = Util::CLDateParser($parsedData["ZeitraumEnde"], "store");

		$AC = $this->getExportCollection($parsedData);

		if(isset($parsedData["ZeitraumEnde"]) AND !isset($parsedData["ZeitraumStart"]))
			 die(Util::getBasicHTMLError("Bitte geben Sie ein Startdatum ein.", "Export-Fehler"));

		if($AC == null)
			die(Util::getBasicHTMLError("Bitte wählen Sie Elemente zum Exportieren aus.", "Export-Fehler"));

		$Ex = $this->factory();

		if($this->headers != null)
			$Ex->addHeaderRow($this->headers);

		/*
		"Firma",
		"Belegnummer",
		"Belegdatum",
		"Mehrwertsteuersatz",
		"Bruttobetrag",
		"Bemerkung",
		"Zahlungsdatum"
		*/
		
		while($C = $AC->n()){
			$data = array(
				$C->A("EingangsbelegLieferantID") == 0 ? $C->A("EingangsbelegLieferantName") : $C->A("LieferantFirma"),
				$C->A("EingangsbelegNummer"),
				Util::CLDateParser($C->A("EingangsbelegDatum")),
				Util::CLNumberParserZ($C->A("EingangsbelegBetragMwSt")),
				Util::CLNumberParserZ($C->A("EingangsbelegBetragBrutto")),
				Util::CLDateParserE($C->A("EingangsbelegBezahltAm")),
				$C->A("EingangsbelegBemerkung")
				
			);
			
			$Ex->addRow($data);
		}
		
		$Ex->getExport("Eingangsbelege_".Util::CLDateParser(time()).".csv");
	}
	

	public function getExportCollection($data = null){
		$AC = anyC::get("Eingangsbeleg");
		$AC->addJoinV3("Lieferant", "EingangsbelegLieferantID", "=", "LieferantID");
		#$AC->addJoinV3("Auftrag", "AuftragID", "=", "AuftragID");
		#$AC->addJoinV3("Adresse", "t2.AdresseID", "=", "AdresseID");
		
		#if($this->usedDate == "GRLBMpayedDate")
		#	$AC->addAssocV3("isPayed", "=", "1");
		
		$c = 0;
		$AC->addAssocV3($this->usedDate, ">=", $data["ZeitraumStart"], "AND", "2");

		if(isset($data["ZeitraumEnde"]))
			$AC->addAssocV3($this->usedDate, "<=", $data["ZeitraumEnde"], "AND", "2");

		$c++;
		

		if($c == 0) 
			return null;
		
		return $AC;
	}

	protected function entryParser(PersistentObject $entry){
		
	}
}
?>