<?php
/*
 *  This file is part of open3A.

 *  open3A is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  open3A is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 *  2007 - 2020, open3A GmbH - Support@open3A.de
 */
class exportAnsprechpartnerGUI extends exportDefault implements iExport, iGUIHTML2 {

	private $Kategorien = array();

	public function getLabel(){
		if(!Session::isPluginLoaded("mAnsprechpartner"))
			return null;
		
		return "Ansprechpartner";
	}
	
	public function getApps(){
		return array("open3A", "lightCRM");
	}

	public function getHTML($id){
		$p = parent::getHTML($id);
		
		$text = "";
		$fields = array();
		$AC = anyC::get("Adresse", "AuftragID", "-1");
		$num = $AC->getTotalNum();
		if($num > 2000){
			$fields[] = "anzahl";
			$fields[] = "start";
			
			$text = "<p>Ihre Datenbank enthält $num Datensätze. Bitte geben Sie den Startdatensatz sowie eine Anzahl ein, um eine Auswahl zu exportieren.</p>";
		}
		
		if(Session::isPluginLoaded("mAdressBuch"))
			$fields[] = "CK1";
		
		$T = new HTMLForm("exportSubset", $fields, "Auswahl");
		$T->getTable()->setColWidth(1, 120);
		
		if(Session::isPluginLoaded("mAdressBuch")){
			$T->setLabel("CK1", "Adressbuch");
			$T->setType("CK1", "select", null, mAdressBuchGUI::getABs(true));
		}
		
		$T->setDescriptionField("start", "Zum Beispiel bei Anzahl 1000: 1, 1001, 2001, 3001, ...");
		
		return $text.$p.$T;
	}

	public function getExportCollection($start = null, $count = null, $Adressbuch = 0){
		$ac = new anyC();
		$ac->setCollectionOf("Kategorie");
		$ac->addAssocV3("type", "=", "1");

		while($a = $ac->getNextEntry())
			$this->Kategorien[$a->getID()] = $a->A("name");


		$ac = new anyC();
		$ac->setCollectionOf("Adresse");
		$ac->addJoinV3("Kappendix", "AdresseID", "=", "AdresseID");
		$ac->addJoinV3("Ansprechpartner", "AdresseID", "=", "AnsprechpartnerOwnerClassID");
		$ac->addJoinV3("Ansprechpartner", "AnsprechpartnerOwnerClass", "=", "Adresse");
		$ac->addAssocV3("AuftragID", "=", "-1");
		if(Session::isPluginLoaded("mAdressBuch") AND $Adressbuch)
			$ac->addAssocV3("type", "=", $Adressbuch);
		
		$ac->setFieldsV3(array(
			"kundennummer AS Kundennummer",
			"firma AS Firma",
			"IF(AnsprechpartnerID IS NULL, anrede, AnsprechpartnerAnrede) AS Anrede",
			"IF(AnsprechpartnerID IS NULL, nachname, AnsprechpartnerNachname) AS Nachname",
			"IF(AnsprechpartnerID IS NULL, vorname, AnsprechpartnerVorname) AS Vorname",
			"AnsprechpartnerPosition AS Position",
			"strasse AS Strasse",
			"nr AS Hausnummer",
			"plz AS PLZ",
			"ort AS Ort",
			"land AS Land",
			"IF(AnsprechpartnerID IS NULL, tel, AnsprechpartnerTel) AS Telefon",
			"IF(AnsprechpartnerID IS NULL, email, AnsprechpartnerEmail) AS EMail",
			"homepage AS Homepage",
			"IF(AnsprechpartnerID IS NULL, mobil, AnsprechpartnerMobil) AS Mobil",
			"KategorieID AS Kategorie",
			"IF(AnsprechpartnerID IS NULL, anrede, AnsprechpartnerAnrede) AS Anrede2",
			"IF(AnsprechpartnerID IS NULL, anrede, AnsprechpartnerAnrede) AS anrede",
			"IF(AnsprechpartnerID IS NULL, nachname, AnsprechpartnerNachname) AS nachname",
			"IF(AnsprechpartnerID IS NULL, vorname, AnsprechpartnerVorname) AS vorname"));

		if($start AND $count)
			$ac->setLimitV3 ("$start, $count");
		
		return $ac;
	}

	protected function entryParser(PersistentObject $entry){

		$entry->changeA("Anrede", Util::formatAnrede("de_DE", $entry, true));
		$entry->changeA("Anrede2", Util::formatAnrede("de_DE", $entry, false));

		if(isset($this->Kategorien[$entry->A("Kategorie")]))
			$entry->changeA("Kategorie", $this->Kategorien[$entry->A("Kategorie")]);
		else $entry->changeA("Kategorie", "");

		$A = $entry->getA();
		unset($A->AdresseID);
		unset($A->anrede);
		unset($A->nachname);
		unset($A->vorname);
	}
}
?>
