<?php
/**
 *  This file is part of open3A.

 *  open3A is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  open3A is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses></http:>.
 * 
 *  2007 - 2020, open3A GmbH - Support@open3A.de
 */

class mBriefGUI extends UnpersistentClass implements iGUIHTML2 {
	
	public function getHTML($id) {
		$B = new Button("Übersetzungen", "new");
		$B->windowRme("mBrief", "-1", "translations");
		return $B;
	}

	public function translations(){
		header("Content-Type: text/plain;  charset=UTF-8");
		header("Content-Disposition: attachment; filename=\"translations.csv\"");
		
		#echo "<pre>";
		$B = new PDFBrief(Stammdaten::getActiveStammdaten());
		foreach($B AS $k => $v){
			if(strpos($k, "label") !== 0)
				continue;
			
			if(trim($v) == "")
				continue;
			
			echo "\"".$k."\",\"$v\"";
			echo ",\"".$B->translation["es_ES"][$k]."\"";
			#echo ",\"".$B->translation["en_GB"][$k]."\"";
			echo ",\"".$B->translation["zh_CN"][$k]."\"";
			
			echo "\n";
		}
		#echo "</pre>";
	}
}
?>