<?php
/*
 *  This file is part of open3A.

 *  open3A is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  open3A is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 *  2007 - 2020, open3A GmbH - Support@open3A.de
 */
class GRLBMGUI extends GRLBM implements iGUIHTML2, icontextMenu {
	
	private $kdNummer = "";
	private $ustidnr = "";
	#public $additionalKalkFields = "";
	#public $additionalNonKalkFields = "";
	public $showPrintAB = false;
	public $useDefaultTransport = false;

	function __construct($id){
		if($id == -2)
			$id = $_SESSION["BPS"]->getProperty("GRLBMGUI","myID");

		parent::__construct($id);
		
		$this->setParser("versandkosten", "Util::CLNumberParserZ");
		$this->setParser("versandkostenMwSt", "Util::CLNumberParserZ");
		$this->setParser("GRLBMWaehrungFaktor", "Util::CLNumberParserZ");
	}
	
	public function markMeAsUnprinted(){
		parent::markMeAsUnprinted();
	}
	
	public function setLetterType($type){
		$this->letterType = $type;
	}
	
	public function setIsCopy($copy){
		$this->isCopy = $copy;
	}
	
	public function setKundennummer($kdnr){
		$this->kdNummer = $kdnr;
	}
	
	public function setKundenUStIdNr($ustidnr){
		$this->ustidnr = $ustidnr;
	}
	
	function getHTML($id){
		
		Timer::now("init", __FILE__, __LINE__);
		T::load(__DIR__, "Auftraege");
		
		if($id == -2)
			$id = $_SESSION["BPS"]->getProperty("GRLBMGUI","myID");
			
		#------------------------ einige Einstellungen für die multiPrint-Liste
		$_SESSION["BPS"]->setActualClass("multiPrintBasketGUI");
		$basketBPS = $_SESSION["BPS"]->getAllProperties();
		
		if($basketBPS == -1 OR !isset($basketBPS["ids"])) {
			if($basketBPS == -1) $basketBPS = array();
			$basketBPS["ids"] = "";
		}
		if($basketBPS["ids"] == ",,") $basketBPS["ids"] = "";
		#------------------------ 

		$this->loadMeOrEmpty();

		$gui = new HTMLGUI2();
		$gui->setObject($this);
		$gui->setFormID("GRLBMForm");
		
		/**
		 * DEPRECATED BUT REQUIRED FOR THIS CLASS
		 */
		BPS::setProperty("GRLBMGUI", "myID", $id);
		/**
		 * NEW
		 */
		BPS::setProperty("Brief", "GRLBMID", $id);
		
		$type = $this->getMyPrefix();

		$Auftrag = new Auftrag($this->A("AuftragID"));
		
		#-------- Posten -----------------------------------------
			$postenRechnung = new mPostenGUI();
			$_SESSION["BPS"]->registerClass("mPostenGUI");
			$_SESSION["BPS"]->setACProperty("loadGRLBMID",$this->ID);
			$_SESSION["BPS"]->setACProperty("GRLBMType", $this->getMyPrefix());
			$_SESSION["BPS"]->setACProperty("AuftragID",$this->A->AuftragID);
			$_SESSION["BPS"]->registerClass("PostenGUI");
			$_SESSION["BPS"]->setACProperty("GRLBMType",$this->getMyPrefix());
			#$postenRechnung->setAssociation("GRLBMID",$this->ID);
		#/------- Posten -----------------------------------------
		
			
		// If Plugin Provisionen exists, set some values for it
		if(Session::isPluginLoaded("Provisionen")){
			#$_SESSION["BPS"]->registerClass("ProvisionSwitchGUI");
			#$_SESSION["BPS"]->setACProperty("useGRLBMID",$this->ID);
			#$_SESSION["BPS"]->setACProperty("useAuftragID",$this->A->AuftragID);
			BPS::setProperty("ProvisionSwitchGUI", "useGRLBMID", $this->ID);
			BPS::setProperty("ProvisionSwitchGUI", "useAuftragID", $this->A("AuftragID"));
		}



		$BAB = "";
		$BNO = "";
		if($type == "A" AND $this->A("printAB") == "0" AND !Auftrag::getBelegArten("B")){
			$BAB = new Button("Bestätigung\nerstellen", "bestaetigung");
			$BAB->style("float:right;margin-right:10px;");
			$BAB->id("createABButton");
			$BAB->className("backgroundColor2");
			$BAB->onclick("if(confirm('".T::_("Auftragsbestätigung jetzt erstellen?")."')) ");
			$BAB->rmePCR("GRLBM", $this->ID, "makeAB", "", "contentManager.loadFrame('subframe','GRLBM', $this->ID);");
		}
		if($type == "A" AND $this->A("printAB") == "0"){
			$BNO = new Button("Angebot abgelehnt", "x", "iconicL");
			$BNO->style("float:right;margin-right:5px;margin-top:5px;");
			$BNO->rmePCR("Auftrag", $this->A("AuftragID"), "updateStatus", array("'declined'"), "function(){ showMessage('Angebot als abgeleht markiert'); contentManager.reloadFrame('contentRight'); Auftrag.reloadBeleg('$id'); }");
		}
		
		
		if($type == "B" AND ($this->A("GRLBMOrderGRLBMIDs") == "" OR $this->A("GRLBMOrderGRLBMIDs") == "note") AND Session::isPluginLoaded("mLBestellung")){
			$BAB = new Button("Zur Bestellung\nvormerken", "bestellung");
			$BAB->style("float:right;margin-right:10px;");
			$BAB->className("backgroundColor2");
			$BAB->rmePCR("GRLBM", $this->ID, "orderNote", "", "contentManager.loadFrame('subframe','GRLBM', $this->ID);");
			if($this->A("GRLBMOrderGRLBMIDs") == "note")
				$BAB->className("highlight");
		}
		
		if($type == "B" AND $this->A("GRLBMOrderGRLBMIDs") != "" AND $this->A("GRLBMOrderGRLBMIDs") != "note" AND Session::isPluginLoaded("mLBestellung")){
			$ids = explode(",", trim($this->A("GRLBMOrderGRLBMIDs"), ","));
			$belege = "";
			foreach ($ids AS $v){
				$G = new GRLBM($v, false);
				$belege .= ($belege == "" ? "" : ", ").$G->A("prefix").$G->A("nummer");
			}
			$BAB = "<div style=\"width:140px;float:right;margin-right:10px;height:30px;padding:5px;\" class=\"confirm\">Bestellt: $belege</div>";
		}
		
		$BAP = "";
		if($type == "B" AND ($this->A("GRLBMProductionLaufzettel") == "" OR $this->A("GRLBMProductionLaufzettel") == "note") AND Session::isPluginLoaded("mLaufzettel")){
			$BAP = new Button("Zur Produktion\nvormerken", "./upFab/Laufzettel/Laufzettel.png");
			$BAP->style("float:right;margin-right:10px;");
			$BAP->className("backgroundColor2");
			$BAP->rmePCR("GRLBM", $this->ID, "productionNote", "", "contentManager.loadFrame('subframe','GRLBM', $this->ID);");
			if($this->A("GRLBMProductionLaufzettel") == "note")
				$BAP->className("highlight");
		}
		
		/*if($type == "L" AND ($this->A("GRLBMDeliveryStatus") == "" OR $this->A("GRLBMDeliveryStatus") == "booked") AND Session::isPluginLoaded("mLagerbestandWare")){
			$BAB = new Button("Ware\nausbuchen", "navigation");
			$BAB->style("float:right;margin-right:10px;");
			$BAB->className("backgroundColor2");
			$BAB->rmePCR("GRLBM", $this->ID, "deliveryNote", "", "contentManager.loadFrame('subframe','GRLBM', $this->ID);");
			if($this->A("GRLBMDeliveryStatus") == "booked")
				$BAB->className("confirm");
		}
		
		/*
		if($type == "L" AND ($this->A("GRLBMDeliveryStatus") == "" OR $this->A("GRLBMDeliveryStatus") == "note") AND Session::isPluginLoaded("mLBestellung")){
			$BAB = new Button("Zur Lieferung\nvormerken", "navigation");
			$BAB->style("float:right;margin-right:10px;");
			$BAB->className("backgroundColor2");
			$BAB->rmePCR("GRLBM", $this->ID, "deliveryNote", "", "contentManager.loadFrame('subframe','GRLBM', $this->ID);");
			if($this->A("GRLBMDeliveryStatus") == "note")
				$BAB->className("highlight");
		}
		
		if($type == "L" AND $this->A("GRLBMDeliveryStatus") != "" AND $this->A("GRLBMDeliveryStatus") != "note" AND Session::isPluginLoaded("mLBestellung")){
			$BAB = "<div style=\"width:140px;float:right;margin-right:10px;height:30px;padding:5px;\" class=\"confirm\">Geliefert: ".$this->A("GRLBMDeliveryStatus")."</div>";
		}*/

		
		$pSpecData = mUserdata::getPluginSpecificData("Provisionen");

		$newType = $type;
		if($type == "B" AND !Auftrag::getBelegArten("B"))
			$newType = "A";
		
		$weiteres = "Zusätzliche";
		$genus = Stammdaten::getGenusType($newType);
		if($genus == "n")
			$weiteres = "Zusätzliches";
		if($genus == "m")
			$weiteres = "Zusätzlicher";
		
		$B = new Button($weiteres."\n".Stammdaten::getLongType($newType)."", "new");
		$B->onclick("$('".$newType."Button').name = '1'; Auftrag.createGRLBM('{$this->A->AuftragID}','Auftrag','$newType');");
		$B->className("backgroundColor0");
		$B->id("createNew{$newType}Button");
		$B->style("margin-left:0px;");
		
		Aspect::joinPoint("addBelegButton", $this, __METHOD__, array($B));
		
		$BP = "";
		if($type == "R" AND Session::isPluginLoaded("Provisionen") AND isset($pSpecData["pluginSpecificCanGiveProvisions"])){
			$BP = new Button("Provisionen\nvergeben", "provision");
			$BP->className("backgroundColor0");
			$BP->onclick("contentManager.loadFrame('contentLeft','ProvisionSwitch');");
			$BP->style("float:right;margin-right:10px;");
		}
		
		$BO = "";
		if($type == "O"){
			$BO = new Button("Waren\nerhalten", "./openWaWi/Bestellungen/received.png");
			$BO->rmePCR("LBestellung", $Auftrag->getID(), "updateStatus", array("'delivered'"), OnEvent::reload("Left"));
			$BO->style("float:right;margin-right:10px;");
			$BO->className("backgroundColor0");
		}
		
		if($type == "O" AND $Auftrag->A("status") == "delivered"){
			$BO = new Button("Wareneingang\nverbuchen", "./openWaWi/Materialentnahme/Materialentnahme.png");
			$BO->popup("", "Wareneingang verbuchen", "LBestellung", $Auftrag->getID(), "bestellungVerbuchenPopup", array($this->getID()));
			$BO->style("float:right;margin-right:10px;");
			$BO->className("backgroundColor0");
		}
		
		if($type == "O" AND $Auftrag->A("status") == "closed")
			$BO = "";
		
		
		$BZ = new Button("Zuordnung zu\nBestätigungen", "./openWaWi/Bestellungen/zuordnung.png");
		$BZ->popup("", "Zuordnung", "LBestellung", $Auftrag->getID(), "bestellungVerbuchenABs", "", "", "{width:800}");
		$BZ->style("float:right;margin-right:10px;");
		$BZ->className("backgroundColor0");

		$AC = anyC::get("GRLBM", "AuftragID", $Auftrag->getID());
		$ACS = anyC::get("GRLBM");
		while($G = $AC->n())
			$ACS->addAssocV3("GRLBMOrderGRLBMIDs", "LIKE", "%".$G->getID()."%", "OR", "2");
		
		$ACS->setLimitV3(1);
		$E = $ACS->n();
		
		if(!$E)
			$BZ->disabled(true);
		
		if($type != "O" AND $type != "P")
			$BZ = "";
		
		$CB = Aspect::joinPoint("topButtons", $this, __METHOD__, array());
		if(is_array($CB))
			$CB = implode("", $CB);
		
		if($type == "O" OR $type == "P")
			$B = "<div class=\"bigButton\"></div>";
		
		$T = "";
		if($type != "I") //dont show buttons when commission
			$T .= "<div style=\"padding-left:10px;padding-top:10px;padding-bottom:30px;\" class=\"AuftragBelegContent backgroundColor4\">$CB$BAP$BAB$BNO$BP$BO$BZ$B</div>";
		


		$belegButtons = array(
			"original" => true,
			"kopie" => true,
			"drucken" => true,
			"pdfdrucken" => true,
			"preview" => true,
			"signieren" => true,
			"email" => true,
			"termin" => true,
			"multiDruck" => true,
			"esr" => true,
			"etiketten" => true,
			"file" => true,
			"3rd" => false,
			"ugl" => true,
			"aufgabe" => true);
		
		$belegButtons = Aspect::joinPoint("belegButtons", $this, __METHOD__, $belegButtons, $belegButtons);
		$below = "";
		
		$Tab = new HTMLSideTable("right");
		#$Tab->setTableStyle("width:180px;margin:0px;margin-right:-190px;float:right;margin-top:60px;");

		Aspect::joinPoint("sideTableTop", $this, __METHOD__, array($Tab));
		
		#if(Session::isPluginLoaded("mPDFJS") AND $belegButtons["preview"])
		#	$Tab->addRow(PDFJS::getButtonGRLBM($this->A("AuftragID"), $this->getID()));

		$BPDFO = new Button("Vorschau\nOriginal", "pdf");
		$BPDFO->windowRme("Auftrag", $this->A("AuftragID"), "getGRLBMPDF", array("'false'", "''", $this->getID(), "0", "''", "1"), "_Brief;templateType:PDF");
		$BPDFO->id("showOriginalButton");

		

		$BPDFKS = new Button("Einstellungen", "wrench", "iconic");
		$BPDFKS->className("buttonSettings iconicG");
		$BPDFKS->onclick("phynxContextMenu.start(this, 'GRLBM','1','".T::_("Kopie").":','right','up');");

		$BPDFK = new Button("Vorschau\nKopie", "./open3A/Auftraege/pdfKopie.png");
		$BPDFK->windowRme("Auftrag", $this->A("AuftragID"), "getGRLBMPDF", array("'true'", "''", $this->getID(), "0", "''", "1"), "_Brief;templateType:PDF");
		$BPDFK->id("showCopyButton");

		
		
		$BPDFPO = new Button("Original\ndrucken", "printer", "MPBig");
		$BPDFPO->doBefore("\$j(this).addClass('confirm'); %AFTER");
		$BPDFPO->windowRme("Auftrag", $this->A("AuftragID"), "getGRLBMPDF", array("'false'", "''", $this->getID(), 1), "_Brief;templateType:PDF");
		$BPDFPO->id("buttonPrintOriginal");
		
		if($this->A("isPrinted") > 0)
			$BPDFPO->addClass ("confirm");
		
		$BPDFPK = new Button("Kopie\ndrucken", "printer", "LPBig");
		$BPDFPK->doBefore("\$j(this).addClass('confirm'); %AFTER");
		$BPDFPK->windowRme("Auftrag", $this->A("AuftragID"), "getGRLBMPDF", array("'true'", "''", $this->getID(), 1), "_Brief;templateType:PDF");
		$BPDFPK->id("buttonPrintCopy");
		if($this->A("isPrintedCopy") > 0)
			$BPDFPK->addClass("confirm");
		
		
		Aspect::joinPoint("pdfButtons", $this, __METHOD__, array($BPDFO, $BPDFK, $BPDFPO, $BPDFPK));
		if($belegButtons["original"])
			$Tab->addRow($BPDFO);
		
		if($belegButtons["kopie"])
			$Tab->addRow($BPDFKS.$BPDFK);
		
		if($belegButtons["pdfdrucken"])
			$Tab->addRow($BPDFPO.$BPDFPK.(($this->A("isPrinted") == "1" AND $this->A("isPrintedTime") != "0") ? "<br /><small style=\"color:grey;\">".Util::CLDateTimeParser($this->A("isPrintedTime"))."</small>" : ""));
		
		
		$BPDFKS = new Button("Einstellungen", "wrench", "iconic");
		$BPDFKS->className("buttonSettings iconicG");
		$BPDFKS->onclick("phynxContextMenu.start(this, 'GRLBM','3','".T::_("Kopie").":','right','up');");
		
		$BPDFK = new Button("Buchhaltung", "./open3A/Auftraege/pdfKopie.png");
		$BPDFK->windowRme("Auftrag", $this->A("AuftragID"), "getGRLBMPDF", array("'true'", "''", $this->getID()), "_Brief;templateType:PDF3rd");
		$BPDFK->id("show3rdButton");
		if($belegButtons["3rd"])
			$Tab->addRow($BPDFKS.$BPDFK);
		
		
		if(Session::isPluginLoaded("mGaeb") AND $belegButtons["ugl"] AND in_array($this->getMyPrefix(), array("P", "O")))
			$Tab->addRow (mGaebGUI::getUGLButton($this->getID()));
		
		if(Session::isPluginLoaded("mESR") AND $belegButtons["esr"])
			$Tab->addRow(mESRGUI::getButton($this->getID()));
		
		
		if(Session::isPluginLoaded("mDrucker") AND $belegButtons["drucken"])
			$Tab->addRow(DruckerWindowGUI::getButton("Auftrag", $this->A("AuftragID"), "printLetter", $this->getID(), true, $this->A("isPrinted") == "1"));
		


		$eSig = "";
		if(Session::isPluginLoaded("SP") AND ($type == "R" OR $type == "G")) {
			$BPL = new Button("versenden mit\nsignaturportal","./open3A/signaturportal/sp.png");
			$BPL->onclick("Auftrag.windowMail(".$this->A->AuftragID.", '".$this->getID()."','sign');");#plSign('{$this->A->AuftragID}');

			$SPL = new Button("Einstellungen","wrench", "iconic");
			$SPL->style("float:right;");
			$SPL->className("mouseoverFade iconicG");
			$SPL->onclick("phynxContextMenu.start(this, 'SP','1','Einstellungen:','right','up');");

			$eSig = $BPL.$SPL;
		}

		if(Session::isPluginLoaded("PL")){
			$BPL = PLGUI::getButton($this->A->AuftragID, $this->getID());
			
			$SPL = new Button("Einstellungen","wrench", "iconic");
			$SPL->className("buttonSettings iconicG");
			$SPL->onclick("phynxContextMenu.start(this, 'PL','1','Einstellungen:','right','up');");

			if($this->A("isPixelLetteredTime") > 0)
				$BPL->addClass("confirm");
			
			$eSig = $BPL.(($this->A("isPixelLetteredTime") > 0) ? "<br /><small style=\"color:grey;\">".Util::CLDateTimeParser($this->A("isPixelLetteredTime"))."</small>" : "");#.$SPL;
		}
		
		if(Session::isPluginLoaded("monlinebrief24")){
			$BPL = onlinebrief24::getButton($this->A->AuftragID, $this->getID());
			
			if($this->A("isPixelLetteredTime") > 0)
				$BPL->addClass("confirm");
			
			$eSig = $BPL.(($this->A("isPixelLetteredTime") > 0) ? "<br /><small style=\"color:grey;\">".Util::CLDateTimeParser($this->A("isPixelLetteredTime"))."</small>" : "");#.$SPL;
		}

		if($eSig != "" AND $belegButtons["signieren"])
			$Tab->addRow(array($eSig));
		
		/*$AnsprechpartnerID = "0";
		if(Session::isPluginLoaded("mAnsprechpartner")){
			$ARecipient = Ansprechpartner::getAnsprechpartner("Adresse", $Auftrag->A("kundennummer"), $this->getMyPrefix());
			if($ARecipient != null)
				$AnsprechpartnerID = $ARecipient->getID();
		}*/

		$BMail = new Button("per E-Mail\nverschicken","mail");
		$BMail->onclick("Auftrag.windowMail(".$this->A->AuftragID.", '".$this->getID()."','E-Mail', \$j('[name=GRLBMAnsprechpartnerID]').val(), '".T::_("Per E-Mail verschicken")."');");
		$BMail->id("sendViaEmailButton");
		if($this->A("isEMailed"))
			$BMail->addClass ("confirm");
		
		$BMailS = new Button("Einstellungen","wrench", "iconic");
		$BMailS->className("buttonSettings iconicG");
		$BMailS->onclick("phynxContextMenu.start(this, 'GRLBM','viaMail:".$this->getID()."','".T::_("E-Mail").":','right','up');");

		if($belegButtons["email"]){
			$logbuch = "";
			if(Session::isPluginLoaded("mEmailLog"))
				$logbuch = "<span style=\"float:right;\"><a style=\"color:grey;margin-right:5px;\" href=\"#\" onclick=\"".OnEvent::popup("E-Mail Logbuch", "mEmailLog", "-1", "showLogs", ["'GRLBM'", $this->getID()])." return false;\">Logbuch</a></span>";
			
			$Tab->addRow($BMailS.$BMail.(($this->A("isEMailed") == "1" AND $this->A("isEMailedTime") != "0") ? "<br><small style=\"color:grey;\">$logbuch".Util::CLDateTimeParser($this->A("isEMailedTime"))."</small>" : ""));
		}
		
		if(Session::isPluginLoaded("mFile") AND $belegButtons["file"]){
			$BFiles = mFileGUI::getManagerButton("GRLBM", $this->getID(), true, "", null, false, "{position:'left'}");
			$BFiles->style("float:right;");
			
			
			$below .= $BFiles;
		}
		
		$BAddMP = new Button("zur multiDruck-\nListe hinzufügen", "./images/navi/addtolist.png");
		$BAddMP->id("GRLBMAddToMultiPrintList");
		$BAddMP->style(((!strstr($basketBPS["ids"],",".$this->ID.",") OR $basketBPS["ids"] == "") ? "":"display:none;")."float:left;");
		$BAddMP->onclick("addToMultiPrintAusAuftrag($this->ID);");

		$BDelMP = new Button("von multiDruck-\nListe entfernen", "./images/navi/subfromlist.png");
		$BDelMP->id("GRLBMSubFromMultiPrintList");
		$BDelMP->style(((!strstr($basketBPS["ids"],",".$this->ID.",") OR $basketBPS["ids"] == "") ? "display:none;":"")."float:left;");
		$BDelMP->onclick("subFromMultiPrintAusAuftrag($this->ID);");

		if($belegButtons["multiDruck"])
			$below .= $BAddMP.$BDelMP;
		
		
		if(Session::isPluginLoaded("mEtikette") AND $belegButtons["etiketten"]/* AND !Session::isPluginLoaded("mBestellung")*/) //Now in Bestellungen!
			$Tab->addRow(Etikette::getButton("GRLBM", $this->getID()));

		if(Session::isPluginLoaded("mAufgabe") AND $Auftrag->A("kundennummer") > 0)
			$Tab->addRow(Aufgabe::getButton("WAdresse", Kappendix::getAdresseIDToKundennummer($Auftrag->A("kundennummer")), "GRLBM", $this->getID()));
		
		if(Session::isPluginLoaded("mNextcloudUser"))
			$Tab->addRow(NextcloudUser::getButton("Auftrag", $this->A("AuftragID"), $this->getID()));
		
		if(Session::isPluginLoaded("mKundenzugang"))
			$Tab->addRow(Kundenzugang::getBelegButton($this));
		
		if($this->useDefaultTransport)
			$Tab->addRow(CustomizerStandardversandGUI::getButton($this));
		
		$gui->setName(Stammdaten::getLongType($type));

		if($this->isLocked() AND $type != "B")
			$gui->setIsDisplayMode(true);

		$fields = array();
		
		$Stammdaten = new Stammdaten($Auftrag->A("AuftragStammdatenID"));
		if($Auftrag->A("AuftragStammdatenID") == 0)
			$Stammdaten = Stammdaten::getActiveStammdaten ();
		
		$CurrentVorlage = $Stammdaten->A("ownTemplate");
		if($Auftrag->A("AuftragVorlage") != "")
			$CurrentVorlage = $Auftrag->A("AuftragVorlage");
		$ErrorVorlage = "";
		try {
			if($CurrentVorlage == "")
				throw new ClassNotFoundException();
			
			$CurrentVorlage = new $CurrentVorlage($Stammdaten);
		} catch (ClassNotFoundException $e){
			$ErrorVorlage = "<div class=\"error AuftragBelegContent\" style=\"padding:10px;padding-right:0px;\">Bitte überprüfen Sie Ihre Stammdaten, die ausgewählte Vorlage ($CurrentVorlage) konnte nicht gefunden werden.</div>";
			$CurrentVorlage = new Vorlage_any($Stammdaten);
		}
		
		for($i = 1; $i < 20; $i++){
			$labelName = "labelCustomField$i";

			if(isset($CurrentVorlage->$labelName) AND $CurrentVorlage->$labelName != null){
				$fields[] = "GRLBMCustomField$i";
				$gui->setLabel("GRLBMCustomField$i", $CurrentVorlage->$labelName);
			}
		}
		
		$fields = array_merge($fields, array(/*"isAbschlussrechnung", */"lieferAdresseID", "nummer", "datum", "lieferDatum", "textbausteinObenID", "textbausteinUntenID", "zahlungsbedingungenID", "leasingrate"));

		if($this->A("GRLBMReferenz") != ""){
			if(Session::isPluginLoaded("mVertrag") AND strpos($this->A("GRLBMReferenz"), "Vertrag:") === 0){
				array_unshift($fields, "GRLBMReferenz");
				#$gui->setType("GRLBMReferenz", "readonly");
				$gui->setLabel("GRLBMReferenz", "Referenz");
				$gui->setParser("GRLBMReferenz", "GRLBMGUI::parserReferenz");
			}
			
			if(Session::isPluginLoaded("mRepeatable") AND strpos($this->A("GRLBMReferenz"), "Repeatable:") === 0){
				array_unshift($fields, "GRLBMReferenz");
				#$gui->setType("GRLBMReferenz", "readonly");
				$gui->setLabel("GRLBMReferenz", "Referenz");
				$gui->setParser("GRLBMReferenz", "GRLBMGUI::parserReferenzRepeatable");
			}
		}
		
		if($this->A("GRLBMReferenznummer") != ""){
			array_unshift($fields, "GRLBMReferenznummer");
			$gui->setType("GRLBMReferenznummer", "readonly");
			$gui->setLabel("GRLBMReferenznummer", "Referenz");

			if(Session::isPluginLoaded("mAmazon")){
				$O = anyC::getFirst("AmazonBestellung", "AmazonBestellungBestellnummer", $this->A("GRLBMReferenznummer"));
				if($O != null){
					$B = new Button("Amazon", "./ubiquitous/Amazon/aLogo18.png");
					$B->popup("", "Amazon-Bestellung", "AmazonBestellung", $O->getID(), "detailsPopup");

					$gui->activateFeature("addCustomButton", $this, "GRLBMReferenznummer", $B);
				}
			}
		}
		
		if(Session::isPluginLoaded("mAnsprechpartner")){
			if($Auftrag->A("kundennummer") != "0" AND $Auftrag->A("kundennummer") != "-2")
				$ACAP = Ansprechpartner::getAllAnsprechpartner($Auftrag->A("kundennummer"));
			if($Auftrag->A("lieferantennummer") > 0)
				$ACAP = Ansprechpartner::getAllAnsprechpartnerTo("Lieferant", $Auftrag->A("lieferantennummer"));
			
			$ansprechpartner = array(0 => "Standard");
			if($ACAP != null)
				while($AP = $ACAP->getNextEntry())
					$ansprechpartner[$AP->getID()] = trim($AP->A("AnsprechpartnerPosition").(trim($AP->A("AnsprechpartnerVorname")." ".$AP->A("AnsprechpartnerNachname")) != "" ? " (".trim($AP->A("AnsprechpartnerVorname")." ".$AP->A("AnsprechpartnerNachname")).")" : ""));
			
			if(count($ansprechpartner) > 1){
				array_unshift($fields, "GRLBMAnsprechpartnerID");
				$gui->setType("GRLBMAnsprechpartnerID", "select");
				$gui->setOptions("GRLBMAnsprechpartnerID", array_keys($ansprechpartner), array_values($ansprechpartner));
				$gui->setLabel("GRLBMAnsprechpartnerID", "Ansprechpartner");
				
				if($Auftrag->A("kundennummer") > 0)
					$gui->activateFeature("addCustomButton", $this, "GRLBMAnsprechpartnerID", Ansprechpartner::getButtonSmall("Adresse", Kappendix::getAdresseIDToKundennummer($Auftrag->A("kundennummer")), "{}", "Ansprechpartner;GRLBMID:".$this->getID().""));
				
				if($Auftrag->A("lieferantennummer") > 0)
					$gui->activateFeature("addCustomButton", $this, "GRLBMAnsprechpartnerID", Ansprechpartner::getButtonSmall("Lieferant", $Auftrag->A("lieferantennummer"), "{}", "Ansprechpartner;GRLBMID:".$this->getID().""));
			}
		}
		
		$gui->setType("lieferAdresseID", "hidden");
		$gui->setType("datum", "calendar");
		
		
		$gui->setLabel("isAbschlussrechnung", "Abschlussre.");
		$gui->setLabel("lieferDatum", "Lieferdatum");
		#$gui->setLabel("rabattInW", "Rabatt");
		$gui->setLabel("leasingrate", "Leasingfaktor");
		$gui->setLabel("textbausteinObenID", "TB oben");
		$gui->setLabel("textbausteinUntenID", "TB unten");
		$gui->setLabel("zahlungsbedingungenID", "Zahlungsbed.");
		$gui->setLabel("lieferAdresseID", "Belegadresse");
		
		$gui->setParser("lieferDatum", "GRLBMGUI::parserLieferDatum", array($this->A("lieferDatumText")));
		
		if($newType == "A" OR $newType == "L" OR $newType == "R" OR Aspect::joinPoint("showBelegadresse", $this, __METHOD__, array($newType), false)){
			$gui->setType("lieferAdresseID", "text");
			$gui->setParser("lieferAdresseID", "GRLBMGUI::lieferAdresseParser", array($this->ID, $this->A("lieferAdresseKundennummer")));
		}
		
		if($newType == "O"){
			$gui->setType("lieferAdresseID", "text");
			$gui->setLabel("lieferAdresseID", "Lieferadresse");
			$gui->setParser("lieferAdresseID", "GRLBMGUI::lieferAdresseParser", array($this->ID, $this->A("lieferAdresseKundennummer")));
		}
		
		if(Session::isPluginLoaded("mTodo") AND Session::isPluginLoaded("mKalender")){
			$gui->setType("datum", "text");
			$gui->setParser("datum", "GRLBMGUI::parserDatumTermin", array($this->ID, $Auftrag->A("AdresseID"), Util::CLDateParser($this->A("datum"), "store")));
		}

		if(stripos($CurrentVorlage->showLieferdatumOn, $newType) === false)
		#if($newType != "R" AND $newType != "A" AND $newType != "B" AND $newType != "P")# AND $newType != "0")
			$gui->setType("lieferDatum", "hidden");

		if($newType != "Kalk"){
			#$gui->setType("rabatt", "hidden");
			#$gui->setType("rabattInW", "hidden");
			$gui->setType("leasingrate", "hidden");

			$gui->setParser("textbausteinObenID", "GRLBMGUI::textbausteinParser", array("oben", $this->getMyPrefix(), $this->A("textbausteinOben"), $this->A("isPayed")));
			$gui->setParser("textbausteinUntenID", "GRLBMGUI::textbausteinParser", array("unten", $this->getMyPrefix(), $this->A("textbausteinUnten"), $this->A("isPayed")));
			$gui->setParser("zahlungsbedingungenID", "GRLBMGUI::textbausteinParser", array("zahlungsbedingungen", $this->getMyPrefix(), $this->A("zahlungsbedingungen"), $this->A("isPayed")));
		} else {
			$gui->setType("textbausteinObenID", "hidden");
			$gui->setType("textbausteinUntenID", "hidden");
			$gui->setType("zahlungsbedingungenID", "hidden");
		}

		$gui->setShowAttributes($fields);
		
		if(Session::isPluginLoaded("mSprache")){
			$Adresse = new Adresse($Auftrag->A("AdresseID"));
			if($Adresse->A("AdresseSpracheID") != 0 OR Aspect::joinPoint("showFaktor", $this, __METHOD__, array(), false)){ 
				$Sprache = new Sprache($Adresse->A("AdresseSpracheID"));
				
				$gui->insertAttribute("after", "nummer", "GRLBMWaehrungFaktor");
				$gui->setLabel("GRLBMWaehrungFaktor", "Umrechn.faktor");
				$gui->setLabelDescription("GRLBMWaehrungFaktor", "in ".$Sprache->A("SpracheWaehrung"));
			}
		}
		
		if(Session::isPluginLoaded("mBestellung")){
			$gui->insertAttribute("before", "nummer", "versandkosten");
			$gui->setParser("versandkosten", "GRLBMGUI::parserVersandkosten");
		}
		
		if(Session::isPluginLoaded("mZahlungsart")){
			$gui->insertSpaceAbove("GRLBMpayedVia");
			
			$gui->setLabel("GRLBMpayedVia", "Zahlungsart");
			$gui->insertAttribute("before", "zahlungsbedingungenID", "GRLBMpayedVia");
			$gui->setType("GRLBMpayedVia", "select");
			
			$Z = GRLBM::getPaymentVia();
			
			$if = "";
			
			foreach($Z AS $k => $ZA){
				$TB = Zahlungsart::getTB($k, $Stammdaten);
				if($TB != null){
					$if .= "if(this.value == '$k') \$j('[name=zahlungsbedingungenID]').val('".$TB->getID()."').trigger('change');";
					$Z[$k] = $ZA." (TB: ".$TB->A("label").")";
				} else
					$Z[$k] = $ZA." (kein TB)";
			}
			
			$gui->setOptions("GRLBMpayedVia", array_keys($Z), array_values($Z));
			
			$gui->setInputJSEvent("GRLBMpayedVia", "onChange", $if);
		}
		
		#$gui->setLabelDescription("rabatt", "in %");
		#$gui->setLabelDescription("rabattInW", "in €");
		$gui->setLabelDescription("leasingrate", "in %");


		$gui->setJSEvent("onSave", "function(){ Auftrag.updateNettoBrutto(".$this->getID()."); }");
		$gui->setStandardSaveButton($this);

		$gui->customize($this->customizer);


		$TN = new HTMLTable(1);
		$TN->setTableID("belegAchtungTabelle");
		$BN = new Button("Achtung", "notice", "icon");
		$BN->style("float:left;margin-right:10px;margin-bottom:15px;");
		
		if($this->A("isAbschlussrechnung"))
			$TN->addRow("$BN Dies ist eine <b>Schlussrechnung</b>.<br />Die Abschlags- oder Teilrechnungen aus diesem Auftrag werden automatisch abgezogen.");
		
		if($this->A("isAbschlagsrechnung"))
			$TN->addRow("$BN Dies ist eine <b>Abschlagsrechnung</b>.<br />Sie wird automatisch von einer Abschlussrechnung in diesem Auftrag abgezogen.");
		
		if($this->A("isTeilrechnung"))
			$TN->addRow("$BN Dies ist eine <b>Teilrechnung</b>.<br />Sie wird automatisch von einer Abschlussrechnung in diesem Auftrag abgezogen.");
		
		$html = "<div class=\"prettySubtitle\" style=\"margin-top:30px;\">".T::_("Beleg")."</div><div style=\"\">$TN".$Tab.$gui->getEditHTML()."</div>";
		Timer::now("step 10", __FILE__, __LINE__);
		$TabBelow = "";
		if($below != ""){
			$TabBelow = new HTMLTable(1);
			$TabBelow->setTableStyle("margin-top:30px;");
			$TabBelow->setColClass(1, "");
			$TabBelow->addRow($below);
		}
		
		$js = "\$j('#AuftragMessage').html('".$Auftrag->getMessage()."');";
		
		return $T.$ErrorVorlage."<div style=\"border-right:1px solid #eee;padding-right:9px;\" class=\"AuftragBelegContent\">"."<div id=\"AuftragBeleg\">".$postenRechnung->getHTML(-1,$this->A->AuftragID,"",$this->ID)."</div><div style=\"width:430px;\">".$html.$TabBelow."</div>".OnEvent::script("$js Auftrag.reWidth();")."</div>";#($type != "Kalk" ? $html : "");
	}
	
	public static function parserVersandkosten($w, $E){
		$I = new HTMLInput("versandkosten", "text", $w);
		$I->style("width:120px;margin-right:10px;text-align:right;");
		
		$IM = new HTMLInput("versandkostenMwSt", "text", $E->A("versandkostenMwSt"));
		$IM->style("width:70px;text-align:right;");
		
		if($E->isLocked()){
			$I->isDisplayMode(true);
			$IM->isDisplayMode(true);
		}
		
		return "$I <span style=\"color:grey;\">".T::_("MwSt").":</span> ".$IM." <span style=\"color:grey;\">%</span>";
	
	}
	
	public static function parserReferenz($w){
		$V = new Vertrag(str_replace("Vertrag:", "", $w));
		
		$B = new Button("Vertrag öffnen", "./images/i2/redo.png", "icon");
		$B->style("float:right;");
		$B->loadPlugin("contentRight", "mVertrag", "", str_replace("Vertrag:", "", $w));
		
		return $B."Erstellt von Vertrag ".$V->A("VertragNummer");
	}
	
	public static function parserReferenzRepeatable($w){
		$R = new Repeatable(str_replace("Repeatable:", "", $w));
		
		#$B = new Button("Repeatable öffnen", "./images/i2/redo.png", "icon");
		#$B->style("float:right;");
		#$B->loadPlugin("contentRight", "mVertrag", "", str_replace("Vertrag:", "", $w));
		
		return "Erstellt von Repeatable ".$R->A("RepeatableNummer");
	}

	public static function parserDatumTermin($w, $E, $p){
		$p = HTMLGUI::getArrayFromParametersString($p);
		$Termin = anyC::get("Todo", "TodoClass", "GRLBM");
		$Termin->addAssocV3("TodoClassID", "=", $p[0]);
		$Termin = $Termin->getNextEntry();

		$ort = "";
		if($p[1] != "0"){
			$Adresse = new Adresse($p[1]);
			$ort = str_replace("\n", ", ", $Adresse->getFormattedAddress());
		}

		$BTermin = new Button("Termin\n".($Termin == null ? "hinzufügen" : "anzeigen"), "./ubiquitous/Kalender/".($Termin == null ? "add" : "has")."ToDo.png", "icon");
		if($Termin == null)
			$BTermin->popup("", "Neuer Termin", "mKalender", "-1", "newTodo", array("-1", $p[2], "'GRLBM'", $p[0], "''", "''", "'$ort'"));
		else
			$BTermin->popup ("", "Event", "mKalender", "-1", "getInfo", array("'mTodoGUI'", $Termin->getID(), $p[2]));
		$BTermin->style("float:right;margin-left:10px;");
		
		$I = new HTMLInput("datum", "date", $w);
		$I->style("width:80%;");
		
		if($E->isLocked()){
			$I->isDisplayMode(true);
		}
		
		Aspect::joinPoint("alter", $E, __METHOD__, array($BTermin, $I));
		
		return $BTermin.$I;
	}
	
	// <editor-fold defaultstate="collapsed" desc="textbausteinParser">
	public static function textbausteinParser($w, $E, $p){
		$s = HTMLGUI::getArrayFromParametersString($p);

		switch($s[0]){
			case "oben":
				$TBF = "textbausteinOben";
				$resize = "$('textbausteinUnten').style.height='18px';$('zahlungsbedingungen').style.height='18px';";
			break;
			case "unten":
				$TBF = "textbausteinUnten";
				$resize = "$('textbausteinOben').style.height='18px';$('zahlungsbedingungen').style.height='18px';";
			break;
			case "zahlungsbedingungen":
				$TBF = "zahlungsbedingungen";
				$resize = "$('textbausteinOben').style.height='18px';$('textbausteinUnten').style.height='18px';";
			break;
		}


		$To = array();
		try {
			$Tbos = new Textbausteine();
			$Tbos = $Tbos->getTBs($s[0], $s[1]);

			if($Tbos)
				foreach($Tbos[0] As $key => $value)
					$To[$value] = $Tbos[1][$key];
		} catch (FieldDoesNotExistException $e){ }

		$To["0"] = T::_("Freitext...");

		$IS = new HTMLInput($TBF."ID", "select", $w, $To);
		#$IS->setOptions($To);
		$IS->onchange("if(this.value=='0') \$j('#{$TBF}Edit').show(); else \$j('#{$TBF}Edit').hide();");
		#$IS->onchange("if(this.value=='0') $('$TBF').style.display = ''; else $('$TBF').style.display = 'none';");
		$IS->isDisplayMode($s[3] == "1" AND $s[1] != "B");
		
		$IT = new HTMLInput($TBF, "nicEdit", $s[2], array("GRLBMForm", $TBF, "Auftrag.availabeTBSelection"));

		if($E->isLocked()){
			$IS->isDisplayMode(true);
			return $IS;
		}
		
		return $IS."<div id=\"{$TBF}Edit\" style=\"margin-top:5px;".($w != "0" ? "display:none;" : "")."\">".$IT."</div>";
/*
		$IS = new HTMLInput("GRLBMTextbausteinServiceID", "select", $w, $To);

		$IS->onchange("if(this.value=='0') \$j('#GRLBMTextbausteinServiceEdit').show(); else \$j('#GRLBMTextbausteinServiceEdit').hide();");
		$IS->isDisplayMode($s[3] == "1" AND $s[1] != "B");
		
		$IT = new HTMLInput("GRLBMTextbausteinService", "nicEdit", $s[2], array("GRLBMForm", "GRLBMTextbausteinService"));
		
		return $IS."<div id=\"GRLBMTextbausteinServiceEdit\" style=\"margin-top:5px;".($w != "0" ? "display:none;" : "")."\">".$IT."</div>";*/
	}
	// </editor-fold>

	// <editor-fold defaultstate="collapsed" desc="lieferAdresseParser">
	public static function lieferAdresseParser($w, $l, $p){
		$s = HTMLGUI::getArrayFromParametersString($p);

		$BD = new Button("Belegadresse löschen", "./images/i2/delete.gif", "icon");
		$BD->style("float:right;margin-left:10px;");
		$BD->onclick("rme('GRLBM','$s[0]','getLieferscheinAdresseCopy','0','contentManager.loadFrame(\'subframe\', \'GRLBM\', \'$s[0]\');');");

		$B1 = new Button("1x-Belegadresse verwenden", "./open3A/Auftraege/1xlieferAdresse.png", "icon");
		$B1->style("float:right;margin-left:10px;");
		$B1->editInPopup("AuftragAdresse", "-1", "Adresse anlegen", "AuftragAdresseGUI;AuftragID:$s[0];displayMode:lieferAdresse");
		#$B1->onclick("contentManager.loadFrame('contentRight','Adresse', -1, 0,'AdresseGUI;AuftragID:$s[0];displayMode:lieferAdresse');");

		$BC = new Button("Belegadresse ändern", "./open3A/Auftraege/lieferAdresse.png", "icon");
		$BC->style("float:right;");
		#$BC->onclick("contentManager.backupFrame('contentRight','selectionOverlay'); contentManager.loadFrame('contentRight','Adressen', -1, 0,'AdressenGUI;selectionMode:singleSelection,GRLBM,$s[0],getLieferscheinAdresseCopy,Auftraege,subframe,GRLBM,$s[0]');");
		$BC->customSelect("contentRight", $s[0], "Adressen", "Auftrag.selectBelegAdresse");
	
		$A = new Adresse($w);
		$K = "";
		if($s[1])
			$K = "<br><small style=\"color:grey;\">Kundennummer: $s[1]</small>";
		
		return ($w != 0 ? $BD : "").$B1.$BC.($w == "0" ? T::_("wie Auftragsadresse") : $A.$K);
	}
	// </editor-fold>

	public function getContextMenuHTML($identifier){
		T::load(__DIR__, "Auftraege");
		
		$options = explode(":",$identifier);
		$identifier = $options[0];
		
		switch($identifier) {
			case "3":
				$gui = new HTMLGUI();
				$aSd = mStammdaten::getActiveStammdaten();
				
				$selectedKey = mUserdata::getUDValueS("activePDF3rdTemplate", $aSd->A("ownTemplate"));
				
				$FB = new FileBrowser();
				$FB->addDir("../open3A/Brief/");
				$FB->addDir("../specifics/");
				if(FileStorage::getFilesDir() != Util::getRootPath()."specifics/")
					$FB->addDir(FileStorage::getFilesDir());
				$a = $FB->getAsLabeledArray("iVorlage",".class.php",true);
				echo "<div style=\"max-height:400px;overflow:auto;\">";
				echo $gui->getContextMenu(array_flip($a), "GRLBM", "3", $selectedKey);
				echo "</div>";
			break;
		
			case "1":
				$gui = new HTMLGUI();
				$aSd = mStammdaten::getActiveStammdaten();
				
				$selectedKey = mUserdata::getUDValueS("activePDFCopyTemplate", $aSd->A("ownTemplate"));
				
				$FB = new FileBrowser();
				$FB->addDir("../open3A/Brief/");
				$FB->addDir("../specifics/");
				if(FileStorage::getFilesDir() != Util::getRootPath()."specifics/")
					$FB->addDir(FileStorage::getFilesDir());
				$a = $FB->getAsLabeledArray("iVorlage",".class.php",true);
				echo "<div style=\"max-height:400px;overflow:auto;\">";
				echo $gui->getContextMenu(array_flip($a), "GRLBM", "1", $selectedKey);
				echo "</div>";
				echo "<br />";
				
				#$ud = new mUserdata();
				$selectedKey = mUserdata::getUDValueS("activePDFCopyVermerk", "true");
				
				#if($aT == null){
				#	$selectedKey = "true";
				#} else $selectedKey = $aT;
				
				$kAL = array();
				$kAL["true"] = "mit Kopie-Vermerk";
				$kAL["false"] = "ohne Kopie-Vermerk";
				
				echo $gui->getContextMenu($kAL, "GRLBM", "2", $selectedKey);
			break;
			
			case "viaMail":
				$GRLBM = new GRLBM($options[1]);
				$Auftrag = new Auftrag($GRLBM->A("AuftragID"));
				$Stammdaten = new Stammdaten($Auftrag->A("AuftragStammdatenID"));
				if(!isset($options[1]))
					$Stammdaten = mStammdaten::getActiveStammdaten();
				if(trim($Stammdaten->A("alwaysBcc")) == "")
					echo "
				<div style=\"margin:1px;padding:3px;font-weight:bold;\" class=\"backgroundColor2\">".T::_("BCC an %1?", $_SESSION["S"]->getCurrentUser()->getA()->UserEmail).":</div>";

				$gui = new HTMLGUI();
				#$ud = new mUserdata();
				$selectedKey = mUserdata::getUDValueS("BCCToUser", "false");
				
				$kAL = array();
				$kAL["false"] = "Nein";
				$kAL["true"] = "Ja";
				
				if(trim($Stammdaten->A("alwaysBcc")) == "")
					echo $gui->getContextMenu($kAL, "GRLBM", "BCCToUser", $selectedKey);
						
				echo "<div style=\"margin:1px;margin-top:10px;padding:3px;font-weight:bold;\" class=\"backgroundColor2\">".T::_("Absender").":</div>";

				
				#$ud = new mUserdata();
				$selectedKey = mUserdata::getUDValueS("sendBelegViaEmailSender", "firm");
				
				$kAL = array();
				$kAL["firm"] = array("Firma (%1)", $Stammdaten->A("email"));
				$kAL["user"] = array("Benutzer (%1)", $_SESSION["S"]->getCurrentUser()->A("UserEmail"));
				
				echo $gui->getContextMenu($kAL, "GRLBM", "mailSender", $selectedKey);
				
				echo "<div style=\"margin:1px;margin-top:10px;padding:3px;font-weight:bold;\" class=\"backgroundColor2\">".T::_("Datei-Anhänge").":</div>";

				if(Session::isPluginLoaded("mFile")){
					#$ud = new mUserdata();
					$selectedKey = mUserdata::getUDValueS("sendBelegViaEmailAttachments", "false");
					
					$kAL = array();
					$kAL["true"] = "mit";
					$kAL["false"] = "ohne";
					
					echo $gui->getContextMenu($kAL, "GRLBM", "mailAttachments", $selectedKey);
				}
				
				$MailServer = LoginData::get("MailServerUserPass");
				if($MailServer != null AND $MailServer->A("server") != ""){
					echo "<div style=\"margin:1px;margin-top:10px;padding:3px;font-weight:bold;\" class=\"backgroundColor2\">".T::_("Übermittlungsstatus (DSN) anfordern").":</div>";

					$selectedKey = mUserdata::getUDValueS("sendBelegViaEmailDSN", "false");

					$kAL = array();
					$kAL["true"] = "ja";
					$kAL["false"] = "nein";

					echo $gui->getContextMenu($kAL, "GRLBM", "useDSN", $selectedKey);
				}
				
				echo "<div style=\"margin:1px;margin-top:10px;padding:3px;font-weight:bold;\" class=\"backgroundColor2\">".T::_("Bei Mahnung").":</div>";
				
				$kAL = array();
				$kAL["false"] = "Keine Rechnung anhängen";
				$kAL["true"] = "Rechnung anhängen";
				
				echo $gui->getContextMenu($kAL, "GRLBM", "mailAttachInvoice", mUserdata::getUDValueS("sendBelegViaEmailAttachInvoice", "false"));
			break;
			
			case "setPayed":
				$pSpecData = mUserdata::getPluginSpecificData("Auftraege");
				if(!isset($pSpecData["pluginSpecificCanSetPayed"])) 
					die("<p><small>Sie können keine Rechnungen als bezahlt markieren.<br><br>Damit Sie Rechnungen als bezahlt markieren können, muss im Administrations-Bereich eine Plugin-spezifische Berechtigung gesetzt werden. Wählen Sie dazu den Benutzer aus, klicken Sie auf \"Plugin-spezifisch\". Wählen Sie Aufträge und \"kann Rechnungen als bezahlt markieren\".</small></p>");
				
				$G = new GRLBM($options[2]);
				$G->loadMe();
				
				$tab = new HTMLTable(1);
				
				if(isset($G->getA()->GRLBMTeilzahlungen) AND $this->CustomizerTeilzahlungen) {
					$tab->addRow("<input type=\"checkbox\" onclick=\"Auftrag.showTeilzahlung();\" id=\"isTeilzahlung\" style=\"float:left;margin-right:5px;\" /> <label style=\"text-align:left;font-weight:normal;float:none;\" for=\"isTeilzahlung\">Teilzahlung</label>");
					$tab->addRowClass("backgroundColor0");
					
					$tab->addRow("Betrag: <input id=\"GRLBMTeilzahlungenBetrag\" type=\"text\" style=\"text-align:right;width:100px;\" value=\"".Util::CLFormatCurrency(0,false)."\" onkeydown=\"if(event.keyCode == 13) Auftrag.nowSetRechnungPayed('$options[1]', '$options[2]');\" />");
					$tab->addCellStyle(1,"display:none;");
					$tab->addCellID(1, "GRLBMTeilzahlungenBetragCell");
				}
				
				$tab->addRow("mit Skonto: <input id=\"withSkonto\" type=\"text\" value=\"\" style=\"text-align:right;width:50px;\" onkeydown=\"if(event.keyCode == 13) Auftrag.nowSetRechnungPayed('$options[1]', '$options[2]');\" /> %");
				$tab->addCellID(1, "markAsPayedSkonto");
				$tab->addRowClass("backgroundColor3");
				
				$ID = new HTMLInput("withDate", "date", Util::CLDateParser(time()));
				$ID->id("withDate");
				$ID->style("width:50%;text-align:right;");
				$ID->onkeydown("if(event.keyCode == 13) Auftrag.nowSetRechnungPayed('$options[1]', '$options[2]');");
				$tab->addRow("Datum: $ID");
				#$tab->addRow("Datum: <input id=\"withDate\" type=\"text\" style=\"text-align:right;width:100px;\" value=\"".date("d.m.Y")."\" onkeydown=\"if(event.keyCode == 13) Auftrag.nowSetRechnungPayed('$options[1]', '$options[2]');\" />");
				$tab->addRowClass("backgroundColor3");
				
				$tab->addRow("<input style=\"background-image:url(./images/i2/save.gif);\" type=\"button\" value=\"markieren\" onclick=\"Auftrag.nowSetRechnungPayed('$options[1]', '$options[2]');\" />");
				
				
				echo $tab;
			break;
		}

	}

	// <editor-fold defaultstate="collapsed" desc="saveContextMenu">
	public function saveContextMenu($identifier, $key){
		$ud = new mUserdata();
		
		if($identifier == "1")
			$ud->setUserdata("activePDFCopyTemplate",$key);
		
		if($identifier == "3")
			$ud->setUserdata("activePDF3rdTemplate",$key);
		
		if($identifier == "2")
			$ud->setUserdata("activePDFCopyVermerk",$key);
		
		if($identifier == "BCCToUser")
			$ud->setUserdata("BCCToUser",$key);
		
		if($identifier == "viaMail")
			$ud->setUserdata("sendBelegCopyViaEmail",$key);
		
		if($identifier == "mailBetreff")
			$ud->setUserdata("sendBelegViaEmailBetreff",$key);
		
		if($identifier == "mailText")
			$ud->setUserdata("sendBelegViaEmailText",$key);
		
		if($identifier == "mailSender")
			$ud->setUserdata("sendBelegViaEmailSender",$key);
		
		if($identifier == "mailAttachments")
			$ud->setUserdata("sendBelegViaEmailAttachments",$key);
		
		if($identifier == "useDSN")
			$ud->setUserdata("sendBelegViaEmailDSN",$key);
		
		if($identifier == "mailAttachInvoice")
			$ud->setUserdata("sendBelegViaEmailAttachInvoice",$key);
		
		
	}
	// </editor-fold>
	
	public function getProvisionCopy($ProvisionID){
		parent::getProvisionCopy($ProvisionID);
		echo "Posten erstellt";
	}
	
	public function getPostenCopy($ArtikelID, $menge = 1, $beschreibung = null, $kundennummer = null, $preis = null){
		T::load(__DIR__, "Auftraege");
		$menge = Util::CLNumberParserZ($menge, "store");
		$PostenID = parent::getPostenCopy($ArtikelID, $menge);
		Red::messageD("Posten erstellt", array("PostenID" => $PostenID, "bestand" => $this->newPostenMessageBestand));
	}

	public function setPayed($p, $skonto = "0,00", $datum = "0", $isTeilzahlung = "false", $TeilzahlungBetrag = "", $save = true, $unused = true){
		echo parent::setPayed($p, $skonto, $datum, $isTeilzahlung, $TeilzahlungBetrag, $save);
	}
	
	public function copyPostenFromMulti($from){
		T::load(__DIR__, "Auftraege");
		
		parse_str($from, $data);
		$copy = array();
		foreach($data AS $k => $v)
			if($v)
				$copy[] = str_replace("GRLBM_", "", $k);
			
		parent::copyPostenFromMulti($copy);
		Red::messageD("Positionen kopiert");
	}
	
	public function copyPostenFrom($fromId, $skipIDs = [], $output = true){
		parent::copyPostenFrom($fromId, $skipIDs);
		if($output)
			Red::messageD ("Posten kopiert");
	}
	
	public function copyPostenByTypeAndNumber($fromNumber, $fromType){
		parent::copyPostenByTypeAndNumber($fromNumber, $fromType);
	}
	
	public static function parserLieferDatum($w, $l, $p, $E){
		$I = new HTMLInput("lieferDatum", "date", $w);
		$I->style("width:88%;");
		
		$IF = new HTMLInput("lieferDatumUseText", "checkbox", $p != "" ? "1" : "0");
		$IF->style("float:right;");
		$IF->onclick("if(this.checked) { \$j('#lieferDatumContainer').hide(); \$j('[name=lieferDatum]').val(''); \$j('[name=lieferDatumText]').show(); } else { \$j('#lieferDatumContainer').show(); \$j('[name=lieferDatumText]').val('').hide(); }");
		$IF->title("Text statt Datum verwenden");
		
		$IT = new HTMLInput("lieferDatumText", "text", $p);
		$IT->style($p != "" ? "" : "display:none;");
		
		if($l->isLocked()){
			$I->isDisplayMode(true);
			$IT->isDisplayMode(true);
			$IF->isDisplayMode(true);
		}
		
		return $IF."<div id=\"lieferDatumContainer\" style=\"width:90%;".($p != "" ? "display:none;" : "")."\">".$I."</div>".$IT;
	}
	
	public function orderNote(){
		// <editor-fold defaultstate="collapsed" desc="Aspect:jP">
		try {
			$MArgs = func_get_args();
			return Aspect::joinPoint("around", $this, __METHOD__, $MArgs);
		} catch (AOPNoAdviceException $e) {}
		Aspect::joinPoint("before", $this, __METHOD__, $MArgs);
		// </editor-fold>
		
		$this->changeA("GRLBMOrderGRLBMIDs", "note");
		$this->changeA("isPayed", "1");
		$this->changeA("GRLBMpayedDate", time());
		$this->saveMe();
	}
	/*
	public function deliveryNote(){
		$this->changeA("GRLBMDeliveryStatus", "note");
		$this->changeA("isPayed", "1");
		$this->changeA("GRLBMpayedDate", time());
		$this->saveMe();
	}*/
	
	public function productionNote(){
		$this->changeA("GRLBMProductionLaufzettel", "note");
		$this->changeA("isPayed", "1");
		$this->changeA("GRLBMpayedDate", time());
		$this->saveMe();
	}
	
	public function addFile($id){
		mFileGUI::addFile("GRLBM",$this->ID, $id);
		Red::messageSaved();
	}
	
	public function saveRabatt($rabatt){
		// <editor-fold defaultstate="collapsed" desc="Aspect:jP">
		try {
			$MArgs = func_get_args();
			return Aspect::joinPoint("around", $this, __METHOD__, $MArgs);
		} catch (AOPNoAdviceException $e) {}
		Aspect::joinPoint("before", $this, __METHOD__, $MArgs);
		// </editor-fold>
		
		$this->changeA("rabatt", Util::CLNumberParserZ($rabatt, "store"));
		$this->saveMe();
		
		$G = new GRLBM($this->getID());
		$G->getSumOfPosten(false, true);
	}

	// <editor-fold defaultstate="collapsed" desc="getLieferscheinAdresseCopy">
	public function getLieferscheinAdresseCopy($adresseID){

		if($this->A("lieferAdresseID") != "0"){
			$Adresse = new Adresse($this->A("lieferAdresseID"));
			$Adresse->deleteMe();
		}

		if($adresseID != 0){
			$AdresseOld = new Adresse($adresseID);
			$AdresseOld->changeA("AuftragID", $this->ID);
			$AdresseOld->changeA("type","lieferAdresse");
			$newID = $AdresseOld->newMe();
		} else {
			
			$newID = 0;
		}
		#if($newID == 0){
			$this->loadMe();
			$this->changeA("lieferAdresseID", $newID);
			$K = Kappendix::getKappendixToAdresse($adresseID);
			if($K)
				$this->changeA("lieferAdresseKundennummer", $K->A("kundennummer"));
			
			$this->saveMe();
		#}
	}
	// </editor-fold>
}
?>
