<?php
/*
 *  This file is part of open3A.

 *  open3A is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  open3A is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 *  2007 - 2020, open3A GmbH - Support@open3A.de
 */
class AdressenGUI extends Adressen implements iGUIHTMLMP2, iAutoCompleteHTML, icontextMenu, iSearchFilter, iCategoryFilter, iOrderByField {
	
	protected $gui;
	public $searchFields = array("nachname", "vorname", "firma", "ort", "strasse", "kundennummer", "tel", "mobil", "VornameNachname", "NachnameVorname");
	public $inAC = false;
	public $searchLimit = 10;

	function __construct(){
		parent::__construct();
		$this->customize();
		#$bps = $this->getMyBPSData();

		try {
			if(Session::isPluginLoaded("mAdressBuch")){
				$CAB = mAdressBuchGUI::getCurrent($this, false, true);

				if($CAB == "-2"){
					$this->addAssocV3("type","=","default", "AND", "1");

					$AC = anyC::get("AdressBuch");
					$AC->addAssocV3("AdressBuchUserID", "=", Session::currentUser()->getID());
					$AC->addAssocV3("AdressBuchTyp", "=", "2");

					while($AB = $AC->getNextEntry())
						$this->addAssocV3 ("type", "=", "AB".$AB->getID(), "OR", "1");
				}

				if($CAB == "0")
					$this->addAssocV3("type","=","default");

				if($CAB > 0){
					$AB = new AdressBuch($CAB);
					if($AB->A("AdressBuchTyp") == "1" OR $AB->A("AdressBuchTyp") == "3" OR
						($AB->A("AdressBuchTyp") == "2" AND $AB->A("AdressBuchUserID") == Session::currentUser()->getID())){
						$this->addAssocV3("type","=","AB".$CAB);
						BPS::setProperty(get_class($this), "AdressBuch", $CAB);
					}
				}
			}
		} catch(TableDoesNotExistException $e){ //on setup!
			
		} catch(NoDBUserDataException $e){ //on setup!
			
		}
	}
	
	function getHTML($id, $page){
		T::load(__DIR__, "Adressen");
		#$this->addOrderV3("KategorieID","ASC");// = "KategorieID ASC, firma, nachname";
		#$this->addOrderV3("CONCAT(firma, nachname)","ASC");
		$this->addOrderV3("KategorieID","ASC");// = "KategorieID ASC, firma, nachname";
		$this->addOrderV3("firma","ASC");
		$this->addOrderV3("nachname","ASC");
		if(Session::isPluginLoaded("Kunden"))
			$this->addJoinV3("Kappendix", "AdresseID", "=", "AdresseID");
		#ALTER TABLE `kappendix` ADD INDEX `AdresseID` (`AdresseID`);
		Aspect::joinPoint("alter", $this, __METHOD__, array());
		
		$spec = mUserdata::getPluginSpecificData("Adressen");
		if(isset($spec["pluginSpecificCanUseProvision"]) AND $id == -1){
			#$this->addJoinV3("Kappendix", "t1.AdresseID", "=", "AdresseID");
			$this->addAssocV3("KappendixProvisionUserID", "=", Session::currentUser()->getID());
		}
		
		#$this->addJoinV3("Kappendix", "AdresseID", "=", "AdresseID"); //this is no good idea, unless with an index on Kappendix::AdresseID column
		if(Applications::activeApplication() == "lightCRM")
			new CRMHTMLGUI();
		$this->filterCategories();
		
        $time = microtime(TRUE);
		$this->loadMultiPageMode($id, $page, 0);
        $time2 = microtime(TRUE);
		
		if($time2 - $time > 2){
            $DB = new DBStorage();
			$C = $DB->getConnection();
			$Q = $C->query("SHOW INDEX FROM Kappendix");
			$found = false;
			while($R = $Q->fetch_assoc())
				if($R["Key_name"] == "AdresseID")
					$found = true;
				
			if(!$found)
				$C->query('ALTER TABLE `Kappendix` ADD INDEX `AdresseID` (`AdresseID`);');
        }
		
		$gui = new HTMLGUIX($this, "Adressen");
		$gui->screenHeight();
		$gui->options(true, true, true, true);
		$gui->version("Adressen");
		
		$gui->name("Adresse");
		#$gui->setObject($this);
		$gui->tip();

		$gui->parser("firma","AdressenGUI::firmaParser");#,array("\$sc->vorname","\$sc->nachname","\$aid", "\$type", "\$tel", "\$fax", "\$email", "\$mobil", "\$homepage", __CLASS__));

		$gui->customize($this->customizer);
		$this->filterCategories();#$gui->showFilteredCategoriesWarning($this->filterCategories(), "Adressen");
		#$gesamt = $this->loadMultiPageMode($id, $page, 0);

		if(get_class($this) == "AdressenGUI"){
			$_SESSION["BPS"]->setActualClass("adressenMode");
			$_SESSION["BPS"]->unsetACProperty("adressenMode");
		}

		if(Session::isPluginLoaded("mAdressBuch") AND $id == -1)
			$gui->prepend(mAdressBuchGUI::getSelectionMenu($this, "contentRight", false, true));
		
		#$gui->isQuickSearchable(str_replace("GUI","",get_class($this)));
		#$gui->setMultiPageMode($gesamt, $page, 0, "contentRight", str_replace("GUI","",get_class($this)));
		#if($this->collector != null) $gui->setAttributes($this->collector);
		
		$gui->displayGroup("KategorieID", "AdressenGUI::DGParser");
		#$gui->setDisplayGroupParser("AdressenGUI::DGParser");
		
		$gui->attributes(array("firma"));
		
		#$gui->setJSEvent("onNew","contentManager.newClassButton('Adresse', function(){ contentManager.reloadFrameRight(); });");
		
		
		
		if(Session::isPluginLoaded("mEtikette") AND Session::isPluginLoaded("Kategorien")){
			$B = $gui->addSideButton("Etiketten\ndrucken", "./ubiquitous/Etiketten/Etiketten.png");
			$B->popup("", "Etiketten drucken", "Adressen", "-1", "etikettenPopup");
		}
		
		return $gui->getBrowserHTML($id, true, "Adressen");
	}
	
	public function etikettenPopup(){
		$F = new HTMLForm("etiketten", array("etikette", "auswahl"));
		$F->getTable()->setColWidth(1, 120);
		$F->useRecentlyChanged();
		
		$AC = anyC::get("Kategorie");
		$AC->addAssocV3("type","=","1");
		while($K = $AC->n()){
			$K->changeA("name", "Kategorie '".$K->A("name")."'");
		}
		$AC->resetPointer();
		$K = $AC->toArray("name", "Aktuelle Auswahl");
			
		$F->setType("auswahl", "select", 0, $K);
		
		$AC = anyC::get("Etikette");
		$E = $AC->toArray("EtiketteName");
		
		$F->setType("etikette", "select", 0, $E);
		
		#$F->setSaveRMEPCR("Etiketten anzeigen", "", "Adressen", "-1", "etikettenSave", OnEvent::closePopup("Adressen"));
		$F->setSaveWindowRMEPCR("Etiketten anzeigen", "", "Adressen", -1, "etikettenSave");
			
		echo $F;
	}
	
	public function etikettenSave($EID, $KID){
		BPS::setProperty("EtiketteGUI", "className", "Adressen");
		BPS::setProperty("EtiketteGUI", "classID", "-1");
		BPS::setProperty("AdressenGUI", "etikettenKID", $KID);
		
		#Red::redirect(OnEvent::window(new EtikettenPDFGUI($EID), "getPDF"));
		$E = new EtikettenPDFGUI($EID);
		echo $E->getPDF("");
	}
	
	public static function DGParser($w, $l, $p = null){
		if($w == 0)
			return "-";
		
		$k = new Kategorie($w);
		return $k->getA() != null ? $k->getA()->name : "Kategorie unbekannt";
	}

	public static function getContactButton($kundennummer){
		$BKontakt = new Button("Kontaktdaten anzeigen", "./images/i2/telephone.png", "icon");
		$BKontakt->style("float:right;");
		$BKontakt->popup("name", "Kontaktdaten", "Adressen", -1, "getContactPopup", $kundennummer);

		return $BKontakt;
	}

	public function getContactPopup($kundennummer){
		$A = new Adresse(Kappendix::getAdresseIDToKundennummer($kundennummer));

		$T = new HTMLTable(2);
		$T->setColWidth(1, 120);

		$T->addRow(array($A->getHTMLFormattedAddress()));
		$T->addRowColspan(1, 2);

		if($A->A("bemerkung") != ""){
			$T->addRow(array(nl2br($A->A("bemerkung"))));
			$T->addRowColspan(1, 2);
		}
		
		if($A->getA() == null) die($T);

		if($A->A("tel") != "") $T->addLV("Telefon:", self::parserTel ($A->A("tel")));
		if($A->A("fax") != "") $T->addLV("Fax:", $A->A("fax"));
		if($A->A("mobil") != "") $T->addLV("Mobil:", self::parserTel($A->A("mobil")));
		if($A->A("email") != "") $T->addLV("E-Mail:", "<a href=\"mailto:".$A->A("email")."\">".$A->A("email")."</a>");

		if(!Session::isPluginLoaded("mAnsprechpartner")) die($T);

		$AC = Ansprechpartner::getAnsprechpartner("Adresse", $kundennummer);
		$TAP = new HTMLTable(2);
		$TAP->setColWidth(1, 120);
		while($AP = $AC->getNextEntry()){
			if(trim($AP->A("AnsprechpartnerVorname")." ".$AP->A("AnsprechpartnerNachname")) != ""){
				$TAP->insertSpaceAbove($AP->A("AnsprechpartnerPosition"));
				$TAP->addLV("Name:", $AP->A("AnsprechpartnerVorname")." ".$AP->A("AnsprechpartnerNachname"));
				
				if($AP->A("AnsprechpartnerTel") != ""){
					$B = AdresseGUI::getCallButton($AP->A("AnsprechpartnerTel"), "telephone");
					$B->style("float:right;");
					
					$TAP->addLV("Telefon:", $B.$AP->A("AnsprechpartnerTel"));
				}
				
				if($AP->A("AnsprechpartnerMobil") != ""){
					$B = AdresseGUI::getCallButton($AP->A("AnsprechpartnerMobil"), "mobile");
					$B->style("float:right;");
					
					$TAP->addLV("Mobil:", $B.$AP->A("AnsprechpartnerMobil"));
				}
				
				if($AP->A("AnsprechpartnerEmail") != "")
					$TAP->addLV("E-Mail:", "<a href=\"mailto:".$AP->A("AnsprechpartnerEmail")."\">".$AP->A("AnsprechpartnerEmail")."</a>");
			}
		}

		echo $T.$TAP;
	}

	public static function parserTel($w){
		if(trim($w) == "")
			return "";
		$B = new Button("$w anrufen", "./images/i2/telephone.png", "icon");
		$B->style("float:right;");
		
		return "<a href=\"tel:$w\">".$B."</a>".$w;
	}
	
	public function getACData($attributeName, $query, $options = null){
		if($options !== null AND $options[0] == "{" AND mb_substr($options, -1) == "}")
			$options = json_decode($options);
		
		
		/*if($attributeName == "SendMailTo"){
			$AC = anyC::get("Adresse");
		
			#$AC->setSearchStringV3($query);
			#$AC->setSearchFieldsV3(array("firma", "nachname", "email"));
		
			if(strpos($query, "@") !== false)
				$AC->addAssocV3("email", "LIKE", "%$query%", "AND", "1");
			else {
				$AC->addAssocV3("firma", "LIKE", "%$query%", "AND", "1");
				$AC->addAssocV3("nachname", "LIKE", "%$query%", "OR", "1");
				$AC->addAssocV3("CONCAT(vorname, ' ', nachname)", "LIKE", "%$query%", "OR", "1");
			}
			
			$AC->addAssocV3("AuftragID","=","-1", "AND", "2");
			$AC->setFieldsV3(array("IF(nachname != '', CONCAT(vorname, ' ', nachname), firma) AS label", "AdresseID AS value", "vorname", "nachname", "email AS description","email", "firma"));
			
			if(Session::isPluginLoaded("mAdressBuch")){
				$ACAB = anyC::get("AdressBuch");
				$ACAB->addAssocV3("AdressBuchUserID", "=", Session::currentUser()->getID());
				$ACAB->addAssocV3("AdressBuchTyp", "=", "2");

				$i = 0;
				$AC->addAssocV3("type","=","default", "AND", "3");
				while($AB = $ACAB->getNextEntry())
					$AC->addAssocV3 ("type", "=", "AB".$AB->getID(), "OR", "3");
			}
			
			$AC->addAssocV3 ("email", "!=", "");
			#$AC->setParser("description", "AdressenGUI::parserACDescriptionEmail");
			
			Aspect::joinPoint("query", $this, __METHOD__, $AC);
			echo $AC->asJSON();
			die();
		#$this->setParser("email", "AdressenGUI::parserACEmail");
		}*/
		
		$fields = $this->searchFields;
		foreach($fields AS $k => $v){
			if($v == "VornameNachname")
				$fields[$k] = "CONCAT(vorname, ' ', nachname)";
			if($v == "NachnameVorname")
				$fields[$k] = "CONCAT(nachname, ' ', vorname)";
		}
		
		$this->addJoinV3("Kappendix", "AdresseID", "=", "AdresseID");
		$this->setSearchStringV3($query);
		$this->setSearchFieldsV3($fields);
		
		$this->setFieldsV3(array("firma AS label", "t1.AdresseID AS value", "vorname", "nachname", "CONCAT(strasse, ' ', nr, ', ', plz, ' ', ort) AS description","email", "firma"));
		
		$this->setLimitV3("10");
		$this->setParser("label", "AdressenGUI::parserACLabel");
		
		Aspect::joinPoint("query", $this, __METHOD__, $this);
		
		$append = null;
		if(isset($options->createNew)){
			$sex = explode("::", $options->createNew);
			$append = array("label" => "Neue Adresse erstellen", "script" => OnEvent::popup("Adresse erstellen", $sex[0], "-1", $sex[1]));
		}
		
		echo $this->asJSON($append);
	}
	
	public static function parserACDescription($w, $m, $E){
		if(trim($w) == ",")
			$w = "";
		
		if($E->A("firma") != "" AND $E->A("nachame") != "")
			return $w.($w != "" ? "<br />" : "")."Firma ".$E->A("firma");
		
		return $w;
	}
	
	public static function parserACEmail($w, $m, $E){
		$name = trim($E->A("firma"));
		if($name == "")
			$name = trim(trim($E->A("vorname"))." ".trim($E->A("nachname")));
		
		if($name == "")
			return $E->A("email");
		
		$name = str_replace("<", "", $name);
		
		return trim($name." <".$E->A("email").">");
	}
	
	public static function parserACLabel($w, $m, $E){
		return $w != "" ? $w : trim($E->A("vorname")." ".$E->A("nachname"));
	}
	
	public function getACHTML($attributeName, $query){
		$this->inAC = true;
		$gui = new HTMLGUI();
		
		$fields = $this->searchFields;
		$settings = mUserdata::getUDValueS("searchAdressen", "");
		if($settings != "")
			$fields = explode(",", $settings);
		
		foreach($fields AS $k => $v){
			if($v == "VornameNachname")
				$fields[$k] = "CONCAT(vorname, ' ', nachname)";
			if($v == "NachnameVorname")
				$fields[$k] = "CONCAT(nachname, ' ', vorname)";
		}
		
		switch($attributeName){
			/*case "plz":
				$this->addAssocV3("plz","LIKE", $query."%");
				$this->addGroupV3("plz");
				$this->setFieldsV3(array("plz","ort"));
				$this->setLimitV3("10");
				$this->lCV3();
				
				#$gui->setAttributes($this->collector);
				#$gui->setObject($this);
				$gui->attributes(array("plz","ort"));
				echo $gui->getACHTMLBrowser();
			break;*/
		
			case "quickSearchAdressen":
			case "quickSearchmAdresse":
				$mode = "quickSearchLoadFrame";
				#$hasNr = false;
				if(is_numeric($query)){
					$AC = anyC::get("Kappendix", "kundennummer", $query);
					$i = 0;
					while($K = $AC->n())
						$this->addAssocV3("t1.AdresseID", "=", $K->A("AdresseID"), $i++ == 0 ? "AND" : "OR");
					#$this->addAssocV3("kundennummer", "LIKE", "%".$query."%");
					#$this->addAssocV3("kundennummer", "=", $query);
					if(in_array("tel", $fields))
						$this->addAssocV3("REPLACE(REPLACE(REPLACE(tel, ' ', ''), '/', ''), '-', '')", "LIKE", "%".str_replace(array(" ", "/", "-"), array("", "", ""), $query)."%", $i++ > 0 ? "OR" : "AND");
					if(in_array("mobil", $fields))
						$this->addAssocV3("REPLACE(REPLACE(REPLACE(mobil, ' ', ''), '/', ''), '-', '')", "LIKE", "%".str_replace(array(" ", "/", "-"), array("", "", ""), $query)."%", $i > 0 ? "OR" : "AND");
					Aspect::joinPoint("alterNumeric", $this, __METHOD__, array($this, $query));
					#$this->addJoinV3("Kappendix","AdresseID","=","AdresseID");
					#$hasNr = true;
				} else {
					if(array_search("kundennummer", $fields) !== false)
						unset($fields[array_search("kundennummer", $fields)]);
					#unset($this->searchFields[array_search("tel", $this->searchFields)]);
					$this->setSearchStringV3($query);
					$this->setSearchFieldsV3($fields);
				}
				
				$this->setLimitV3($this->searchLimit);
				
				$spec = mUserdata::getPluginSpecificData("Adressen");
				if(isset($spec["pluginSpecificCanUseProvision"]) AND Session::isPluginLoaded("Kunden")){
					$this->addJoinV3("Kappendix", "t1.AdresseID", "=", "AdresseID");
					$this->addAssocV3("KappendixProvisionUserID", "=", Session::currentUser()->getID());
				}
		
				Aspect::joinPoint("query", $this, __METHOD__, array($attributeName, $query));
				
				$this->lCV3();

				if(Session::isPluginLoaded("Kunden") AND $this->numLoaded() > 0){
					$AC = anyC::get("Kappendix");
					while($A = $this->getNextEntry())
						$AC->addAssocV3("t1.AdresseID", "=", $A->getID(), "OR");
					
					$this->resetPointer();
					
					$kundennummern = array();
					while($K = $AC->getNextEntry())
						$kundennummern[$K->A("AdresseID")] = $K->A("kundennummer");
					
					
					while($A = $this->getNextEntry()){
						if(!isset($kundennummern[$A->getID()]))
							continue;
						
						$A->changeA("kundennummer", $kundennummern[$A->getID()]);
					}
					
					$this->resetPointer();
				}
				
				$gui->setObject($this);
				#$gui->setAttributes($this->collector);
				$gui->setShowAttributes(array("kundennummer","firma"));
				
				#$gui->setParser("firma","AdressenGUI::ACFirmaParser",array("\$sc->nachname","\$sc->vorname"));
				$gui->setParser("firma","AdressenGUI::ACFirmaParser",array("\$sc->nachname","\$sc->vorname","\$sc->plz","\$sc->ort","\$sc->strasse"));
				
				$_SESSION["BPS"]->registerClass(get_class($gui));
				$_SESSION["BPS"]->setACProperty("targetFrame","contentLeft");
				$_SESSION["BPS"]->setACProperty("targetPlugin","Adresse");
				$gui->autoCheckSelectionMode(get_class($this));
				$gui->customize($this->customizer);
				echo "<div style=\"max-height:550px;overflow:auto;\">".$gui->getACHTMLBrowser($mode, true, Session::isPluginLoaded("mAnsprechpartner") ? "Adressen" : null, null, Session::isPluginLoaded("mAnsprechpartner") ? 0 : $this->searchLimit);
				
					
				if(Session::isPluginLoaded("mAnsprechpartner")){
					$AC = anyC::get("Ansprechpartner");
					$AC->addAssocV3("CONCAT(AnsprechpartnerVorname, ' ', AnsprechpartnerNachname)", "LIKE", "%$query%");
					$AC->addAssocV3("AnsprechpartnerOwnerClass", "=", "Adresse");
					$AC->addAssocV3("t2.AdresseID", "IS NOT", "NULL");
					$AC->setFieldsV3(array("AnsprechpartnerOwnerClassID"));
					$AC->setLimitV3(10);
					$AC->addJoinV3("Adresse", "AnsprechpartnerOwnerClassID", "=", "AdresseID");
					$AC->addJoinV3("Kappendix", "AnsprechpartnerOwnerClassID", "=", "AdresseID");
					$AC->setFieldsV3(array("t2.AdresseID", "kundennummer","firma", "AnsprechpartnerNachname AS nachname", "AnsprechpartnerVorname AS vorname", "ort", "plz", "strasse"));
					#$AC->addGroupV3("t2.AdresseID");
					Aspect::joinPoint("alterAnsprechpartner", $this, __METHOD__, array($AC, $query));
					$AC->lCV3();
					#while($AP = $AC->n())
					#	$this->addAssocV3 ("AdresseID", "=", $AP->A("AnsprechpartnerOwnerClassID"), "OR");
					
					$gui->setObject($AC);
					if($AC->numLoaded() > 0)
						echo $gui->getACHTMLBrowser($mode, false, "Ansprechpartner", "AdresseID", $this->searchLimit);
				}
				echo "</div>";
			break;

		}
	}
	
	public static function ACFirmaParser($w,$l,$p){
		$s = HTMLGUI::getArrayFromParametersString($p);
		return ($w != "" ? $w.(trim($s[0].$s[1]) != "" ? "<br /><small>$s[1] $s[0]</small>" : "") : "$s[1] $s[0]")."<br /><small style=\"color:grey;\">$s[2] $s[3]".($s[4] != "" ? ", $s[4]" : "")."</small>";
	}
	
	public function getContextMenuHTML($identifier){
		switch($identifier){
			case "searchHelp":
				$F = new HTMLFormCheckList("searchedmAdresse", $this->searchFields);
				
				foreach($this->searchFields AS $v){
					$label = ucfirst(preg_replace("/[a-z0-9]+\./", "", $v));
					if(strpos($label, " AS ") !== false){
						$ex = explode(" AS ", $label);
						$label = $ex[1];
					}
					$F->setLabel($v, $label);
				}
		
				$F->setSaveCheckListUD("Adressen", "search", true, OnEvent::closeContext());
				
				echo "<p style=\"padding:5px;\">Es werden folgende Felder durchsucht:</p>$F<p>Sie können Ihre Suchanfrage mit UND verknüpfen.<br/>Also z.B. \"Firmenname UND Ort\"</p><p><img src=\"./images/i2/searchFilter.png\" style=\"float:left;margin-right:5px;\" /> Bei der Filterung nach einem Suchbegriff wird die Kundennummer nicht berücksichtigt.</p>";
			break;
		}
		#echo "<p style=\"padding:5px;\">Es werden folgende Felder durchsucht:<br /><br />Kundennummer<br />Firma<br />Vorname<br />Nachname<br />Straße<br />Ort<br />Telefonnummer</p><p>Sie können Ihre Suchanfrage mit UND verknüpfen.<br />Also z.B. \"Firmenname UND Ort\"</p>
		#	<p><img src=\"./images/i2/searchFilter.png\" style=\"float:left;margin-right:5px;\" /> Bei der Filterung nach einem Suchbegriff wird die Kundennummer nicht berücksichtigt.</p>";

	}
	
	public static function firmaParser($w,$E){
		$s = array();
		#array("\$sc->vorname","\$sc->nachname","\$aid", "\$type", "\$tel", "\$fax", "\$email", "\$mobil", "\$homepage", __CLASS__)
		$s[0] = $E->A("vorname");
		$s[1] = $E->A("nachname");
		$s[2] = $E->getID();
		$s[3] = $E->A("type");
		$s[4] = $E->A("tel");
		$s[5] = $E->A("fax");
		$s[6] = $E->A("email");
		$s[7] = $E->A("mobil");
		$s[8] = $E->A("homepage");
		$s[9] = get_class($E);
		
		/*if(!is_array($p))
			$s = HTMLGUI::getArrayFromParametersString($p);
		else
			$s = $p;*/
		
		$SM = BPS::getProperty("AdressenGUI", "selectionMode", false);
		if($s[9] == "mAdresseGUI")
			$SM = BPS::getProperty("mAdresseGUI", "selectionMode", false);
		
		$symbols = "";
		if($s[8] != "") {
			$link = $s[8];
			if(strpos($link, "http") === false)
				$link = "http://$link";
			$symbols .= "<a href=\"".$link."\" target=\"_blank\"><img class=\"mouseoverFade\" style=\"float:right;margin-left:4px;\" src=\"./images/i2/flowers.gif\" title=\"$s[8]\" /></a>";
		}
		
		if($s[7] != "") {
			#if(Session::isPluginLoaded("mTelefonanlage")){
				$B = AdresseGUI::getCallButton($s[7], "mobile");
				$B->style("float:right;margin-left:4px;");
				$symbols .= $B;
			#} else
			#	$symbols .= "<img class=\"mouseoverFade\" style=\"float:right;margin-left:4px;\" src=\"./images/i2/mobile.png\" title=\"$s[7]\" />";
		}
		if($s[6] != "")
			$symbols .= "<a href=\"mailto:$s[6]\"><img class=\"mouseoverFade\" style=\"float:right;margin-left:4px;\" src=\"./images/i2/email.png\" title=\"$s[6]\" /></a>";
		if($s[5] != "")
			$symbols .= "<img class=\"mouseoverFade\" style=\"float:right;margin-left:4px;\" src=\"./images/i2/fax.png\" title=\"$s[5]\" />";
		if($s[4] != "") {
			#if(Session::isPluginLoaded("mTelefonanlage")){
				$B = AdresseGUI::getCallButton($s[4]);
				$B->style("float:right;margin-left:4px;");
				$symbols .= $B;
			#} else
			#	$symbols .= "<img class=\"mouseoverFade\" style=\"float:right;margin-left:4px;\" src=\"./images/i2/telephone.png\" title=\"$s[4]\" />";
		}
		
		return $symbols.((Session::isPluginLoaded("Kunden") AND $s[3] == "default" AND !$SM) ? 
		"<img src=\"./images/i2/kunde.png\" title=\"Kundendaten anzeigen/erstellen\" onclick=\"contentManager.selectRow(this); contentManager.loadFrame('contentLeft', 'Kunde', -1, 0, 'KundeGUI;AdresseID:$s[2];action:Kappendix');\" style=\"float:left;margin-right:4px;\" class=\"mouseoverFade\" />" : "")
		.((Session::isPluginLoaded("Kundenpreise") AND $s[3] == "default" AND !$SM) ? "<img src=\"./images/i2/kundenpreis.png\" title=\"Kundenpreise festlegen\" onclick=\"contentManager.selectRow(this); contentManager.loadFrame('contentLeft','Kunde', -1, 0,'KundeGUI;AdresseID:$s[2];action:Kundenpreise');\" style=\"float:left;margin-right:4px;\" class=\"mouseoverFade\" />" : "")
		.((Session::isPluginLoaded("labelPrinter") AND $s[3] == "default") ? "<img src=\"./images/i2/printer.png\" title=\"Etikette mit Adresse drucken\" onclick=\"rme('labelPrinter','','printEtikette','$s[2]');\" style=\"float:left;margin-right:4px;\" class=\"mouseoverFade\" />" : "")
		."<div style=\"margin-left:".(21 + (Session::isPluginLoaded("Kundenpreise") ? 21 : 0) + (Session::isPluginLoaded("labelPrinter") ? 21 : 0))."px;\">". ($w != "" ? htmlspecialchars(stripslashes($w)).(($s[1] != "" OR $s[0] != "") ? "<br /><small>".htmlspecialchars($s[0]." ".$s[1])."</small>" : "") : htmlspecialchars($s[0]." ".$s[1]))."</div>";
	}

	public static function doSomethingElse(){
		if(!isset($_SESSION[$_SESSION["applications"]->getActiveApplication()]["kategorien"]))
			$_SESSION[$_SESSION["applications"]->getActiveApplication()]["kategorien"] = array();

		$_SESSION[$_SESSION["applications"]->getActiveApplication()]["kategorien"]["Adressen"] = "1";
	}

	public function openHP($url){
		header("Location: ".(substr($url, 0, 4) != "http" ? "http://" : "")."$url");
		exit();
	}

	public function getSearchedFields() {
		$SF = $this->searchFields;
		unset($SF[array_search("kundennummer", $SF)]);
		
		if(in_array("VornameNachname", $SF))
			$SF[array_search("VornameNachname", $SF)] = "CONCAT(vorname, ' ', nachname)";
		
		if(in_array("NachnameVorname", $SF))
			$SF[array_search("NachnameVorname", $SF)] = "CONCAT(nachname, ' ', vorname)";
		
		return $SF;
	}

	function getAvailableCategories(){
		$kat = new Kategorien();
		$kat->addAssocV3("type","=","1");
		return $kat->getArrayWithKeysAndValues();
	}
	
	function getCategoryFieldName(){
		return "t1.KategorieID";
	}
	
	#public function getCategoryFieldLabel(array $KIDs){
		
	#}
	
	public function checkDoubles($strasse, $nr, $plz){
		if(trim($strasse) == "")
			return "";
		
		$AC = anyC::get("Adresse", "AuftragID", "-1");
		$AC->addAssocV3("strasse", "LIKE", "$strasse%");
		if($nr != "")
			$AC->addAssocV3("nr", "=", "$nr");
		if($plz != "")
			$AC->addAssocV3("plz", "=", "$plz");
		$AC->setLimitV3(10);
		
		$AC->lCV3();
		
		if($AC->numLoaded() == 0){
			$B = new Button("", "bestaetigung", "icon");
			$B->style("float:left;margin-right:5px;");
					
			die($B."<span style=\"color:grey;\">Keine ähnliche Adresse gefunden.</span>");
		}
		
		if($AC->numLoaded() > 0){
			$B = new Button("", "notice", "icon");
			$B->style("float:left;margin-right:10px;");
			
			$L = new HTMLList();
			$L->noDots();
			#$T->weight("light");
			while($A = $AC->n()){
				$L->addItem($A->getShortAddress()."<br><small style=\"color:grey;\">".$A->A("strasse")." ".$A->A("nr")."<br>".$A->A("plz")." ".$A->A("ort")."</small>");
				$L->addItemStyle("width:50%;display:inline-block;vertical-align:top;margin:0;margin-bottom:15px;");
			}
			die("<div class=\"highlight\" style=\"padding:5px;box-sizing:border-box;\">".$B."<span style=\"\">".$AC->numLoaded()." ähnliche Adresse".($AC->numLoaded() == 1 ? "" :"n")." gefunden.</span><div style=\"clear:both;height:10px;\"></div></div><div style=\"clear:both;height:10px;\"></div>".$L);
		}
		
		
	}

	public function getOrderByFields() {
		$o = new stdClass();
		$o->label = "Firma/Nachname gemischt";
		$o->orderBy = array("KategorieID", "CONCAT(firma, nachname)");
		
		if(!Session::isPluginLoaded("Kunden"))
			return array($o);
		
		$o2 = new stdClass();
		$o2->label = "Kundennummer";
		$o2->orderBy = array("KategorieID", "kundennummer", "CONCAT(firma, nachname)");
		
		return array($o, $o2);
	}

}
?>
