<?php
/*
 *  This file is part of open3A.

 *  open3A is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  open3A is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 *  2007 - 2020, open3A GmbH - Support@open3A.de
 */
class Adressen extends anyC implements iPluginSpecificRestrictions {
	function __construct() {
		$this->setCollectionOf("Adresse");
		$this->addAssocV3("AuftragID","=","-1");
		#$this->addOrderV3("nachname","ASC");
	}
	
	function getPluginSpecificRestrictions(){
		return array("pluginSpecificCanUse1xAdresse" => "kann NUR vorhandene und 1x-Adressen verwenden", "pluginSpecificCanUseProvision" => "kann NUR Adressen mit Provision verwenden");
	}
	
	public function getEtiketten(){
		$KID = BPS::getProperty("AdressenGUI", "etikettenKID", 0);
		
		#$Auftrag = new Auftrag($this->A("AuftragID"));
		#$Adresse = new Adresse($Auftrag->A("AdresseID"));

		$Stammdaten = Stammdaten::getActiveStammdaten();

		if($KID > 0){
			$AC = anyC::get("Adresse", "type", "default");
			$AC->addAssocV3("AuftragID", "=", "-1");
			$AC->addAssocV3("KategorieID", "=", $KID);
		} 
		
		if($KID == 0){
			$AC = new AdressenGUI();
			$AC->filterCategories();
		}
		
		$a = array();
		while($Ad = $AC->n())
			$a[] = array($Stammdaten->A("firmaLang").", ".$Stammdaten->A("strasse")." ".$Stammdaten->A("nr").", ".$Stammdaten->A("plz")." ".$Stammdaten->A("ort").(ISO3166::getCountryToCode($Stammdaten->A("land")) != $Ad->A("land") ? ", ".ISO3166::getCountryToCode($Stammdaten->A("land")) : ""), $Ad->getFormattedAddress());
		
		return $a;
	}
	
	public function findByPhone($number){
		$AC = anyC::get("Adresse", "AuftragID", "-1");
		$AC->addAssocV3("tel", "=", $number);
		$AC->addAssocV3("mobil", "=", $number, "OR");
		
		$A = $AC->n();
		if($A != null)
			return "WAdresse:".$A->getID();
		
		
		$AC = anyC::get("Ansprechpartner", "AnsprechpartnerOwnerClass", "Adresse");
		$AC->addAssocV3("AnsprechpartnerTel", "=", $number, "AND", "2");
		$AC->addAssocV3("AnsprechpartnerMobil", "=", $number, "OR", "2");

		$A = $AC->n();
		if($A != null)
			return "WAdresse:".$A->A("AnsprechpartnerOwnerClassID");
		
		
		$AC = anyC::get("Lieferant", "LieferantTel", $number);
		$A = $AC->n();
		if($A != null)
			return "Lieferant:".$A->getID();
		
		
		$AC = anyC::get("Ansprechpartner", "AnsprechpartnerOwnerClass", "Lieferant");
		$AC->addAssocV3("AnsprechpartnerTel", "=", $number, "AND", "2");
		$AC->addAssocV3("AnsprechpartnerMobil", "=", $number, "OR", "2");

		$A = $AC->n();
		if($A != null)
			return "Lieferant:".$A->A("AnsprechpartnerOwnerClassID");
		
		
		return null;
	}

}
?>
