<?php
/*
 *  This file is part of open3A.

 *  open3A is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  open3A is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 *  2007 - 2020, open3A GmbH - Support@open3A.de
 */

class AbschlagsrechnungGUI {
	public function createNewFromBeleg($fromGRLBMID, $toGRLBMID, $percent, $absolute = ""){
		if($fromGRLBMID == "0")
			Red::alertD ("Bitte wählen Sie eine Bestätigung aus.");
		
		$percent = Util::CLNumberParserZ($percent, "store");
		$percent = $percent / 100;
		
		$fromGRLBM = new GRLBM($fromGRLBMID);
		$toGRLBM = new GRLBM($toGRLBMID);
		
		if($fromGRLBMID != -1)
			$preise = $fromGRLBM->getSumOfPosten(true);
		else {
			$mwst = Util::CLNumberParserZ(str_replace("%", "", Kategorien::getDefault("mwst", 0)), "store");
			$preise = array(6 => array($mwst => 0));
		}
		
		if($absolute == "")
			foreach($preise[6] AS $mwst => $netprice)
				$toGRLBM->addPosten("Abschlagszahlung", "", 1, $netprice * $percent, $mwst, "zu Auftragsbestätigung ".$fromGRLBM->A("prefix").$fromGRLBM->A("nummer")." vom ".$fromGRLBM->A("datum"), false, null, $netprice * $percent);
		else {
			$absolute = Util::CLNumberParserZ($absolute, "store");
			
			foreach($preise[6] AS $mwst => $netprice){
				$toGRLBM->addPosten("Abschlagszahlung", "", 1, $absolute, $mwst, "zu Auftragsbestätigung ".$fromGRLBM->A("prefix").$fromGRLBM->A("nummer")." vom ".$fromGRLBM->A("datum"), false, null, $absolute);
			
				break;
			}
		}
		
		$toGRLBM->changeA("isAbschlagsrechnung", "1");
		$toGRLBM->changeA("isAbschlussrechnung", "0");
		$toGRLBM->changeA("isTeilrechnung", "0");
		$toGRLBM->saveMe();
		
		$Auftrag = new Auftrag($toGRLBM->A("AuftragID"));
		$Auftrag->updateStatus("RT");
	}
}
?>