/*! jQuery plugin for Hammer.JS - v1.0.6 - 2014-03-28
 * http://eightmedia.github.com/hammer.js
 *
 * Copyright (c) 2014 Jorik Tangelder <j.tangelder@gmail.com>;
 * Licensed under the MIT license */

!function(a,b){"use strict";function c(){e.READY||(t.determineEventTypes(),p.each(e.gestures,function(a){v.register(a)}),t.onTouch(e.DOCUMENT,n,v.detect),t.onTouch(e.DOCUMENT,o,v.detect),e.READY=!0)}function d(a,c){Date.now||(Date.now=function(){return(new Date).getTime()}),a.event.bindDom=function(d,e,f){c(d).on(e,function(c){var d=c.originalEvent||c,e=["pageX","pageY","clientX","clientY","target","preventDefault","stopPropagation"];a.utils.each(e,function(a){null==d[a]&&(d[a]=c[a])}),d.which===b&&(d.which=d.button),f.call(this,d)})},a.utils.each(["on","off"],function(b){a.Instance.prototype[b]=function(a,d){return c(this.element)[b](a,d)}}),a.Instance.prototype.trigger=function(a,b){var d=c(this.element);return d.has(b.target).length&&(d=c(b.target)),d.trigger({type:a,gesture:b})},c.fn.hammer=function(b){return this.each(function(){var d=c(this),e=d.data("hammer");e?e&&b&&a.utils.extend(e.options,b):d.data("hammer",new a(this,b||{}))})}}var e=function(a,b){return new e.Instance(a,b||{})};e.VERSION="1.0.10",e.defaults={stop_browser_behavior:{userSelect:"none",touchAction:"none",touchCallout:"none",contentZooming:"none",userDrag:"none",tapHighlightColor:"rgba(0,0,0,0)"}},e.HAS_POINTEREVENTS=a.navigator.pointerEnabled||a.navigator.msPointerEnabled,e.HAS_TOUCHEVENTS="ontouchstart"in a,e.MOBILE_REGEX=/mobile|tablet|ip(ad|hone|od)|android|silk/i,e.NO_MOUSEEVENTS=e.HAS_TOUCHEVENTS&&a.navigator.userAgent.match(e.MOBILE_REGEX),e.EVENT_TYPES={},e.UPDATE_VELOCITY_INTERVAL=16,e.DOCUMENT=a.document;var f=e.DIRECTION_DOWN="down",g=e.DIRECTION_LEFT="left",h=e.DIRECTION_UP="up",i=e.DIRECTION_RIGHT="right",j=e.POINTER_MOUSE="mouse",k=e.POINTER_TOUCH="touch",l=e.POINTER_PEN="pen",m=e.EVENT_START="start",n=e.EVENT_MOVE="move",o=e.EVENT_END="end";e.plugins=e.plugins||{},e.gestures=e.gestures||{},e.READY=!1;var p=e.utils={extend:function(a,c,d){for(var e in c)a[e]!==b&&d||(a[e]=c[e]);return a},each:function(a,c,d){var e,f;if("forEach"in a)a.forEach(c,d);else if(a.length!==b){for(e=-1;f=a[++e];)if(c.call(d,f,e,a)===!1)return}else for(e in a)if(a.hasOwnProperty(e)&&c.call(d,a[e],e,a)===!1)return},inStr:function(a,b){return a.indexOf(b)>-1},hasParent:function(a,b){for(;a;){if(a==b)return!0;a=a.parentNode}return!1},getCenter:function(a){var b=[],c=[],d=[],e=[],f=Math.min,g=Math.max;return 1===a.length?{pageX:a[0].pageX,pageY:a[0].pageY,clientX:a[0].clientX,clientY:a[0].clientY}:(p.each(a,function(a){b.push(a.pageX),c.push(a.pageY),d.push(a.clientX),e.push(a.clientY)}),{pageX:(f.apply(Math,b)+g.apply(Math,b))/2,pageY:(f.apply(Math,c)+g.apply(Math,c))/2,clientX:(f.apply(Math,d)+g.apply(Math,d))/2,clientY:(f.apply(Math,e)+g.apply(Math,e))/2})},getVelocity:function(a,b,c){return{x:Math.abs(b/a)||0,y:Math.abs(c/a)||0}},getAngle:function(a,b){var c=b.clientX-a.clientX,d=b.clientY-a.clientY;return 180*Math.atan2(d,c)/Math.PI},getDirection:function(a,b){var c=Math.abs(a.clientX-b.clientX),d=Math.abs(a.clientY-b.clientY);return c>=d?a.clientX-b.clientX>0?g:i:a.clientY-b.clientY>0?h:f},getDistance:function(a,b){var c=b.clientX-a.clientX,d=b.clientY-a.clientY;return Math.sqrt(c*c+d*d)},getScale:function(a,b){return a.length>=2&&b.length>=2?this.getDistance(b[0],b[1])/this.getDistance(a[0],a[1]):1},getRotation:function(a,b){return a.length>=2&&b.length>=2?this.getAngle(b[1],b[0])-this.getAngle(a[1],a[0]):0},isVertical:function(a){return a==h||a==f},toggleDefaultBehavior:function(a,b,c){if(b&&a&&a.style){p.each(["webkit","moz","Moz","ms","o",""],function(d){p.each(b,function(b,e){d&&(e=d+e.substring(0,1).toUpperCase()+e.substring(1)),e in a.style&&(a.style[e]=!c&&b)})});var d=function(){return!1};"none"==b.userSelect&&(a.onselectstart=!c&&d),"none"==b.userDrag&&(a.ondragstart=!c&&d)}}};e.Instance=function(a,b){var d=this;return c(),this.element=a,this.enabled=!0,this.options=p.extend(p.extend({},e.defaults),b||{}),this.options.stop_browser_behavior&&p.toggleDefaultBehavior(this.element,this.options.stop_browser_behavior,!1),this.eventStartHandler=t.onTouch(a,m,function(a){d.enabled&&v.startDetect(d,a)}),this.eventHandlers=[],this},e.Instance.prototype={on:function(a,b){var c=a.split(" ");return p.each(c,function(a){this.element.addEventListener(a,b,!1),this.eventHandlers.push({gesture:a,handler:b})},this),this},off:function(a,b){var c,d,e=a.split(" ");return p.each(e,function(a){for(this.element.removeEventListener(a,b,!1),c=-1;d=this.eventHandlers[++c];)d.gesture===a&&d.handler===b&&this.eventHandlers.splice(c,1)},this),this},trigger:function(a,b){b||(b={});var c=e.DOCUMENT.createEvent("Event");c.initEvent(a,!0,!0),c.gesture=b;var d=this.element;return p.hasParent(b.target,d)&&(d=b.target),d.dispatchEvent(c),this},enable:function(a){return this.enabled=a,this},dispose:function(){var a,b;for(this.options.stop_browser_behavior&&p.toggleDefaultBehavior(this.element,this.options.stop_browser_behavior,!0),a=-1;b=this.eventHandlers[++a];)this.element.removeEventListener(b.gesture,b.handler,!1);return this.eventHandlers=[],t.unbindDom(this.element,e.EVENT_TYPES[m],this.eventStartHandler),null}};var q=null,r=!1,s=!1,t=e.event={bindDom:function(a,b,c){var d=b.split(" ");p.each(d,function(b){a.addEventListener(b,c,!1)})},unbindDom:function(a,b,c){var d=b.split(" ");p.each(d,function(b){a.removeEventListener(b,c,!1)})},onTouch:function(a,b,c){var d=this,f=function(f){var g=f.type.toLowerCase();if(!p.inStr(g,"mouse")||!s){p.inStr(g,"touch")||p.inStr(g,"pointerdown")||p.inStr(g,"mouse")&&1===f.which?r=!0:p.inStr(g,"mouse")&&!f.which&&(r=!1),(p.inStr(g,"touch")||p.inStr(g,"pointer"))&&(s=!0);var h=0;r&&(e.HAS_POINTEREVENTS&&b!=o?h=u.updatePointer(b,f):p.inStr(g,"touch")?h=f.touches.length:s||(h=p.inStr(g,"up")?0:1),h>0&&b==o?b=n:h||(b=o),(h||null===q)&&(q=f),c.call(v,d.collectEventData(a,b,d.getTouchList(q,b),f)),e.HAS_POINTEREVENTS&&b==o&&(h=u.updatePointer(b,f))),h||(q=null,r=!1,s=!1,u.reset())}};return this.bindDom(a,e.EVENT_TYPES[b],f),f},determineEventTypes:function(){var a;a=e.HAS_POINTEREVENTS?u.getEvents():e.NO_MOUSEEVENTS?["touchstart","touchmove","touchend touchcancel"]:["touchstart mousedown","touchmove mousemove","touchend touchcancel mouseup"],e.EVENT_TYPES[m]=a[0],e.EVENT_TYPES[n]=a[1],e.EVENT_TYPES[o]=a[2]},getTouchList:function(a){return e.HAS_POINTEREVENTS?u.getTouchList():a.touches?a.touches:(a.identifier=1,[a])},collectEventData:function(a,b,c,d){var e=k;return(p.inStr(d.type,"mouse")||u.matchType(j,d))&&(e=j),{center:p.getCenter(c),timeStamp:Date.now(),target:d.target,touches:c,eventType:b,pointerType:e,srcEvent:d,preventDefault:function(){var a=this.srcEvent;a.preventManipulation&&a.preventManipulation(),a.preventDefault&&a.preventDefault()},stopPropagation:function(){this.srcEvent.stopPropagation()},stopDetect:function(){return v.stopDetect()}}}},u=e.PointerEvent={pointers:{},getTouchList:function(){var a=[];return p.each(this.pointers,function(b){a.push(b)}),a},updatePointer:function(a,b){return a==o?delete this.pointers[b.pointerId]:(b.identifier=b.pointerId,this.pointers[b.pointerId]=b),Object.keys(this.pointers).length},matchType:function(a,b){if(!b.pointerType)return!1;var c=b.pointerType,d={};return d[j]=c===j,d[k]=c===k,d[l]=c===l,d[a]},getEvents:function(){return["pointerdown MSPointerDown","pointermove MSPointerMove","pointerup pointercancel MSPointerUp MSPointerCancel"]},reset:function(){this.pointers={}}},v=e.detection={gestures:[],current:null,previous:null,stopped:!1,startDetect:function(a,b){this.current||(this.stopped=!1,this.current={inst:a,startEvent:p.extend({},b),lastEvent:!1,lastVelocityEvent:!1,velocity:!1,name:""},this.detect(b))},detect:function(a){if(this.current&&!this.stopped){a=this.extendEventData(a);var b=this.current.inst,c=b.options;return p.each(this.gestures,function(d){return this.stopped||c[d.name]===!1||b.enabled===!1||d.handler.call(d,a,b)!==!1?void 0:(this.stopDetect(),!1)},this),this.current&&(this.current.lastEvent=a),a.eventType==o&&!a.touches.length-1&&this.stopDetect(),a}},stopDetect:function(){this.previous=p.extend({},this.current),this.current=null,this.stopped=!0},getVelocityData:function(a,b,c,d){var f=this.current,g=f.lastVelocityEvent,h=f.velocity;g&&a.timeStamp-g.timeStamp>e.UPDATE_VELOCITY_INTERVAL?(h=p.getVelocity(a.timeStamp-g.timeStamp,a.center.clientX-g.center.clientX,a.center.clientY-g.center.clientY),f.lastVelocityEvent=a):f.velocity||(h=p.getVelocity(b,c,d),f.lastVelocityEvent=a),f.velocity=h,a.velocityX=h.x,a.velocityY=h.y},getInterimData:function(a){var b,c,d=this.current.lastEvent;a.eventType==o?(b=d&&d.interimAngle,c=d&&d.interimDirection):(b=d&&p.getAngle(d.center,a.center),c=d&&p.getDirection(d.center,a.center)),a.interimAngle=b,a.interimDirection=c},extendEventData:function(a){var b=this.current,c=b.startEvent;(a.touches.length!=c.touches.length||a.touches===c.touches)&&(c.touches=[],p.each(a.touches,function(a){c.touches.push(p.extend({},a))}));var d=a.timeStamp-c.timeStamp,e=a.center.clientX-c.center.clientX,f=a.center.clientY-c.center.clientY;return this.getVelocityData(a,d,e,f),this.getInterimData(a),p.extend(a,{startEvent:c,deltaTime:d,deltaX:e,deltaY:f,distance:p.getDistance(c.center,a.center),angle:p.getAngle(c.center,a.center),direction:p.getDirection(c.center,a.center),scale:p.getScale(c.touches,a.touches),rotation:p.getRotation(c.touches,a.touches)}),a},register:function(a){var c=a.defaults||{};return c[a.name]===b&&(c[a.name]=!0),p.extend(e.defaults,c,!0),a.index=a.index||1e3,this.gestures.push(a),this.gestures.sort(function(a,b){return a.index<b.index?-1:a.index>b.index?1:0}),this.gestures}};e.gestures.Drag={name:"drag",index:50,defaults:{drag_min_distance:10,correct_for_drag_min_distance:!0,drag_max_touches:1,drag_block_horizontal:!1,drag_block_vertical:!1,drag_lock_to_axis:!1,drag_lock_min_distance:25},triggered:!1,handler:function(a,b){var c=v.current;if(c.name!=this.name&&this.triggered)return b.trigger(this.name+"end",a),void(this.triggered=!1);if(!(b.options.drag_max_touches>0&&a.touches.length>b.options.drag_max_touches))switch(a.eventType){case m:this.triggered=!1;break;case n:if(a.distance<b.options.drag_min_distance&&c.name!=this.name)return;var d=c.startEvent.center;if(c.name!=this.name&&(c.name=this.name,b.options.correct_for_drag_min_distance&&a.distance>0)){var e=Math.abs(b.options.drag_min_distance/a.distance);d.pageX+=a.deltaX*e,d.pageY+=a.deltaY*e,d.clientX+=a.deltaX*e,d.clientY+=a.deltaY*e,a=v.extendEventData(a)}(c.lastEvent.drag_locked_to_axis||b.options.drag_lock_to_axis&&b.options.drag_lock_min_distance<=a.distance)&&(a.drag_locked_to_axis=!0);var j=c.lastEvent.direction;a.drag_locked_to_axis&&j!==a.direction&&(a.direction=p.isVertical(j)?a.deltaY<0?h:f:a.deltaX<0?g:i),this.triggered||(b.trigger(this.name+"start",a),this.triggered=!0),b.trigger(this.name,a),b.trigger(this.name+a.direction,a);var k=p.isVertical(a.direction);(b.options.drag_block_vertical&&k||b.options.drag_block_horizontal&&!k)&&a.preventDefault();break;case o:this.triggered&&b.trigger(this.name+"end",a),this.triggered=!1}}},e.gestures.Hold={name:"hold",index:10,defaults:{hold_timeout:500,hold_threshold:2},timer:null,handler:function(a,b){switch(a.eventType){case m:clearTimeout(this.timer),v.current.name=this.name,this.timer=setTimeout(function(){"hold"==v.current.name&&b.trigger("hold",a)},b.options.hold_timeout);break;case n:a.distance>b.options.hold_threshold&&clearTimeout(this.timer);break;case o:clearTimeout(this.timer)}}},e.gestures.Release={name:"release",index:1/0,handler:function(a,b){a.eventType==o&&b.trigger(this.name,a)}},e.gestures.Swipe={name:"swipe",index:40,defaults:{swipe_min_touches:1,swipe_max_touches:1,swipe_velocity:.7},handler:function(a,b){if(a.eventType==o){if(a.touches.length<b.options.swipe_min_touches||a.touches.length>b.options.swipe_max_touches)return;(a.velocityX>b.options.swipe_velocity||a.velocityY>b.options.swipe_velocity)&&(b.trigger(this.name,a),b.trigger(this.name+a.direction,a))}}},e.gestures.Tap={name:"tap",index:100,defaults:{tap_max_touchtime:250,tap_max_distance:10,tap_always:!0,doubletap_distance:20,doubletap_interval:300},has_moved:!1,handler:function(a,b){var c,d,e;a.eventType==m?this.has_moved=!1:a.eventType!=n||this.moved?a.eventType==o&&"touchcancel"!=a.srcEvent.type&&a.deltaTime<b.options.tap_max_touchtime&&!this.has_moved&&(c=v.previous,d=c&&c.lastEvent&&a.timeStamp-c.lastEvent.timeStamp,e=!1,c&&"tap"==c.name&&d&&d<b.options.doubletap_interval&&a.distance<b.options.doubletap_distance&&(b.trigger("doubletap",a),e=!0),(!e||b.options.tap_always)&&(v.current.name="tap",b.trigger(v.current.name,a))):this.has_moved=a.distance>b.options.tap_max_distance}},e.gestures.Touch={name:"touch",index:-1/0,defaults:{prevent_default:!1,prevent_mouseevents:!1},handler:function(a,b){return b.options.prevent_mouseevents&&a.pointerType==j?void a.stopDetect():(b.options.prevent_default&&a.preventDefault(),void(a.eventType==m&&b.trigger(this.name,a)))}},e.gestures.Transform={name:"transform",index:45,defaults:{transform_min_scale:.01,transform_min_rotation:1,transform_always_block:!1,transform_within_instance:!1},triggered:!1,handler:function(a,b){if(v.current.name!=this.name&&this.triggered)return b.trigger(this.name+"end",a),void(this.triggered=!1);if(!(a.touches.length<2)){if(b.options.transform_always_block&&a.preventDefault(),b.options.transform_within_instance)for(var c=-1;a.touches[++c];)if(!p.hasParent(a.touches[c].target,b.element))return;switch(a.eventType){case m:this.triggered=!1;break;case n:var d=Math.abs(1-a.scale),e=Math.abs(a.rotation);if(d<b.options.transform_min_scale&&e<b.options.transform_min_rotation)return;v.current.name=this.name,this.triggered||(b.trigger(this.name+"start",a),this.triggered=!0),b.trigger(this.name,a),e>b.options.transform_min_rotation&&b.trigger("rotate",a),d>b.options.transform_min_scale&&(b.trigger("pinch",a),b.trigger("pinch"+(a.scale<1?"in":"out"),a));break;case o:this.triggered&&b.trigger(this.name+"end",a),this.triggered=!1}}}},a.Hammer=e,"object"==typeof module&&module.exports&&(module.exports=e),"function"==typeof define&&define.amd?define(["jquery"],function(b){return d(a.Hammer,b)}):d(a.Hammer,a.jQuery||a.Zepto)}(window);
//# sourceMappingURL=jquery.hammer-full.min.map