<?php
/**
 *  This file is part of openWaWi.

 *  openWaWi is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  openWaWi is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 *  2007 - 2020, open3A GmbH - Support@open3A.de
 */
class RabattgruppeGUI extends Rabattgruppe implements iGUIHTML2 {
	function getHTML($id){
		$gui = new HTMLGUIX($this);
		$gui->name("Rabattgruppe");
	
		$gui->attributes(array("RabattgruppeLieferantID", "RabattgruppeNummer", "RabattgruppeName", "RabattgruppeKennzeichen", "RabattgruppeWert"));
		
		$gui->space("RabattgruppeKennzeichen");
		
		$gui->label("RabattgruppeLieferantID", "Lieferant");
		
		$gui->type("RabattgruppeLieferantID", "select", new mLieferant(), "LieferantFirma");
		
		$gui->type("RabattgruppeKennzeichen", "select", array("1" => "Rabatt", "2" => "Multiplikator"));
		
		$gui->descriptionField("RabattgruppeWert", "Multiplikator: Tragen Sie 1500 für einen Multiplikator von 1,5 ein<br>Rabatt: Für 15% Rabatt tragen Sie 1500 ein");
		
		return $gui->getEditHTML();
	}
}
?>