<?php
/**
 *  This file is part of openWaWi.

 *  openWaWi is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  openWaWi is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 *  2007 - 2020, open3A GmbH - Support@open3A.de
 */
class LieferantPreis extends PersistentObject {
	public function getEK(){
		if($this->A("LieferantPreisRabattgruppe") != "" AND $this->A("LieferantPreisRabattgruppe") != "0"){
			$AC = anyC::get("Rabattgruppe", "RabattgruppeNummer", $this->A("LieferantPreisRabattgruppe"));
			$AC->addAssocV3("RabattgruppeLieferantID", "=", $this->A("LieferantPreisLieferantID"));
					
			$R = $AC->getNextEntry();
			if($R == null)
				return null;

			if($R->A("RabattgruppeWert") == "0")
				return $this->add($this->A("LieferantPreisListenPreis"));
			
			if($R->A("RabattgruppeKennzeichen") == "2"){

				$usePreis = $this->A("LieferantPreisListenPreis");

				$newEK1 = $usePreis * ($R->A("RabattgruppeWert") / 1000);

				return $this->add($newEK1);
			}

			if($R->A("RabattgruppeKennzeichen") == "1"){
				$usePreis = $this->A("LieferantPreisListenPreis");

				$newEK1 = (1 - $R->A("RabattgruppeWert") / 10000) * $usePreis;#$usePreis - ($usePreis * ());

				return $this->add($newEK1);
			}
		}
		
		return $this->add($this->A("LieferantPreisListenPreis"));
	}
	
	private function add($LP){
		$LP += $this->A("LieferantPreisSonstiges1");
		
		$fracht = $this->A("LieferantPreisFracht");
		if($this->A("LieferantPreisFrachtMode") == 1)
			$fracht = $LP * ($this->A("LieferantPreisFracht") / 100);
		
		return $LP + $fracht + $this->A("LieferantPreisVerpackung") + $this->A("LieferantPreisSonstiges");
	}
	
	public function getLP(){
		return $this->A("LieferantPreisListenPreis") * 1;
	}
	
	public function saveMultiEditField($fieldName, $value){
		$this->changeA($fieldName, $value);
		$this->saveMe(true, true);
	}
	
	/*public function addToBeleg($ArtikelID, $GRLBMID){
		$Posten = new Posten(-1);
		$Posten->skipLieferantTest = true;
		$id = $Posten->newFromArtikel($ArtikelID, $GRLBMID, 1, null, null, null, 0, $this->A("LieferantPreisLieferantID"));
		
	}*/
}
?>