<?php
/**
 *  This file is part of openWaWi.

 *  openWaWi is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  openWaWi is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 *  2007 - 2020, open3A GmbH - Support@open3A.de
 */
class Lieferant extends PersistentObject {
	public function newMe($checkUserData = true, $output = false) {
		$newID = parent::newMe($checkUserData, $output);

		/*if(Session::isPluginLoaded("mAnsprechpartner")){
			$AC = anyC::get("Ansprechpartner", "AnsprechpartnerOwnerClass", "Lieferant");
			$AC->addAssocV3("AnsprechpartnerOwnerClassID", "=", "-1");
			while($A = $AC->getNextEntry()){
				$A->changeA("AnsprechpartnerOwnerClassID", $newID);
				$A->saveMe();
			}
		}*/
		
		return $newID;
	}
	
	public function newAttributes() {
		$A = parent::newAttributes();
		
		$AC = anyC::get("Kategorie", "type", "mwst");
		$AC->addAssocV3("isDefault", "=", "1");
		$M = $AC->getNextEntry();
		if($M != null)
			$A->LieferantMwStSatz = Util::parseFloat("de_DE",str_replace("%","",$M->A("name")));
		
		return $A;
	}
	
	/**
	 * @return Factory
	 */
	public function getNewAdresse(){
		/*$A = new Adresse(-1);
		$A->loadMeOrEmpty();*/
		$A = new Factory("Adresse");
		
		$A->sA("firma", $this->A("LieferantFirma"));
		$A->sA("strasse", $this->A("LieferantStrasse"));
		$A->sA("ort", $this->A("LieferantOrt"));
		$A->sA("nr", $this->A("LieferantHausnummer"));
		$A->sA("plz", $this->A("LieferantPLZ"));
		$A->sA("tel", $this->A("LieferantTel"));
		$A->sA("fax", $this->A("LieferantFax"));
		$A->sA("email", $this->A("LieferantEMail"));
		if($this->A("LieferantLand") != "")
			$A->sA("land", ISO3166::getCountryToCode($this->A("LieferantLand")));
		
		$A->sA("AdresseSpracheID", $this->A("LieferantSpracheID"));
		
		return $A;
	}
	
	public function getAsAdresse(){
		$A = new Adresse(-1);
		$A->loadMeOrEmpty();
		
		$A->changeA("firma", $this->A("LieferantFirma"));
		$A->changeA("strasse", $this->A("LieferantStrasse"));
		$A->changeA("ort", $this->A("LieferantOrt"));
		$A->changeA("nr", $this->A("LieferantHausnummer"));
		$A->changeA("plz", $this->A("LieferantPLZ"));
		$A->changeA("tel", $this->A("LieferantTel"));
		$A->changeA("fax", $this->A("LieferantFax"));
		$A->changeA("email", $this->A("LieferantEMail"));
		if($this->A("LieferantLand") != "")
			$A->changeA("land", ISO3166::getCountryToCode($this->A("LieferantLand")));
		
		$A->changeA("AdresseSpracheID", $this->A("LieferantSpracheID"));
		
		return $A;
	}
	
	public function getFormattedAddress(Stammdaten $Stammdaten = null){
		$values = array();
		
		$values["firma"] = $this->A("LieferantFirma");
		$values["strasse"] = $this->A("LieferantStrasse");
		$values["ort"] = $this->A("LieferantOrt");
		$values["nr"] = $this->A("LieferantHausnummer");
		$values["plz"] = $this->A("LieferantPLZ");
		$values["tel"] = $this->A("LieferantTel");
		$values["fax"] = $this->A("LieferantFax");
		$values["email"] = $this->A("LieferantEMail");
		if($this->A("LieferantLand") != "")
			$values["land"] = ISO3166::getCountryToCode($this->A("LieferantLand"));
		
		/*if($withAnrede){
			if($this->A("vorname") != "")
				$this->changeA("vorname", Util::formatAnrede($language, $this, true)." ".$this->A("vorname"));
			else
				$this->changeA("nachname", Util::formatAnrede($language, $this, true)." ".$this->A("nachname"));
		}*/

		$format = Util::getCountryAddressFormat(ISO3166::getCodeToCountry($this->A("LieferantLand")));

		if($Stammdaten != null AND $Stammdaten->A("land") == $this->A("LieferantLand"))
			$format = str_replace ("\n{land}", "", $format);
		
		preg_match_all("/\{([a-zA-Z1-9]*)\}/", $format, $matches);

		foreach($matches[1] AS $var)
			$format = str_replace("{".$var."}",!isset($values[$var]) ? "" : $values[$var]." ", $format);
		
		$ex = explode("\n", $format);
		foreach($ex AS $n => $l){
			$nl = trim($l);
			if($nl == "")
				unset($ex[$n]);
			else
				$ex[$n] = $nl;
		}

		return trim(implode("\n", $ex));
	}
	
	public static function getButton($ArtikelID){
		// <editor-fold defaultstate="collapsed" desc="Aspect:jP">
		try {
			$MArgs = func_get_args();
			return Aspect::joinPoint("around", null, __METHOD__, $MArgs);
		} catch (AOPNoAdviceException $e) {}
		Aspect::joinPoint("before", null, __METHOD__, $MArgs);
		// </editor-fold>
		
		$B = new Button("Lieferanten", "./openWaWi/Lieferanten/Lieferant.png");
		$B->popup("", "Lieferanten", "mLieferant", -1, "getLieferantenPopup", array("'$ArtikelID'"), "", "{width:800, position: 'left'}");
		$B->doBefore("\$j('#AjaxForm [name=currentSaveButton]').trigger(Touch.trigger); Lieferant.lastScroll = 0; %AFTER");
		
		return $B;
	}

	public static function check($type){
		return ($type == "A" OR $type == "B" OR $type == "R" OR $type == "L");
	}
	
	public static function has($ArtikelID){
		return self::hasArtikelLieferant($ArtikelID);
	}
	
	public static function hasArtikelLieferant($ArtikelID){
		$AC = anyC::get("LieferantPreis", "LieferantPreisArtikelID", $ArtikelID);
		$AC->setLimitV3("1");

		$LP = $AC->getNextEntry();
		return $LP != null;
	}

	public static function getLieferanten($ArtikelID){
		$AC = anyC::get("LieferantPreis", "LieferantPreisArtikelID", $ArtikelID);
		$AC->addJoinV3("Lieferant", "LieferantPreisLieferantID", "=", "LieferantID");
		$AC->addAssocV3("LieferantPreisVarianteArtikelID", "=", "0");
		$AC->addOrderV3("LieferantPreisLieferantID", "ASC");
		
		return $AC;
	}
	
	public function getEmailData(){
		$recipients = array();
		$recipients[0] = array($this->A("LieferantFirma"), $this->A("LieferantEMail"));
		
		if(Session::isPluginLoaded("mAnsprechpartner")){
			$AC = Ansprechpartner::getAllAnsprechpartnerTo("Lieferant", $this->getID());
			while($A = $AC->getNextEntry())
				$recipients[$A->getID()] = array($A->A("AnsprechpartnerVorname")." ".$A->A("AnsprechpartnerNachname"), $A->A("AnsprechpartnerEmail"));
		}
		
		return array(
			"fromName" => Session::currentUser() ? Session::currentUser()->A("name") : "", 
			"fromAddress" => Session::currentUser() ? Session::currentUser()->A("UserEmail") : "", 
			"recipients" => $recipients, 
			"subject" => "", 
			"body" => "");
	}
}
?>