<?php
/**
 * Riecken Webservice & Application GmbH
 * Niklas Riecken
 * niklas.riecken@riecken-webservices.at
 */
class exportDatevDOXMLInvoice {

    private $generatingSystem = "open3A";

    private $generatorInfo = "exportDatev";

    /**
     * @var SimpleXMLElement We build the XML in here
     */

    private $xml;

    /**
     * CreateInvoiceDocumentReceivable constructor.
     * @param $xmlDataArray
     * array(
     *   "consolidatedCurrencyCode" => "EUR",
     *   "consolidatedInvoiceId" => "RENR",
     *   "consolidatedDate" => "Y-m-d",
     *   "consolidatedAmount" => "AmountTotalGross (i.e. 320.50) Be aware of Number Format",
     *   'bookingLines' => array(
     *       0 => array(
     *           "date" => "Y-m-d",
     *           "amount" => "320.50",
     *           "accountNo" => "SACHKONTO",
     *           "costCategory1" => "Optional",
     *           "tax" => "Optional",
     *           "information" => "Optional",
     *           "currencyCode" => "EUR",
     *           "invoiceId" => "RENR",
     *           "bookingText" => "Buchungstext",
     *           "dueDate" => "Y-m-d Optional",
     *           "paymentConditionsId" => "ZahlungsbedingungsId Optional",
     *           "bpAccountNo" => "Debitor"
     *           )
     *       )
     *   );
     */

    public function __construct($xmlDataArray) {

        $ledgerImport = new SimpleXMLElement('<?xml version="1.0" encoding="utf-8" ?><LedgerImport></LedgerImport>');

        $ledgerImport->addAttribute("xmlns:xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        $ledgerImport->addAttribute("xmlns", "http://xml.datev.de/bedi/tps/ledger/v040");
        $ledgerImport->addAttribute("xsi:xsi:schemaLocation", "http://xml.datev.de/bedi/tps/ledger/v040 Belegverwaltung_online_ledger_import_v040.xsd");
        $ledgerImport->addAttribute("version", "4.0");
        $ledgerImport->addAttribute("xml_data", "Kopie nur zur Verbuchung berechtigt nicht zum Vorsteuerabzug");
        $ledgerImport->addAttribute("generating_system", $this->generatingSystem);
        $ledgerImport->addAttribute("generator_info", $this->generatorInfo);

        $consolidate = $ledgerImport->addChild("consolidate");
        $consolidate->addAttribute("consolidatedCurrencyCode", $xmlDataArray["consolidatedCurrencyCode"]);
        $consolidate->addAttribute("consolidatedInvoiceId", $xmlDataArray["consolidatedInvoiceId"]);
        $consolidate->addAttribute("consolidatedDate", $xmlDataArray["consolidatedDate"]);
        $consolidate->addAttribute("consolidatedAmount", $xmlDataArray["consolidatedAmount"]);

        foreach($xmlDataArray["bookingLines"] as $accountsReceivableLedgerElement){
            $accountsReceivableLedger = $consolidate->addChild("accountsReceivableLedger");
            $date = $accountsReceivableLedger->addChild("date", $accountsReceivableLedgerElement["date"]);
            $amount = $accountsReceivableLedger->addChild("amount", $accountsReceivableLedgerElement["amount"]);
            $accountNo = $accountsReceivableLedger->addChild("accountNo", $accountsReceivableLedgerElement["accountNo"]);
            if(isset($accountsReceivableLedgerElement["costCategory1"])) {
                $costCategory1 = $accountsReceivableLedger->addChild("costCategoryId", $accountsReceivableLedgerElement["costCategory1"]);
            }
            if(isset($accountsReceivableLedgerElement["tax"])) {
                $tax = $accountsReceivableLedger->addChild("tax", $accountsReceivableLedgerElement["tax"]);
            }
            $information = (isset($accountsReceivableLedgerElement["information"])) ? $accountsReceivableLedger->addChild("information", $accountsReceivableLedgerElement["information"]) : NULL;
            $currencyCode = $accountsReceivableLedger->addChild("currencyCode", $accountsReceivableLedgerElement["currencyCode"]);
            $invoiceId = $accountsReceivableLedger->addChild("invoiceId", $accountsReceivableLedgerElement["invoiceId"]);
            if(isset($accountsReceivableLedgerElement["bookingText"]) && $accountsReceivableLedgerElement["bookingText"] != '') {
                $bookingText = $accountsReceivableLedger->addChild("bookingText", $accountsReceivableLedgerElement["bookingText"]);
            }
            if(isset($accountsReceivableLedgerElement["dueDate"])) {
                $bookingText = $accountsReceivableLedger->addChild("dueDate", $accountsReceivableLedgerElement["dueDate"]);
            }
            if(isset($accountsReceivableLedgerElement['paymentConditionsId'])) {
                $paymentConditionsId = $accountsReceivableLedger->addChild("paymentConditionsId", $accountsReceivableLedgerElement["paymentConditionsId"]);
            }
            $bpAccountNo = $accountsReceivableLedger->addChild("bpAccountNo", $accountsReceivableLedgerElement["bpAccountNo"]);
        }

        $this->xml = $ledgerImport;

    }

    public function asXML() {
        return $this->xml->asXML();
    }

    public function save($path) {
        return $this->xml->asXML($path);
    }

}

?>