<?php
/**
 * Riecken Webservice & Application GmbH
 * Niklas Riecken
 * niklas.riecken@riecken-webservices.at
 */
class exportDatevDOXMLDokument {

    /**
     * @var SimpleXMLElement We create the XML in Here
     */

    private $xml;

    /**
     * CreateDocumentHeaderReceivables constructor.
     * @param $xmlDataArray
     * This is the usual valid Array:
     * array(
     *   'date' => date("Y-m-d")."T".date("H:i:s"),
     *   'description' => "Dateibeschreibung",
     *   'client' => "Kunde123",
     *   'documents' => array(
     *       0 => array(
     *       'file' => "INVOICEXML DOCUMENT",
     *       'yearMonth' => "Y-m",
     *       'filePDF' => "PDF DOCUMENT NAME"
     *       )
     *   )
     * );
     *
     * There are some other possibilitys like only giving a PDF with a GUID. You can import the bookings then via
     * the Normal ASCII Import with the GUID as Beleglink in DATEV and it will be connected
     */

    public function __construct($xmlDataArray) {

        $ledgerImport = new SimpleXMLElement('<?xml version="1.0" encoding="utf-8" ?><archive></archive>');

        $ledgerImport->addAttribute("xmlns:xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        $ledgerImport->addAttribute("xmlns", "http://xml.datev.de/bedi/tps/document/v04.0");
        $ledgerImport->addAttribute("xsi:xsi:schemaLocation", "http://xml.datev.de/bedi/tps/document/v04.0 document_v040.xsd");
        $ledgerImport->addAttribute("version", "4.0");

        $header = $ledgerImport->addChild("header");
        $date = $header->addChild("date", $xmlDataArray['date']);
        $description = $header->addChild("description", $xmlDataArray['description']);
        $client = $header->addChild("clientName", $xmlDataArray['client']);

        $content = $ledgerImport->addChild('content');

        foreach($xmlDataArray["documents"] as $doc){

            $document = $content->addChild('document');
            if(isset($doc['guid'])) {

                $document->addAttribute("processID", 1);
                $document->addAttribute("type", 2);
                $document->addAttribute("guid", $doc['guid']);

            }

            if(isset($doc['file'])) {

                $extension = $document->addChild('extension');
                $extension->addAttribute("datafile", $doc['file']);
                $extension->addAttribute("xsi:xsi:type", "accountsReceivableLedger");

                $property = $extension->addChild('property');
                $property->addAttribute('key', '1');
                $property->addAttribute('value', $doc['yearMonth']);

                $property = $extension->addChild('property');
                $property->addAttribute('key', '3');
                $property->addAttribute('value', "Ausgangsrechnungen");

            }

            if(isset($doc['filePDF'])) {

                $extension = $document->addChild('extension');
                $extension->addAttribute("name", $doc['filePDF']);
                $extension->addAttribute("xsi:xsi:type", "File");
            }

        }

        $this->xml = $ledgerImport;

    }

	public function asXML(){
		return $this->xml->asXML();
	}
	
    public function save($path) {
        return $this->xml->asXML($path);
    }

}

?>