<?php
/*
 *  This file is part of open3A.

 *  open3A is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 
 *  open3A is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 *  2007 - 2020, open3A GmbH - Support@open3A.de
 */
class UebersichtGUI extends anyC implements iGUIHTMLMP2, iAutoCompleteHTML, icontextMenu, iCategoryFilter, iSearchFilter, iOrderByField, iCustomSettings {
	function __construct(){
		$this->setCollectionOf("GRLBM");
		$this->customize();
	}

	public $CustomizerTeilzahlungen;
	public static $Mahnungen;

	public $inAC = false;
	public $searchedFields = array("nummer", "CONCAT(vorname, ' ', nachname)","firma","kundennummer");
	public static $Zahlungsziel = false;
	public static $maxDays = 14;
	#
	public function getOrderByFields(){
		return array("nummer" => "Rechnungsnummer", "datum" => "Datum");
	}
	
	public function getCustomSettings(){
		$mU = new mUserdata();
		$maxD = $mU->getUDValue("maxDaysUnpayedBeforeRed", 14);
		
		return "
				<table style=\"border:0px;\">
					<tr>
						<td class=\"backgroundColor3\">Unbezahlt nach ? Tagen:</td>
					</tr>
					<tr>
						<td>
						<input
								type=\"image\" 
								src=\"./images/i2/save.gif\"
								style=\"border: 0px none ; width: 18px;float:right;\" 
								onclick=\"rme('Uebersicht','', 'saveCustomSettings', Array($('unpayedAfterDays').value), 'if(checkResponse(transport)) { phynxContextMenu.stop(); contentManager.reloadFrameRight(); }');\" />
						<input style=\"width:130px;text-align:right;\" id=\"unpayedAfterDays\" type=\"text\" value=\"$maxD\" /></td>
					</tr>
				</table>";
	}
	
	public function saveCustomSettings($d){
		$mU = new mUserdata();
		$mU->setUserdata("maxDaysUnpayedBeforeRed", $d);
	}
	
	function getHTML($id, $page){
		T::load(__DIR__, "Uebersicht");
		
		$pSpecData = mUserdata::getPluginSpecificData("Auftraege");
		#$demo = new HTMLTable(1);
		#if(strstr($_SERVER["SCRIPT_FILENAME"],"demo") AND strpos($_SERVER["SCRIPT_FILENAME"],"demo_all") === false)
		#	$demo->addRow("<img src=\"./images/navi/warning.png\" style=\"float:left;margin-right:10px;\" />Dieses Plugin ist nicht in der kostenlosen Version enthalten. Weitere Informationen finden Sie auf der <a href=\"http://www.open3a.de/page-Plugins\">Plugins-Seite</a>");
		
		
		$mU = new mUserdata();
		$entriesPerPage = $mU->getUDValue("entriesPerPageUebersicht");
		$entriesPerPage = ($entriesPerPage == null ? 20 : $entriesPerPage);
		
		$sort = new mUserdata();
		$sort = $sort->getUDValue("OrderByFieldInHTMLGUI".$this->getClearClass());

		$mU = new mUserdata();
		self::$maxDays = $mU->getUDValue("maxDaysUnpayedBeforeRed", 14);
		
		$this->addJoinV3("Auftrag","AuftragID","=","AuftragID");
		$this->addJoinV3("Adresse","t2.AdresseID","=","AdresseID");
		$this->addAssocV3("isR","=","1");
		$this->addAssocV3("isG","=","1","OR");
		$this->addAssocV3("isWhat","=","T","OR");
		$this->addOrderV3("isPayed","ASC");
		$this->addOrderV3("nummer","DESC");
		if($sort != null) $this->setOrderV3(substr($sort,0,strpos($sort,";")),substr($sort,strpos($sort,";")+1));

		$i = 0;
		if(isset($pSpecData["pluginSpecificCanOnlyEditOwn"])) 
			$this->addAssocV3("t2.UserID","=",$_SESSION["S"]->getCurrentUser()->getID(),"AND","2");

		foreach($pSpecData as $key => $value)
			if(strstr($key,"pluginSpecificCanSeeAuftraegeFrom"))
				$this->addAssocV3("t2.UserID","=",str_replace("pluginSpecificCanSeeAuftraegeFrom","",$key),(($i++ == 0 AND !isset($pSpecData["pluginSpecificCanOnlyEditOwn"])) ? "AND" : "OR"),"1");


		#$this->setLimitV3(($page * $entriesPerPage).",$entriesPerPage");
		$this->filterCategories();
		#$this->lCV3($id);
		$currentFilter = mUserdata::getUDValueS("customFilterInHTMLGUIUebersicht", null);
		
		if($currentFilter != null AND $currentFilter != "notSent"){
			$this->addAssocV3($currentFilter, ">", "0", "AND", "4");
			$this->isFiltered = true;
		}
		
		if($currentFilter == "notSent"){
			$this->addAssocV3("isEMailed", "=", "0", "AND", "4");
			$this->addAssocV3("isPixelLetteredTime", "=", "0", "AND", "4");
			$this->addAssocV3("isPrinted", "=", "0", "AND", "4");
			$this->isFiltered = true;
		}
			
		$currentFilter2 = mUserdata::getUDValueS("customFilter2InHTMLGUIUebersicht", null);
		if($currentFilter2){
			$this->addAssocV3("datum", "<=", Util::CLDateParser($currentFilter2, "store"), "AND", "5");
			$this->isFiltered = true;
		}
		
		$currentFilter3 = mUserdata::getUDValueS("customFilter3InHTMLGUIUebersicht", null);
		if($currentFilter3){
			$this->addAssocV3("datum", ">=", Util::CLDateParser($currentFilter3, "store"), "AND", "5");
			$this->isFiltered = true;
		}
		
		Aspect::joinPoint("alter", $this, __METHOD__, array());
		
		$this->loadMultiPageMode($id, $page, $entriesPerPage);
		
		$gui = new HTMLGUIX($this, "Uebersicht");
		$gui->version("Uebersicht");
		$gui->tip();
		$gui->screenHeight();
		

		
		if(Session::isPluginLoaded("Mahnung"))
			self::findMahnungen($this);
		
		
		$gui->attributes(array("isEMailed","nummer","datum","payedWithSkonto"));
		
		$gui->colWidth("isEMailed",20);
		$gui->colStyle("payedWithSkonto","text-align:right;width:70px;");
		
		$gui->parser("datum","UebersichtGUI::datumParser");
		$gui->parser("nummer","UebersichtGUI::nummerParser");
		$gui->parser("payedWithSkonto","UebersichtGUI::payedWithSkontoParser");
		$gui->parser("isEMailed", "UebersichtGUI::parserMailed");
		
		$gui->replaceEvent("onEdit", "contentManager.loadFrame('contentLeft','GRLBMDisplay','%CLASSID');");
		
		$gui->options(false, true, false, true, true);
		
		$tab = new HTMLSideTable("left");
		if($_SESSION["S"]->checkForPlugin("Mahnung")){
			$B = $tab->addButton("Mahnungen\nerstellen","mahnung");
			$B->onclick("contentManager.loadFrame('contentLeft','createMahnungen');");
			$B->id("createMahnungenButton");
			$BS = $B->settings("Mahnung", "", "left");
			$BS->style("float:left;margin-left:-25px;");
			
			$BP = $tab->addButton("multiDruck\nListe anzeigen","liste");
			$BP->onclick("contentManager.editInPopup('multiPrintBasket','','multiDruck-Liste');");
		}

		if($_SESSION["S"]->checkForPlugin("mSEPA") OR $_SESSION["S"]->checkForPlugin("mRegID")){
			$B = $tab->addButton("per Lastschrift\nabbuchen","lastschrift");
			$B->onclick("contentManager.loadFrame('contentLeft','LastschriftListe');");
		}
		
		if(isset($pSpecData["pluginSpecificCanSetPayed"]) AND Session::isPluginLoaded("mZahlungsart")){
			$B = $tab->addButton("Bar-Belege als\nbezahlt markieren","./open3A/Uebersicht/bezahlt.png");
			$B->popup("", "Bar-Belege", "Uebersicht", "-1", "cashPayedPopup");
		}
		
		if(Session::isPluginLoaded("mZahlungsaufforderung")){
			$tab->addRow(Zahlungsaufforderung::getButton());
		}
		
		Aspect::joinPoint("sideTable", $this, __METHOD__, array($tab));
		
		#$BA = new Button("Alle", "./images/i2/clear.png", "icon");
		#$BA->style("margin-right:12px;".($currentFilter == "all" ? "" : "opacity:0.4;"));
		#$BA->rmePCR("mUserdata", "-1", "setUserdata", array("'customFilterInHTMLGUIUebersicht'", "'all'"), OnEvent::reload("Right"));
		
		$BN = new Button("Nicht per E-Mail versendet und nicht als gedruckt markiert.", "./images/i2/stop.png", "icon");
		$BN->style("margin-right:12px;".($currentFilter == "notSent" ? "" : "opacity:0.4;"));
		$BN->rmePCR("mUserdata", "-1", "setUserdata", array("'customFilterInHTMLGUIUebersicht'", "'notSent'"), OnEvent::reload("Right"));
		
		$BE = new Button("Per E-Mail verschickt", "./images/i2/mail.png", "icon");
		$BE->style("margin-right:12px;".($currentFilter == "isEMailed" ? "" : "opacity:0.4;"));
		$BE->rmePCR("mUserdata", "-1", "setUserdata", array("'customFilterInHTMLGUIUebersicht'", "'isEMailed'"), OnEvent::reload("Right"));
		
		$BP = new Button("Als gedruckt markiert", "./images/i2/printer.png", "icon");
		$BP->style("margin-right:12px;".($currentFilter == "isPrinted" ? "" : "opacity:0.4;"));
		$BP->rmePCR("mUserdata", "-1", "setUserdata", array("'customFilterInHTMLGUIUebersicht'", "'isPrinted'"), OnEvent::reload("Right"));
		
		$BS = new Button("Per PixelLetter verschickt", "./open3A/PixelLetter/pl18.png", "icon");
		$BS->style("margin-right:12px;".($currentFilter == "isPixelLetteredTime" ? "" : "opacity:0.4;"));
		$BS->rmePCR("mUserdata", "-1", "setUserdata", array("'customFilterInHTMLGUIUebersicht'", "'isPixelLetteredTime'"), OnEvent::reload("Right"));
		if(!Session::isPluginLoaded("PL"))
			$BS = "";
		
		$tab->addRow("<div style=\"margin-bottom:5px;\"><small style=\"color:grey;\">".T::_("Filtern nach Versand&shy;status").":</small></div>".$BN.$BE.$BP.$BS);
		
		$IS = new HTMLInput("filterByDateStart", "date", $currentFilter2);
		$IS->placeholder("Bis");
		$action = OnEvent::rme(new mUserdata(-1), "setUserdata", array("'customFilter2InHTMLGUIUebersicht'", "this.value"), OnEvent::reload("Right"));
		$IS->onchange($action);
		$IS->onEnter($action);
		
		$IE = new HTMLInput("filterByDateEnde", "date", $currentFilter3);
		$IE->placeholder("Ab");
		$action = OnEvent::rme(new mUserdata(-1), "setUserdata", array("'customFilter3InHTMLGUIUebersicht'", "this.value"), OnEvent::reload("Right"));
		$IE->onchange($action);
		$IE->onEnter($action);
		
		$tab->addRow("<div style=\"margin-bottom:5px;\"><small style=\"color:grey;\">".T::_("Filtern nach Belegdatum").":</small></div>".$IS."<div style=\"margin-top:10px;\">".$IE."</div>");
		
		if(mUserdata::getUDValueS("lastPayedStatusChange"))
			$tab->addRow("<small style=\"color:grey;\">Zuletzt als bezahlt<br>markiert am:<br>".Util::CLDateTimeParser(mUserdata::getUDValueS("lastPayedStatusChange"))."</small>");
		
		$tab->addRow("<small style=\"color:grey;\" id=\"unpaidSum\">".$this->summeUnbezahlt()."</small>");
		
		$gui->customize($this->customizer);
		$gui->prepend($tab);
		try {
			return $gui->getBrowserHTML($id);
		} catch (Exception $e){ }
	}
	
	public function summeUnbezahlt($return = true){
		$AC = anyC::get("GRLBM");
		$AC->addAssocV3("isR", "=", "1");
		$AC->addAssocV3("isPayed", "=", "0");
		$AC->addAssocV3("isPayed", "!=", "2");
		$fields = array("SUM(ROUND(bruttobetrag + 0.0000000001, 2)) as ausstehend");
		if($this->CustomizerTeilzahlungen)
			$fields[] = "SUM(GRLBMTeilzahlungenSumme) AS teilzahlungen";
		else
			$fields[] = "0 AS teilzahlungen";
		
		$AC->addAssocV3("datum", ">", time() - 3600 * 24 * 365);
		$AC->setFieldsV3($fields);
		$U1 = $AC->n();
		
		$sum = 0;
		$s = "Ausstehend<br>";
		if($U1){
			$s .= "Rechnungen:<br><strong>".Util::CLNumberParserZ((float)$U1->A("ausstehend") - (float)$U1->A("teilzahlungen"))."</strong><br>";
			$sum = (float)$U1->A("ausstehend") - (float)$U1->A("teilzahlungen");
		}
		
		$AC = anyC::get("GRLBM");
		$AC->addAssocV3("isG", "=", "1");
		$AC->addAssocV3("isPayed", "=", "0");
		$AC->addAssocV3("datum", ">", time() - 3600 * 24 * 365);
		$fields = array("SUM(ROUND(bruttobetrag + 0.0000000001, 2)) as ausstehend");
		if($this->CustomizerTeilzahlungen)
			$fields[] = "SUM(GRLBMTeilzahlungenSumme) AS teilzahlungen";
		else
			$fields[] = "0 AS teilzahlungen";
		$AC->setFieldsV3($fields);
		$U2 = $AC->n();
		if($U2){
			$s .= "Gutschriften:<br><strong>".Util::CLNumberParserZ((float)$U2->A("ausstehend") - (float)$U2->A("teilzahlungen"))."</strong><br>";
			$sum -= (float)$U2->A("ausstehend") - (float)$U2->A("teilzahlungen");
		}
		
		if($sum != 0 AND $U2 AND $U1)
			$s .= "Gesamt:<br><strong>".Util::CLNumberParserZ($sum)."</strong>";
		
		
		if($return)
			return $s;
		
		echo $s;
	}
	
	public static function findMahnungen($AC){
			$IDs = array();
			
			while($G = $AC->getNextEntry()){
				if($G->A("isPayed") == "1") continue;
				
				$IDs[] = $G->getID();
			}
			$AC->resetPointer();
			
			if(!count($IDs))
				return;
			
			$ACM = anyC::get("GRLBM");
			$ACM->addAssocV3("AuftragID", "IN", "(".trim(implode(",", $IDs), ",").")", "OR", "1");
			
			$ACM->addAssocV3("isM", "=", "1", "AND", "2");
			$ACM->addGroupV3("AuftragID");
			
			$ACM->setFieldsV3(array("MAX(nummer) AS anzahl", "AuftragID AS GID", "MAX(datum) AS lastDatum", "MAX(lieferDatum) AS lastPayDatum"));

			$Ms = array();

			while($M = $ACM->getNextEntry())
				$Ms[$M->A("GID")] = array($M->A("anzahl"), $M->A("lastDatum"), $M->A("lastPayDatum"));

			self::$Mahnungen = $Ms;

	}
	
	public function cashPayedPopup(){
		$AC = anyC::get("GRLBM");
		$AC->addAssocV3("isPayed", "=", "0");
		$AC->addAssocV3("GRLBMpayedVia", "=", "cash");
		
		$AC->addAssocV3("isR", "=", "1", "AND", "2");
		$AC->addAssocV3("isG", "=", "1", "OR", "2");
		$AC->setLimitV3(50);
		
		$T = new HTMLTable(2);
		$T->addColStyle(1, "text-align:right;");
		$T->setColWidth(1, 100);
		$T->maxHeight(400);
		while($B = $AC->n()){
			$B->resetParsers();
			
			$T->addRow(array(
				$B->A("prefix").$B->A("nummer"),
				Util::CLDateParser($B->A("datum"))
			));
			
			$B->setPayed("true", "0,00", $B->A("datum"));
		}
		
		if($AC->numLoaded() == 0)
			die("<p class=\"highlight\">Keine unbezahlten Bar-Belege gefunden.</p>");
		
		echo "<p class=\"confirm\">Folgende Bar-Belege wurden als bezahlt markiert.<br><small>(max. 50 Stück pro Durchgang)</small></p>".$T.OnEvent::script(OnEvent::reload("Right"));
	}
	
	public static function parserMailed($w, $E){
		$B = new Button("Nicht per E-Mail versendet und nicht als gedruckt markiert.", "./images/i2/stop.png", "icon");
		
		if($w == "1")
			$B = new Button("Per E-Mail verschickt", "./images/i2/mail.png", "icon");
		
		if($E->A("isPrinted") == "1")
			$B = new Button("Als gedruckt markiert", "./images/i2/printer.png", "icon");
		
		if($E->A("isPixelLetteredTime") > 0)
			$B = new Button("Per PixelLetter verschickt", "./open3A/PixelLetter/pl18.png", "icon");
		
		return $B;
	}
	
	public function getSearchedFields(){
		return $this->searchedFields;
	}
	
	public function getAvailableCategories(){
		return array("1" => T::_("bezahlt"), "0" => T::_("unbezahlt"),"2" => T::_("storniert"));
	}
	
	public function getCategoryFieldName(){
		return "isPayed";
	}
	
	function getClearClass(){
		return "Uebersicht";
	}
	
	public static function datumParser($w,$E){
		$BZZ = new Button("", "./open3A/Uebersicht/zahlungsziel.png", "icon");

		$ZZT = "";
		$timeToRed = 3600 * 24 * self::$maxDays + $w;
		if(self::$Zahlungsziel AND $E->A("zahlungsziel") != "0"){
			$timeToRed = $E->A("zahlungsziel");
			$ZZT = "<br />$BZZ <small>".Util::CLDateParser($E->A("zahlungsziel"))."</small>";
		}
		
		if(isset(self::$Mahnungen[$E->getID()])){
			$timeToRed = self::$Mahnungen[$E->getID()][2];
			$ZZT = "<br />$BZZ <small>".Util::CLDateParser(self::$Mahnungen[$E->getID()][2])."</small>";
		}
		
		$tage = floor((time() - $w) / (3600 * 24));
		if($E->A("isPayed") == "0") return (time() > $timeToRed  ? "<span style=\"color:red;\">".$tage." ".T::_("Tag".($tage != 1 ? "e" : "")).$ZZT."</span>" : $tage." ".T::_("Tag".($tage != 1 ? "e" : "")).$ZZT)."<br><small style=\"color:grey;\">".Util::CLDateParser($w)."</style>";
		
		if($E->A("isPayed") == "1") return "<small style=\"color:grey;\">bezahlt am</small><br />".Util::CLDateParser($E->A("GRLBMpayedDate"));
		if($E->A("isPayed") == "2") return "<small style=\"color:grey;\">storniert am</small><br />".Util::CLDateParser($E->A("GRLBMpayedDate"));

	}
	
	public static function payedWithSkontoParser($w, $E){
		#$s = HTMLGUI::getArrayFromParametersString($p);
		$w += $E->A("gebuehren");
		if($E->A("isPayed") == "1" AND $w != 0) 
			return "<small style=\"color:grey;\">Skonto:</small><br>".($w != 0 ? Util::CLNumberParserZ($w)."%" : "0%");
		
		#$summe = $E->getSumOfPosten(); //WHY? Slows everything down 20190517
		$summe = $E->A("bruttobetrag");
		$summe += $E->A("gebuehren");
		
		if($E->A("GRLBMTeilzahlungenSumme") != null)
			$summe -= $E->A("GRLBMTeilzahlungenSumme");

		return "<small style=\"color:grey;\">".T::_("brutto-Betrag").":</small><br />".($summe < 0 ? "<span style=\"color:red;\">" : "").Util::CLFormatCurrency($summe, false).($summe < 0 ? "</span>" : "");
	}
	
	public static function isPayedParser($w, $E){
		$B = new Button("Details anzeigen", "./images/i2/edit.png", "icon");
		$B->onclick("contentManager.selectRow(this); contentManager.loadFrame('contentLeft','GRLBMDisplay','".$E->getID()."');");
		$B->className("editButton");

		return $B;
	}

	public function getACHTML($attributeName, $query){
		$gui = new HTMLGUI();
		$this->inAC = true;
		
		if($query[0] == "R") {
			$query[0] = " ";
			$query = trim($query);
		}
		
		switch($attributeName){
			case "quickSearchUebersicht":
				
				$mode = "quickSearchLoadFrame";
				
				if($query[0] == "=")
					$this->addAssocV3("bruttobetrag", "=", Util::CLNumberParserZ(substr($query, 1), "store"), "AND", "BG123");
				else {
					$this->setSearchStringV3($query);
					$this->setSearchFieldsV3($this->getSearchedFields());
					$this->addJoinV3("Auftrag","AuftragID","=","AuftragID");
					$this->addJoinV3("Adresse","t2.AdresseID","=","AdresseID");
				}
				
				$this->addAssocV3("isR","=","1");
				$this->addAssocV3("isG","=","1","OR");
				$this->addAssocV3("isWhat","=","T","OR");
				$this->setLimitV3("10");
				$this->addOrderV3("nummer","DESC");
				
				Aspect::joinPoint("alter", $this, __METHOD__, array());
				
				
				$this->lCV3();
				
				#$gui->setAttributes($this->collector);
				$gui->setObject($this);
				$gui->setShowAttributes(array("nummer","firma"));
				
				$gui->setParser("firma","UebersichtGUI::ACFirmaParser",array("\$nachname","\$vorname"));
				$gui->setParser("nummer","UebersichtGUI::ACNummerParser",array("\$isR"));
				
				$_SESSION["BPS"]->registerClass("HTMLGUI");
				$_SESSION["BPS"]->setACProperty("targetFrame","contentLeft");
				$_SESSION["BPS"]->setACProperty("targetPlugin","GRLBMDisplay");
				$gui->customize($this->customizer);
				echo $gui->getACHTMLBrowser($mode);
			break;

		}
	}
	
	public static function ACNummerParser($w, $l, $p){
		if($p == "0") return "G$w";
		else return "R$w";
	}
	
	public static function ACFirmaParser($w, $l, $p){
		$s = HTMLGUI::getArrayFromParametersString($p);
		return $w == "" ? $s[1]." ".$s[0] : $w;
	}
	
	public static function nummerParser($w, $E){
		$s = array("", $E->getID(),$E->A("firma"),$E->A("vorname"),$E->A("nachname"),$E->A("isPayed"),$E->A("isG"));
		#$s = HTMLGUI::getArrayFromParametersString($p);
		
		#$t = $E->getMyPrefix();
		#if($s[6] == "1") $t = "G";

		$action = "";
		if($s[5] == "0") $action = "not";
		if($s[5] == "2") $action = "never";
		$html = "<img id=\"rechnungPayedID$s[1]\" title=\"Rechnung als ".($s[5] == 0 ? "" : "un")."bezahlt markieren\" "."onclick=\"Auftrag.setRechnungPayed(this,'$s[1]');\" class=\"mouseoverFade\""." style=\"float:left;margin-right:3px;\" src=\"./images/i2/{$action}ok.gif\" />";
		#($s[0] == "true" ? "<img src=\"./images/i2/provision.png\" title=\"Provisionen vergeben\" class=\"mouseoverFade\" onclick=\"loadFrameV2('contentLeft','ProvisionSwitch','ProvisionSwitchGUI;useGRLBMID:$s[1]');\" style=\"float:left;margin-right:3px;\" />" : "").

		$BM = "";
		if(self::$Mahnungen != null AND isset(self::$Mahnungen[$s[1]])){
			$BM = new Button(self::$Mahnungen[$s[1]][0]." Mahnung".(self::$Mahnungen[$s[1]][0] != 1 ? "en" : "")." erstellt", "./open3A/Mahnung/".self::$Mahnungen[$s[1]][0]."Mahnung.png", "icon");
			$BM->style("float:right;");
			$BM->className("hasMahnung");
		}
		
		$BT = "";
		if($E->A("GRLBMSEPATransmitted") > 0 AND !$E->A("isPayed")){
			$BT = new Button("Auftrag übermittelt am ".Util::CLDateTimeParser($E->A("GRLBMSEPATransmitted")),"./open3A/Uebersicht/inAuftrag18.png", "icon");
			$BT->style("float:right;");
		}
		
		return "$BT$BM$html<small style=\"color:grey;\">".($s[2] == "" ? "$s[3] $s[4]" : $s[2])."</small><p style=\"margin-left:21px;\">".$E->A("prefix").$w."</p>";
	}
	
	public function getContextMenuHTML($identifier){
		echo "<p style=\"padding:5px;\">Es werden folgende Felder durchsucht:<br><br>Rechnungsnummer<br>Vorname<br>Nachname<br>Firma<br>Kundennummer</p><p>Um nach einem Rechnungsbetrag zu suchen, stellen Sie ein \"=\" davor: z.B. \"=403,66\"</p>";
	}

	public function saveContextMenu($identifier, $key){ }
}
?>
