<?php
/**
 *  This file is part of open3A.

 *  open3A is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  open3A is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 *  2007 - 2020, open3A GmbH - Support@open3A.de
 */
class mMahnung {
	protected function getData($useZahlungsziel){
		$ziel = mUserdata::getUDValueS("maxDaysUnpayedBeforeRed", 14);
		
		if($useZahlungsziel)
			$ZZR = "IF(t1.zahlungsziel != 0, t1.zahlungsziel,t1.datum + $ziel * 3600 * 24) AS zahlungszielRechnung";
		else
			$ZZR = "t1.datum + $ziel * 3600 * 24 AS zahlungszielRechnung";
		
		$ac = anyC::get("GRLBM");
		
		$ac->addAssocV3("t1.isR","=","1");
		$ac->addAssocV3("t1.isPayed","=","0");
		$ac->addAssocV3("t1.GRLBMpayedVia","!=","cashing");
		
		$ac->addOrderV3("t1.nummer","DESC");
		
		$ac->addJoinV3("GRLBM","GRLBMID","=","AuftragID");
		$ac->addJoinV3("GRLBM","isM","=","1");
		$ac->addJoinV3("Auftrag","t1.AuftragID","=","AuftragID");
		$ac->addJoinV3("Adresse","t3.AdresseID","=","AdresseID");
		$ac->addJoinV3("Kappendix", "t3.kundennummer", "=", "kundennummer");
		$ac->addAssocV3("KappendixKeineMahnung", "!=", "1");
		$ac->addGroupV3("t1.nummer");
		
		$ac->setFieldsV3(array(
			"t3.kundennummer",
			($useZahlungsziel ? "t1.zahlungsziel" : "t1.bruttobetrag"), 
			"t1.datum",
			"t1.nummer AS nummer",
			"COUNT(t2.nummer) AS mahnungen",
			"CONCAT(vorname,' ',nachname) AS name",
			"firma",
			"MAX(t2.lieferDatum) as letztesZahlungsziel",
			"t1.AuftragID",
			"t1.bruttobetrag",
			$ZZR));
		
		return $ac;
	}
		
	
	public function findOverDue($useZahlungsziel, $validOnly = false){
		$ac = $this->getData($useZahlungsziel);
		
		$bills = array();
		
		while($a = $ac->getNextEntry()){
			$isOverDue = false;
			$zz = ($a->A("letztesZahlungsziel") != "" ? Util::CLDateParser($a->A("letztesZahlungsziel")) : "");
			$message = Util::CLDateParser($a->A("zahlungszielRechnung"));
			
			if($a->A("letztesZahlungsziel") != "" AND $a->A("letztesZahlungsziel") < time()) {
				$isOverDue = true;
				$zz = "<span style=\"color:red;\">$zz</span>";
			}
			
			if(!$isOverDue AND $a->A("mahnungen") == "0" AND $a->A("zahlungszielRechnung") < time()) {
				$isOverDue = true;
				$message = "<span style=\"color:red;\">$message</span>";
			}
			$message = "<b>R.</b> $message";
			
			if($zz != "" AND $a->A("mahnungen") > 0)
				$message = "<b>".$a->A("mahnungen").".</b> ".$zz;
			
			$canCheck = true;
			if($isOverDue AND $useZahlungsziel){
				$Kappendix = Kappendix::getKappendixToKundennummer($a->A("kundennummer"));
				if($Kappendix != null AND $Kappendix->A("KappendixZahlungsziel") != null){
					$ZZR = round(($a->A("zahlungsziel") - $a->A("datum")) / (3600 * 24));
					
					if($Kappendix->A("KappendixZahlungsziel") != $ZZR){
						$message .= "<br><small style=\"color:grey;\">Entspricht nicht dem aktuellen Zahlungsziel ($ZZR/".$Kappendix->A("KappendixZahlungsziel")." Tage)</small>";
						$canCheck = false;
					}
				}
			}
			
			if($validOnly AND $isOverDue AND $canCheck)
				$bills[$a->getID()] = array($a, ($isOverDue AND $canCheck), $isOverDue, $message);
			
			elseif(!$validOnly)
				$bills[$a->getID()] = array($a, ($isOverDue AND $canCheck), $isOverDue, $message);
		}
		
		return $bills;
	}
	
	public function create($forIDs){
		
		$M = new MahnungGUI(-1);
		$newIds = array();
		foreach($forIDs AS $id){
			$ac = new anyC();
			$ac->setCollectionOf("GRLBM");
			$ac->addAssocV3("AuftragID","=",$id);
			$ac->addAssocV3("isM","=","1");
			$ac->lCV3();
			
			if($ac->numLoaded() == 3) 
				continue;
			
			$newIds[] = $M->createMahnung($id, $ac->numLoaded() + 1);
		}

		return $newIds;
	}
}
?>