<?php
/**
 *  This file is part of open3A.

 *  open3A is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  open3A is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 *  2007 - 2020, open3A GmbH - Support@open3A.de
 */
class createMahnungenGUI extends mMahnung implements iGUIHTML2 {
	public function getHTML($id){
		
		/*$B1 = new Button("Alle unbezahlten Rechnungen anzeigen","./images/i2/notok.gif");
		$B1->onclick("$('showRows').style.display = 'none'; $('hideRows').style.display = ''; var rows = $$('.hiddenRow'); for(var el = 0; el < rows.length; el++) if(rows[el]) rows[el].style.display = ''; ");
		$B1->type("icon");
		$B1->id("showRows");
		$B1->style("float:right;");
		
		$B2 = new Button("Nur Rechnungen mit abgelaufenem Zahlungsziel anzeigen","./images/i2/ok.gif");
		$B2->onclick("$('showRows').style.display = ''; $('hideRows').style.display = 'none'; var rows = $$('.hiddenRow'); for(var el = 0; el < rows.length; el++) if(rows[el]) rows[el].style.display = 'none';");
		$B2->type("icon");
		$B2->id("hideRows");
		$B2->style("float:right;display:none;");*/

		$B3 = new HTMLInput("toggleAll", "checkbox", 0);
		$B3->onclick("\$j('.overDueCheckBox').prop('checked', \$j(this).prop('checked')); \$j('[name=filter]').trigger('keyup');");
		
		$tab = new HTMLTable(4,"offene Rechnungen");
		$tab->setTableStyle("margin-left:10px;width:calc(100% - 10px);");
		$tab->addColStyle(3, "width:20px;");
		$tab->maxHeight(400);
		
		$G = anyC::get("GRLBM");
		$G->setLimitV3("1");
		$G->addAssocV3("isR","=","1");
		$G = $G->getNextEntry();
		
		if($G == null){
			$tab->addRow(array("Keine Rechnungen gefunden"));
			$tab->addRowColspan(1,4);
			return $tab;
		}
		
		$IF = new HTMLInput("filter");
		$IF->style("width:250px;");
		$IF->onkeyup("var q = \$j(this).val(); var gesamt = 0; \$j('.filterItem').show().each(function(k, v){ var d = \$j(v); if((d.data('search')+'').indexOf(q.toLowerCase()) < 0 ) {  d.hide(); } else { if(\$j('#mahnungForID'+d.data('id')).prop('checked')) gesamt += d.data('amount') * 1; } }); ".OnEvent::rme($this, "formatNumber", array("gesamt"), "function(t){ \$j('#summe').html(t.responseText); }"));
		
		$BC = new Button("Filter zurücksetzen", "./images/i2/clear.png", "icon");
		$BC->onclick("\$j('[name=filter]').val('').trigger('keyup');");
		
		$tab->addRow(array(
			"Anzeige filtern: ".$IF,
			"",
			"",
			$BC
		));
		$tab->addRowColspan(1, 3);
		$tab->addCellStyle(4, "text-align:center;");
		
		$tab->addRow(array("Kunde/Rechnung","fällig am", "Betrag",$B3));
		$tab->addRowStyle("font-weight:bold;");
		
		$ac = $this->getData($G->A("zahlungsziel") !== null);
		$overDue = $this->findOverDue($G->A("zahlungsziel") !== null);
		
		$total = 0;
		$tab->addColStyle(1,"text-align:left;width:180px;");
		$tab->addColStyle(3,"text-align:right;");
		while($a = $ac->getNextEntry()){
			if(!$overDue[$a->getID()][2])
				continue;
			
			$I = new HTMLInput("mahnungForID{$a->getID()}", "checkbox", $overDue[$a->getID()][1]);
			$I->id("mahnungForID{$a->getID()}");
			$I->setClass("overDueCheckBox");
			$I->onchange("\$j('[name=filter]').trigger('keyup');");
			
			if($a->A("mahnungen") == 3)
				$I = "";
			
			$name = $a->A("firma");
			if($name == "") 
				$name = $a->A("name");
			
			$B = new Button("Beleg anzeigen", "./images/i2/pdf.gif", "icon");
			$B->style("float:left;margin-right:5px;");
			$B->windowRme("Auftrag", $a->A("AuftragID"), "getGRLBMPDF", array("'false'", "''", $a->getID()));
			
			$tab->addRow(
				array("$B<small style=\"color:grey;\">".$name." (".$a->A("kundennummer").")</small><br />".$a->A("nummer"),
					$overDue[$a->getID()][3],
					Util::CLNumberParserZ(Util::kRound($a->A("bruttobetrag"))),
					$I));
			
			$tab->addRowData("search", strtolower($a->A("nummer")).";".strtolower($name).";".strtolower($a->A("kundennummer")));
			$tab->addRowClass("filterItem");
			$tab->addRowData("amount", Util::kRound($a->A("bruttobetrag")));
			$tab->addRowData("id", $a->getID());
			
			#if(!$overDue[$a->getID()][2]) {
			#	$tab->addRowClass("hiddenRow");
			#	$tab->addRowStyle("display:none;");
			#}
			
			if($overDue[$a->getID()][1])
				$total += Util::kRound($a->A("bruttobetrag"));
		}
		
		$tab2 = new HTMLTable(2);
		$tab2->setTableID("tableSubmit");
		
		$tab2->addColStyle(2, "width:26px;");
		if($ac->numLoaded() > 0){
			$tab2->addRow(array("Gesamt: <span style=\"float:right;\" id=\"summe\">".Util::CLNumberParserZ($total)."</span>"), "");
			$tab2->addRowClass("backgroundColor0");
			$tab2->addCellStyle(1, "border-top-width:3px;border-top-style:double;font-weight:bold;");
			$tab2->addCellClass(1, "borderColor1");
			
			$tab2->addCellStyle(2, "border-top-width:3px;border-top-style:double;font-weight:bold;");
			$tab2->addCellClass(2, "borderColor1");
		}
		
		$S = new Button("Mahnungen\nerstellen", "navigation");
		#$S->type("save");
		#$S->style("width:100%;");
		$S->onclick("if(confirm('Mahnungen jetzt erstellen? Achtung: die aktuelle multiDruck-Liste wird überschrieben!')) ");
		$S->rmePCR('createMahnungen','','createMahnungen',array("joinFormFieldsToString('createMahnungenForm')"),"contentManager.reloadFrame('contentLeft'); contentManager.editInPopup('multiPrintBasket','','multiDruck-Liste');");
		
		$ST = new HTMLSideTable("right");
		$ST->addRow($S);
		#$tab2->addRow(array($S));
		#$tab2->addRowColspan(1, 2);
		
		return "<form id=\"createMahnungenForm\">".$ST.$tab.$tab2."</form>".
			OnEvent::script("\$j('#contentLeft .Tab').next().css('max-height', contentManager.maxHeight() - \$j('.browserContainerSubHeight').outerHeight() - \$j('#tableSubmit').outerHeight());");
	}
	
	public function formatNumber($num){
		echo Util::CLNumberParserZ($num);
	}
	
	public function createMahnungen($string){
		$hi = array();
		parse_str($string, $hi);
		
		$forIDs = array();
		foreach($hi AS $k => $v){
			if($v == "0") 
				continue;
			
			$id = str_replace("mahnungForID","",$k);
			
			$forIDs[] = $id;
		}
		
		$newIds = parent::create($forIDs);
		
		$_SESSION["BPS"]->setActualClass("multiPrintBasketGUI");
		$_SESSION["BPS"]->setACProperty("ids",",,".implode(",,",$newIds).(count($newIds) > 0 ? ",," : ""));
	}
}
?>