<?php
/*
 *  This file is part of open3A.

 *  open3A is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  open3A is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 *  2007 - 2020, open3A GmbH - Support@open3A.de
 */
class importAdresseGUI extends aImportDefault implements iImportable, iFileBrowser  {
	public function getLabel(){
		if(!Session::isPluginLoaded("Adressen") OR Applications::activeApplication() == "openWaWi") return null;
		return "Adressen";
	}
	
	public function getFieldsList(){
		$fields = array(
			"Firma" => "firma",
			"Abteilung" => "abteilung",
			"Anrede" => "anrede",
			"Vorname" => "vorname",
			"Nachname" => "nachname",
			"Straße" => "strasse",
			"Hausnummer" => "nr",
			"PLZ" => "plz",
			"Ort" => "ort",
			"Land" => "land",
			"Telefon" => "tel",
			"Mobil" => "mobil",
			"Fax" => "fax",
			"E-Mail" => "email",
			"Kundennummer" => "kundennummer",
			"UStID" => "ustid",
			#"Kontonummer" => "kontonummer",
			#"BLZ" => "blz",
			"IBAN" => "KappendixIBAN",
			"BIC" => "swiftbic",
			"Mandatsreferenz" => "KappendixIBANMandatReferenz",
			"Homepage" => "homepage",
			"Bemerkung" => "bemerkung"/*,
			"Geburtstag" => "geb"*/);
		
		if(Session::isPluginLoaded("mAdressBuch"))
			$fields["Adressbuch"] = "type";
		
		if(Applications::activeApplication() == "lightCRM" AND Session::isPluginLoaded("mAkquise"))
			$fields["Benutzer"] = "userID";
		
		$fields["Kategorie"] = "KategorieID";
		
		if(Session::isPluginLoaded("mAnsprechpartner")){
			$fields["AP Anrede"] = "ansprechpartnerAnrede";
			$fields["AP Vorname"] = "ansprechpartnerVorname";
			$fields["AP Nachname"] = "ansprechpartnerNachname";
			$fields["AP Position"] = "ansprechpartnerPosition";
		}
		if(Session::isPluginLoaded("mTag")){
			$fields["Tag setzen?"] = "setTag";
		}
		
		$fields = Aspect::joinPoint("fields", $this, __METHOD__, array($fields), $fields);
		
		if(is_array(current($fields))){
			$new = array();
			foreach($fields AS $subfields)
				foreach ($subfields AS $l => $v){
					if(isset($new[$l]))
						continue;
					
					$new[$l] = $v;
				}
				
				$fields = $new;
		}
		
		return $fields;
	}
	
	public function getFieldsSeparators(){
		$separators = array(
			"strasse" => "Adresse",
			"tel" => "Kontakt",
			"kundennummer" => "Kundendaten",
			"kontonummer" => "Kontodaten",
			"homepage" => "Sonstiges",
			"ansprechpartnerAnrede" => "1. Ansprechpartner",
			"setTag" => "Taggen?");
		
		return Aspect::joinPoint("separators", $this, __METHOD__, array($separators), $separators);
	}
	
	public function getFieldsValues(){
		$fields = array();
		
		if(Session::isPluginLoaded("mAdressBuch")){
			$ABs = mAdressBuchGUI::getABs(true);
			$fields["type"] = $ABs;
		}
		
		$AC = anyC::get("Kategorie", "type", "1");
		$Ks = array();
		while($K = $AC->getNextEntry())
			$Ks["use_".$K->getID()] = $K->A("name");
		
		$fields["KategorieID_append"] = $Ks;
		
		$fields["userID"] = Users::getUsersArray();
		
		$fields["setTag"] = array("1" => "Ja");
		
		return $fields;
	}
	
	public function getFieldsDescriptions(){
		$fields = array(
			"kundennummer" => "<small style=\"color:red;\">Wenn eine Kundennummer gefunden wird, wird der Eintrag aktualisiert.</small>"#,
			#"KappendixIBAN" => "<small style=\"color:grey;\">Nur mit Spalte für 'Kundennummer'.</small>",
			#"KappendixIBANMandatReferenz" => "<small style=\"color:grey;\">Nur mit Spalte für 'Kundennummer'.</small>",
			#"swiftbic" => "<small style=\"color:grey;\">Nur mit Spalte für 'Kundennummer'.</small>",
			#"ustid" => "<small style=\"color:grey;\">Nur mit Spalte für 'Kundennummer'.</small>"
		);
		
		return Aspect::joinPoint("descriptions", $this, __METHOD__, array($fields), $fields);
	}
	
	public function getPlugin(){
		return "Adresse";
	}

	public function getImportID($lineData){
		if($this->A("kundennummer") == "-")
			return -1;

		$AID = Kappendix::getAdresseIDToKundennummer($lineData[$this->A("kundennummer")]);
		if($AID == null)
			return -1;
		
		return $AID;
	}

	public function getFastImportWindow($return  = false){
		T::load(__DIR__, "mImport");
		
		$T = new HTMLTable(1);

		$TA = new HTMLInput("schnellImportAdresse", "textarea");
		$TA->style("height:200px;");
		$TA->onkeyup("Import.schnellImportAdresse(this.value);");
		$TA->hasFocusEvent(true);
		$TA->id("InputSchnellImportAdresse");
		$T->addRow($TA);

		$T->addRow(T::_("Bitte fügen Sie die zu importierende Adresse in das Textfeld ein.")." ".T::_("Die Adresse muss folgendermaßen aufgebaut sein:<br><br>Firma<br>Anrede Vorname Nachname<br>Straße Hausnummer<br>PLZ Ort<br>Land<br>Telefon<br>E-Mail")."<br><br>".T::_("Verwenden Sie Leerzeilen für nicht vorhandene Werte."));
		
		if($return)
			return $T;
		
		echo $T;
	}

	public function onNew($newID, $lineData) {
		if(Session::isPluginLoaded("mAnsprechpartner") AND ($this->A("ansprechpartnerVorname") != "-" OR $this->A("ansprechpartnerNachname") != "-" OR $this->A("ansprechpartnerPosition") != "-")){
			
			$F = new Factory("Ansprechpartner");
			
			$F->sA("AnsprechpartnerOwnerClass", "Adresse");
			$F->sA("AnsprechpartnerOwnerClassID", $newID);
			
			if(isset($lineData[$this->A("ansprechpartnerVorname")]))
				$F->sA("AnsprechpartnerVorname", $lineData[$this->A("ansprechpartnerVorname")]);
			
			if(isset($lineData[$this->A("ansprechpartnerNachname")]))
				$F->sA("AnsprechpartnerNachname", $lineData[$this->A("ansprechpartnerNachname")]);
			
			if(isset($lineData[$this->A("ansprechpartnerPosition")]))
				$F->sA("AnsprechpartnerPosition", $lineData[$this->A("ansprechpartnerPosition")]);
			
			if(isset($lineData[$this->A("ansprechpartnerAnrede")])){
				$value = $lineData[$this->A("ansprechpartnerAnrede")];
				
				$anrede = "1";
				if(trim($value) == "Herr")
					$anrede = "2";
				
				$F->sA("AnsprechpartnerAnrede", $anrede);
			}
			$F->store();
			
		}
		
		
		if(Session::isPluginLoaded("mAkquise") AND $this->A("userID") != "-"){
			
			$F = new Factory("AkquiseLead");
			$F->sA("AkquiseLeadAdresseID", $newID);
			$F->sA("AkquiseLeadSource", "0");
			$F->sA("AkquiseLeadUserID", $this->A("userID"));
			
			$F->store();
		}
		
		if(Session::isPluginLoaded("mTag") AND $this->A("setTag") == "1"){
			$F = new Factory("Tag");
			$F->sA("TagOwnerClass", "Adresse");
			$F->sA("TagOwnerClassID", $newID);
			$F->sA("TagName", "Import ".Util::CLDateParser(time()));
			$F->sA("TagCreatedDate", time());
			$F->sA("TagCreatedUserID", Session::currentUser()->getID());

			$F->store();
		}
		
		$fields["AP Vorname"] = "ansprechpartnerVorname";
		$fields["AP Nachname"] = "ansprechpartnerNachname";
		$fields["AP Position"] = "ansprechpartnerPosition";
		
		
		if($this->A("kundennummer") != "-" 
			OR $this->A("ustid") != "-" 
			OR $this->A("KappendixIBAN") != "-" 
			OR $this->A("KappendixIBANMandatReferenz") != "-"
			OR ($this->A("KappendixZahlungsziel") != "-1" AND $this->A("KappendixZahlungsziel") != null AND $this->A("KappendixZahlungsziel") != "-")
			OR $this->A("swiftbic") != "-"){
			
			$K = new Kunden();
			$Kunde = $K->createKundeToAdresse($newID, false, true);

			#$Kunde = new Kappendix($KID);

			if($this->A("kundennummer") != "-")
				$Kunde->changeA("kundennummer", $lineData[$this->A("kundennummer")]);

			if(isset($lineData[$this->A("ustid")]))
				$Kunde->changeA("UStIdNr", $lineData[$this->A("ustid")]);

			if(isset($lineData[$this->A("KappendixIBAN")])){
				$Kunde->changeA("KappendixIBAN", $lineData[$this->A("KappendixIBAN")]);
				$Kunde->changeA("KappendixSameKontoinhaber", "1");
			}

			if(isset($lineData[$this->A("KappendixIBANMandatReferenz")])){
				$Kunde->changeA("KappendixIBANMandatReferenz", $lineData[$this->A("KappendixIBANMandatReferenz")]);
				$Kunde->changeA("KappendixEinzugsermaechtigung", "1");
			}

			if(isset($lineData[$this->A("KappendixZahlungsziel")]))
				$Kunde->changeA("KappendixZahlungsziel", $lineData[$this->A("KappendixZahlungsziel")]);

			if(isset($lineData[$this->A("swiftbic")]))
				$Kunde->changeA("KappendixSWIFTBIC", $lineData[$this->A("swiftbic")]);

			Aspect::joinPoint("alterKunde", $this, __METHOD__, array($Kunde, $lineData));
			
			$Kunde->newMe(true, false);
		}
	}

	protected function onUpdate($ID, $lineData) {
		if($this->A("kundennummer") != "-") {
			$Kunde = Kappendix::getKappendixToAdresse($ID);
			if(!$Kunde){
				$K = new Kunden();
				$KID = $K->createKundeToAdresse($ID);

				$Kunde = new Kappendix($KID);
			}
			
			$Kunde->changeA("kundennummer", $lineData[$this->A("kundennummer")]);

			if(isset($lineData[$this->A("ustid")]))
				$Kunde->changeA("UStIdNr", $lineData[$this->A("ustid")]);

			if(isset($lineData[$this->A("KappendixIBAN")])){
				$Kunde->changeA("KappendixIBAN", $lineData[$this->A("KappendixIBAN")]);
				$Kunde->changeA("KappendixSameKontoinhaber", "1");
			}
			
			if(isset($lineData[$this->A("KappendixIBANMandatReferenz")])){
				$Kunde->changeA("KappendixIBANMandatReferenz", $lineData[$this->A("KappendixIBANMandatReferenz")]);
				$Kunde->changeA("KappendixEinzugsermaechtigung", "1");
			}
			
			if(isset($lineData[$this->A("KappendixZahlungsziel")]))
				$Kunde->changeA("KappendixZahlungsziel", $lineData[$this->A("KappendixZahlungsziel")]);

			if(isset($lineData[$this->A("swiftbic")]))
				$Kunde->changeA("KappendixSWIFTBIC", $lineData[$this->A("swiftbic")]);

			$Kunde->saveMe(true, false);
		}
	}


	private $KIDs = array();
	protected function parser($fieldName, $value) {
		$value = Aspect::joinPoint("parser", $this, __METHOD__, array($fieldName, $value), $value);
		
		if($fieldName == "geb")
			return Util::CLDateParser($value, "store");
		
		if($fieldName == "land" AND mb_strlen($value) == 2)
			return ISO3166::getCountryToCode ($value);
		
		if($fieldName == "type" AND $this->A("type") != "-")
			return $this->A("type");
		
		if($fieldName == "KategorieID" AND $this->A("KategorieID") != "-" AND substr($this->A("KategorieID"), 0, 4) == "use_")
			return str_replace ("use_", "", $this->A("KategorieID"));

		if($fieldName == "KategorieID" AND $this->A("KategorieID") != "-" AND substr($this->A("KategorieID"), 0, 4) != "use_" AND trim($value) != ""){
			if(isset($this->KIDs[$value]))
				return $this->KIDs[$value];
			
			$AC = anyC::get("Kategorie", "type", "1");
			$AC->addAssocV3("name", "=", $value);
			$K = $AC->n();
			if($K == null){
				$F = new Factory("Kategorie");
				$F->sA("type", "1");
				$F->sA("name", $value);
				$id = $F->store();
				
				$this->KIDs[$value] = $id;
				
				return $id;
			} else {
				$this->KIDs[$value] = $K->getID();
				return $K->getID();
			}
		}
		
		if($fieldName == "anrede" OR $fieldName == "ansprechpartnerAnrede"){
			$return = 3;
			if($fieldName == "ansprechpartnerAnrede")
				$return = 0;
			
			if($this->A("anrede") != "-"){
				if(trim($value) == "Frau" OR trim($value) == "weiblich")
					$return = "1";

				if(trim($value) == "Herr" OR trim($value) == "Herrn" OR trim($value) == "männlich")
					$return = "2";

				#if(trim($value) == "Firma")
				#	$value = "3";
				
				if(trim($value) == "Familie")
					$return = "4";
				
				#echo "<br>$return";
			}
			
			return $return;
		}
		
		return $value;
	}
}
?>