<?php
/*
 *  This file is part of open3A.

 *  open3A is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  open3A is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 *  2007 - 2020, open3A GmbH - Support@open3A.de
 */

abstract class aImportDefault {
	
	protected $A;
	protected $ID;
	protected $customizer;

	/**
	 * If active, customizes this class.
	 *
	 * If updated, please also update Collection::customizer and Environment::customizer
	 */
	public function customize(){
		try {
			$active = mUserdata::getGlobalSettingValue("activeCustomizer");
			if($active == null) return;

			$this->customizer = new $active();
			$this->customizer->customizeClass($this);
		} catch (Exception $e){	}
	}
	
	public function __construct($ID = ""){
		$this->ID = $ID;
		
		$this->customize();
	}
	
	public function loadMe(){ }
	
	protected function parser($fieldName, $value){ return $value; }
	protected function isEmpty($lineData){ return false; }
	protected function parserLine($lineData){ return $lineData; }
	
	public function getFieldsValues(){
		return array();
	}
	
	public function getFieldsSeparators(){
		return array();
	}
	
	public function getFieldsDescriptions(){
		return array();
	}
	
	
	public function getA(){
		$fields = $this->getFieldsList();
		
		$A = new stdClass();
		$A->codepage = "";
		$A->sep = "";
		$A->sepText = "";
		$A->newLine = "";
		$A->startLine = "";
		$A->endLine = "";
		$A->firstLine = "false";
		foreach($fields AS $key => $value)
			$A->$value = "";
	
		return $A;
	}

	public function A($name){
		return $this->A->$name;
	}
	
	public function AA(){
		
	}

	public function getImportID($lineData){
		return -1;
	}

	protected function onNew($newID, $lineData){
		
	}

	protected function onUpdate($ID, $lineData){
		
	}
	
	protected function beforeNew(PersistentObject $O){
		
	}
	
	protected function beforeUpdate(PersistentObject $O){
		
	}
	
	#public function getUniqueField(){
	#	return null;
	#}

	public function setA($A){
		$this->A = $A;
	}
	
	public function saveMe($die = true){
		if($this->A->sep == "1")
			$this->A->sep = ",";
		
		if($this->A->sep == "2")
			$this->A->sep = ";";
		
		if($this->A->sep == "3")
			$this->A->sep = "	";
		
		if($this->A->sepText == "1")
			$this->A->sepText = "'";
		
		if($this->A->sepText == "2")
			$this->A->sepText = "\"";
		
		if($this->A("firstLine") == "1" AND $this->A->startLine == 0)
			$this->A->startLine = 1;
		
		#if($this->A("firstLine") == "1" AND $this->A->endLine > 0)
		#	$this->A->endLine++;
		
		$plugin = $this->getPlugin();
		$fields = $this->getFieldsList();
		$file = $_SESSION["TempFiles"]->get($this->ID);
		$lines = $file->parse("", stripslashes($this->A->sepText), $this->A->sep, $this->A->codepage, $this->A->startLine, $this->A->endLine);

		#if($this->A->endLine == 0)
		#	$this->A->endLine = count($lines)+10;
		$count = 0;

		#$startWithLine = 0;
		#if($this->A("firstLine") == "1")
		#	$startWithLine = 1;
		$time = date("Ymd_His");

		#for($i = $startWithLine; $i < count($lines); $i++){
		foreach($lines AS $i => $line){
			#if($this->A->startLine > $i+1 OR $i+1 > $this->A->endLine)
			#	continue;
			if($this->isEmpty($line)){
				$count++;
				continue;
			}
			
			$line = $this->parserLine($line);
			
			$idToUse = $this->getImportID($line);
			$c = new $plugin($idToUse);

			$A = $c->newAttributes();
			
			foreach($fields AS $key => $value){
				if(!isset($A->$value)) continue;
				if($this->A->$value == "-") continue;

				$currentValue = $this->parser($value, isset($line[$this->A->$value]) ? $line[$this->A->$value] : "");
				
				if($idToUse == -1)
					$A->$value = $currentValue;
				else
					$c->changeA($value, $currentValue);
			}
			
			if($idToUse == -1){
				$importedID = $plugin."Imported";
				
				if(isset($A->$importedID))
					$A->$importedID = $file->A("originalFilename").":$time";
				
				$c->setA($A);
				$this->beforeNew($c);
				$newID = $c->newMe(true, false);

				$this->onNew($newID, $line);
			} else {
				$this->beforeUpdate($c);
				$c->saveMe(true, false);
				$this->onUpdate($idToUse, $line);
			}
			
			$count++;
		}

		if($die)
			Red::alertD(($count == 1 ? "$count Datensatz wurde" : "$count Datensätze wurden")." erfolgreich importiert");
		
		return $count;
	}
}
?>