<?php
/*
 *  This file is part of open3A.

 *  open3A is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  open3A is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 *  2007 - 2020, open3A GmbH - Support@open3A.de
 */

class ImportXMLGUI implements iGUIHTML2 {
	function tempXML($xml){
		$_SESSION["XMLImport"] = str_replace("&XMLString=","", urldecode($xml));
	}
	
	function getHTML($id){
		$XC = new XMLC();
		$XC->setXML($_SESSION["XMLImport"]);
		try {
			$XC->lCV3();
		} catch(ClassNotFoundException $e){
			$t = new HTMLTable(1);
			$t->addRow("Import fehlgeschlagen, Typ unbekannt.");
			return $t->getHTML();
		}
		
		$gui = new HTMLGUI();
		$E = $XC->getNextEntry();
		$XC->resetPointer();
		
		$gui->setName(get_class($E));
		
		$gui->setAttributes($XC->getCollector());
		
		$gui->setCollectionOf($XC->getCollectionOf());
		$gui->setIsDisplayMode(true);
		
		$t = new HTMLTable(1);
		$t->addRow("<input type=\"button\" value=\"jetzt importieren\" onclick=\"rme('ImportXML','','importNow','','checkResponse(transport);');\" />");

		try {
			return $gui->getBrowserHTML($id).$t->getHTML();
		} catch (Exception $e){ }
	}
	
	function importNow(){
		$XC = new XMLC();
		$XC->setXML($_SESSION["XMLImport"]);
		try {
			$XC->lCV3();
		} catch(ClassNotFoundException $e){
			
		}
		
		while($t = $XC->getNextEntry())
			$t->newMe();
		
		echo "message:ImportMessages.M001(".$XC->numLoaded().")";
	}
}
?>