<?php
/*
 *  This file is part of open3A.

 *  open3A is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  open3A is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  2007 - 2020, open3A GmbH - Support@open3A.de
 */

class ImportAPI {
	public static function processOrder(stdClass $Adresse, array $Posten, stdClass $Bestellung, HTMLTable $LogTab){
		$AdresseID = self::processAdresse($Adresse, $LogTab);
		
		$BestellungID = self::processBestellung($AdresseID, $Bestellung);
		self::processBestellungPosten($BestellungID, $Posten, $LogTab);
		
	}
	
	public static function processBestellung($AdresseID, stdClass $Bestellung){
		$F = new Factory("Bestellung");
		$F->sA("BestellungAdresseID", $AdresseID);
		$F->sA("BestellungDatum", $Bestellung->datum);
		$F->sA("BestellungGesamt", $Bestellung->total);
		$F->sA("BestellungBezahlungVia", $Bestellung->bezahltVia);
		$F->sA("BestellungUserID", Session::currentUser()->getID());
		$F->sA("BestellungVersandKosten", $Bestellung->versandKosten);
		$F->sA("BestellungVersandMwSt", $Bestellung->versandMwSt);
		$F->sA("BestellungRabattInP", $Bestellung->rabattInP);
		$F->sA("BestellungEmpfaenger", json_encode($Bestellung->empfaenger, JSON_UNESCAPED_UNICODE));
		$F->sA("BestellungNummer", $Bestellung->nummer);
		$F->sA("BestellungZahlungErhalten", $Bestellung->bezahlt ? "1" : "0");
		
		return $F->store();
	}
	
	public static function processBestellungPosten($BestellungID, $Posten, HTMLTable $LogTab){
		$B = new Button("Fehler","./images/i2/stop.png");
		$B->type("icon");
		$B->style("float:left;margin-right:5px;");

		foreach($Posten AS $p){
			$AC = anyC::get("Artikel");
			$AC->addAssocV3("artikelnummer", "=", $p->artikelNummer);

			$Artikel = $AC->getNextEntry();

			if($Artikel == null){
				$LogTab->addRow($B."Der Artikel mit Artikelnummer $p->artikelNummer wurde nicht gefunden!");
				continue;
			}

			if($AC->numLoaded() > 1){
				$LogTab->addRow($B."Es wurden mehrere Artikel mit Artikelnummer $p->artikelNummer gefunden, es wird keiner hinzugefügt!");
				continue;
			}
		
			$F = new Factory("TempPosten");
			$F->sA("TempPostenClass", "Bestellung");
			$F->sA("TempPostenClassID", $BestellungID);
			
			$F->sA("name", $p->name);
			$F->sA("menge", $p->menge);
			$F->sA("mwst", $p->mwst);
			$F->sA("artikelnummer", $p->artikelNummer);
			$F->sA("preisNeu", $p->preisNeu);
			$F->sA("beschreibung", $p->beschreibung);

			$F->sA("TempPostenTypeClass", "Artikel");
			$F->sA("TempPostenTypeClassID", $Artikel->getID());
			
			$F->store();
		}
	}
	
	public static function processCheck($GRLBMID, $bruttobetrag){
		$r = new stdClass();
		$r->messages = array();
		
		$G = new GRLBM($GRLBMID, false);
		
		$r->result = ($G->A("bruttobetrag") * 1 == $bruttobetrag * 1);
		if($G->A("bruttobetrag") * 1 != $bruttobetrag * 1)
			$r->messages[] = "Der Bruttobetrag stimmt nicht überein";
		
		return $r;
	}
	
	public static function processVersand(GRLBM $Rechnung, $versandkosten, $mwst = 0){
		$Rechnung->changeA("versandkosten", $versandkosten);
		$Rechnung->changeA("versandkostenMwSt", $mwst);
	}
	
	public static function processPayment(GRLBM $Rechnung, $via, $bezahlt, $bezahltDatum = null){
		$Rechnung->changeA("isPayed", $bezahlt ? "1" : "0");
		if($bezahltDatum != null)
			$Rechnung->changeA ("GRLBMpayedDate", $bezahltDatum);
		
		$Rechnung->changeA("GRLBMpayedVia", $via);
		if(Session::isPluginLoaded("mZahlungsart"))
			$Rechnung->changeA ("zahlungsbedingungenID", Zahlungsart::getTB($via)->getID());
	}
	
	public static function processRabattInP(GRLBM $Rechnung, $rabatt){
		$Rechnung->changeA("rabatt", $rabatt);
	}
	
	public static function processAdresse(stdClass $Adresse, HTMLTable $LogTab){
		$B = new Button("", "warning");
		$B->style("float:left;margin-right:10px;");
		$B->type("icon");

		$required = array("anrede", "firma", "vorname", "nachname", "strasse", "nr", "plz", "ort", "land", "email");
		foreach($required AS $key){
			if(!property_exists($Adresse, $key)){
				$LogTab->addRow($B."Dem Adresse-Objekt fehlt folgendes Attribut: $key");
				#$LogTab->addRow($B."Das Adresse-Objekt muss folgende Attribute beinhalten:<br />".implode("<br />", $required));
				return false;
			}
		}

		$F = new Factory("Adresse");
		$F->sA("firma", $Adresse->firma);
		$F->sA("vorname", $Adresse->vorname);
		$F->sA("nachname", $Adresse->nachname);

		$strasse = $Adresse->strasse;print_r($a);
		$nr = $Adresse->nr;
		if($nr == ""){
			$sex = explode(" ", $strasse);
			if(count($sex) > 1){
				$nr = $sex[count($sex) - 1];

				unset($sex[count($sex) - 1]);

				$strasse = implode(" ", $sex);
			}
		}
		$F->sA("strasse", $strasse);
		$F->sA("nr", $nr);
		$F->sA("land", $Adresse->land);
		$F->sA("plz", $Adresse->plz);
		$F->sA("ort", $Adresse->ort);
		$F->sA("email", $Adresse->email);
		$F->sA("AuftragID", "-1");

		$AdresseID = $F->exists();

		if($AdresseID === false){
			$F->sA("anrede", $Adresse->anrede);
			$AdresseID = $F->store(true, false);
			#$LogTab->addRow("Die Adresse wurde angelegt.");

			$K = new Kunden();
			$KID = $K->createKundeToAdresse($AdresseID);

			$Kunde = new Kappendix($KID);
			if(isset($Adresse->ustidnr)) {
				$Kunde->changeA("UStIdNr", $Adresse->ustidnr);
				$Kunde->saveMe(false, false);
			}

			#$LogTab->addRow("Eine Kundennummer (".$Kunde->A("kundennummer").") für die Adresse wurde angelegt.");
		} else {
			#$LogTab->addRow("Die Adresse existiert bereits in der Datenbank (ID: $AdresseID)!");
		}

		return $AdresseID;
	}
	
	public static function processGRLBM($AdresseID, $type, HTMLTable $LogTab){
		#$LogTab->addRow("Ein neuer Auftrag wurde erstellt.");
		$Auftrag = new Auftrag(-1);
		$Auftrag->newWithDefaultValues($AdresseID);

		$RechnungID = $Auftrag->createGRLBM($type, true);

		$R = new GRLBM($RechnungID, false);
		#$LogTab->addRow("Eine Rechnung (".$R->A("nummer").") wurde erstellt.");

		return $R;
	}

	public static function findArtikel($artikelnummer){
			$AC = anyC::get("Artikel");
			$AC->addAssocV3("artikelnummer", "=", $artikelnummer);

			return $AC->getNextEntry();
	}
	
	public static function processPosten(GRLBM $Rechnung, array $Posten, HTMLTable $LogTab, $updateTotal = true){
		$B = new Button("Fehler","./images/i2/stop.png");
		$B->type("icon");
		$B->style("float:left;margin-right:5px;");

		foreach($Posten AS $p){
			$AC = anyC::get("Artikel");
			$AC->addAssocV3("artikelnummer", "=", $p->artikelNummer);

			$Artikel = $AC->getNextEntry();

			if($Artikel == null){
				$LogTab->addRow($B."Der Artikel mit Artikelnummer $p->artikelNummer wurde nicht gefunden!");
				continue;
			}

			if($AC->numLoaded() > 1){
				$LogTab->addRow($B."Es wurden mehrere Artikel mit Artikelnummer $p->artikelNummer gefunden, es wird keiner hinzugefügt!");
				continue;
			}

			#$nettopreis = "";
			#if(isset($p->nettoPreis) AND $p->nettoPreis != $Artikel->A("preis")){
			#	$nettopreis = "<br /><small style=\"color:red\">Achtung: Der importierte Preis entspricht nicht dem open3A-Preis: $p->nettoPreis != ".$Artikel->A("preis").". Verwende open3A-Preis.</small>";
			#}

			#$mwst = "";
			#if(isset($p->mwst) AND $p->mwst != $Artikel->A("mwst")){
			#	$mwst = "<br /><small style=\"color:red\">Achtung: Der importierte MwSt-Satz entspricht nicht dem open3A-MwSt-Satz: $p->mwst != ".$Artikel->A("mwst").". Verwende open3A-MwSt-Satz.</small>";
			#}

			$PostenID = $Rechnung->getPostenCopy($Artikel->getID());

			$Posten = new Posten($PostenID, false);
			$savePosten = false;
			if($p->menge != 1) {
				$Posten->changeA("menge", $p->menge);
				$savePosten = true;
			}

			if(isset($p->name) AND $p->name != ""){
				$Posten->changeA("name", $p->name);
				$savePosten = true;
			}

			if(isset($p->beschreibung) AND $p->beschreibung != ""){
				$Posten->changeA("beschreibung", $p->beschreibung);
				$savePosten = true;
			}

			if(isset($p->mwst) AND $p->mwst != ""){
				$Posten->changeA("mwst", $p->mwst);
				$savePosten = true;
			}

			if(isset($p->preisNeu) AND $p->preisNeu != ""){
				$Posten->changeA("preis", $p->preisNeu);
				$savePosten = true;
			}

			if(isset($p->artikelNummerVariante) AND $p->artikelNummerVariante != ""){
				$Posten->changeA("artikelnummer", $p->artikelNummerVariante);
				$savePosten = true;
			}

			Posten::$recalcBeleg = $updateTotal;
			if($savePosten){
				$Posten->saveMe(true, false);
				$Rechnung->forceReload();
			}
			#$LogTab->addRow("Der Artikel '".$Artikel->A("name")."' wurde {$p->menge}x hinzugefügt.");
		}

	}
}
