<?php
/*
 *  This file is part of open3A.

 *  open3A is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.

 *  open3A is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 *  2007 - 2020, open3A GmbH - Support@open3A.de
 */
class exportBelegeUBGUI extends exportDefault implements iExport, iGUIHTML2 {

	private $Kategorien = array();

	public function getLabel(){
		return "Ausgangsbelege unbezahlt";
	}
	
	public function getApps(){
		return array("open3A", "openFiBu");
	}
	
	public function getExportCollection(){
		$AC = anyC::get("GRLBM", "isPayed", "0");
		$AC->addJoinV3("Auftrag", "AuftragID", "=", "AuftragID");
		$AC->addJoinV3("Adresse", "t2.AdresseID", "=", "AdresseID");
		$AC->addAssocV3("isR", "=", "1", "AND", "2");
		$AC->addAssocV3("isG", "=", "1", "OR", "2");
		$AC->setFieldsV3(array(
			"CONCAT(prefix,nummer) AS nummer",
			"datum",
			"bruttobetrag",
			"IF(firma = '', CONCAT(vorname, ' ', nachname), firma) AS kunde",
			"kundennummer",
			"CONCAT(strasse, ' ', nr) AS strasse",
			"CONCAT(plz, ' ', ort) AS ort",
			"email"
		));
		
		return $AC;
	}

	protected function entryParser(\PersistentObject $entry) {
		$entry->changeA("datum", Util::CLDateParser($entry->A("datum")));
	}

}
?>
